/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import freenet.support.OOMHook;
import freenet.support.SizeUtil;
import freenet.support.WeakHashSet;
import java.util.Set;
import org.tanukisoftware.wrapper.WrapperManager;

public class OOMHandler {
    private static volatile boolean isOOM = false;
    private static volatile byte[] emergencyPool = new byte[8192];
    private static Set<OOMHook> oomHooks = new WeakHashSet<OOMHook>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOOMHook(OOMHook hook) {
        Set<OOMHook> set = oomHooks;
        synchronized (set) {
            oomHooks.add(hook);
        }
    }

    public static void lowMemory() {
        System.gc();
        System.runFinalization();
        for (OOMHook hook : oomHooks) {
            if (hook == null) continue;
            try {
                hook.handleLowMemory();
            }
            catch (Throwable throwable) {}
        }
        System.gc();
        System.runFinalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleOOM(OutOfMemoryError e) {
        if (isOOM) {
            Logger.error(null, "Double OOM", (Throwable)e);
            return;
        }
        isOOM = true;
        Runtime r = null;
        try {
            r = Runtime.getRuntime();
            long usedAtStart = r.totalMemory() - r.freeMemory();
            if (emergencyPool != null) {
                emergencyPool = null;
            }
            System.gc();
            System.runFinalization();
            for (OOMHook hook : oomHooks) {
                if (hook == null) continue;
                try {
                    hook.handleOutOfMemory();
                }
                catch (Throwable t) {}
            }
            System.gc();
            System.runFinalization();
            System.err.println(e.getClass());
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (e.getMessage().equals("Java heap space")) {
                Thread.dumpStack();
            }
            long usedNow = r.totalMemory() - r.freeMemory();
            System.err.println("Memory: GC " + SizeUtil.formatSize(usedAtStart, false) + " -> " + SizeUtil.formatSize(usedNow, false) + ": total " + SizeUtil.formatSize(r.totalMemory(), false) + " free " + SizeUtil.formatSize(r.freeMemory(), false) + " max " + SizeUtil.formatSize(r.maxMemory(), false));
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            System.err.println("Running threads: " + tg.activeCount());
            Logger.error(null, "Caught " + e, (Throwable)e);
            Logger.error(null, "Memory: GC " + SizeUtil.formatSize(usedAtStart, false) + " -> " + SizeUtil.formatSize(usedNow, false) + ": total " + SizeUtil.formatSize(r.totalMemory(), false) + " free " + SizeUtil.formatSize(r.freeMemory(), false) + " max " + SizeUtil.formatSize(r.maxMemory(), false));
            Logger.error(null, "Running threads: " + tg.activeCount());
        }
        catch (Throwable t) {
            System.err.println("Caught handling OOM " + e + " : " + t);
            e.printStackTrace();
            if (r != null) {
                System.err.println("Memory: total " + SizeUtil.formatSize(r.totalMemory(), false) + " free " + SizeUtil.formatSize(r.freeMemory(), false) + " max " + SizeUtil.formatSize(r.maxMemory(), false));
            }
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            System.err.println("Running threads: " + tg.activeCount());
            WrapperManager.requestThreadDump();
        }
        finally {
            isOOM = false;
        }
    }
}

