/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class ReceivedPacketNumbers {
    final LinkedList<Range> ranges = new LinkedList();
    int lowestSeqNumber = -1;
    int highestSeqNumber = -1;
    final int horizon;

    public ReceivedPacketNumbers(int horizon) {
        this.horizon = horizon;
    }

    public synchronized void clear() {
        this.lowestSeqNumber = -1;
        this.highestSeqNumber = -1;
        this.ranges.clear();
    }

    public synchronized boolean got(int seqNumber) {
        if (seqNumber < 0) {
            throw new IllegalArgumentException();
        }
        if (this.ranges.isEmpty()) {
            Range r = new Range();
            this.lowestSeqNumber = this.highestSeqNumber = seqNumber;
            r.end = this.highestSeqNumber;
            r.start = this.highestSeqNumber;
            this.ranges.addFirst(r);
            return true;
        }
        ListIterator<Range> li = this.ranges.listIterator();
        Range r = (Range)li.next();
        int firstSeq = r.end;
        if (seqNumber - firstSeq > this.horizon) {
            li.remove();
            r = (Range)li.next();
            this.lowestSeqNumber = r.start;
        }
        while (true) {
            if (seqNumber == r.start - 1) {
                --r.start;
                if (li.hasPrevious()) {
                    Range r1 = (Range)li.previous();
                    if (r1.end == seqNumber - 1) {
                        r.start = r1.start;
                        li.remove();
                    }
                } else {
                    this.lowestSeqNumber = seqNumber;
                }
                return true;
            }
            if (seqNumber < r.start - 1) {
                if (this.highestSeqNumber - seqNumber > this.horizon) {
                    return false;
                }
                Range r1 = new Range();
                r1.start = r1.end = seqNumber;
                li.previous();
                if (!li.hasPrevious()) {
                    this.lowestSeqNumber = seqNumber;
                }
                li.add(r1);
                return true;
            }
            if (seqNumber >= r.start && seqNumber <= r.end) {
                return true;
            }
            if (seqNumber == r.end + 1) {
                ++r.end;
                if (li.hasNext()) {
                    Range r1 = (Range)li.next();
                    if (r1.start == seqNumber + 1) {
                        r.end = r1.end;
                        li.remove();
                    }
                } else {
                    this.highestSeqNumber = seqNumber;
                }
                return true;
            }
            if (seqNumber > r.end + 1 && !li.hasNext()) {
                Range r1 = new Range();
                r1.end = this.highestSeqNumber = seqNumber;
                r1.start = this.highestSeqNumber;
                li.add(r1);
                return true;
            }
            r = (Range)li.next();
        }
    }

    public synchronized boolean contains(int seqNumber) {
        if (seqNumber > this.highestSeqNumber) {
            return false;
        }
        if (seqNumber == this.highestSeqNumber) {
            return true;
        }
        if (seqNumber == this.lowestSeqNumber) {
            return true;
        }
        if (this.highestSeqNumber - seqNumber > this.horizon) {
            return true;
        }
        Object last = null;
        for (Range r : this.ranges) {
            if (r.start > r.end) {
                Logger.error(this, "Bad Range: " + r);
            }
            if (last != null && r.start < last.end) {
                Logger.error(this, "This range: " + r + " but last was: " + last);
            }
            if (r.start > seqNumber || r.end < seqNumber) continue;
            return true;
        }
        return false;
    }

    public synchronized int highest() {
        return this.highestSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(": max=");
        ReceivedPacketNumbers receivedPacketNumbers = this;
        synchronized (receivedPacketNumbers) {
            sb.append(this.highestSeqNumber);
            sb.append(", min=");
            sb.append(this.lowestSeqNumber);
            sb.append(", ranges=");
            Iterator i = this.ranges.iterator();
            while (i.hasNext()) {
                Range r = (Range)i.next();
                sb.append(r.start);
                sb.append('-');
                sb.append(r.end);
                if (!i.hasNext()) continue;
                sb.append(',');
            }
        }
        return sb.toString();
    }

    private static class Range {
        int start;
        int end;

        private Range() {
        }

        public String toString() {
            return "Range:" + this.start + "->" + this.end;
        }
    }
}

