/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

public class SentTimes {
    private final int[] seqnums;
    private final long[] times;
    private int ptr;

    public SentTimes(int size) {
        this.seqnums = new int[size];
        this.times = new long[size];
        this.ptr = 0;
    }

    public synchronized void add(int seqnum, long time) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.seqnums[this.ptr] = seqnum;
        this.times[this.ptr] = time;
        ++this.ptr;
        if (this.ptr == this.seqnums.length) {
            this.ptr = 0;
        }
    }

    public synchronized long removeTime(int seqnum) {
        for (int i = 0; i < this.seqnums.length; ++i) {
            if (this.seqnums[i] != seqnum || this.times[i] <= 0L) continue;
            long t = this.times[i];
            this.seqnums[i] = 0;
            this.times[i] = -1L;
            return t;
        }
        return -1L;
    }
}

