/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import java.util.Arrays;

public class SortedLongSet {
    private long[] data = new long[32];
    private int length;
    private static final int MIN_SIZE = 32;

    public SortedLongSet() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Long.MAX_VALUE;
        }
        this.length = 0;
    }

    public synchronized long getFirst() {
        if (this.length == 0) {
            return -1L;
        }
        return this.data[0];
    }

    public synchronized boolean isEmpty() {
        return this.length == 0;
    }

    public synchronized boolean contains(long num) {
        int x = this.binarySearch(num);
        return x >= 0;
    }

    public synchronized void remove(long item) {
        int x = this.binarySearch(item);
        if (x >= 0) {
            if (x < this.length - 1) {
                System.arraycopy(this.data, x + 1, this.data, x, this.length - x - 1);
            }
            this.data[--this.length] = Long.MAX_VALUE;
        }
        if (this.length * 4 < this.data.length && this.length > 32) {
            long[] newData = new long[Math.max(this.data.length / 2, 32)];
            System.arraycopy(this.data, 0, newData, 0, this.length);
            for (int i = this.length; i < newData.length; ++i) {
                newData[i] = Long.MAX_VALUE;
            }
            this.data = newData;
        }
        assert (this.verify());
    }

    private synchronized boolean verify() {
        int i;
        long lastItem = -1L;
        for (i = 0; i < this.length; ++i) {
            long item = this.data[i];
            if (i > 0 && item <= lastItem) {
                throw new IllegalStateException("Verify failed!");
            }
            lastItem = item;
        }
        for (i = this.length; i < this.data.length; ++i) {
            if (this.data[i] == Long.MAX_VALUE) continue;
            throw new IllegalStateException("length=" + this.length + ", data.length=" + this.data.length + " but [" + i + "] != Long.MAX_VALUE");
        }
        return true;
    }

    public synchronized boolean push(long num) {
        int x = this.binarySearch(num);
        if (x >= 0) {
            return false;
        }
        x = -x - 1;
        this.push(num, x);
        return true;
    }

    public synchronized void add(long num) {
        int x = this.binarySearch(num);
        if (x >= 0) {
            throw new IllegalArgumentException();
        }
        x = -x - 1;
        this.push(num, x);
    }

    private synchronized void push(long num, int x) {
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (logMINOR) {
            Logger.minor(this, "Insertion point: " + x + " length " + this.length + " data.length " + this.data.length);
        }
        if (this.length == this.data.length) {
            if (logMINOR) {
                Logger.minor(this, "Expanding from " + this.length + " to " + this.length * 2);
            }
            long[] newData = Arrays.copyOf(this.data, this.length * 2);
            for (int i = this.length; i < newData.length; ++i) {
                newData[i] = Long.MAX_VALUE;
            }
            this.data = newData;
        }
        if (x < this.length) {
            System.arraycopy(this.data, x, this.data, x + 1, this.length - x);
        }
        this.data[x] = num;
        ++this.length;
        assert (this.verify());
    }

    public long removeFirst() {
        long val = this.getFirst();
        this.remove(val);
        return val;
    }

    public synchronized void clear() {
        this.data = new long[32];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Long.MAX_VALUE;
        }
        this.length = 0;
    }

    public synchronized long[] toArray() {
        return Arrays.copyOf(this.data, this.length);
    }

    private int binarySearch(long key) {
        return Arrays.binarySearch(this.data, 0, this.length, key);
    }
}

