/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TrivialIntArrayList
implements List<Integer> {
    private int[] list;

    @Override
    public boolean add(Integer arg0) {
        return this.insert(arg0);
    }

    public boolean insert(int arg0) {
        int[] newList = Arrays.copyOf(this.list, this.list.length + 1);
        newList[this.list.length] = arg0;
        this.list = newList;
        return true;
    }

    @Override
    public void add(int index, Integer arg1) {
        this.insert(index, arg1);
    }

    public void insert(int index, int arg1) {
        int[] newList = new int[this.list.length + 1];
        if (index > 0) {
            System.arraycopy(this.list, 0, newList, 0, index);
        }
        newList[index] = arg1;
        if (index < this.list.length) {
            System.arraycopy(this.list, index, newList, index + 1, this.list.length - index);
        }
    }

    @Override
    public boolean addAll(Collection<? extends Integer> arg0) {
        for (Integer n : arg0) {
            this.add(n);
        }
        return true;
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends Integer> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.list = new int[0];
    }

    @Override
    public boolean contains(Object arg0) {
        return this.indexOf(arg0) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        for (Object o : arg0) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer get(int index) {
        return this.list[index];
    }

    public int fetch(int index) {
        return this.list[index];
    }

    @Override
    public int indexOf(Object arg0) {
        if (!(arg0 instanceof Integer)) {
            return -1;
        }
        return this.search((Integer)arg0);
    }

    public int search(int x) {
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] != x) continue;
            return i;
        }
        return -1;
    }

    public int backwardsSearch(int x) {
        for (int i = this.list.length - 1; i >= 0; --i) {
            if (this.list[i] != x) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.list.length == 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int x = 0;

            @Override
            public boolean hasNext() {
                return this.x < TrivialIntArrayList.this.list.length;
            }

            @Override
            public Integer next() {
                if (this.x >= TrivialIntArrayList.this.list.length) {
                    throw new NoSuchElementException();
                }
                return TrivialIntArrayList.this.list[this.x++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int lastIndexOf(Object arg0) {
        if (!(arg0 instanceof Integer)) {
            return -1;
        }
        return this.backwardsSearch((Integer)arg0);
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Integer> listIterator(int arg0) {
        return new MyListIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        int index = this.indexOf(arg0);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public Integer remove(int index) {
        return this.removeAt(index);
    }

    public int removeAt(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.list.length) {
            return this.removeEnd();
        }
        int retval = this.list[index];
        int[] newList = new int[this.list.length - 1];
        if (index > 0) {
            System.arraycopy(this.list, 0, newList, 0, index);
        }
        System.arraycopy(this.list, index + 1, newList, index, this.list.length - index - 1);
        this.list = newList;
        return retval;
    }

    public int removeEnd() {
        int newLength = this.list.length - 1;
        int[] newList = Arrays.copyOf(this.list, newLength);
        int ret = this.list[newLength];
        this.list = newList;
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        boolean didSomething = false;
        for (Object arg : arg0) {
            while (this.remove(arg)) {
                didSomething = true;
            }
        }
        return didSomething;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer set(int index, Integer arg1) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int ret = this.list[index];
        this.list[index] = arg1;
        return ret;
    }

    @Override
    public int size() {
        return this.list.length;
    }

    @Override
    public List<Integer> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.list, this.list.length);
    }

    public int[] rawIntArray() {
        return this.list;
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            ret[i] = this.list[i];
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException();
    }

    private class MyListIterator
    implements ListIterator<Integer> {
        private int index;

        MyListIterator(int x) {
            this.index = x;
        }

        @Override
        public void add(Integer arg0) {
            TrivialIntArrayList.this.add(this.index, arg0);
        }

        @Override
        public boolean hasNext() {
            return this.index < TrivialIntArrayList.this.list.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Integer next() {
            if (this.index >= TrivialIntArrayList.this.list.length) {
                throw new NoSuchElementException();
            }
            return TrivialIntArrayList.this.list[this.index++];
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public Integer previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            return TrivialIntArrayList.this.list[--this.index];
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            TrivialIntArrayList.this.remove(this.index);
        }

        @Override
        public void set(Integer arg0) {
            if (this.index >= TrivialIntArrayList.this.list.length) {
                throw new IllegalStateException();
            }
            ((TrivialIntArrayList)TrivialIntArrayList.this).list[this.index] = arg0;
        }
    }
}

