/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.DoublyLinkedList;
import freenet.support.DoublyLinkedListImpl;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.UpdatableSortedLinkedListItem;
import freenet.support.UpdatableSortedLinkedListKilledException;
import java.util.Enumeration;
import java.util.Iterator;

public class UpdatableSortedLinkedList<T extends UpdatableSortedLinkedListItem<T>>
implements Iterable<T> {
    boolean debug = false;
    protected boolean killed = false;
    private static volatile boolean logMINOR;
    private final DoublyLinkedList<T> list = new DoublyLinkedListImpl();
    private int ctr;

    public synchronized void add(T i) throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        if (logMINOR) {
            Logger.minor(this, "Add(" + i + ") on " + this);
        }
        if (this.list.isEmpty()) {
            this.list.push(i);
            this.checkList();
            return;
        }
        if (i.compareTo(this.list.tail()) >= 0) {
            this.list.push(i);
            this.checkList();
            return;
        }
        if (i.compareTo(this.list.head()) <= 0) {
            this.list.unshift(i);
            this.checkList();
            return;
        }
        Enumeration<T> e = this.list.elements();
        UpdatableSortedLinkedListItem prev = null;
        while (e.hasMoreElements()) {
            UpdatableSortedLinkedListItem cur = (UpdatableSortedLinkedListItem)e.nextElement();
            if (prev != null && cur.compareTo(i) >= 0 && prev.compareTo(i) <= 0) {
                this.list.insertNext(prev, (UpdatableSortedLinkedListItem)i);
                this.checkList();
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Not matching " + cur + ' ' + prev);
            }
            prev = cur;
        }
        throw new IllegalStateException("impossible");
    }

    protected synchronized void checkList() {
        ++this.ctr;
        if (this.ctr % 256 != 0 && !this.debug) {
            return;
        }
        int statedLength = this.list.size();
        int realLength = 0;
        Enumeration<T> e = this.list.elements();
        while (e.hasMoreElements()) {
            UpdatableSortedLinkedListItem i = (UpdatableSortedLinkedListItem)e.nextElement();
            if (realLength > 100000) {
                Logger.normal(this, "[" + realLength + "] = " + i + " (prev=" + i.getPrev() + ')');
            }
            ++realLength;
        }
        if (statedLength != realLength) {
            String err = "statedLength = " + statedLength + " but realLength = " + realLength + " on " + this;
            Logger.error(this, "Illegal ERROR: " + err, (Throwable)new Exception("error"));
            throw new IllegalStateException(err);
        }
    }

    public synchronized T remove(T i) throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        if (logMINOR) {
            Logger.minor(this, "Remove(" + i + ") on " + this);
        }
        this.checkList();
        UpdatableSortedLinkedListItem item = (UpdatableSortedLinkedListItem)this.list.remove(i);
        if (logMINOR) {
            Logger.minor(this, "Returning " + item);
        }
        this.checkList();
        return (T)item;
    }

    public synchronized void addOrUpdate(T item) throws UpdatableSortedLinkedListKilledException {
        if (item.getParent() == this.list) {
            this.update(item);
        } else if (item.getParent() == null) {
            this.add(item);
        } else {
            throw new IllegalStateException("Item " + item + " should be on our list: " + this.list + " or null, but is " + item.getParent());
        }
    }

    public synchronized void update(T i) throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        if (logMINOR) {
            Logger.minor(this, "Update(" + i + ") on " + this);
        }
        this.checkList();
        if (i.compareTo(this.list.tail()) > 0) {
            this.list.remove(i);
            this.list.push(i);
            this.checkList();
            return;
        }
        if (i.compareTo(this.list.head()) < 0) {
            this.list.remove(i);
            this.list.unshift(i);
            this.checkList();
            return;
        }
        if (this.list.head() == this.list.tail() && i != this.list.head()) {
            Logger.error(this, "Only 1 element: " + this.list.head() + " and updating " + i + " on " + this, (Throwable)new Exception("error"));
            this.add(i);
            this.checkList();
            return;
        }
        UpdatableSortedLinkedListItem next = (UpdatableSortedLinkedListItem)this.list.next(i);
        UpdatableSortedLinkedListItem prev = (UpdatableSortedLinkedListItem)this.list.prev(i);
        if (next == null && prev == null) {
            return;
        }
        if (next != null && prev != null && next.compareTo(i) >= 0 && prev.compareTo(i) <= 0) {
            return;
        }
        if (next == null && prev != null && prev.compareTo(i) <= 0) {
            return;
        }
        if (next != null && prev == null && next.compareTo(i) >= 0) {
            return;
        }
        if (next != null && i.compareTo((UpdatableSortedLinkedListItem)next) > 0) {
            do {
                prev = next;
                if ((next = this.list.next(next)) != null) continue;
                throw new NullPointerException("impossible - we checked");
            } while (i.compareTo((UpdatableSortedLinkedListItem)next) >= 0 || i.compareTo((UpdatableSortedLinkedListItem)prev) <= 0);
            this.list.remove(i);
            this.list.insertNext(prev, i);
            this.checkList();
            return;
        }
        if (prev != null && i.compareTo((UpdatableSortedLinkedListItem)prev) < 0) {
            do {
                next = prev;
                prev = this.list.prev(prev);
                if (next != null) continue;
                throw new NullPointerException("impossible - we checked");
            } while (i.compareTo((UpdatableSortedLinkedListItem)next) >= 0 || i.compareTo((UpdatableSortedLinkedListItem)prev) <= 0);
            this.list.remove(i);
            this.list.insertNext(prev, i);
            this.checkList();
            return;
        }
        Logger.error(this, "Could not update " + i, (Throwable)new Exception("error"));
        if (logMINOR) {
            this.dump();
        }
        this.remove(i);
        this.add(i);
        this.checkList();
    }

    private synchronized void dump() throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        Enumeration<T> e = this.list.elements();
        while (e.hasMoreElements()) {
            UpdatableSortedLinkedListItem item = (UpdatableSortedLinkedListItem)e.nextElement();
            if (!logMINOR) continue;
            Logger.minor(this, item.toString());
        }
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized UpdatableSortedLinkedListItem<T>[] toArray() throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        int size = this.list.size();
        if (size < 0) {
            throw new IllegalStateException("list.size() = " + size + " for " + this);
        }
        UpdatableSortedLinkedListItem[] output = new UpdatableSortedLinkedListItem[size];
        int i = 0;
        Enumeration<T> e = this.list.elements();
        while (e.hasMoreElements()) {
            output[i++] = (UpdatableSortedLinkedListItem)e.nextElement();
        }
        return output;
    }

    public synchronized <E> E[] toArray(E[] array) throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        int size = this.list.size();
        if (size < 0) {
            throw new IllegalStateException("list.size() = " + size + " for " + this);
        }
        int i = 0;
        Enumeration<T> e = this.list.elements();
        while (e.hasMoreElements()) {
            array[i++] = e.nextElement();
        }
        return array;
    }

    public synchronized boolean contains(T item) {
        return this.list.contains(item);
    }

    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    public synchronized T getLowest() {
        return (T)((UpdatableSortedLinkedListItem)this.list.head());
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized void kill() {
        this.clear();
        this.killed = true;
    }

    public synchronized T removeLowest() throws UpdatableSortedLinkedListKilledException {
        if (this.isEmpty()) {
            return null;
        }
        T i = this.getLowest();
        this.remove(i);
        return i;
    }

    public synchronized void moveTo(UpdatableSortedLinkedList<T> dest) throws UpdatableSortedLinkedListKilledException {
        Enumeration<T> e = this.list.elements();
        while (e.hasMoreElements()) {
            UpdatableSortedLinkedListItem item = (UpdatableSortedLinkedListItem)e.nextElement();
            this.remove(item);
            dest.add(item);
        }
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.list.iterator();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

