/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import freenet.support.compress.Compressor;
import freenet.support.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class DecompressorThreadManager {
    final Queue<DecompressorThread> threads;
    PipedInputStream input;
    PipedOutputStream output = new PipedOutputStream();
    final long maxLen;
    private boolean finished = false;
    private Throwable error = null;
    private static volatile boolean logMINOR;

    public DecompressorThreadManager(PipedInputStream inputStream, List<? extends Compressor> decompressors, long maxLen) throws IOException {
        this.threads = new ArrayDeque<DecompressorThread>(decompressors.size());
        this.maxLen = maxLen;
        if (inputStream == null) {
            IOException e = new IOException("Input stream may not be null");
            this.onFailure(e);
            throw e;
        }
        this.input = inputStream;
        while (!decompressors.isEmpty()) {
            Compressor compressor = decompressors.remove(decompressors.size() - 1);
            if (logMINOR) {
                Logger.minor(this, "Decompressing with " + compressor);
            }
            DecompressorThread thread = new DecompressorThread(compressor, this, this.input, this.output, maxLen);
            this.threads.add(thread);
            this.input = new PipedInputStream(this.output);
            this.output = new PipedOutputStream();
        }
    }

    public synchronized PipedInputStream execute() throws Throwable {
        if (this.error != null) {
            throw this.error;
        }
        if (this.threads.isEmpty()) {
            this.onFinish();
            return this.input;
        }
        try {
            int count = 0;
            while (!this.threads.isEmpty()) {
                if (this.getError() != null) {
                    throw this.getError();
                }
                DecompressorThread threadRunnable = this.threads.remove();
                if (this.threads.isEmpty()) {
                    threadRunnable.setLast();
                }
                Thread t = new Thread((Runnable)threadRunnable, "DecompressorThread" + count);
                t.start();
                if (logMINOR) {
                    Logger.minor(this, "Started decompressor thread " + t);
                }
                ++count;
            }
            this.output.close();
        }
        catch (Throwable t) {
            this.onFailure(t);
            throw t;
        }
        finally {
            Closer.close(this.output);
        }
        return this.input;
    }

    public synchronized void onFailure(Throwable t) {
        this.error = t;
        this.onFinish();
    }

    public synchronized void onFinish() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void waitFinished() throws Throwable {
        long start = System.currentTimeMillis();
        while (!this.finished) {
            try {
                this.wait(TimeUnit.MINUTES.toMillis(20L));
                long time = System.currentTimeMillis() - start;
                if (time <= TimeUnit.MINUTES.toMillis(20L)) continue;
                Logger.error(this, "Still waiting for decompressor chain after " + TimeUtil.formatTime(time));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    public synchronized Throwable getError() {
        return this.error;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    class DecompressorThread
    implements Runnable {
        final Compressor compressor;
        private InputStream input;
        private PipedOutputStream output;
        final long maxLen;
        final DecompressorThreadManager manager;
        boolean isLast = false;

        public DecompressorThread(Compressor compressor, DecompressorThreadManager manager, InputStream input, PipedOutputStream output, long maxLen) {
            this.compressor = compressor;
            this.input = input;
            this.output = output;
            this.maxLen = maxLen;
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logMINOR) {
                Logger.minor(this, "Decompressing...");
            }
            try {
                if (this.manager.getError() == null) {
                    this.compressor.decompress(this.input, this.output, this.maxLen, this.maxLen * 4L);
                    this.input.close();
                    this.output.close();
                    this.input = null;
                    this.output = null;
                    if (this.isLast) {
                        this.manager.onFinish();
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Finished decompressing...");
                }
            }
            catch (Exception e) {
                this.manager.onFailure(e);
            }
            finally {
                Closer.close(this.input);
                Closer.close(this.output);
            }
        }

        public void setLast() {
            this.isLast = true;
        }
    }
}

