/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.io.Closer;
import freenet.support.io.CountedInputStream;
import freenet.support.io.CountedOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OldLZMACompressor
implements Compressor {
    private static volatile boolean logMINOR;
    static final int propSize = 5;
    static final byte[] props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        Bucket output;
        InputStream is = null;
        OutputStream os = null;
        try {
            output = bf.makeBucket(maxWriteLength);
            is = data.getInputStream();
            os = output.getOutputStream();
            if (logMINOR) {
                Logger.minor(this, "Compressing " + data + " size " + data.size() + " to new bucket " + output);
            }
            this.compress(is, os, maxReadLength, maxWriteLength);
            is.close();
            is = null;
            os.close();
            os = null;
        }
        catch (Throwable throwable) {
            Closer.close(is);
            Closer.close(os);
            throw throwable;
        }
        Closer.close(is);
        Closer.close(os);
        return output;
    }

    @Override
    public long compress(InputStream is, OutputStream os, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        CountedInputStream cis = null;
        CountedOutputStream cos = null;
        cis = new CountedInputStream(new BufferedInputStream(is, 32768));
        cos = new CountedOutputStream(new BufferedOutputStream(os, 32768));
        Encoder encoder = new Encoder();
        encoder.SetEndMarkerMode(true);
        encoder.SetDictionarySize(0x100000);
        encoder.Code((InputStream)cis, (OutputStream)cos, -1L, -1L, null);
        if (logMINOR) {
            Logger.minor(this, "Read " + cis.count() + " written " + cos.written());
        }
        if (cos.written() > maxWriteLength) {
            throw new CompressionOutputSizeException();
        }
        cos.flush();
        return cos.written();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket decompress(Bucket data, BucketFactory bf, long maxLength, long maxCheckSizeLength, Bucket preferred) throws IOException, CompressionOutputSizeException {
        Bucket output = preferred != null ? preferred : bf.makeBucket(maxLength);
        if (logMINOR) {
            Logger.minor(this, "Decompressing " + data + " size " + data.size() + " to new bucket " + output);
        }
        CountedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new CountedInputStream(new BufferedInputStream(data.getInputStream(), 32768));
            os = new BufferedOutputStream(output.getOutputStream(), 32768);
            this.decompress(is, os, maxLength, maxCheckSizeLength);
            if (logMINOR) {
                Logger.minor(this, "Output: " + output + " size " + output.size() + " read " + is.count());
            }
            is.close();
            is = null;
            os.close();
            os = null;
        }
        catch (Throwable throwable) {
            Closer.close(is);
            Closer.close(os);
            throw throwable;
        }
        Closer.close(is);
        Closer.close(os);
        return output;
    }

    @Override
    public long decompress(InputStream is, OutputStream os, long maxLength, long maxCheckSizeBytes) throws IOException, CompressionOutputSizeException {
        CountedOutputStream cos = new CountedOutputStream(os);
        Decoder decoder = new Decoder();
        decoder.SetDecoderProperties(props);
        decoder.Code(is, (OutputStream)cos, maxLength);
        return cos.written();
    }

    @Override
    public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dbuf, i, j);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
        int bytes = 0;
        try {
            this.decompress(bais, baos, (long)output.length, -1L);
            bytes = baos.size();
        }
        catch (IOException e) {
            throw new Error("Got IOException: " + e.getMessage(), e);
        }
        byte[] buf = baos.toByteArray();
        System.arraycopy(buf, 0, output, 0, bytes);
        return bytes;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        props = new byte[5];
        OldLZMACompressor.props[0] = 93;
        OldLZMACompressor.props[1] = 0;
        OldLZMACompressor.props[2] = 0;
        OldLZMACompressor.props[3] = 16;
        OldLZMACompressor.props[4] = 0;
    }
}

