/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.crypt.RandomSource;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.DelayedFreeBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.PersistentBlobTempBucketFactory;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempFileBucket;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class PersistentTempBucketFactory
implements BucketFactory,
PersistentFileTracker {
    private HashSet<File> originalFiles;
    public final FilenameGenerator fg;
    private transient RandomSource strongPRNG;
    private transient Random weakPRNG;
    private final ArrayList<DelayedFreeBucket> bucketsToFree;
    private final long nodeDBHandle;
    private volatile boolean encrypt;
    private final PersistentBlobTempBucketFactory blobFactory;
    static final int BLOB_SIZE = 32768;
    private transient boolean modifiedBucketsToFree;
    private static volatile boolean logMINOR;

    public PersistentTempBucketFactory(File dir, final String prefix, RandomSource strongPRNG, Random weakPRNG, boolean encrypt, long nodeDBHandle) throws IOException {
        File[] files;
        this.blobFactory = new PersistentBlobTempBucketFactory(32768L, nodeDBHandle, new File(dir, "persistent-blob.tmp"));
        this.strongPRNG = strongPRNG;
        this.nodeDBHandle = nodeDBHandle;
        this.weakPRNG = weakPRNG;
        this.encrypt = encrypt;
        this.fg = new FilenameGenerator(weakPRNG, false, dir, prefix);
        if (!dir.exists()) {
            dir.mkdir();
            if (!dir.exists()) {
                throw new IOException("Directory does not exist and cannot be created: " + dir);
            }
        }
        if (!dir.isDirectory()) {
            throw new IOException("Directory is not a directory: " + dir);
        }
        this.originalFiles = new HashSet();
        for (File f : files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.exists() || pathname.isDirectory()) {
                    return false;
                }
                String name = pathname.getName();
                return name.startsWith(prefix);
            }
        })) {
            f = FileUtil.getCanonicalFile(f);
            if (logMINOR) {
                Logger.minor(this, "Found " + f);
            }
            this.originalFiles.add(f);
        }
        this.bucketsToFree = new ArrayList();
    }

    public void init(File dir, String prefix, RandomSource strongPRNG, Random weakPRNG) throws IOException {
        this.strongPRNG = strongPRNG;
        this.weakPRNG = weakPRNG;
        this.fg.init(dir, prefix, weakPRNG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(File file) {
        PersistentTempBucketFactory persistentTempBucketFactory = this;
        synchronized (persistentTempBucketFactory) {
            if (this.originalFiles == null) {
                throw new IllegalStateException("completed Init has already been called!");
            }
            if (!this.originalFiles.remove(file = FileUtil.getCanonicalFile(file))) {
                Logger.error(this, "Preserving " + file + " but it wasn't found!", (Throwable)new Exception("error"));
            }
        }
    }

    public synchronized void completedInit() {
        this.originalFiles = null;
    }

    @Override
    public Bucket makeBucket(long size) throws IOException {
        Bucket rawBucket = null;
        boolean mustWrap = true;
        if (size == 32768L) {
            mustWrap = false;
            try {
                rawBucket = this.blobFactory.makeBucket();
            }
            catch (DatabaseDisabledException e) {
                throw new IOException("Database disabled, persistent buckets not available");
            }
        }
        if (rawBucket == null) {
            rawBucket = new PersistentTempFileBucket(this.fg.makeRandomFilename(), this.fg);
        }
        if (this.encrypt) {
            rawBucket = new PaddedEphemerallyEncryptedBucket(rawBucket, 1024, this.strongPRNG, this.weakPRNG);
        }
        if (mustWrap) {
            rawBucket = new DelayedFreeBucket(this, rawBucket);
        }
        return rawBucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delayedFreeBucket(DelayedFreeBucket b) {
        PersistentTempBucketFactory persistentTempBucketFactory = this;
        synchronized (persistentTempBucketFactory) {
            this.bucketsToFree.add(b);
            this.modifiedBucketsToFree = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelayedFreeBucket[] grabBucketsToFree() {
        PersistentTempBucketFactory persistentTempBucketFactory = this;
        synchronized (persistentTempBucketFactory) {
            if (this.bucketsToFree.isEmpty()) {
                return null;
            }
            DelayedFreeBucket[] buckets = this.bucketsToFree.toArray(new DelayedFreeBucket[this.bucketsToFree.size()]);
            this.bucketsToFree.clear();
            this.modifiedBucketsToFree = true;
            return buckets;
        }
    }

    @Override
    public File getDir() {
        return this.fg.getDir();
    }

    @Override
    public FilenameGenerator getGenerator() {
        return this.fg;
    }

    @Override
    public boolean matches(File file) {
        return this.fg.matches(file);
    }

    @Override
    public long getID(File file) {
        return this.fg.getID(file);
    }

    public boolean isEncrypting() {
        return this.encrypt;
    }

    public static PersistentTempBucketFactory load(File dir, String prefix, RandomSource random, Random fastWeakRandom, ObjectContainer container, final long nodeDBHandle, boolean encrypt, DBJobRunner jobRunner, Ticker ticker) throws IOException {
        ObjectSet results = container.query((Predicate)new Predicate<PersistentTempBucketFactory>(){

            public boolean match(PersistentTempBucketFactory factory) {
                return factory.nodeDBHandle == nodeDBHandle;
            }
        });
        if (results.hasNext()) {
            PersistentTempBucketFactory factory = (PersistentTempBucketFactory)results.next();
            container.activate((Object)factory, 5);
            factory.init(dir, prefix, random, fastWeakRandom);
            factory.setEncryption(encrypt);
            factory.blobFactory.onInit(container, jobRunner, fastWeakRandom, new File(dir, "persistent-blob.tmp"), 32768L, ticker);
            return factory;
        }
        PersistentTempBucketFactory factory = new PersistentTempBucketFactory(dir, prefix, random, fastWeakRandom, encrypt, nodeDBHandle);
        factory.blobFactory.onInit(container, jobRunner, fastWeakRandom, new File(dir, "persistent-blob.tmp"), 32768L, ticker);
        return factory;
    }

    public void setEncryption(boolean encrypt) {
        this.encrypt = encrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCommit(ObjectContainer db) {
        PersistentTempBucketFactory persistentTempBucketFactory = this;
        synchronized (persistentTempBucketFactory) {
            if (!this.modifiedBucketsToFree) {
                return;
            }
            this.modifiedBucketsToFree = false;
            for (DelayedFreeBucket bucket : this.bucketsToFree) {
                db.activate((Object)bucket, 1);
                bucket.storeTo(db);
            }
            db.store(this.bucketsToFree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(ObjectContainer db) {
        this.blobFactory.postCommit();
        DelayedFreeBucket[] toFree = this.grabBucketsToFree();
        if (toFree == null || toFree.length == 0) {
            return;
        }
        int x = 0;
        for (DelayedFreeBucket bucket : toFree) {
            try {
                if (bucket.toFree()) {
                    bucket.realFree();
                }
                if (bucket.toRemove()) {
                    bucket.realRemoveFrom(db);
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " freeing bucket " + bucket + " after transaction commit", t);
            }
            ++x;
        }
        if (x > 1024) {
            PersistentTempBucketFactory persistentTempBucketFactory = this;
            synchronized (persistentTempBucketFactory) {
                db.store(this.bucketsToFree);
            }
            db.commit();
        }
    }

    public void addBlobFreeCallback(DBJob job) {
        this.blobFactory.addBlobFreeCallback(job);
    }

    public void removeBlobFreeCallback(DBJob job) {
        this.blobFactory.removeBlobFreeCallback(job);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

