/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.api.Bucket;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class ReadOnlyFileSliceBucket
implements Bucket {
    private final File file;
    private final long startAt;
    private final long length;

    private ReadOnlyFileSliceBucket() {
        this.startAt = 0L;
        this.length = 0L;
        this.file = null;
    }

    public ReadOnlyFileSliceBucket(File f, long startAt, long length) {
        this.file = new File(f.getPath());
        this.startAt = startAt;
        this.length = length;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Bucket is read-only");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new MyInputStream();
    }

    @Override
    public String getName() {
        return "ROFS:" + this.file.getAbsolutePath() + ':' + this.startAt + ':' + this.length;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public void free() {
    }

    @Override
    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.file);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        container.activate((Object)this.file, 5);
    }

    @Override
    public Bucket createShadow() {
        String fnam = new String(this.file.getPath());
        File newFile = new File(fnam);
        return new ReadOnlyFileSliceBucket(newFile, this.startAt, this.length);
    }

    public static class ReadOnlyFileSliceBucketException
    extends IOException {
        private static final long serialVersionUID = -1L;

        public ReadOnlyFileSliceBucketException(FileNotFoundException e) {
            super("File not found: " + e.getMessage());
            this.initCause(e);
        }

        public ReadOnlyFileSliceBucketException(String string) {
            super(string);
        }
    }

    private class MyInputStream
    extends InputStream {
        private RandomAccessFile f;
        private long ptr;

        MyInputStream() throws IOException {
            try {
                this.f = new RandomAccessFile(ReadOnlyFileSliceBucket.this.file, "r");
                this.f.seek(ReadOnlyFileSliceBucket.this.startAt);
                if (this.f.length() < ReadOnlyFileSliceBucket.this.startAt + ReadOnlyFileSliceBucket.this.length) {
                    throw new ReadOnlyFileSliceBucketException("File truncated? Length " + this.f.length() + " but start at " + ReadOnlyFileSliceBucket.this.startAt + " for " + ReadOnlyFileSliceBucket.this.length + " bytes");
                }
                this.ptr = 0L;
            }
            catch (FileNotFoundException e) {
                throw new ReadOnlyFileSliceBucketException(e);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.ptr >= ReadOnlyFileSliceBucket.this.length) {
                return -1;
            }
            int x = this.f.read();
            if (x != -1) {
                ++this.ptr;
            }
            return x;
        }

        @Override
        public int read(byte[] buf, int offset, int len) throws IOException {
            if (this.ptr >= ReadOnlyFileSliceBucket.this.length) {
                return -1;
            }
            len = (int)Math.min((long)len, ReadOnlyFileSliceBucket.this.length - this.ptr);
            int x = this.f.read(buf, offset, len);
            this.ptr += (long)x;
            return x;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public void close() throws IOException {
            this.f.close();
        }
    }
}

