/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveFailureException;
import freenet.keys.FreenetURI;
import java.util.HashSet;

public class ArchiveContext {
    private HashSet<FreenetURI> soFar;
    final int maxArchiveLevels;
    final long maxArchiveSize;

    public ArchiveContext(long maxArchiveSize, int max) {
        this.maxArchiveLevels = max;
        this.maxArchiveSize = maxArchiveSize;
    }

    public synchronized void doLoopDetection(FreenetURI key, ObjectContainer container) throws ArchiveFailureException {
        if (container != null) {
            container.activate(this.soFar, Integer.MAX_VALUE);
        }
        if (this.soFar == null) {
            this.soFar = new HashSet();
            if (container != null) {
                container.store(this.soFar);
            }
        }
        if (this.soFar.size() > this.maxArchiveLevels) {
            throw new ArchiveFailureException("Too many archive levels");
        }
        FreenetURI uri = key;
        if (container != null) {
            uri = uri.clone();
        }
        if (!this.soFar.add(uri)) {
            throw new ArchiveFailureException("Archive loop detected");
        }
        if (container != null) {
            container.store((Object)uri);
            container.store(this.soFar);
        }
    }

    public void removeFrom(ObjectContainer container) {
        if (this.soFar != null) {
            for (FreenetURI uri : this.soFar) {
                uri.removeFrom(container);
            }
            container.delete(this.soFar);
        }
        container.delete((Object)this);
    }
}

