/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import com.onionnetworks.fec.FECCode;
import com.onionnetworks.util.Buffer;
import freenet.client.FECJob;
import freenet.client.FECQueue;
import freenet.client.InsertContext;
import freenet.client.SplitfileBlock;
import freenet.client.StandardOnionFECCodec;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FECCodec {
    protected transient FECCode fec;
    protected final int k;
    protected final int n;
    static final int MAX_MEMORY_BUFFER = 0x800000;
    private static volatile boolean logMINOR;

    protected abstract void loadFEC();

    protected FECCodec(int k, int n) {
        this.k = k;
        this.n = n;
        if (n == 0 || n < k) {
            throw new IllegalArgumentException("Invalid: k=" + k + " n=" + n);
        }
    }

    public static FECCodec getCodec(short splitfileType, int dataBlocks, int checkBlocks) {
        if (logMINOR) {
            Logger.minor(FECCodec.class, "getCodec: splitfileType=" + splitfileType + " dataBlocks=" + dataBlocks + " checkBlocks=" + checkBlocks);
        }
        if (splitfileType == 0) {
            return null;
        }
        if (splitfileType == 1) {
            return StandardOnionFECCodec.getInstance(dataBlocks, checkBlocks);
        }
        return null;
    }

    public static FECCodec getCodec(short splitfileType, int dataBlocks, InsertContext.CompatibilityMode compatibilityMode) {
        if (splitfileType == 0) {
            return null;
        }
        if (splitfileType == 1) {
            int checkBlocks = FECCodec.standardOnionCheckBlocks(dataBlocks, compatibilityMode);
            return StandardOnionFECCodec.getInstance(dataBlocks, checkBlocks);
        }
        return null;
    }

    private static int standardOnionCheckBlocks(int dataBlocks, InsertContext.CompatibilityMode compatibilityMode) {
        int checkBlocks = dataBlocks * 128 / 128;
        if (dataBlocks >= 128) {
            checkBlocks = 128;
        }
        if (dataBlocks < 256 && dataBlocks + ++checkBlocks > 256) {
            checkBlocks = 256 - dataBlocks;
        }
        if ((compatibilityMode == InsertContext.CompatibilityMode.COMPAT_1250 || compatibilityMode == InsertContext.CompatibilityMode.COMPAT_1250_EXACT) && checkBlocks > dataBlocks) {
            checkBlocks = dataBlocks;
        }
        return checkBlocks;
    }

    public static int getCheckBlocks(short splitfileType, int dataBlocks, InsertContext.CompatibilityMode compatibilityMode) {
        if (splitfileType == 1) {
            return FECCodec.standardOnionCheckBlocks(dataBlocks, compatibilityMode);
        }
        return 0;
    }

    public abstract int countCheckBlocks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realDecode(SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus, int blockLength, BucketFactory bf) throws IOException {
        int i;
        this.loadFEC();
        if (logMINOR) {
            Logger.minor(this, "Doing decode: " + dataBlockStatus.length + " data blocks, " + checkBlockStatus.length + " check blocks, block length " + blockLength + " with " + this, (Throwable)new Exception("debug"));
        }
        if (dataBlockStatus.length + checkBlockStatus.length != this.n) {
            throw new IllegalArgumentException();
        }
        if (dataBlockStatus.length != this.k) {
            throw new IllegalArgumentException();
        }
        Buffer[] packets = new Buffer[this.k];
        Bucket[] buckets = new Bucket[this.n];
        DataInputStream[] readers = new DataInputStream[this.n];
        OutputStream[] writers = new OutputStream[this.k];
        boolean[] toWrite = new boolean[this.k];
        int stripeSize = 0x800000 / this.k;
        if (stripeSize > blockLength) {
            stripeSize = blockLength;
        }
        if ((this.k > 256 || this.n > 256) && (stripeSize & 1) == 1) {
            ++stripeSize;
        }
        if (logMINOR && stripeSize != 32768) {
            Logger.minor(this, "Stripe size is " + stripeSize);
        }
        try {
            byte[] realBuffer = new byte[this.k * stripeSize];
            int[] packetIndexes = new int[this.k];
            for (int i2 = 0; i2 < packetIndexes.length; ++i2) {
                packetIndexes[i2] = -1;
            }
            int idx = 0;
            for (int i3 = 0; i3 < this.k; ++i3) {
                packets[i3] = new Buffer(realBuffer, i3 * stripeSize, stripeSize);
            }
            boolean needDecode = false;
            for (i = 0; i < dataBlockStatus.length; ++i) {
                if (dataBlockStatus[i].getData() != null) continue;
                needDecode = true;
            }
            if (!needDecode) {
                return;
            }
            for (i = 0; i < dataBlockStatus.length; ++i) {
                buckets[i] = dataBlockStatus[i].getData();
                if (buckets[i] == null) {
                    buckets[i] = bf.makeBucket(blockLength);
                    if (stripeSize != blockLength) {
                        writers[i] = buckets[i].getOutputStream();
                    }
                    toWrite[i] = true;
                    if (logMINOR) {
                        Logger.minor(this, "writers[" + i + "] != null");
                    }
                    readers[i] = null;
                    continue;
                }
                long sz = buckets[i].size();
                if (sz < (long)blockLength) {
                    if (i == dataBlockStatus.length - 1) continue;
                    throw new IllegalArgumentException("All buckets must be the full size (caller must pad if needed) but data bucket " + i + " of " + dataBlockStatus.length + " (" + dataBlockStatus[i] + ") is " + sz + " not " + blockLength);
                }
                if (logMINOR) {
                    Logger.minor(this, "writers[" + i + "] = null (already filled)");
                }
                writers[i] = null;
                readers[i] = new DataInputStream(buckets[i].getInputStream());
                packetIndexes[idx++] = i;
            }
            for (i = 0; i < checkBlockStatus.length; ++i) {
                buckets[i + this.k] = checkBlockStatus[i].getData();
                if (buckets[i + this.k] == null) {
                    readers[i + this.k] = null;
                    continue;
                }
                if (stripeSize != blockLength) {
                    readers[i + this.k] = new DataInputStream(buckets[i + this.k].getInputStream());
                }
                if (idx >= this.k) continue;
                packetIndexes[idx++] = i + this.k;
            }
            if (idx < this.k) {
                throw new IllegalArgumentException("Must have at least k packets (k=" + this.k + ",idx=" + idx + ')');
            }
            if (logMINOR) {
                for (i = 0; i < packetIndexes.length; ++i) {
                    Logger.minor(this, "[" + i + "] = " + packetIndexes[i]);
                }
            }
            for (int offset = 0; offset < blockLength; offset += stripeSize) {
                if (offset + stripeSize > blockLength) {
                    stripeSize = blockLength - offset;
                }
                for (int i4 = 0; i4 < this.k; ++i4) {
                    int x = packetIndexes[i4];
                    DataInputStream dis = stripeSize == blockLength ? new DataInputStream(buckets[x].getInputStream()) : readers[x];
                    try {
                        dis.readFully(realBuffer, i4 * stripeSize, stripeSize);
                        continue;
                    }
                    finally {
                        if (stripeSize == blockLength) {
                            dis.close();
                        }
                    }
                }
                int[] disposableIndexes = (int[])packetIndexes.clone();
                this.fec.decode(packets, disposableIndexes);
                for (int i5 = 0; i5 < this.k; ++i5) {
                    if (!toWrite[i5]) continue;
                    OutputStream os = stripeSize == blockLength ? buckets[i5].getOutputStream() : writers[i5];
                    try {
                        os.write(realBuffer, i5 * stripeSize, stripeSize);
                        continue;
                    }
                    finally {
                        if (stripeSize == blockLength) {
                            os.close();
                        }
                    }
                }
            }
        }
        finally {
            for (i = 0; i < this.k; ++i) {
                Closer.close(writers[i]);
            }
            for (i = 0; i < this.n; ++i) {
                Closer.close(readers[i]);
            }
        }
        for (int i6 = 0; i6 < dataBlockStatus.length; ++i6) {
            Bucket data = buckets[i6];
            if (data.size() != (long)blockLength) {
                throw new IllegalStateException("Block " + i6 + ": " + data + " : " + dataBlockStatus[i6] + " length " + data.size() + " whereas blockLength=" + blockLength);
            }
            Bucket existingData = dataBlockStatus[i6].trySetData(data);
            if (existingData == null || existingData == data) continue;
            if (logMINOR) {
                Logger.minor(this, "Discarding block " + i6 + " as now unneeded");
            }
            data.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realEncode(Bucket[] dataBlockStatus, Bucket[] checkBlockStatus, int blockLength, BucketFactory bf) throws IOException {
        int i;
        if (bf == null) {
            throw new NullPointerException();
        }
        this.loadFEC();
        if (logMINOR) {
            long memUsedAtStart = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            Logger.minor(this, "Memory in use at start: " + memUsedAtStart + " max=" + Runtime.getRuntime().maxMemory());
            Logger.minor(this, "Doing encode: " + dataBlockStatus.length + " data blocks, " + checkBlockStatus.length + " check blocks, block length " + blockLength + " with " + this);
        }
        if (dataBlockStatus.length + checkBlockStatus.length != this.n || dataBlockStatus.length != this.k) {
            throw new IllegalArgumentException("Data blocks: " + dataBlockStatus.length + ", Check blocks: " + checkBlockStatus.length + ", n: " + this.n + ", k: " + this.k);
        }
        Buffer[] dataPackets = new Buffer[this.k];
        Bucket[] buckets = new Bucket[this.n];
        DataInputStream[] readers = new DataInputStream[this.k];
        OutputStream[] writers = null;
        try {
            int i2;
            int numberToEncode = 0;
            int created = 0;
            for (int i3 = 0; i3 < checkBlockStatus.length; ++i3) {
                buckets[i3 + this.k] = checkBlockStatus[i3];
                if (buckets[i3 + this.k] != null) continue;
                buckets[i3 + this.k] = bf.makeBucket(blockLength);
                ++numberToEncode;
                ++created;
            }
            int[] toEncode = new int[numberToEncode];
            Buffer[] checkPackets = new Buffer[numberToEncode];
            writers = new OutputStream[numberToEncode];
            int stripeSize = 0x800000 / (this.k + numberToEncode);
            if (stripeSize > blockLength) {
                stripeSize = blockLength;
            }
            if ((this.k > 256 || this.n > 256) && (stripeSize & 1) == 1) {
                ++stripeSize;
            }
            if (logMINOR && stripeSize != 32768) {
                Logger.minor(this, "Stripe size is " + stripeSize);
            }
            byte[] realBuffer = new byte[(this.k + numberToEncode) * stripeSize];
            int x = 0;
            for (i2 = 0; i2 < checkBlockStatus.length; ++i2) {
                if (checkBlockStatus[i2] != null) continue;
                toEncode[x] = i2 + this.k;
                checkPackets[x] = new Buffer(realBuffer, (x + this.k) * stripeSize, stripeSize);
                if (stripeSize != blockLength) {
                    writers[x] = buckets[i2 + this.k].getOutputStream();
                }
                ++x;
            }
            for (i2 = 0; i2 < this.k; ++i2) {
                dataPackets[i2] = new Buffer(realBuffer, i2 * stripeSize, stripeSize);
            }
            for (i2 = 0; i2 < dataBlockStatus.length; ++i2) {
                buckets[i2] = dataBlockStatus[i2];
                if (buckets[i2] == null) {
                    throw new NullPointerException("Data bucket " + i2 + " is null!");
                }
                long sz = buckets[i2].size();
                if (sz < (long)blockLength) {
                    throw new IllegalArgumentException("All buckets must be the full size: caller must pad the last one if needed");
                }
                if (stripeSize == blockLength) continue;
                readers[i2] = new DataInputStream(buckets[i2].getInputStream());
            }
            if (logMINOR) {
                Logger.minor(this, "Created " + created + " check buckets");
            }
            if (logMINOR) {
                long memUsedBeforeEncodes = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                Logger.minor(this, "Memory in use before encodes: " + memUsedBeforeEncodes);
            }
            if (numberToEncode > 0) {
                for (int offset = 0; offset < blockLength; offset += stripeSize) {
                    if (offset + stripeSize > blockLength) {
                        stripeSize = blockLength - offset;
                    }
                    if (logMINOR) {
                        long memUsedBeforeRead = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        Logger.minor(this, "Memory in use before read: " + memUsedBeforeRead);
                    }
                    for (int i4 = 0; i4 < this.k; ++i4) {
                        DataInputStream dis = stripeSize == blockLength ? new DataInputStream(buckets[i4].getInputStream()) : readers[i4];
                        try {
                            dis.readFully(realBuffer, i4 * stripeSize, stripeSize);
                            continue;
                        }
                        finally {
                            if (stripeSize == blockLength) {
                                dis.close();
                            }
                        }
                    }
                    long startTime = 0L;
                    if (logMINOR) {
                        startTime = System.currentTimeMillis();
                        long memUsedBeforeStripe = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        Logger.minor(this, "Memory in use before stripe: " + memUsedBeforeStripe);
                    }
                    this.fec.encode(dataPackets, checkPackets, toEncode);
                    if (logMINOR) {
                        long memUsedAfterStripe = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        Logger.minor(this, "Memory in use after stripe: " + memUsedAfterStripe);
                        long endTime = System.currentTimeMillis();
                        Logger.minor(this, "Stripe encode took " + (endTime - startTime) + "ms for k=" + this.k + ", n=" + this.n + ", stripeSize=" + stripeSize);
                    }
                    for (int i5 = 0; i5 < writers.length; ++i5) {
                        OutputStream os = stripeSize == blockLength ? buckets[toEncode[i5]].getOutputStream() : writers[i5];
                        try {
                            os.write(realBuffer, (i5 + this.k) * stripeSize, stripeSize);
                            continue;
                        }
                        finally {
                            if (stripeSize == blockLength) {
                                os.close();
                            }
                        }
                    }
                }
            }
        }
        finally {
            for (i = 0; i < this.k; ++i) {
                Closer.close(readers[i]);
            }
            if (writers != null) {
                for (i = 0; i < writers.length; ++i) {
                    Closer.close(writers[i]);
                }
            }
        }
        for (i = 0; i < checkBlockStatus.length; ++i) {
            Bucket data = buckets[i + this.k];
            if (data == null) {
                throw new NullPointerException();
            }
            checkBlockStatus[i] = data;
        }
    }

    public void addToQueue(FECJob job, FECQueue queue, ObjectContainer container) {
        queue.addToQueue(job, this, container);
    }

    public void objectCanDeactivate(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Deactivating " + this, (Throwable)new Exception("debug"));
        }
    }

    public abstract short getAlgorithm();

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

