/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECQueue;
import freenet.client.SplitfileBlock;
import freenet.client.async.ClientContext;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;

public class FECJob {
    private static volatile transient boolean logMINOR;
    private transient FECCodec codec;
    private final short fecAlgo;
    final Bucket[] dataBlocks;
    final Bucket[] checkBlocks;
    final SplitfileBlock[] dataBlockStatus;
    final SplitfileBlock[] checkBlockStatus;
    final BucketFactory bucketFactory;
    final int blockLength;
    final FECCallback callback;
    final boolean isADecodingJob;
    final long addedTime;
    final short priority;
    final boolean persistent;
    final FECQueue queue;
    private final int hashCode;
    transient boolean running;

    public int hashCode() {
        return this.hashCode;
    }

    public FECJob(FECCodec codec, FECQueue queue, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus, int blockLength, BucketFactory bucketFactory, FECCallback callback, boolean isADecodingJob, short priority, boolean persistent) {
        int i;
        this.codec = codec;
        this.fecAlgo = codec.getAlgorithm();
        this.queue = queue;
        this.priority = priority;
        this.addedTime = System.currentTimeMillis();
        this.dataBlockStatus = new SplitfileBlock[dataBlockStatus.length];
        this.checkBlockStatus = new SplitfileBlock[checkBlockStatus.length];
        for (i = 0; i < dataBlockStatus.length; ++i) {
            this.dataBlockStatus[i] = dataBlockStatus[i];
        }
        for (i = 0; i < checkBlockStatus.length; ++i) {
            this.checkBlockStatus[i] = checkBlockStatus[i];
        }
        this.dataBlocks = new Bucket[dataBlockStatus.length];
        this.checkBlocks = new Bucket[checkBlockStatus.length];
        for (i = 0; i < this.dataBlocks.length; ++i) {
            this.dataBlocks[i] = dataBlockStatus[i].getData();
        }
        for (i = 0; i < this.checkBlocks.length; ++i) {
            this.checkBlocks[i] = checkBlockStatus[i].getData();
        }
        this.blockLength = blockLength;
        this.bucketFactory = bucketFactory;
        if (bucketFactory == null) {
            throw new NullPointerException();
        }
        this.callback = callback;
        this.isADecodingJob = isADecodingJob;
        this.persistent = persistent;
        this.hashCode = super.hashCode();
    }

    public String toString() {
        return super.toString() + ":decode=" + this.isADecodingJob + ":callback=" + this.callback + ":persistent=" + this.persistent;
    }

    public FECJob(FECCodec codec, FECQueue queue, Bucket[] dataBlocks, Bucket[] checkBlocks, int blockLength, BucketFactory bucketFactory, FECCallback callback, boolean isADecodingJob, short priority, boolean persistent) {
        int i;
        this.hashCode = super.hashCode();
        this.codec = codec;
        this.fecAlgo = codec.getAlgorithm();
        this.queue = queue;
        this.priority = priority;
        this.addedTime = System.currentTimeMillis();
        this.dataBlocks = new Bucket[dataBlocks.length];
        this.checkBlocks = new Bucket[checkBlocks.length];
        for (i = 0; i < dataBlocks.length; ++i) {
            this.dataBlocks[i] = dataBlocks[i];
            if (isADecodingJob || dataBlocks[i] != null) continue;
            throw new NullPointerException("Data block " + i + " is null for encode in FECJob constructor!");
        }
        for (i = 0; i < checkBlocks.length; ++i) {
            this.checkBlocks[i] = checkBlocks[i];
        }
        this.dataBlockStatus = null;
        this.checkBlockStatus = null;
        this.blockLength = blockLength;
        this.bucketFactory = bucketFactory;
        if (bucketFactory == null) {
            throw new NullPointerException();
        }
        this.callback = callback;
        this.isADecodingJob = isADecodingJob;
        this.persistent = persistent;
    }

    public FECCodec getCodec() {
        if (this.codec == null) {
            this.codec = FECCodec.getCodec(this.fecAlgo, this.dataBlocks.length, this.checkBlocks.length);
            if (this.codec == null) {
                Logger.error(this, "No codec found for algo " + this.fecAlgo + " data blocks length " + this.dataBlocks.length + " check blocks length " + this.checkBlocks.length);
            }
        }
        return this.codec;
    }

    public boolean activateForExecution(ObjectContainer container) {
        int i;
        if (logMINOR) {
            Logger.minor(this, "Activating FECJob... " + this);
            if (this.dataBlockStatus != null) {
                for (int i2 = 0; i2 < this.dataBlockStatus.length; ++i2) {
                    Logger.minor(this, "Data block status " + i2 + ": " + this.dataBlockStatus[i2] + " (before activation)");
                }
            }
        }
        container.activate((Object)this, 2);
        boolean hasDataBlocks = false;
        int countDataBlocks = 0;
        int countNullDataBlocks = 0;
        if (this.dataBlockStatus != null) {
            hasDataBlocks = true;
            countDataBlocks = this.dataBlockStatus.length;
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                container.activate((Object)this.dataBlockStatus[i], 2);
                if (this.dataBlockStatus[i] != null) continue;
                ++countNullDataBlocks;
            }
            if (logMINOR) {
                for (i = 0; i < this.dataBlockStatus.length; ++i) {
                    Logger.minor(this, "Data block status " + i + ": " + this.dataBlockStatus[i] + " (after activation)");
                }
            }
        }
        if (this.checkBlockStatus != null) {
            for (i = 0; i < this.checkBlockStatus.length; ++i) {
                container.activate((Object)this.checkBlockStatus[i], 2);
            }
        }
        if (this.dataBlocks != null) {
            hasDataBlocks = true;
            countDataBlocks = this.dataBlocks.length;
            for (i = 0; i < this.dataBlocks.length; ++i) {
                container.activate((Object)this.dataBlocks[i], 1);
                if (logMINOR) {
                    Logger.minor(this, "Data bucket " + i + ": " + this.dataBlocks[i] + " (after activation)");
                }
                if (this.dataBlocks[i] != null) continue;
                ++countNullDataBlocks;
            }
        }
        if (this.checkBlocks != null) {
            for (i = 0; i < this.checkBlocks.length; ++i) {
                container.activate((Object)this.checkBlocks[i], 1);
                if (!logMINOR) continue;
                Logger.minor(this, "Check bucket " + i + ": " + this.checkBlocks[i] + " (after activation)");
            }
        }
        if (!this.isADecodingJob) {
            if (!hasDataBlocks) {
                Logger.error(this, "Invalid job: Encoding: No data blocks or data block status");
                return false;
            }
            if (hasDataBlocks && countDataBlocks == 0) {
                Logger.error(this, "Invalid job: Encoding: " + countDataBlocks + " blocks");
                return false;
            }
            if (hasDataBlocks && countNullDataBlocks > 0) {
                Logger.error(this, "Invalid job: Encoding: " + countDataBlocks + " blocks but " + countNullDataBlocks + " are null!");
                return false;
            }
        }
        return true;
    }

    public void storeBlockStatuses(ObjectContainer container, boolean failure) {
        SplitfileBlock block;
        int i;
        if (logMINOR) {
            Logger.minor(this, "Storing block statuses");
        }
        int countNullsData = -1;
        int countNullsCheck = -1;
        int dataLength = -1;
        int checkLength = -1;
        if (this.dataBlockStatus != null) {
            dataLength = this.dataBlockStatus.length;
            countNullsData = 0;
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                block = this.dataBlockStatus[i];
                if (logMINOR) {
                    Logger.minor(this, "Storing data block " + i + ": " + block);
                }
                if (block != null) {
                    block.storeTo(container);
                    continue;
                }
                ++countNullsData;
            }
        }
        if (this.checkBlockStatus != null) {
            checkLength = this.checkBlockStatus.length;
            countNullsCheck = 0;
            for (i = 0; i < this.checkBlockStatus.length; ++i) {
                block = this.checkBlockStatus[i];
                if (logMINOR) {
                    Logger.minor(this, "Storing check block " + i + ": " + block);
                }
                if (block != null) {
                    block.storeTo(container);
                    continue;
                }
                ++countNullsCheck;
            }
        }
        if (failure && (countNullsData > 0 || countNullsCheck > 0)) {
            Logger.normal(this, "After failed, storing block statuses, " + countNullsData + "/" + this.dataBlockStatus.length + " nulls in data blocks " + countNullsCheck + "/" + this.checkBlockStatus.length + " nulls in check blocks");
        } else if (failure) {
            if (logMINOR) {
                Logger.minor(this, "After failed, storing block statuses, " + countNullsData + "/" + this.dataBlockStatus.length + " nulls in data blocks " + countNullsCheck + "/" + this.checkBlockStatus.length + " nulls in check blocks");
            }
        } else if (this.isADecodingJob) {
            if (countNullsData != 0) {
                Logger.normal(this, "After successful decode, storing block statuses, " + countNullsData + "/" + dataLength + " nulls in data blocks " + countNullsCheck + "/" + checkLength + " nulls in check blocks");
            } else if (logMINOR) {
                Logger.minor(this, "After successful decode, storing block statuses, " + countNullsData + "/" + dataLength + " nulls in data blocks " + countNullsCheck + "/" + checkLength + " nulls in check blocks");
            }
        } else if (countNullsCheck != 0 || countNullsData != 0) {
            Logger.normal(this, "After successful decode, storing block statuses, " + countNullsData + "/" + dataLength + " nulls in data blocks " + countNullsCheck + "/" + checkLength + " nulls in check blocks");
        } else if (logMINOR) {
            Logger.minor(this, "After successful decode, storing block statuses, " + countNullsData + "/" + dataLength + " nulls in data blocks " + countNullsCheck + "/" + checkLength + " nulls in check blocks");
        }
    }

    public boolean isCancelled(ObjectContainer container) {
        if (this.callback == null) {
            Bucket data;
            for (Bucket bucket : this.dataBlocks) {
                if (bucket == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + bucket);
                bucket.free();
                bucket.removeFrom(container);
            }
            for (Bucket bucket : this.checkBlocks) {
                if (bucket == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + bucket);
                bucket.free();
                bucket.removeFrom(container);
            }
            for (SplitfileBlock splitfileBlock : this.dataBlockStatus) {
                if (splitfileBlock == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + splitfileBlock);
                data = splitfileBlock.getData();
                if (data != null) {
                    Logger.error(this, "Callback is null (deleted??) but data is valid: " + data);
                    data.free();
                    data.removeFrom(container);
                }
                container.delete((Object)splitfileBlock);
            }
            for (SplitfileBlock splitfileBlock : this.checkBlockStatus) {
                if (splitfileBlock == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + splitfileBlock);
                data = splitfileBlock.getData();
                if (data != null) {
                    Logger.error(this, "Callback is null (deleted??) but data is valid: " + data);
                    data.free();
                    data.removeFrom(container);
                }
                container.delete((Object)splitfileBlock);
            }
            return true;
        }
        return false;
    }

    public boolean cancel(ObjectContainer container, ClientContext context) {
        return this.queue.cancel(this, container, context);
    }

    public void dump(ObjectContainer container) {
        Bucket data;
        SplitfileBlock status;
        Bucket data2;
        int i;
        int dataCount;
        System.err.println("FEC job: " + this.toString());
        System.err.println("Algorithm: " + this.fecAlgo);
        System.err.println("Bucket factory: " + this.bucketFactory);
        System.err.println("Block length: " + this.blockLength);
        System.err.println("Callback: " + this.callback);
        System.err.println("Type: " + (this.isADecodingJob ? "DECODE" : "ENCODE"));
        System.err.println("Added time: " + this.addedTime);
        System.err.println("Priority: " + this.priority);
        System.err.println("Persistent: " + this.persistent);
        System.err.println("Queue: " + this.queue);
        System.err.println("Hash code: " + this.hashCode);
        System.err.println("Running: " + this.running);
        if (this.dataBlocks != null) {
            System.err.println("Has data blocks");
            dataCount = 0;
            for (i = 0; i < this.dataBlocks.length; ++i) {
                data2 = this.dataBlocks[i];
                if (data2 == null) {
                    System.err.println("Data block " + i + " is null!");
                    continue;
                }
                container.activate((Object)data2, 5);
                if (data2.size() != 32768L) {
                    System.err.println("Size of data block " + i + " is " + data2.size() + " should be " + 32768);
                } else {
                    ++dataCount;
                }
                System.err.println(data2.toString() + " : " + data2.size());
                container.deactivate((Object)data2, 5);
            }
            if (dataCount == this.dataBlocks.length) {
                System.out.println("Has all data blocks");
            } else {
                System.out.println("Does not have all data blocks: " + dataCount + " of " + this.dataBlocks.length);
            }
        }
        if (this.checkBlocks != null) {
            System.err.println("Has check blocks");
            dataCount = 0;
            for (i = 0; i < this.checkBlocks.length; ++i) {
                data2 = this.checkBlocks[i];
                if (data2 == null) {
                    System.err.println("Check block " + i + " is null!");
                    continue;
                }
                container.activate((Object)data2, 5);
                if (data2.size() != 32768L) {
                    System.err.println("Size of check block " + i + " is " + data2.size() + " should be " + 32768);
                } else {
                    ++dataCount;
                }
                System.err.println(data2.toString() + " : " + data2.size());
                container.deactivate((Object)data2, 5);
            }
            if (dataCount == this.checkBlocks.length) {
                System.out.println("Has all check blocks");
            } else {
                System.out.println("Does not have all check blocks: " + dataCount + " of " + this.checkBlocks.length);
            }
        }
        if (this.dataBlockStatus != null) {
            System.err.println("Has data block status");
            dataCount = 0;
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                status = this.dataBlockStatus[i];
                Bucket bucket = data = status == null ? null : status.getData();
                if (data == null) {
                    System.err.println("Data block " + i + " is null!");
                    continue;
                }
                container.activate((Object)data, 5);
                if (data.size() != 32768L) {
                    System.err.println("Size of data block " + i + " is " + data.size() + " should be " + 32768);
                } else {
                    ++dataCount;
                }
                System.err.println(data.toString() + " : " + data.size());
                container.deactivate((Object)data, 5);
            }
            if (dataCount == this.dataBlockStatus.length) {
                System.out.println("Has all data block statuses");
            } else {
                System.out.println("Does not have all data block statuses: " + dataCount + " of " + this.dataBlockStatus.length);
            }
        }
        if (this.checkBlockStatus != null) {
            System.err.println("Has check block status");
            dataCount = 0;
            for (i = 0; i < this.checkBlockStatus.length; ++i) {
                status = this.checkBlockStatus[i];
                Bucket bucket = data = status == null ? null : status.getData();
                if (data == null) {
                    System.err.println("Check block " + i + " is null!");
                    continue;
                }
                container.activate((Object)data, 5);
                if (data.size() != 32768L) {
                    System.err.println("Size of check block " + i + " is " + data.size() + " should be " + 32768);
                } else {
                    ++dataCount;
                }
                System.err.println(data.toString() + " : " + data.size());
                container.deactivate((Object)data, 5);
            }
            if (dataCount == this.checkBlockStatus.length) {
                System.out.println("Has all data block statuses");
            } else {
                System.out.println("Does not have all data block statuses: " + dataCount + " of " + this.checkBlockStatus.length);
            }
        }
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        if (this.running) {
            Logger.error(this, "Tried to deactivate but running == true!");
            return false;
        }
        return true;
    }

    static {
        Logger.registerClass(FECJob.class);
    }
}

