/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.SimpleEventProducer;
import freenet.support.Logger;

public class InsertContext
implements Cloneable {
    public boolean dontCompress;
    public final short splitfileAlgorithm;
    public int maxInsertRetries;
    public final int consecutiveRNFsCountAsSuccess;
    public final int splitfileSegmentDataBlocks;
    public final int splitfileSegmentCheckBlocks;
    public final ClientEventProducer eventProducer;
    public boolean canWriteClientCache;
    public String compressorDescriptor;
    public boolean forkOnCacheable;
    public int extraInsertsSingleBlock;
    public int extraInsertsSplitfileHeaderBlock;
    public boolean localRequestOnly;
    public boolean ignoreUSKDatehints;
    private long compatibilityMode;

    public CompatibilityMode getCompatibilityMode() {
        return CompatibilityMode.values[(int)this.compatibilityMode];
    }

    public long getCompatibilityCode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(CompatibilityMode mode) {
        if (mode == CompatibilityMode.COMPAT_CURRENT) {
            mode = CompatibilityMode.latest();
        }
        this.compatibilityMode = mode.ordinal();
    }

    public InsertContext(int maxRetries, int rnfsToSuccess, int splitfileSegmentDataBlocks, int splitfileSegmentCheckBlocks, ClientEventProducer eventProducer, boolean canWriteClientCache, boolean forkOnCacheable, boolean localRequestOnly, String compressorDescriptor, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, CompatibilityMode compatibilityMode) {
        this.dontCompress = false;
        this.splitfileAlgorithm = 1;
        this.consecutiveRNFsCountAsSuccess = rnfsToSuccess;
        this.maxInsertRetries = maxRetries;
        this.eventProducer = eventProducer;
        this.splitfileSegmentDataBlocks = splitfileSegmentDataBlocks;
        this.splitfileSegmentCheckBlocks = splitfileSegmentCheckBlocks;
        this.canWriteClientCache = canWriteClientCache;
        this.forkOnCacheable = forkOnCacheable;
        this.compressorDescriptor = compressorDescriptor;
        this.extraInsertsSingleBlock = extraInsertsSingleBlock;
        this.extraInsertsSplitfileHeaderBlock = extraInsertsSplitfileHeaderBlock;
        if (compatibilityMode == CompatibilityMode.COMPAT_CURRENT) {
            compatibilityMode = CompatibilityMode.latest();
        }
        this.compatibilityMode = compatibilityMode.ordinal();
        this.localRequestOnly = localRequestOnly;
        this.ignoreUSKDatehints = false;
    }

    public InsertContext(InsertContext ctx, SimpleEventProducer producer) {
        this.dontCompress = ctx.dontCompress;
        this.splitfileAlgorithm = ctx.splitfileAlgorithm;
        this.consecutiveRNFsCountAsSuccess = ctx.consecutiveRNFsCountAsSuccess;
        this.maxInsertRetries = ctx.maxInsertRetries;
        this.eventProducer = producer;
        this.splitfileSegmentDataBlocks = ctx.splitfileSegmentDataBlocks;
        this.splitfileSegmentCheckBlocks = ctx.splitfileSegmentCheckBlocks;
        this.compressorDescriptor = ctx.compressorDescriptor;
        this.forkOnCacheable = ctx.forkOnCacheable;
        this.extraInsertsSingleBlock = ctx.extraInsertsSingleBlock;
        this.extraInsertsSplitfileHeaderBlock = ctx.extraInsertsSplitfileHeaderBlock;
        this.compatibilityMode = ctx.compatibilityMode;
        this.localRequestOnly = ctx.localRequestOnly;
        this.ignoreUSKDatehints = ctx.ignoreUSKDatehints;
    }

    public InsertContext clone() {
        try {
            return (InsertContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void removeFrom(ObjectContainer container) {
        if (this.eventProducer == null) {
            Logger.error(this, "No EventProducer on InsertContext! activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("error"));
        } else {
            container.activate((Object)this.eventProducer, 1);
            this.eventProducer.removeFrom(container);
        }
        container.delete((Object)this);
    }

    public static enum CompatibilityMode {
        COMPAT_UNKNOWN,
        COMPAT_CURRENT,
        COMPAT_1250_EXACT,
        COMPAT_1250,
        COMPAT_1251,
        COMPAT_1255,
        COMPAT_1416;

        private static final CompatibilityMode[] values;

        public static CompatibilityMode latest() {
            return values[values.length - 1];
        }

        static {
            values = CompatibilityMode.values();
        }
    }
}

