/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientPutCallback;
import freenet.keys.FreenetURI;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;

public class PutWaiter
implements ClientPutCallback {
    private boolean finished;
    private boolean succeeded;
    private FreenetURI uri;
    private InsertException error;
    private static volatile boolean logMINOR;

    @Override
    public synchronized void onSuccess(BaseClientPutter state, ObjectContainer container) {
        this.succeeded = true;
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public synchronized void onFailure(InsertException e, BaseClientPutter state, ObjectContainer container) {
        this.error = e;
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public synchronized void onGeneratedURI(FreenetURI uri, BaseClientPutter state, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "URI: " + uri);
        }
        if (this.uri == null) {
            this.uri = uri;
        }
        if (uri.equals(this.uri)) {
            return;
        }
        Logger.error(this, "URI already set: " + this.uri + " but new URI: " + uri, (Throwable)new Exception("error"));
    }

    public synchronized FreenetURI waitForCompletion() throws InsertException {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.error != null) {
            this.error.uri = this.uri;
            throw this.error;
        }
        if (this.succeeded) {
            return this.uri;
        }
        Logger.error(this, "Did not succeed but no error");
        throw new InsertException(3, "Did not succeed but no error", this.uri);
    }

    @Override
    public void onMajorProgress(ObjectContainer container) {
    }

    @Override
    public void onFetchable(BaseClientPutter state, ObjectContainer container) {
    }

    @Override
    public void onGeneratedMetadata(Bucket metadata, BaseClientPutter state, ObjectContainer container) {
        Logger.error(this, "onGeneratedMetadata() on PutWaiter from " + state, (Throwable)new Exception("error"));
        metadata.free();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

