/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.onionnetworks.fec.PureCode;
import freenet.client.FECCodec;
import freenet.support.LRUMap;
import freenet.support.Logger;

public class StandardOnionFECCodec
extends FECCodec {
    private static final int MAX_CACHED_CODECS = 8;
    static boolean noNative;
    private static final LRUMap<MyKey, StandardOnionFECCodec> recentlyUsedCodecs;

    public static synchronized FECCodec getInstance(int dataBlocks, int checkBlocks) {
        if (checkBlocks == 0 || dataBlocks == 0) {
            throw new IllegalArgumentException("data blocks " + dataBlocks + " check blocks " + checkBlocks);
        }
        MyKey key = new MyKey(dataBlocks, checkBlocks + dataBlocks);
        StandardOnionFECCodec codec = recentlyUsedCodecs.get(key);
        if (codec != null) {
            recentlyUsedCodecs.push(key, codec);
            return codec;
        }
        codec = new StandardOnionFECCodec(dataBlocks, checkBlocks + dataBlocks);
        recentlyUsedCodecs.push(key, codec);
        while (recentlyUsedCodecs.size() > 8) {
            recentlyUsedCodecs.popKey();
        }
        return codec;
    }

    public StandardOnionFECCodec(int k, int n) {
        super(k, n);
        this.loadFEC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFEC() {
        StandardOnionFECCodec standardOnionFECCodec = this;
        synchronized (standardOnionFECCodec) {
            if (this.fec != null) {
                return;
            }
        }
        PureCode fec2 = null;
        if (this.k >= this.n) {
            throw new IllegalArgumentException("n must be >k: n = " + this.n + " k = " + this.k);
        }
        if (this.k > 256 || this.n > 256) {
            Logger.error(this, "Wierd FEC parameters? k = " + this.k + " n = " + this.n);
        }
        if (fec2 != null) {
            StandardOnionFECCodec standardOnionFECCodec2 = this;
            synchronized (standardOnionFECCodec2) {
                this.fec = fec2;
            }
        }
        fec2 = new PureCode(this.k, this.n);
        StandardOnionFECCodec standardOnionFECCodec3 = this;
        synchronized (standardOnionFECCodec3) {
            this.fec = fec2;
        }
    }

    @Override
    public int countCheckBlocks() {
        return this.n - this.k;
    }

    public String toString() {
        return super.toString() + ":n=" + this.n + ",k=" + this.k;
    }

    @Override
    public short getAlgorithm() {
        return 1;
    }

    static {
        recentlyUsedCodecs = LRUMap.createSafeMap();
    }

    private static class MyKey
    implements Comparable<MyKey> {
        int k;
        int n;

        public MyKey(int k, int n) {
            this.n = n;
            this.k = k;
        }

        public boolean equals(Object o) {
            if (o instanceof MyKey) {
                MyKey key = (MyKey)o;
                return key.n == this.n && key.k == this.k;
            }
            return false;
        }

        public int hashCode() {
            return (this.n << 16) + this.k;
        }

        @Override
        public int compareTo(MyKey o) {
            if (this.n > o.n) {
                return 1;
            }
            if (this.n < o.n) {
                return -1;
            }
            if (this.k > o.k) {
                return 1;
            }
            if (this.k < o.k) {
                return -1;
            }
            return 0;
        }
    }
}

