/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.BinaryBlobFormatException;
import freenet.client.async.BinaryBlobInserter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.io.IOException;

public class ClientPutter
extends BaseClientPutter
implements PutCompletionCallback {
    final ClientPutCallback client;
    final Bucket data;
    final FreenetURI targetURI;
    final ClientMetadata cm;
    final InsertContext ctx;
    final String targetFilename;
    private ClientPutState currentState;
    private boolean finished;
    private final boolean getCHKOnly;
    private final boolean isMetadata;
    private boolean startedStarting;
    private final boolean binaryBlob;
    private FreenetURI uri;
    private final byte[] overrideSplitfileCrypto;
    private byte[] cryptoKey;
    private final long metadataThreshold;
    private boolean gotFinalMetadata;
    private static volatile boolean logMINOR;
    protected int minSuccessFetchBlocks;

    private ClientPutter() {
        this.targetURI = null;
        this.targetFilename = null;
        this.overrideSplitfileCrypto = null;
        this.isMetadata = false;
        this.getCHKOnly = false;
        this.data = null;
        this.ctx = null;
        this.cm = null;
        this.client = null;
        this.binaryBlob = false;
        this.metadataThreshold = 0L;
    }

    public ClientPutter(ClientPutCallback client, Bucket data, FreenetURI targetURI, ClientMetadata cm, InsertContext ctx, short priorityClass, boolean getCHKOnly, boolean isMetadata, RequestClient clientContext, String targetFilename, boolean binaryBlob, ClientContext context, byte[] overrideSplitfileCrypto, long metadataThreshold) {
        super(priorityClass, clientContext);
        this.cm = cm;
        this.isMetadata = isMetadata;
        this.getCHKOnly = getCHKOnly;
        this.client = client;
        this.data = data;
        this.targetURI = targetURI.clone();
        this.ctx = ctx;
        this.finished = false;
        this.cancelled = false;
        this.targetFilename = targetFilename;
        this.binaryBlob = binaryBlob;
        this.overrideSplitfileCrypto = overrideSplitfileCrypto;
        this.metadataThreshold = metadataThreshold;
    }

    public void start(boolean earlyEncode, ObjectContainer container, ClientContext context) throws InsertException {
        this.start(earlyEncode, false, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean earlyEncode, boolean restart, ObjectContainer container, ClientContext context) throws InsertException {
        block54: {
            InsertContext.CompatibilityMode mode;
            if (this.persistent()) {
                container.activate((Object)this.ctx, 1);
                container.activate((Object)this.client, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Starting " + this + " for " + this.targetURI);
            }
            byte cryptoAlgorithm = (mode = this.ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && mode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1416.ordinal() ? (byte)2 : 3;
            try {
                this.targetURI.checkInsertURI();
                boolean randomiseSplitfileKeys = ClientPutter.randomiseSplitfileKeys(this.targetURI, this.ctx, this.persistent(), container);
                if (this.data == null) {
                    throw new InsertException(2, "No data to insert", null);
                }
                boolean cancel = false;
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    if (restart) {
                        this.clearCountersOnRestart();
                        if (this.currentState != null && !this.finished) {
                            if (logMINOR) {
                                Logger.minor(this, "Can't restart, not finished and currentState != null : " + this.currentState);
                            }
                            return false;
                        }
                        this.finished = false;
                    }
                    if (this.startedStarting) {
                        if (logMINOR) {
                            Logger.minor(this, "Can't " + (restart ? "restart" : "start") + " : startedStarting = true");
                        }
                        return false;
                    }
                    this.startedStarting = true;
                    if (this.currentState != null) {
                        if (logMINOR) {
                            Logger.minor(this, "Can't " + (restart ? "restart" : "start") + " : currentState != null : " + this.currentState);
                        }
                        return false;
                    }
                    cancel = this.cancelled;
                    this.cryptoKey = null;
                    if (this.overrideSplitfileCrypto != null) {
                        this.cryptoKey = this.overrideSplitfileCrypto;
                        if (this.cryptoKey.length != 32) {
                            throw new InsertException(1, "overrideSplitfileCryptoKey must be of length 32", null);
                        }
                    } else if (randomiseSplitfileKeys) {
                        this.cryptoKey = new byte[32];
                        context.random.nextBytes(this.cryptoKey);
                    }
                    if (!cancel) {
                        if (!this.binaryBlob) {
                            ClientMetadata meta = this.cm;
                            if (meta != null) {
                                meta = this.persistent() ? meta.clone() : meta;
                            }
                            this.currentState = new SingleFileInserter(this, this, new InsertBlock(this.data, meta, this.persistent() ? this.targetURI.clone() : this.targetURI), this.isMetadata, this.ctx, this.realTimeFlag, false, this.getCHKOnly, false, null, null, false, this.targetFilename, earlyEncode, false, this.persistent(), 0L, 0L, null, cryptoAlgorithm, this.cryptoKey, this.metadataThreshold);
                        } else {
                            this.currentState = new BinaryBlobInserter(this.data, this, this.getClient(), false, this.priorityClass, this.ctx, context, container);
                        }
                    }
                }
                if (cancel) {
                    this.onFailure(new InsertException(10), null, container, context);
                    return false;
                }
                clientPutter = this;
                synchronized (clientPutter) {
                    cancel = this.cancelled;
                }
                if (cancel) {
                    this.onFailure(new InsertException(10), null, container, context);
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                    return false;
                }
                if (logMINOR) {
                    Logger.minor(this, "Starting insert: " + this.currentState);
                }
                if (this.currentState instanceof SingleFileInserter) {
                    ((SingleFileInserter)this.currentState).start(container, context);
                } else {
                    this.currentState.schedule(container, context);
                }
                clientPutter = this;
                synchronized (clientPutter) {
                    cancel = this.cancelled;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                    container.deactivate((Object)this.currentState, 1);
                }
                if (cancel) {
                    this.onFailure(new InsertException(10), null, container, context);
                    return false;
                }
            }
            catch (InsertException e) {
                Logger.error(this, "Failed to start insert: " + e, (Throwable)e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.currentState = null;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                if (this.client != null) {
                    this.client.onFailure(e, this, container);
                }
            }
            catch (IOException e) {
                Logger.error(this, "Failed to start insert: " + e, (Throwable)e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.currentState = null;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                if (this.client != null) {
                    this.client.onFailure(new InsertException(2, e, null), this, container);
                }
            }
            catch (BinaryBlobFormatException e) {
                Logger.error(this, "Failed to start insert: " + e, (Throwable)e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.currentState = null;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                if (this.client == null) break block54;
                this.client.onFailure(new InsertException(12, e, null), this, container);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Started " + this);
        }
        return true;
    }

    public static boolean randomiseSplitfileKeys(FreenetURI targetURI, InsertContext ctx, boolean persistent, ObjectContainer container) {
        boolean randomiseSplitfileKeys;
        boolean bl = randomiseSplitfileKeys = targetURI.isSSK() || targetURI.isKSK() || targetURI.isUSK();
        if (randomiseSplitfileKeys) {
            InsertContext.CompatibilityMode cmode;
            boolean ctxActive = true;
            if (persistent) {
                boolean bl2 = ctxActive = container.ext().isActive((Object)ctx) || !container.ext().isStored((Object)ctx);
                if (ctxActive) {
                    container.activate((Object)ctx, 1);
                }
            }
            if ((cmode = ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && cmode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
                randomiseSplitfileKeys = false;
            }
            if (!ctxActive) {
                container.deactivate((Object)ctx, 1);
            }
        }
        return randomiseSplitfileKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        ClientPutState oldState;
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.finished = true;
            oldState = this.currentState;
            this.currentState = null;
        }
        if (oldState != null && this.persistent()) {
            container.activate((Object)oldState, 1);
            oldState.removeFrom(container, context);
        }
        if (state != null && state != oldState && this.persistent()) {
            state.removeFrom(container, context);
        }
        if (this.failedBlocks > 0 || this.fatallyFailedBlocks > 0 || this.successfulBlocks < this.totalBlocks) {
            if (this.persistent()) {
                container.activate((Object)this.uri, 1);
            }
            if (!this.uri.isUSK()) {
                Logger.error(this, "Failed blocks: " + this.failedBlocks + ", Fatally failed blocks: " + this.fatallyFailedBlocks + ", Successful blocks: " + this.successfulBlocks + ", Total blocks: " + this.totalBlocks + " but success?! on " + this + " from " + state, (Throwable)new Exception("debug"));
            }
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.client.onSuccess(this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        ClientPutState oldState;
        if (logMINOR) {
            Logger.minor(this, "onFailure() for " + this + " : " + state + " : " + e, (Throwable)e);
        }
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.finished = true;
            oldState = this.currentState;
            this.currentState = null;
        }
        if (oldState != null && this.persistent()) {
            container.activate((Object)oldState, 1);
            oldState.removeFrom(container, context);
        }
        if (state != null && state != oldState && this.persistent()) {
            state.removeFrom(container, context);
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.client.onFailure(e, this, container);
    }

    @Override
    public void onMajorProgress(ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        this.client.onMajorProgress(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
        FreenetURI u;
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.uri != null) {
                Logger.error(this, "onEncode() called twice? Already have a uri: " + this.uri + " for " + this);
                if (this.persistent()) {
                    this.uri.removeFrom(container);
                }
            }
            if (this.gotFinalMetadata) {
                Logger.error(this, "Generated URI *and* sent final metadata??? on " + this + " from " + state);
            }
            this.uri = key.getURI();
            if (this.targetFilename != null) {
                this.uri = this.uri.pushMetaString(this.targetFilename);
            }
            u = this.uri;
        }
        if (this.persistent()) {
            container.store((Object)this);
            u = u.clone();
        }
        this.client.onGeneratedURI(this.uri, this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMetadata(Bucket finalMetadata, ClientPutState state, ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        boolean freeIt = false;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.uri != null) {
                Logger.error(this, "Generated URI *and* sent final metadata??? on " + this + " from " + state);
            }
            if (this.gotFinalMetadata) {
                Logger.error(this, "onMetadata called twice - already sent metadata to client for " + this);
                freeIt = true;
            } else {
                this.gotFinalMetadata = true;
            }
        }
        if (freeIt) {
            finalMetadata.free();
            finalMetadata.removeFrom(container);
            return;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.client.onGeneratedMetadata(finalMetadata, this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
        }
        ClientPutState oldState = null;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.cancelled) {
                return;
            }
            if (this.finished) {
                return;
            }
            super.cancel();
            oldState = this.currentState;
        }
        if (this.persistent()) {
            container.store((Object)this);
            if (oldState != null) {
                container.activate((Object)oldState, 1);
            }
        }
        if (oldState != null) {
            oldState.cancel(container, context);
        }
        this.onFailure(new InsertException(10), null, container, context);
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    public Bucket getData() {
        return this.data;
    }

    public FreenetURI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public FreenetURI getURI() {
        return this.uri;
    }

    public byte[] getSplitfileCryptoKey() {
        return this.cryptoKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        if (newState == null) {
            throw new NullPointerException();
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.currentState == oldState) {
                this.currentState = newState;
                if (this.persistent()) {
                    container.store((Object)this);
                }
                return;
            }
        }
        Logger.error(this, "onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState);
    }

    @Override
    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Got metadata on " + this + " from " + state + " (this means the metadata won't be inserted)");
    }

    @Override
    public int getMinSuccessFetchBlocks() {
        return this.minSuccessFetchBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlock(ObjectContainer container) {
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            ++this.minSuccessFetchBlocks;
        }
        super.addBlock(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlocks(int num, ObjectContainer container) {
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.minSuccessFetchBlocks += num;
        }
        super.addBlocks(num, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMustSucceedBlocks(int blocks, ObjectContainer container) {
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.minSuccessFetchBlocks += blocks;
        }
        super.addMustSucceedBlocks(blocks, container);
    }

    @Override
    public void addRedundantBlocks(int blocks, ObjectContainer container) {
        super.addMustSucceedBlocks(blocks, container);
    }

    @Override
    protected void clearCountersOnRestart() {
        this.minSuccessFetchBlocks = 0;
        super.clearCountersOnRestart();
    }

    @Override
    public void notifyClients(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 2);
        }
        this.ctx.eventProducer.produceEvent(new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.minSuccessBlocks, this.minSuccessFetchBlocks, this.blockSetFinalized), container, context);
    }

    @Override
    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SendingToNetworkEvent(), container, context);
    }

    @Override
    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Set finished", (Throwable)new Exception("debug"));
        }
        this.blockSetFinalized(container, context);
    }

    @Override
    public void onFetchable(ClientPutState state, ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        this.client.onFetchable(this, container);
    }

    public boolean canRestart() {
        if (this.currentState != null && !this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.uri);
            return false;
        }
        return this.data != null;
    }

    public boolean restart(boolean earlyEncode, ObjectContainer container, ClientContext context) throws InsertException {
        this.checkForBrokenClient(container, context);
        return this.start(earlyEncode, true, container, context);
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.cm, 2);
        this.cm.removeFrom(container);
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        if (this.uri != null) {
            container.activate((Object)this.uri, 5);
            this.uri.removeFrom(container);
        }
        super.removeFrom(container, context);
    }

    @Override
    public void dump(ObjectContainer container) {
        container.activate((Object)this.uri, 5);
        System.out.println("URI: " + this.uri);
        container.activate((Object)this.client, 1);
        System.out.println("Client: " + this.client);
        System.out.println("Finished: " + this.finished);
        container.activate((Object)this.data, 5);
        System.out.println("Data: " + this.data);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

