/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.ext.Db4oException;
import freenet.client.FECQueue;
import freenet.client.async.BlockSet;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestSchedulerCore;
import freenet.client.async.ClientRequestSchedulerNonPersistent;
import freenet.client.async.ClientRequestSelector;
import freenet.client.async.ClientRequester;
import freenet.client.async.CooldownQueue;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.DatastoreChecker;
import freenet.client.async.DatastoreCheckerItem;
import freenet.client.async.Db4oBugs;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.NoValidBlocksException;
import freenet.client.async.OfferedKeysList;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.PersistentCooldownQueue;
import freenet.client.async.RegisterMe;
import freenet.client.async.RequestCooldownQueue;
import freenet.crypt.RandomSource;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.PrioRunnable;
import freenet.node.RequestScheduler;
import freenet.node.RequestStarter;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItemKey;
import freenet.support.Fields;
import freenet.support.IdentityHashSet;
import freenet.support.Logger;
import freenet.support.PrioritizedSerialExecutor;
import freenet.support.TimeUtil;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;

public class ClientRequestScheduler
implements RequestScheduler {
    private ClientRequestSchedulerCore schedCore;
    final ClientRequestSchedulerNonPersistent schedTransient;
    private final transient ClientRequestSelector selector;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final OfferedKeysList offeredKeys;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final boolean isRTScheduler;
    final RandomSource random;
    private final RequestStarter starter;
    private final Node node;
    public final String name;
    private final CooldownQueue transientCooldownQueue;
    private CooldownQueue persistentCooldownQueue;
    final PrioritizedSerialExecutor databaseExecutor;
    final DatastoreChecker datastoreChecker;
    public final ClientContext clientContext;
    final DBJobRunner jobRunner;
    public static final String PRIORITY_NONE = "NONE";
    public static final String PRIORITY_SOFT = "SOFT";
    public static final String PRIORITY_HARD = "HARD";
    private String choosenPriorityScheduler;
    static final int QUEUE_THRESHOLD = 100;
    private final transient IdentityHashSet<SendableRequest> runningPersistentRequests = new IdentityHashSet();
    static final int MAX_STARTER_QUEUE_SIZE = 512;
    static final int WARNING_STARTER_QUEUE_SIZE = 800;
    private static final long WAIT_AFTER_NOTHING_TO_START;
    private final transient LinkedList<PersistentChosenRequest> starterQueue = new LinkedList();
    private long nextQueueFillRequestStarterQueue = -1L;
    private DBJob requestStarterQueueFiller = new DBJob(){

        @Override
        public boolean run(ObjectContainer container, ClientContext context) {
            ClientRequestScheduler.this.fillRequestStarterQueue(container, context);
            return false;
        }

        public String toString() {
            return "fillRequestStarterQueue";
        }
    };
    private boolean fillingRequestStarterQueue;
    static final int TRIP_PENDING_PRIORITY;

    public ClientRequestScheduler(boolean forInserts, boolean forSSKs, boolean forRT, RandomSource random, RequestStarter starter, Node node, NodeClientCore core, String name, ClientContext context) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.isRTScheduler = forRT;
        this.schedTransient = new ClientRequestSchedulerNonPersistent(this, forInserts, forSSKs, forRT, random);
        this.databaseExecutor = core.clientDatabaseExecutor;
        this.datastoreChecker = core.storeChecker;
        this.starter = starter;
        this.random = random;
        this.node = node;
        this.clientContext = context;
        this.selector = new ClientRequestSelector(forInserts, this);
        this.name = name;
        this.choosenPriorityScheduler = PRIORITY_HARD;
        this.offeredKeys = !forInserts ? new OfferedKeysList(core, random, 0, forSSKs, forRT) : null;
        this.transientCooldownQueue = !forInserts ? new RequestCooldownQueue(COOLDOWN_PERIOD) : null;
        this.jobRunner = this.clientContext.jobRunner;
    }

    public void startCore(NodeClientCore core, long nodeDBHandle, ObjectContainer container) {
        this.schedCore = ClientRequestSchedulerCore.create(this.node, this.isInsertScheduler, this.isSSKScheduler, this.isRTScheduler, nodeDBHandle, container, COOLDOWN_PERIOD, core.clientDatabaseExecutor, this, this.clientContext);
        this.persistentCooldownQueue = this.schedCore.persistentCooldownQueue;
    }

    public static void loadKeyListeners(ObjectContainer container, ClientContext context) {
        ObjectSet<HasKeyListener> results = Db4oBugs.query(container, HasKeyListener.class);
        while (true) {
            HasKeyListener l;
            try {
                if (!results.hasNext()) break;
                l = (HasKeyListener)results.next();
            }
            catch (RuntimeException e) {
                throw new Db4oException("Something is broken: " + e, (Throwable)e);
            }
            container.activate((Object)l, 1);
            try {
                if (l.isCancelled(container)) continue;
                KeyListener listener = l.makeKeyListener(container, context, true);
                if (listener != null) {
                    if (listener.isSSK()) {
                        context.getSskFetchScheduler(listener.isRealTime()).addPersistentPendingKeys(listener);
                    } else {
                        context.getChkFetchScheduler(listener.isRealTime()).addPersistentPendingKeys(listener);
                    }
                    if (logMINOR) {
                        Logger.minor(ClientRequestScheduler.class, "Loaded request key listener: " + listener + " for " + l);
                    }
                }
            }
            catch (KeyListenerConstructionException e) {
                System.err.println("FAILED TO LOAD REQUEST BLOOM FILTERS:");
                e.printStackTrace();
                Logger.error(ClientRequestSchedulerCore.class, "FAILED TO LOAD REQUEST BLOOM FILTERS: " + e, (Throwable)e);
            }
            catch (Throwable t) {
                Logger.error(ClientRequestSchedulerCore.class, "FAILED TO LOAD REQUEST: " + t, t);
                System.err.println("FAILED TO LOAD REQUEST: " + t);
                t.printStackTrace();
            }
            container.deactivate((Object)l, 1);
        }
    }

    @Override
    public void start(NodeClientCore core) {
        if (this.schedCore != null) {
            this.schedCore.start(core);
        }
        this.queueFillRequestStarterQueue();
    }

    public synchronized void setPriorityScheduler(String val) {
        this.choosenPriorityScheduler = val;
    }

    public void registerInsert(final SendableRequest req, boolean persistent, boolean regmeOnly, ObjectContainer container) {
        if (!this.isInsertScheduler) {
            throw new IllegalArgumentException("Adding a SendableInsert to a request scheduler!!");
        }
        if (persistent) {
            if (regmeOnly) {
                boolean queueFull;
                long bootID = 0L;
                boolean bl = queueFull = this.jobRunner.getQueueSize(NativeThread.NORM_PRIORITY) >= 100;
                if (!queueFull) {
                    bootID = this.node.bootID;
                }
                final RegisterMe regme = new RegisterMe(req, req.getPriorityClass(container), this.schedCore, null, bootID);
                container.store((Object)regme);
                if (logMINOR) {
                    Logger.minor(this, "Added insert RegisterMe: " + regme);
                }
                if (!queueFull) {
                    try {
                        this.jobRunner.queue(new DBJob(){

                            @Override
                            public boolean run(ObjectContainer container, ClientContext context) {
                                container.delete((Object)regme);
                                if (req.isCancelled(container)) {
                                    if (logMINOR) {
                                        Logger.minor(this, "Request already cancelled");
                                    }
                                    return false;
                                }
                                if (container.ext().isActive((Object)req)) {
                                    Logger.error(this, "ALREADY ACTIVE: " + req + " in delayed insert register");
                                }
                                container.activate((Object)req, 1);
                                ClientRequestScheduler.this.registerInsert(req, true, false, container);
                                container.deactivate((Object)req, 1);
                                return true;
                            }

                            public String toString() {
                                return "registerInsert";
                            }
                        }, NativeThread.NORM_PRIORITY, false);
                    }
                    catch (DatabaseDisabledException e) {}
                } else {
                    this.schedCore.rerunRegisterMeRunner(this.jobRunner);
                }
                container.deactivate((Object)req, 1);
                return;
            }
            this.schedCore.innerRegister(req, container, this.clientContext, null);
            this.starter.wakeUp();
        } else {
            this.schedTransient.innerRegister(req, null, this.clientContext, null);
            this.starter.wakeUp();
        }
    }

    public void register(HasKeyListener hasListener, SendableGet[] getters, boolean persistent, ObjectContainer container, BlockSet blocks, boolean noCheckStore) throws KeyListenerConstructionException {
        if (logMINOR) {
            Logger.minor(this, "register(" + persistent + "," + hasListener + "," + Fields.commaList(getters));
        }
        if (this.isInsertScheduler) {
            IllegalStateException e = new IllegalStateException("finishRegister on an insert scheduler");
            throw e;
        }
        if (persistent) {
            this.innerRegister(hasListener, getters, blocks, noCheckStore, container);
        } else {
            KeyListener listener;
            if (hasListener != null) {
                listener = hasListener.makeKeyListener(container, this.clientContext, false);
                if (listener != null) {
                    this.schedTransient.addPendingKeys(listener);
                } else {
                    Logger.normal(this, "No KeyListener for " + hasListener);
                }
            } else {
                listener = null;
            }
            if (getters != null && !noCheckStore) {
                for (SendableGet getter : getters) {
                    this.datastoreChecker.queueTransientRequest(getter, blocks);
                }
            } else {
                boolean anyValid = false;
                for (SendableGet getter : getters) {
                    if (getter.isCancelled(null) || getter.getCooldownTime(container, this.clientContext, System.currentTimeMillis()) != 0L) continue;
                    anyValid = true;
                }
                this.finishRegister(getters, false, container, anyValid, null);
            }
        }
    }

    private void innerRegister(HasKeyListener hasListener, SendableGet[] getters, BlockSet blocks, boolean noCheckStore, ObjectContainer container) throws KeyListenerConstructionException {
        KeyListener listener;
        if (hasListener != null) {
            if (hasListener.isCancelled(container)) {
                if (logMINOR) {
                    Logger.minor(this, "Key listener is cancelled, not registering: " + hasListener);
                }
                return;
            }
            container.store((Object)hasListener);
            listener = hasListener.makeKeyListener(container, this.clientContext, false);
            this.schedCore.addPendingKeys(listener);
        } else {
            listener = null;
        }
        if (getters != null) {
            for (SendableGet getter : getters) {
                container.activate((Object)getter, 1);
                container.store((Object)getter);
            }
        }
        if (this.isInsertScheduler) {
            throw new IllegalStateException("finishRegister on an insert scheduler");
        }
        if (!noCheckStore) {
            for (SendableGet getter : getters) {
                container.activate((Object)getter, 1);
                this.datastoreChecker.queuePersistentRequest(getter, blocks, container, this.clientContext);
                container.deactivate((Object)getter, 1);
            }
        } else {
            this.finishRegister(getters, true, container, true, null);
        }
    }

    void finishRegister(SendableGet[] getters, boolean persistent, ObjectContainer container, boolean anyValid, DatastoreCheckerItem reg) {
        if (logMINOR) {
            Logger.minor(this, "finishRegister for " + Fields.commaList(getters) + " anyValid=" + anyValid + " reg=" + reg + " persistent=" + persistent);
        }
        if (this.isInsertScheduler) {
            IllegalStateException e = new IllegalStateException("finishRegister on an insert scheduler");
            for (SendableGet getter : getters) {
                if (persistent) {
                    container.activate((Object)getter, 1);
                }
                getter.internalError(e, this, container, this.clientContext, persistent);
                if (!persistent) continue;
                container.deactivate((Object)getter, 1);
            }
            throw e;
        }
        if (persistent) {
            if (!this.databaseExecutor.onThread()) {
                throw new IllegalStateException("Not on database thread!");
            }
            if (persistent) {
                container.activate((Object)getters, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "finishRegister() for " + Fields.commaList(getters));
            }
            if (anyValid) {
                boolean wereAnyValid = false;
                for (SendableGet getter : getters) {
                    container.activate((Object)getter, 1);
                    if (!getter.isCancelled(container)) {
                        wereAnyValid = true;
                        if (getter.preRegister(container, this.clientContext, true)) continue;
                        this.schedCore.innerRegister(getter, container, this.clientContext, getters);
                        continue;
                    }
                    getter.preRegister(container, this.clientContext, false);
                }
                if (!wereAnyValid) {
                    Logger.normal(this, "No requests valid");
                }
            } else {
                Logger.normal(this, "No valid requests passed in");
            }
            if (reg != null) {
                container.delete((Object)reg);
            }
            this.queueFillRequestStarterQueue(true);
        } else {
            for (SendableGet getter : getters) {
                if (!anyValid || getter.isCancelled(null)) {
                    getter.preRegister(container, this.clientContext, false);
                    continue;
                }
                if (getter.preRegister(container, this.clientContext, true) || getter.isCancelled(null)) continue;
                this.schedTransient.innerRegister(getter, null, this.clientContext, getters);
            }
            this.starter.wakeUp();
        }
    }

    public ChosenBlock getBetterNonPersistentRequest(short prio) {
        if ((prio = (short)(prio - (this.node.fastWeakRandom.nextBoolean() ? (short)1 : 0))) < 0) {
            return null;
        }
        int fuzz = -1;
        if (PRIORITY_SOFT.equals(this.choosenPriorityScheduler)) {
            fuzz = -1;
        } else if (PRIORITY_HARD.equals(this.choosenPriorityScheduler)) {
            fuzz = 0;
        }
        return this.selector.removeFirstTransient(fuzz, this.random, this.offeredKeys, this.starter, this.schedTransient, prio, this.isRTScheduler, this.clientContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRunningRequest(SendableRequest request, ObjectContainer container) {
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            if (this.runningPersistentRequests.remove(request) && logMINOR) {
                Logger.minor(this, "Removed running request " + request + " size now " + this.runningPersistentRequests.size());
            }
        }
        boolean active = container.ext().isActive((Object)request);
        if (!active) {
            container.activate((Object)request, 1);
        }
        request.clearCooldown(container, this.clientContext, false);
        if (!active) {
            container.deactivate((Object)request, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunningOrQueuedPersistentRequest(SendableRequest request) {
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            if (this.runningPersistentRequests.contains(request)) {
                return true;
            }
            for (PersistentChosenRequest req : this.starterQueue) {
                if (req.request != request) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ChosenBlock grabRequest() {
        boolean needsRefill = true;
        while (true) {
            Iterator it;
            int finalLength;
            PersistentChosenRequest reqGroup = null;
            LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
            // MONITORENTER : linkedList
            short bestPriority = Short.MAX_VALUE;
            for (PersistentChosenRequest req : this.starterQueue) {
                if (req.prio == 6) {
                    if (!logDEBUG) continue;
                    Logger.debug(this, "Ignoring paused persistent request: " + req + " prio: " + req.prio);
                    continue;
                }
                if (req.prio >= bestPriority) continue;
                bestPriority = req.prio;
                reqGroup = req;
            }
            // MONITOREXIT : linkedList
            if (reqGroup != null) {
                ChosenBlock better;
                if (logMINOR) {
                    Logger.minor(this, "Persistent request: " + reqGroup + " prio " + reqGroup.prio);
                }
                if ((better = this.getBetterNonPersistentRequest(reqGroup.prio)) != null) {
                    if (better.getPriority() > reqGroup.prio) {
                        Logger.error(this, "Selected " + better + " as better than " + reqGroup + " but isn't better!");
                    }
                    if (!logMINOR) return better;
                    Logger.minor(this, "Returning better: " + better);
                    return better;
                }
            }
            if (reqGroup == null) {
                this.queueFillRequestStarterQueue();
                return this.getBetterNonPersistentRequest((short)Short.MAX_VALUE);
            }
            LinkedList<PersistentChosenRequest> linkedList2 = this.starterQueue;
            // MONITORENTER : linkedList2
            ChosenBlock block = reqGroup.grabNotStarted(this.clientContext.fastWeakRandom, this);
            if (block == null) {
                if (logMINOR) {
                    Logger.minor(this, "No block found on " + reqGroup);
                }
                finalLength = 0;
                it = this.starterQueue.iterator();
            } else {
                if (!this.runningPersistentRequests.contains(reqGroup.request)) {
                    this.runningPersistentRequests.add(reqGroup.request);
                }
                // MONITOREXIT : linkedList2
                if (needsRefill) {
                    this.queueFillRequestStarterQueue();
                }
                if (!logMINOR) return block;
                Logger.minor(this, "grabRequest() returning " + block + " for " + reqGroup);
                return block;
            }
            while (it.hasNext()) {
                PersistentChosenRequest req = (PersistentChosenRequest)it.next();
                if (req == reqGroup) {
                    it.remove();
                    if (!logMINOR) continue;
                    Logger.minor(this, "Removed " + reqGroup + " from starter queue because is empty");
                    continue;
                }
                finalLength += req.sizeNotStarted();
            }
            needsRefill = finalLength < 512;
            // MONITOREXIT : linkedList2
        }
    }

    @Override
    public void queueFillRequestStarterQueue() {
        this.queueFillRequestStarterQueue(false);
    }

    public void queueFillRequestStarterQueue(boolean force) {
        if (System.currentTimeMillis() < this.nextQueueFillRequestStarterQueue && !force) {
            return;
        }
        if (this.starterQueueLength() > 256) {
            return;
        }
        try {
            this.jobRunner.queue(this.requestStarterQueueFiller, NativeThread.MAX_PRIORITY, true);
        }
        catch (DatabaseDisabledException e) {
            this.moveKeysFromCooldownQueue(this.transientCooldownQueue, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int starterQueueLength() {
        int length = 0;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            for (PersistentChosenRequest request : this.starterQueue) {
                length += request.sizeNotStarted();
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addToStarterQueue(SendableRequest request, ObjectContainer container) {
        PersistentChosenRequest chosen;
        if (logMINOR) {
            Logger.minor(this, "Adding to starter queue: " + request);
        }
        container.activate((Object)request, 1);
        try {
            chosen = new PersistentChosenRequest(request, request.getPriorityClass(container), container, this, this.clientContext);
        }
        catch (NoValidBlocksException e) {
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Created PCR: " + chosen);
        }
        container.deactivate((Object)request, 1);
        boolean dumpNew = false;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            int length = 0;
            for (PersistentChosenRequest req : this.starterQueue) {
                if (req.request == request) {
                    Logger.error(this, "Already on starter queue: " + req + " for " + request, (Throwable)new Exception("debug"));
                    dumpNew = true;
                    break;
                }
                length += req.sizeNotStarted();
            }
            if (!dumpNew) {
                this.starterQueue.add(chosen);
                length += chosen.sizeNotStarted();
                this.runningPersistentRequests.add(request);
                if (logMINOR) {
                    Logger.minor(this, "Added to running persistent requests, size now " + this.runningPersistentRequests.size() + " : " + request);
                }
                return length > 512;
            }
        }
        if (dumpNew) {
            chosen.onDumped(this.schedCore, container, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromStarterQueue(SendableRequest req, ObjectContainer container, boolean reqAlreadyActive) {
        PersistentChosenRequest dumped = null;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            Iterator it = this.starterQueue.iterator();
            while (it.hasNext()) {
                PersistentChosenRequest pcr = (PersistentChosenRequest)it.next();
                if (pcr.request != req) continue;
                it.remove();
                dumped = pcr;
                break;
            }
        }
        if (dumped != null) {
            dumped.onDumped(this.schedCore, container, reqAlreadyActive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int starterQueueSize() {
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            return this.starterQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void fillRequestStarterQueue(ObjectContainer container, ClientContext context) {
        SendableRequest request;
        boolean addedMore;
        Object old;
        boolean added;
        int fuzz;
        boolean checkCooldownQueue;
        long noLaterThan;
        long now;
        block53: {
            ClientRequestScheduler clientRequestScheduler = this;
            // MONITORENTER : clientRequestScheduler
            if (this.fillingRequestStarterQueue) {
                // MONITOREXIT : clientRequestScheduler
                return;
            }
            this.fillingRequestStarterQueue = true;
            // MONITOREXIT : clientRequestScheduler
            now = System.currentTimeMillis();
            if (logMINOR) {
                Logger.minor(this, "Filling request queue... (SSK=" + this.isSSKScheduler + " insert=" + this.isInsertScheduler);
            }
            noLaterThan = Long.MAX_VALUE;
            boolean bl = checkCooldownQueue = now > this.nextQueueFillRequestStarterQueue;
            if (!this.isInsertScheduler && checkCooldownQueue) {
                if (this.persistentCooldownQueue != null) {
                    noLaterThan = this.moveKeysFromCooldownQueue(this.persistentCooldownQueue, true, container);
                }
                noLaterThan = Math.min(noLaterThan, this.moveKeysFromCooldownQueue(this.transientCooldownQueue, false, container));
            }
            fuzz = -1;
            if (PRIORITY_SOFT.equals(this.choosenPriorityScheduler)) {
                fuzz = -1;
            } else if (PRIORITY_HARD.equals(this.choosenPriorityScheduler)) {
                fuzz = 0;
            }
            added = false;
            LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
            // MONITORENTER : linkedList
            if (logMINOR && !this.isSSKScheduler && !this.isInsertScheduler) {
                Logger.minor(this, "Scheduling CHK fetches...");
                for (SendableRequest req : this.runningPersistentRequests) {
                    boolean wasActive = container.ext().isActive((Object)req);
                    if (!wasActive) {
                        container.activate((Object)req, 1);
                    }
                    Logger.minor(this, "Running persistent request: " + req);
                    if (wasActive) continue;
                    container.deactivate((Object)req, 1);
                }
            }
            int length = 0;
            old = null;
            for (PersistentChosenRequest req : this.starterQueue) {
                block57: {
                    block56: {
                        boolean ignoreActive;
                        if (old == req) {
                            Logger.error(this, "DUPLICATE CHOSEN REQUESTS ON QUEUE: " + req);
                        }
                        if (old != null && ((PersistentChosenRequest)old).request == req.request) {
                            Logger.error(this, "DUPLICATE REQUEST ON QUEUE: " + old + " vs " + req + " both " + req.request);
                        }
                        if (ignoreActive = false) break block56;
                        if (container.ext().isActive((Object)req.request)) {
                            Logger.warning(this, "REQUEST ALREADY ACTIVATED: " + req.request + " for " + req + " while checking request queue in filling request queue");
                            break block57;
                        } else if (logMINOR) {
                            Logger.minor(this, "Not already activated for " + req + " in while checking request queue in filling request queue");
                        }
                        break block57;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring active because just registered: " + req.request);
                    }
                }
                req.pruneDuplicates(this);
                old = req;
                length += req.sizeNotStarted();
            }
            if (logMINOR) {
                Logger.minor(this, "Queue size: " + length + " SSK=" + this.isSSKScheduler + " insert=" + this.isInsertScheduler);
            }
            if (length <= 384) break block53;
            if (length >= 800) {
                Logger.error(this, "Queue already full: " + length);
            }
            // MONITOREXIT : linkedList
            ClientRequestScheduler i$ = this;
            // MONITORENTER : i$
            this.fillingRequestStarterQueue = false;
            // MONITOREXIT : i$
            return;
        }
        try {
            // MONITOREXIT : linkedList
            if (!this.isSSKScheduler && !this.isInsertScheduler) {
                Logger.minor(this, "Scheduling CHK fetches...");
            }
            addedMore = false;
            while (true) {
                old = this;
                // MONITORENTER : old
                ClientRequestSelector.SelectorReturn r = this.selector.removeFirstInner(fuzz, this.random, this.offeredKeys, this.starter, this.schedCore, this.schedTransient, false, true, (short)Short.MAX_VALUE, this.isRTScheduler, context, container, now);
                // MONITOREXIT : old
                request = null;
                if (r != null && r.req != null) {
                    request = r.req;
                } else if (r != null && r.wakeupTime > 0L && noLaterThan > r.wakeupTime) {
                    noLaterThan = r.wakeupTime;
                    if (logMINOR) {
                        Logger.minor(this, "Waking up in " + TimeUtil.formatTime(noLaterThan - now) + " for cooldowns");
                    }
                }
                if (request != null) break block54;
                ClientRequestScheduler i$ = this;
                // MONITORENTER : i$
                if (checkCooldownQueue && !added) {
                    this.nextQueueFillRequestStarterQueue = System.currentTimeMillis() + WAIT_AFTER_NOTHING_TO_START;
                    if (this.nextQueueFillRequestStarterQueue > noLaterThan) {
                        this.nextQueueFillRequestStarterQueue = noLaterThan + 1L;
                    }
                }
                // MONITOREXIT : i$
                if (addedMore) {
                    this.starter.wakeUp();
                }
                i$ = this;
                break;
            }
        }
        catch (Throwable throwable) {
            ClientRequestScheduler clientRequestScheduler = this;
            // MONITORENTER : clientRequestScheduler
            this.fillingRequestStarterQueue = false;
            // MONITOREXIT : clientRequestScheduler
            throw throwable;
        }
        {
            block55: {
                block54: {
                    // MONITORENTER : i$
                    this.fillingRequestStarterQueue = false;
                    // MONITOREXIT : i$
                    return;
                }
                boolean full = this.addToStarterQueue(request, container);
                container.deactivate((Object)request, 1);
                if (!added) {
                    this.starter.wakeUp();
                } else {
                    addedMore = true;
                }
                added = true;
                if (!full) break block55;
                if (addedMore) {
                    this.starter.wakeUp();
                }
                ClientRequestScheduler clientRequestScheduler = this;
                // MONITORENTER : clientRequestScheduler
                this.fillingRequestStarterQueue = false;
                // MONITOREXIT : clientRequestScheduler
                return;
            }
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeAddToStarterQueue(SendableRequest req, ObjectContainer container, SendableRequest[] mightBeActive) {
        short prio = req.getPriorityClass(container);
        if (logMINOR) {
            Logger.minor(this, "Maybe adding to starter queue: prio=" + prio);
        }
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            boolean betterThanSome = false;
            int size = 0;
            for (PersistentChosenRequest old : this.starterQueue) {
                if (old.request == req) {
                    if (logMINOR) {
                        Logger.minor(this, "Already on starter queue: " + old + " for " + req);
                    }
                    return;
                }
                boolean ignoreActive = false;
                if (mightBeActive != null) {
                    for (SendableRequest tmp : mightBeActive) {
                        if (tmp != old.request) continue;
                        ignoreActive = true;
                    }
                }
                if (!ignoreActive) {
                    if (container.ext().isActive((Object)old.request)) {
                        Logger.warning(this, "REQUEST ALREADY ACTIVATED: " + old.request + " for " + old + " while checking request queue in maybeAddToStarterQueue for " + req);
                    } else if (logDEBUG) {
                        Logger.debug(this, "Not already activated for " + old + " in while checking request queue in maybeAddToStarterQueue for " + req);
                    }
                } else if (logMINOR) {
                    Logger.minor(this, "Ignoring active because just registered: " + old.request + " in maybeAddToStarterQueue for " + req);
                }
                size += old.sizeNotStarted();
                if (old.prio > prio) {
                    betterThanSome = true;
                }
                if (old.request != req) continue;
                return;
            }
            if (size >= 512 && !betterThanSome) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding to starter queue: over limit and req not better than any queued requests");
                }
                return;
            }
        }
        this.addToStarterQueue(req, container);
        this.trimStarterQueue(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimStarterQueue(ObjectContainer container) {
        ArrayList<PersistentChosenRequest> dumped = null;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            int length = this.starterQueueLength();
            while (length > 512) {
                PersistentChosenRequest worst = null;
                short worstPrio = -1;
                int worstIndex = -1;
                int worstLength = -1;
                if (this.starterQueue.isEmpty()) break;
                length = 0;
                ListIterator it = this.starterQueue.listIterator();
                while (it.hasNext()) {
                    int nextIndex = it.nextIndex();
                    PersistentChosenRequest req = (PersistentChosenRequest)it.next();
                    short prio = req.prio;
                    int size = req.sizeNotStarted();
                    length += size;
                    if (prio <= worstPrio) continue;
                    worstPrio = prio;
                    worst = req;
                    worstIndex = nextIndex;
                    worstLength = size;
                }
                int lengthAfter = length - worstLength;
                if (lengthAfter < 512) break;
                if (dumped == null) {
                    dumped = new ArrayList<PersistentChosenRequest>(2);
                }
                dumped.add(worst);
                this.starterQueue.remove(worstIndex);
                if (lengthAfter != 512) continue;
                break;
            }
        }
        if (dumped == null) {
            return;
        }
        for (PersistentChosenRequest req : dumped) {
            req.onDumped(this.schedCore, container, false);
        }
    }

    public void removePendingKeys(KeyListener getter, boolean complain) {
        boolean found = this.schedTransient.removePendingKeys(getter);
        if (this.schedCore != null) {
            found |= this.schedCore.removePendingKeys(getter);
        }
        if (complain && !found) {
            Logger.error(this, "Listener not found when removing: " + getter);
        }
    }

    public void removePendingKeys(HasKeyListener getter, boolean complain) {
        boolean found = this.schedTransient.removePendingKeys(getter);
        if (this.schedCore != null) {
            found |= this.schedCore.removePendingKeys(getter);
        }
        if (complain && !found) {
            Logger.error(this, "Listener not found when removing: " + getter);
        }
    }

    public void reregisterAll(ClientRequester request, ObjectContainer container, short oldPrio) {
        this.schedTransient.reregisterAll(request, this, null, this.clientContext, oldPrio);
        if (this.schedCore != null) {
            this.schedCore.reregisterAll(request, this, container, this.clientContext, oldPrio);
        }
        this.starter.wakeUp();
    }

    public String getChoosenPriorityScheduler() {
        return this.choosenPriorityScheduler;
    }

    @Override
    public synchronized void succeeded(final BaseSendableGet succeeded, boolean persistent) {
        if (persistent) {
            try {
                this.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)succeeded)) {
                            Logger.error(this, "ALREADY ACTIVE in succeeded(): " + succeeded);
                        }
                        container.activate((Object)succeeded, 1);
                        ClientRequestScheduler.this.schedCore.succeeded(succeeded, container);
                        container.deactivate((Object)succeeded, 1);
                        return false;
                    }

                    public String toString() {
                        return "BaseSendableGet succeeded";
                    }
                }, TRIP_PENDING_PRIORITY, false);
            }
            catch (DatabaseDisabledException e) {
                Logger.error(this, "succeeded() on a persistent request but database disabled", (Throwable)new Exception("error"));
            }
        } else {
            this.schedTransient.succeeded(succeeded, null);
        }
    }

    public void tripPendingKey(final KeyBlock block) {
        Key key;
        if (logMINOR) {
            Logger.minor(this, "tripPendingKey(" + block.getKey() + ")");
        }
        if (this.offeredKeys != null) {
            this.offeredKeys.remove(block.getKey());
        }
        if (this.schedTransient.anyProbablyWantKey(key = block.getKey(), this.clientContext)) {
            this.clientContext.mainExecutor.execute(new PrioRunnable(){

                @Override
                public void run() {
                    ClientRequestScheduler.this.schedTransient.tripPendingKey(key, block, null, ClientRequestScheduler.this.clientContext);
                }

                @Override
                public int getPriority() {
                    return TRIP_PENDING_PRIORITY;
                }
            }, "Trip pending key (transient)");
        }
        if (this.schedCore == null) {
            return;
        }
        if (this.schedCore.anyProbablyWantKey(key, this.clientContext)) {
            try {
                this.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (logMINOR) {
                            Logger.minor(this, "tripPendingKey for " + key);
                        }
                        if (ClientRequestScheduler.this.schedCore.tripPendingKey(key, block, container, ClientRequestScheduler.this.clientContext)) {
                            context.jobRunner.setCommitSoon();
                        }
                        return false;
                    }

                    public String toString() {
                        return "tripPendingKey";
                    }
                }, TRIP_PENDING_PRIORITY, false);
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean wantKey(Key key) {
        if (this.schedTransient.anyProbablyWantKey(key, this.clientContext)) {
            return true;
        }
        return this.schedCore != null && this.schedCore.anyProbablyWantKey(key, this.clientContext);
    }

    public void queueOfferedKey(Key key, boolean realTime) {
        if (logMINOR) {
            Logger.minor(this, "queueOfferedKey(" + key);
        }
        this.offeredKeys.queueKey(key);
        this.starter.wakeUp();
    }

    public void dequeueOfferedKey(Key key) {
        this.offeredKeys.remove(key);
    }

    private long moveKeysFromCooldownQueue(CooldownQueue queue, boolean persistent, ObjectContainer container) {
        Key[] keys;
        boolean logMINOR = ClientRequestScheduler.logMINOR;
        if (queue == null) {
            return Long.MAX_VALUE;
        }
        long now = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Moving keys from cooldown queue persistent=" + persistent);
        }
        int MAX_KEYS = 20;
        ClientRequestScheduler otherScheduler = !this.isSSKScheduler ? this.clientContext.getSskFetchScheduler(this.isRTScheduler) : this.clientContext.getChkFetchScheduler(this.isRTScheduler);
        Object ret = queue instanceof PersistentCooldownQueue ? ((PersistentCooldownQueue)queue).removeKeyBefore(now, WAIT_AFTER_NOTHING_TO_START, container, 20, (PersistentCooldownQueue)otherScheduler.persistentCooldownQueue) : queue.removeKeyBefore(now, WAIT_AFTER_NOTHING_TO_START, container, 20);
        if (ret == null) {
            return Long.MAX_VALUE;
        }
        if (ret instanceof Long) {
            return (Long)ret;
        }
        for (Key key : keys = (Key[])ret) {
            if (persistent) {
                container.activate((Object)key, 5);
            }
            if (logMINOR) {
                Logger.minor(this, "Restoring key: " + key);
            }
            if (key instanceof NodeSSK == this.isSSKScheduler) {
                this.restoreKey(key, container, now);
            } else {
                otherScheduler.restoreKey(key, container, now);
            }
            if (!persistent) continue;
            container.deactivate((Object)key, 5);
        }
        return Long.MAX_VALUE;
    }

    private void restoreKey(Key key, ObjectContainer container, long now) {
        SendableGet[] reqs = container == null ? null : (this.schedCore == null ? null : this.schedCore.requestsForKey(key, container, this.clientContext));
        SendableGet[] transientReqs = this.schedTransient.requestsForKey(key, container, this.clientContext);
        if (reqs == null && transientReqs == null && logMINOR) {
            Logger.minor(this, "Restoring key but no keys queued?? for " + key);
        }
        if (reqs != null) {
            for (SendableGet req : reqs) {
                container.activate((Object)req, 1);
                req.requeueAfterCooldown(key, now, container, this.clientContext);
                container.deactivate((Object)req, 1);
            }
        }
        if (transientReqs != null) {
            for (SendableGet req : transientReqs) {
                req.requeueAfterCooldown(key, now, container, this.clientContext);
            }
        }
    }

    @Override
    public long countTransientQueuedRequests() {
        return this.schedTransient.countQueuedRequests(null, this.clientContext);
    }

    @Override
    public KeysFetchingLocally fetchingKeys() {
        return this.selector;
    }

    @Override
    public void removeFetchingKey(Key key) {
        this.selector.removeFetchingKey(key);
    }

    @Override
    public void removeTransientInsertFetching(SendableInsert insert, SendableRequestItemKey token) {
        this.selector.removeTransientInsertFetching(insert, token);
        insert.clearCooldown(null, this.clientContext, false);
    }

    @Override
    public void callFailure(final SendableGet get, final LowLevelGetException e, int prio, boolean persistent) {
        if (!persistent) {
            get.onFailure(e, null, null, this.clientContext);
        } else {
            try {
                this.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)get)) {
                            Logger.error(this, "ALREADY ACTIVE: " + get + " in callFailure(request)");
                        }
                        container.activate((Object)get, 1);
                        get.onFailure(e, null, container, ClientRequestScheduler.this.clientContext);
                        container.deactivate((Object)get, 1);
                        return false;
                    }

                    public String toString() {
                        return "SendableGet onFailure";
                    }
                }, prio, false);
            }
            catch (DatabaseDisabledException e1) {
                Logger.error(this, "callFailure() on a persistent request but database disabled", (Throwable)new Exception("error"));
            }
        }
    }

    @Override
    public void callFailure(final SendableInsert insert, final LowLevelPutException e, int prio, boolean persistent) {
        if (!persistent) {
            insert.onFailure(e, null, null, this.clientContext);
        } else {
            try {
                this.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)insert)) {
                            Logger.error(this, "ALREADY ACTIVE: " + insert + " in callFailure(insert)");
                        }
                        container.activate((Object)insert, 1);
                        insert.onFailure(e, null, container, context);
                        container.deactivate((Object)insert, 1);
                        return false;
                    }

                    public String toString() {
                        return "SendableInsert onFailure";
                    }
                }, prio, false);
            }
            catch (DatabaseDisabledException e1) {
                Logger.error(this, "callFailure() on a persistent request but database disabled", (Throwable)new Exception("error"));
            }
        }
    }

    @Override
    public FECQueue getFECQueue() {
        return this.clientContext.fecQueue;
    }

    @Override
    public ClientContext getContext() {
        return this.clientContext;
    }

    @Override
    public boolean addToFetching(Key key) {
        return this.selector.addToFetching(key);
    }

    @Override
    public boolean addTransientInsertFetching(SendableInsert insert, SendableRequestItemKey token) {
        return this.selector.addTransientInsertFetching(insert, token);
    }

    @Override
    public boolean hasFetchingKey(Key key, BaseSendableGet getterWaiting, boolean persistent, ObjectContainer container) {
        return this.selector.hasKey(key, null, false, null);
    }

    public long countPersistentWaitingKeys(ObjectContainer container) {
        if (this.schedCore == null) {
            return 0L;
        }
        return this.schedCore.countWaitingKeys(container);
    }

    public long countPersistentQueuedRequests(ObjectContainer container) {
        if (this.schedCore == null) {
            return 0L;
        }
        return this.schedCore.countQueuedRequests(container, this.clientContext);
    }

    public boolean isQueueAlmostEmpty() {
        return this.starterQueueSize() < 128;
    }

    public boolean isInsertScheduler() {
        return this.isInsertScheduler;
    }

    public void removeFromAllRequestsByClientRequest(ClientRequester clientRequest, SendableRequest get, boolean dontComplain, ObjectContainer container) {
        if (get.persistent()) {
            this.schedCore.removeFromAllRequestsByClientRequest(get, clientRequest, dontComplain, container);
        } else {
            this.schedTransient.removeFromAllRequestsByClientRequest(get, clientRequest, dontComplain, null);
        }
    }

    void addPersistentPendingKeys(KeyListener listener) {
        this.schedCore.addPendingKeys(listener);
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing ClientRequestScheduler in database", (Throwable)new Exception("error"));
        return false;
    }

    @Override
    public void wakeStarter() {
        this.starter.wakeUp();
    }

    public byte[] saltKey(boolean persistent, Key key) {
        return persistent ? this.schedCore.saltKey(key) : this.schedTransient.saltKey(key);
    }

    Node getNode() {
        return this.node;
    }

    static {
        Logger.registerClass(ClientRequestScheduler.class);
        WAIT_AFTER_NOTHING_TO_START = TimeUnit.SECONDS.toMillis(60L);
        TRIP_PENDING_PRIORITY = NativeThread.HIGH_PRIORITY - 1;
    }
}

