/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerBase;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.PersistentCooldownQueue;
import freenet.client.async.RegisterMe;
import freenet.node.Node;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.PrioritizedSerialExecutor;
import freenet.support.io.NativeThread;
import java.util.concurrent.TimeUnit;

class ClientRequestSchedulerCore
extends ClientRequestSchedulerBase {
    private final long nodeDBHandle;
    final PersistentCooldownQueue persistentCooldownQueue;
    private static volatile boolean logMINOR;
    private final byte[] globalSalt;
    private transient DBJob preRegisterMeRunner;
    private transient ObjectSet<RegisterMe> registerMeSet;
    private transient RegisterMeRunner registerMeRunner;

    public static ClientRequestSchedulerCore create(Node node, final boolean forInserts, final boolean forSSKs, final boolean forRT, final long nodeDBHandle, ObjectContainer selectorContainer, long cooldownTime, PrioritizedSerialExecutor databaseExecutor, ClientRequestScheduler sched, ClientContext context) {
        ClientRequestSchedulerCore core;
        if (selectorContainer == null) {
            return null;
        }
        ObjectSet results = selectorContainer.query((Predicate)new Predicate<ClientRequestSchedulerCore>(){
            private static final long serialVersionUID = -7517827015509774396L;

            public boolean match(ClientRequestSchedulerCore core) {
                if (core.nodeDBHandle != nodeDBHandle) {
                    return false;
                }
                if (core.isInsertScheduler != forInserts) {
                    return false;
                }
                if (core.isSSKScheduler != forSSKs) {
                    return false;
                }
                return core.isRTScheduler == forRT;
            }
        });
        if (results.hasNext()) {
            core = (ClientRequestSchedulerCore)results.next();
            selectorContainer.activate((Object)core, 2);
            System.err.println("Loaded core...");
            if (core.nodeDBHandle != nodeDBHandle) {
                throw new IllegalStateException("Wrong nodeDBHandle");
            }
            if (core.isInsertScheduler != forInserts) {
                throw new IllegalStateException("Wrong isInsertScheduler");
            }
            if (core.isSSKScheduler != forSSKs) {
                throw new IllegalStateException("Wrong forSSKs");
            }
        } else {
            core = new ClientRequestSchedulerCore(node, forInserts, forSSKs, forRT, selectorContainer, cooldownTime);
            selectorContainer.store((Object)core);
            System.err.println("Created new core...");
        }
        core.onStarted(selectorContainer, cooldownTime, sched, context);
        return core;
    }

    ClientRequestSchedulerCore(Node node, boolean forInserts, boolean forSSKs, boolean forRT, ObjectContainer selectorContainer, long cooldownTime) {
        super(forInserts, forSSKs, forRT, node.random);
        this.nodeDBHandle = node.nodeDBHandle;
        this.persistentCooldownQueue = !forInserts ? new PersistentCooldownQueue() : null;
        this.globalSalt = null;
    }

    private void onStarted(ObjectContainer container, long cooldownTime, ClientRequestScheduler sched, ClientContext context) {
        super.onStarted(container, context);
        System.err.println("insert scheduler: " + this.isInsertScheduler);
        if (!this.isInsertScheduler) {
            this.persistentCooldownQueue.setCooldownTime(cooldownTime);
        }
        this.sched = sched;
        this.hintGlobalSalt(this.globalSalt);
        if (this.isInsertScheduler) {
            this.preRegisterMeRunner = new DBJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    ClientRequestSchedulerCore clientRequestSchedulerCore = ClientRequestSchedulerCore.this;
                    synchronized (clientRequestSchedulerCore) {
                        if (ClientRequestSchedulerCore.this.registerMeSet != null) {
                            return false;
                        }
                    }
                    long tStart = System.currentTimeMillis();
                    ObjectSet results = null;
                    for (int i = 0; i <= 6; ++i) {
                        Query query = container.query();
                        query.constrain(RegisterMe.class);
                        query.descend("core").constrain((Object)ClientRequestSchedulerCore.this).and(query.descend("priority").constrain((Object)i));
                        results = query.execute();
                        if (results.hasNext()) break;
                        results = null;
                    }
                    if (results == null) {
                        return false;
                    }
                    ClientRequestSchedulerCore i = ClientRequestSchedulerCore.this;
                    synchronized (i) {
                        ClientRequestSchedulerCore.this.registerMeSet = results;
                    }
                    long tEnd = System.currentTimeMillis();
                    if (logMINOR) {
                        Logger.minor(this, "RegisterMe query took " + (tEnd - tStart) + " hasNext=" + ClientRequestSchedulerCore.this.registerMeSet.hasNext() + " for insert=" + ClientRequestSchedulerCore.this.isInsertScheduler + " ssk=" + ClientRequestSchedulerCore.this.isSSKScheduler);
                    }
                    boolean boost = ClientRequestSchedulerCore.this.sched.isQueueAlmostEmpty();
                    try {
                        context.jobRunner.queue(ClientRequestSchedulerCore.this.registerMeRunner, NativeThread.NORM_PRIORITY - 1 + (boost ? 1 : 0), true);
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return false;
                }
            };
            this.registerMeRunner = new RegisterMeRunner();
        }
    }

    void start(DBJobRunner runner) {
        this.startRegisterMeRunner(runner);
    }

    private void startRegisterMeRunner(DBJobRunner runner) {
        if (this.isInsertScheduler) {
            try {
                runner.queue(this.preRegisterMeRunner, NativeThread.NORM_PRIORITY, true);
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
        }
    }

    @Override
    boolean persistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rerunRegisterMeRunner(DBJobRunner runner) {
        ClientRequestSchedulerCore clientRequestSchedulerCore = this;
        synchronized (clientRequestSchedulerCore) {
            if (this.registerMeSet != null) {
                return;
            }
        }
        this.startRegisterMeRunner(runner);
    }

    @Override
    public synchronized long countQueuedRequests(ObjectContainer container, ClientContext context) {
        long ret = super.countQueuedRequests(container, context);
        long cooldown = this.persistentCooldownQueue.size(container);
        System.out.println("Cooldown queue size: " + cooldown);
        return ret + cooldown;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    class RegisterMeRunner
    implements DBJob {
        RegisterMeRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ObjectContainer container, ClientContext context) {
            if (ClientRequestSchedulerCore.this.sched.databaseExecutor.getQueueSize(NativeThread.NORM_PRIORITY) > 100 && !ClientRequestSchedulerCore.this.sched.isQueueAlmostEmpty()) {
                try {
                    context.jobRunner.queue(ClientRequestSchedulerCore.this.registerMeRunner, NativeThread.NORM_PRIORITY - 1, false);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
                return false;
            }
            long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
            if (ClientRequestSchedulerCore.this.registerMeSet == null) {
                Logger.error(this, "registerMeSet is null for " + ClientRequestSchedulerCore.this + " ( " + this + " )");
                return false;
            }
            for (int i = 0; i < 1000; ++i) {
                try {
                    if (!ClientRequestSchedulerCore.this.registerMeSet.hasNext()) {
                        break;
                    }
                }
                catch (NullPointerException t) {
                    Logger.error(this, "DB4O thew NPE in hasNext(): " + t, (Throwable)t);
                    try {
                        context.jobRunner.queue(ClientRequestSchedulerCore.this.preRegisterMeRunner, NativeThread.NORM_PRIORITY, true);
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return true;
                }
                catch (ClassCastException t) {
                    Logger.error(this, "DB4O thew ClassCastException in hasNext(): " + t, (Throwable)t);
                    try {
                        context.jobRunner.queue(ClientRequestSchedulerCore.this.preRegisterMeRunner, NativeThread.NORM_PRIORITY, true);
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return true;
                }
                RegisterMe reg = (RegisterMe)ClientRequestSchedulerCore.this.registerMeSet.next();
                container.activate((Object)reg, 1);
                if (reg.bootID == context.bootID) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not registering block " + reg + " as was added to the queue");
                    continue;
                }
                if (reg.core != ClientRequestSchedulerCore.this) {
                    if (!container.ext().isStored((Object)reg)) {
                        if (!logMINOR) continue;
                        Logger.minor(this, "Already deleted RegisterMe " + reg + " - skipping");
                        continue;
                    }
                    if (reg.core == null) {
                        Logger.error(this, "Leftover RegisterMe " + reg + " : core already deleted. THIS IS AN ERROR unless you have seen \"Old core not active\" messages before this point.");
                        container.delete((Object)reg);
                        continue;
                    }
                    if (!container.ext().isActive((Object)reg.core)) {
                        Logger.error(this, "Old core not active in RegisterMe " + reg + " - duplicated cores????");
                        container.delete((Object)reg.core);
                        container.delete((Object)reg);
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring RegisterMe " + reg + " as doesn't belong to me: my insert=" + ClientRequestSchedulerCore.this.isInsertScheduler + " my ssk=" + ClientRequestSchedulerCore.this.isSSKScheduler + " his insert=" + reg.core.isInsertScheduler + " his ssk=" + reg.core.isSSKScheduler);
                    }
                    container.deactivate((Object)reg, 1);
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Running RegisterMe " + reg + " for " + reg.nonGetRequest + " : " + reg.addedTime + " : " + reg.priority);
                }
                if (reg.nonGetRequest != null) {
                    container.activate((Object)reg.nonGetRequest, 1);
                    if (reg.nonGetRequest.isStorageBroken(container)) {
                        String toString = "(throws)";
                        try {
                            toString = reg.nonGetRequest.toString();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        Logger.error(this, "Stored SingleBlockInserter is broken, maybe leftover from database leakage?: " + toString);
                    } else if (reg.nonGetRequest.isCancelled(container)) {
                        Logger.normal(this, "RegisterMe: request cancelled: " + reg.nonGetRequest);
                    } else {
                        if (logMINOR) {
                            Logger.minor(this, "Registering RegisterMe for insert: " + reg.nonGetRequest);
                        }
                        ClientRequestSchedulerCore.this.sched.registerInsert(reg.nonGetRequest, true, false, container);
                    }
                    container.delete((Object)reg);
                    container.deactivate((Object)reg.nonGetRequest, 1);
                } else {
                    container.delete((Object)reg);
                    container.deactivate((Object)reg, 1);
                }
                if (System.currentTimeMillis() > deadline) break;
            }
            boolean boost = ClientRequestSchedulerCore.this.sched.isQueueAlmostEmpty();
            if (ClientRequestSchedulerCore.this.registerMeSet.hasNext()) {
                try {
                    context.jobRunner.queue(ClientRequestSchedulerCore.this.registerMeRunner, NativeThread.NORM_PRIORITY - 1 + (boost ? 1 : 0), true);
                }
                catch (DatabaseDisabledException e) {}
            } else {
                if (logMINOR) {
                    Logger.minor(this, "RegisterMeRunner finished");
                }
                ClientRequestSchedulerCore clientRequestSchedulerCore = ClientRequestSchedulerCore.this;
                synchronized (clientRequestSchedulerCore) {
                    ClientRequestSchedulerCore.this.registerMeSet = null;
                }
                ClientRequestSchedulerCore.this.preRegisterMeRunner.run(container, context);
            }
            return true;
        }
    }
}

