/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.CooldownCacheItem;
import freenet.client.async.CooldownTrackerItem;
import freenet.client.async.HasCooldownCacheItem;
import freenet.client.async.HasCooldownTrackerItem;
import freenet.client.async.PersistentCooldownCacheItem;
import freenet.client.async.TransientCooldownCacheItem;
import freenet.client.async.WantsCooldownCallback;
import freenet.support.Logger;
import freenet.support.RemoveRandomWithObject;
import freenet.support.Ticker;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

public class CooldownTracker {
    private static volatile boolean logMINOR;
    private final HashMap<Long, CooldownTrackerItem> trackerItemsPersistent = new HashMap();
    private final WeakHashMap<HasCooldownTrackerItem, CooldownTrackerItem> trackerItemsTransient = new WeakHashMap();
    private final HashMap<Long, PersistentCooldownCacheItem> cacheItemsPersistent = new HashMap();
    private final WeakHashMap<HasCooldownCacheItem, TransientCooldownCacheItem> cacheItemsTransient = new WeakHashMap();
    private static final long MAINTENANCE_PERIOD;

    public synchronized CooldownTrackerItem make(HasCooldownTrackerItem parent, boolean persistent, ObjectContainer container) {
        if (persistent) {
            if (!container.ext().isStored((Object)parent)) {
                throw new IllegalArgumentException("Must store first!");
            }
            long uid = container.ext().getID((Object)parent);
            CooldownTrackerItem item = this.trackerItemsPersistent.get(uid);
            if (item == null) {
                item = parent.makeCooldownTrackerItem();
                this.trackerItemsPersistent.put(uid, item);
            }
            return item;
        }
        CooldownTrackerItem item = this.trackerItemsTransient.get(parent);
        if (item == null) {
            item = parent.makeCooldownTrackerItem();
            this.trackerItemsTransient.put(parent, item);
        }
        return item;
    }

    public synchronized CooldownTrackerItem remove(HasCooldownTrackerItem parent, boolean persistent, ObjectContainer container) {
        if (persistent) {
            if (!container.ext().isStored((Object)parent)) {
                throw new IllegalArgumentException("Must store first!");
            }
            long uid = container.ext().getID((Object)parent);
            return this.trackerItemsPersistent.remove(uid);
        }
        return this.trackerItemsTransient.remove(parent);
    }

    public synchronized long getCachedWakeup(HasCooldownCacheItem toCheck, boolean persistent, ObjectContainer container, long now) {
        if (toCheck == null) {
            Logger.error(this, "Asked to check wakeup time for null!", (Throwable)new Exception("error"));
            return -1L;
        }
        if (persistent) {
            if (!container.ext().isStored((Object)toCheck)) {
                throw new IllegalArgumentException("Must store first!: " + toCheck);
            }
            long uid = container.ext().getID((Object)toCheck);
            CooldownCacheItem item = this.cacheItemsPersistent.get(uid);
            if (item == null) {
                return -1L;
            }
            if (item.timeValid < now) {
                this.cacheItemsPersistent.remove(uid);
                return -1L;
            }
            return item.timeValid;
        }
        CooldownCacheItem item = this.cacheItemsTransient.get(toCheck);
        if (item == null) {
            return -1L;
        }
        if (item.timeValid < now) {
            this.cacheItemsTransient.remove(toCheck);
            return -1L;
        }
        return item.timeValid;
    }

    public synchronized void setCachedWakeup(long wakeupTime, HasCooldownCacheItem toCheck, HasCooldownCacheItem parent, boolean persistent, ObjectContainer container, ClientContext context) {
        this.setCachedWakeup(wakeupTime, toCheck, parent, persistent, container, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCachedWakeup(long wakeupTime, HasCooldownCacheItem toCheck, HasCooldownCacheItem parent, boolean persistent, ObjectContainer container, ClientContext context, boolean dontLogOnClearingParents) {
        Object client;
        CooldownTracker cooldownTracker = this;
        synchronized (cooldownTracker) {
            if (logMINOR) {
                Logger.minor(this, "Wakeup time " + wakeupTime + " set for " + toCheck + " parent is " + parent);
            }
            if (persistent) {
                if (!container.ext().isStored((Object)toCheck)) {
                    throw new IllegalArgumentException("Must store first!");
                }
                long uid = container.ext().getID((Object)toCheck);
                if (parent != null && !container.ext().isStored((Object)parent)) {
                    throw new IllegalArgumentException("Must store first!");
                }
                long parentUID = parent == null ? -1L : container.ext().getID((Object)parent);
                PersistentCooldownCacheItem item = this.cacheItemsPersistent.get(uid);
                if (item == null) {
                    item = new PersistentCooldownCacheItem(wakeupTime, parentUID);
                    this.cacheItemsPersistent.put(uid, item);
                } else {
                    if (item.timeValid < wakeupTime) {
                        item.timeValid = wakeupTime;
                    }
                    item.parentID = parentUID;
                }
                if (parentUID != -1L) {
                    PersistentCooldownCacheItem checkParent;
                    while ((checkParent = this.cacheItemsPersistent.get(parentUID)) != null && checkParent.timeValid >= item.timeValid) {
                        if (checkParent.timeValid > item.timeValid) {
                            if (!dontLogOnClearingParents) {
                                Logger.error(this, "Corrected parent timeValid from " + checkParent.timeValid + " to " + item.timeValid, (Throwable)new Exception("debug"));
                            } else if (logMINOR) {
                                Logger.minor(this, "Corrected parent timeValid from " + checkParent.timeValid + " to " + item.timeValid);
                            }
                            checkParent.timeValid = item.timeValid;
                        }
                        if ((parentUID = checkParent.parentID) >= 0L) continue;
                        break;
                    }
                }
            } else {
                TransientCooldownCacheItem item = this.cacheItemsTransient.get(toCheck);
                if (item == null) {
                    item = new TransientCooldownCacheItem(wakeupTime, parent);
                    this.cacheItemsTransient.put(toCheck, item);
                } else {
                    if (item.timeValid < wakeupTime) {
                        item.timeValid = wakeupTime;
                    }
                    if (item.parent.get() != parent) {
                        item.parent = parent == null ? null : new WeakReference<HasCooldownCacheItem>(parent);
                    }
                }
                if (parent != null) {
                    TransientCooldownCacheItem checkParent;
                    while ((checkParent = this.cacheItemsTransient.get(parent)) != null && checkParent.timeValid >= item.timeValid) {
                        if (checkParent.timeValid > item.timeValid) {
                            if (!dontLogOnClearingParents) {
                                Logger.error(this, "Corrected parent timeValid from " + checkParent.timeValid + " to " + item.timeValid, (Throwable)new Exception("debug"));
                            } else if (logMINOR) {
                                Logger.minor(this, "Corrected parent timeValid from " + checkParent.timeValid + " to " + item.timeValid);
                            }
                            checkParent.timeValid = item.timeValid;
                        }
                        if ((parent = (HasCooldownCacheItem)checkParent.parent.get()) != null) continue;
                        break;
                    }
                }
            }
        }
        if (toCheck instanceof RemoveRandomWithObject && (client = ((RemoveRandomWithObject)toCheck).getObject()) instanceof WantsCooldownCallback) {
            boolean wasActive = true;
            if (persistent) {
                wasActive = container.ext().isActive(client);
            }
            if (!wasActive) {
                container.activate(client, 1);
            }
            ((WantsCooldownCallback)client).enterCooldown(wakeupTime, container, context);
            if (!wasActive) {
                container.deactivate(client, 1);
            }
        }
    }

    public synchronized boolean removeCachedWakeup(HasCooldownCacheItem toCheck, boolean persistent, ObjectContainer container) {
        if (persistent) {
            if (!container.ext().isStored((Object)toCheck)) {
                throw new IllegalArgumentException("Must store first!");
            }
            long uid = container.ext().getID((Object)toCheck);
            return this.cacheItemsPersistent.remove(uid) != null;
        }
        return this.cacheItemsTransient.remove(toCheck) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearCachedWakeup(HasCooldownCacheItem toCheck, boolean persistent, ObjectContainer container) {
        Object client;
        if (toCheck == null) {
            Logger.error(this, "Clearing cached wakeup for null", (Throwable)new Exception("error"));
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Clearing cached wakeup for " + toCheck);
        }
        if (persistent) {
            if (!container.ext().isStored((Object)toCheck)) {
                throw new IllegalArgumentException("Must store first!");
            }
            long uid = container.ext().getID((Object)toCheck);
            if (this.clearCachedWakeupPersistent(uid)) {
                Object client2;
                if (toCheck instanceof RemoveRandomWithObject && (client2 = ((RemoveRandomWithObject)toCheck).getObject()) instanceof WantsCooldownCallback) {
                    boolean wasActive = container.ext().isActive(client2);
                    if (!wasActive) {
                        container.activate(client2, 1);
                    }
                    ((WantsCooldownCallback)client2).clearCooldown(container);
                    if (!wasActive) {
                        container.deactivate(client2, 1);
                    }
                }
                return true;
            }
            return false;
        }
        boolean ret = false;
        CooldownTracker cooldownTracker = this;
        synchronized (cooldownTracker) {
            TransientCooldownCacheItem item;
            while ((item = this.cacheItemsTransient.get(toCheck)) != null) {
                if (logMINOR) {
                    Logger.minor(this, "Clearing " + toCheck);
                }
                ret = true;
                this.cacheItemsTransient.remove(toCheck);
                toCheck = (HasCooldownCacheItem)item.parent.get();
                if (toCheck == null) break;
                if (!logMINOR) continue;
                Logger.minor(this, "Parent is " + toCheck);
            }
        }
        if (toCheck instanceof RemoveRandomWithObject && (client = ((RemoveRandomWithObject)toCheck).getObject()) instanceof WantsCooldownCallback) {
            ((WantsCooldownCallback)client).clearCooldown(container);
        }
        return ret;
    }

    public synchronized boolean clearCachedWakeupPersistent(Long uid) {
        boolean ret = false;
        PersistentCooldownCacheItem item;
        while ((item = this.cacheItemsPersistent.get(uid)) != null) {
            if (logMINOR) {
                Logger.minor(this, "Clearing " + uid);
            }
            ret = true;
            this.cacheItemsPersistent.remove(uid);
            uid = item.parentID;
            if (uid == -1L) {
                return ret;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Parent is " + uid);
        }
        return ret;
    }

    public synchronized void clearExpired(long now) {
        int removedPersistent = 0;
        Iterator<Map.Entry<Long, PersistentCooldownCacheItem>> it = this.cacheItemsPersistent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, PersistentCooldownCacheItem> item = it.next();
            if (item.getValue().timeValid >= now) continue;
            ++removedPersistent;
            it.remove();
        }
        int removedTransient = 0;
        Iterator<Map.Entry<HasCooldownCacheItem, TransientCooldownCacheItem>> it2 = this.cacheItemsTransient.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<HasCooldownCacheItem, TransientCooldownCacheItem> item = it2.next();
            if (item.getValue().timeValid >= now) continue;
            ++removedTransient;
            it2.remove();
        }
        if (logMINOR) {
            Logger.minor(this, "Removed " + removedPersistent + " persistent cooldown cache items and " + removedTransient + " transient cooldown cache items");
        }
    }

    public void startMaintenance(final Ticker ticker) {
        ticker.queueTimedJob(new Runnable(){

            @Override
            public void run() {
                CooldownTracker.this.clearExpired(System.currentTimeMillis());
                ticker.queueTimedJob(this, MAINTENANCE_PERIOD);
            }
        }, MAINTENANCE_PERIOD);
    }

    static {
        Logger.registerClass(CooldownTracker.class);
        MAINTENANCE_PERIOD = TimeUnit.MINUTES.toMillis(10L);
    }
}

