/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.SingleFileInserter;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressJob;
import freenet.support.io.NativeThread;

public class InsertCompressor
implements CompressJob {
    public final long nodeDBHandle;
    public final SingleFileInserter inserter;
    final Bucket origData;
    public final int minSize;
    public final BucketFactory bucketFactory;
    public final boolean persistent;
    public final String compressorDescriptor;
    private transient boolean scheduled;
    private static volatile boolean logMINOR;
    private final long generateHashes;
    private final boolean pre1254;

    public InsertCompressor(long nodeDBHandle2, SingleFileInserter inserter2, Bucket origData2, int minSize2, BucketFactory bf, boolean persistent, long generateHashes, boolean pre1254) {
        this.nodeDBHandle = nodeDBHandle2;
        this.inserter = inserter2;
        this.origData = origData2;
        this.minSize = minSize2;
        this.bucketFactory = bf;
        this.persistent = persistent;
        this.compressorDescriptor = this.inserter.ctx.compressorDescriptor;
        this.generateHashes = generateHashes;
        this.pre1254 = pre1254;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ObjectContainer container, ClientContext ctx) {
        if (this.persistent) {
            container.activate((Object)this.inserter, 1);
            container.activate((Object)this.origData, 1);
        }
        if (this.origData == null) {
            if (this.inserter == null || this.inserter.cancelled()) {
                container.delete((Object)this);
                return;
            }
            if (this.inserter.parent == null) {
                Logger.error(this, "InsertCompressor for " + this.inserter + " has no parent! Not compressing...");
                container.delete((Object)this);
                return;
            }
            if (this.inserter.started()) {
                Logger.error(this, "Inserter started already, but we are about to attempt to compress the data!");
                container.delete((Object)this);
                return;
            }
            Logger.error(this, "Original data was deleted but inserter neither deleted nor cancelled nor missing!");
            container.delete((Object)this);
            return;
        }
        InsertCompressor insertCompressor = this;
        synchronized (insertCompressor) {
            if (this.scheduled) {
                Logger.error(this, "Already scheduled compression, not rescheduling");
                return;
            }
            this.scheduled = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Compressing " + this + " : origData.size=" + this.origData.size() + " for " + this.inserter + " origData=" + this.origData + " hashes=" + this.generateHashes);
        }
        ctx.rc.enqueueNewJob(this);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void tryCompress(ClientContext context) throws InsertException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fail(final InsertException ie, ClientContext context, Bucket bestCompressedData) {
        if (this.persistent) {
            try {
                context.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (!container.ext().isStored((Object)InsertCompressor.this.inserter)) {
                            if (logMINOR) {
                                Logger.minor(this, "Already deleted (on failed): " + InsertCompressor.this.inserter + " for " + InsertCompressor.this);
                            }
                            container.delete((Object)InsertCompressor.this);
                            return false;
                        }
                        if (container.ext().isActive((Object)InsertCompressor.this.inserter)) {
                            Logger.error(this, "ALREADY ACTIVE in compress failure callback: " + InsertCompressor.this.inserter);
                        }
                        container.activate((Object)InsertCompressor.this.inserter, 1);
                        container.activate((Object)InsertCompressor.this.inserter.cb, 1);
                        InsertCompressor.this.inserter.cb.onFailure(ie, InsertCompressor.this.inserter, container, context);
                        container.deactivate((Object)InsertCompressor.this.inserter.cb, 1);
                        container.deactivate((Object)InsertCompressor.this.inserter, 1);
                        container.delete((Object)InsertCompressor.this);
                        return true;
                    }
                }, NativeThread.NORM_PRIORITY + 1, false);
            }
            catch (DatabaseDisabledException e1) {
                Logger.error(this, "Database disabled compressing data", (Throwable)new Exception("error"));
                if (bestCompressedData != null && bestCompressedData != this.origData) {
                    bestCompressedData.free();
                }
            }
        } else {
            this.inserter.cb.onFailure(ie, this.inserter, null, context);
        }
    }

    public static InsertCompressor start(ObjectContainer container, ClientContext context, SingleFileInserter inserter, Bucket origData, int minSize, BucketFactory bf, boolean persistent, long generateHashes, boolean pre1254) {
        if (persistent != (container != null)) {
            throw new IllegalStateException("Starting compression, persistent=" + persistent + " but container=" + container);
        }
        InsertCompressor compressor = new InsertCompressor(context.nodeDBHandle, inserter, origData, minSize, bf, persistent, generateHashes, pre1254);
        if (persistent) {
            container.store((Object)compressor);
        }
        compressor.init(container, context);
        return compressor;
    }

    public static void load(ObjectContainer container, ClientContext context) {
        long handle = context.nodeDBHandle;
        Query query = container.query();
        query.constrain(InsertCompressor.class);
        query.descend("nodeDBHandle").constrain((Object)handle);
        ObjectSet results = query.execute();
        while (results.hasNext()) {
            InsertCompressor comp = (InsertCompressor)results.next();
            if (!container.ext().isActive((Object)comp)) {
                Logger.error(InsertCompressor.class, "InsertCompressor not activated by query?!?!");
                container.activate((Object)comp, 1);
            }
            comp.init(container, context);
        }
    }

    @Override
    public void onFailure(final InsertException e, ClientPutState c, ClientContext context) {
        if (this.persistent) {
            try {
                context.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)InsertCompressor.this.inserter)) {
                            Logger.error(this, "ALREADY ACTIVE in compress failure callback: " + InsertCompressor.this.inserter);
                        }
                        container.activate((Object)InsertCompressor.this.inserter, 1);
                        container.activate((Object)InsertCompressor.this.inserter.cb, 1);
                        InsertCompressor.this.inserter.cb.onFailure(e, InsertCompressor.this.inserter, container, context);
                        container.deactivate((Object)InsertCompressor.this.inserter.cb, 1);
                        container.deactivate((Object)InsertCompressor.this.inserter, 1);
                        container.delete((Object)InsertCompressor.this);
                        return true;
                    }
                }, NativeThread.NORM_PRIORITY + 1, false);
            }
            catch (DatabaseDisabledException e1) {}
        } else {
            this.inserter.cb.onFailure(e, this.inserter, null, context);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

