/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.SplitfileBlock;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;

public class MinimalSplitfileBlock
implements SplitfileBlock {
    private static volatile boolean logMINOR;
    public final int number;
    private Bucket data;
    boolean flag;

    public MinimalSplitfileBlock(int n) {
        this.number = n;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public synchronized Bucket getData() {
        return this.data;
    }

    @Override
    public synchronized Bucket trySetData(Bucket data) {
        if (this.data != null) {
            return this.data;
        }
        this.data = data;
        return null;
    }

    @Override
    public synchronized void assertSetData(Bucket data) {
        assert (this.data == null || this.data == data);
        this.data = data;
    }

    @Override
    public synchronized Bucket clearData() {
        Bucket ret = this.data;
        this.data = null;
        return ret;
    }

    @Override
    public synchronized Bucket replaceData(Bucket data) {
        Bucket ret = this.data;
        this.data = data;
        return ret;
    }

    @Override
    public synchronized void storeTo(ObjectContainer container) {
        if (this.data != null) {
            this.data.storeTo(container);
        }
        container.store((Object)this);
        if (logMINOR) {
            Logger.minor(this, "Storing " + this + " with data: " + this.data + " id = " + container.ext().getID((Object)this));
        }
    }

    public synchronized void removeFrom(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + this + " with data: " + this.data);
        }
        if (this.data != null) {
            container.activate((Object)this.data, 1);
            this.data.removeFrom(container);
        }
        container.delete((Object)this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

