/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerCore;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.NoValidBlocksException;
import freenet.client.async.PersistentChosenBlock;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.BulkCallFailureItem;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestSender;
import freenet.node.SupportsBulkCallFailure;
import freenet.support.ListUtils;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class PersistentChosenRequest {
    public final transient SendableRequest request;
    public final transient short prio;
    public final transient boolean localRequestOnly;
    public final transient boolean ignoreStore;
    public final transient boolean canWriteClientCache;
    public final transient boolean forkOnCacheable;
    public final transient boolean realTimeFlag;
    public final transient ArrayList<PersistentChosenBlock> blocksNotStarted;
    public final transient HashSet<PersistentChosenBlock> blocksStarted;
    public final transient HashSet<PersistentChosenBlock> blocksFinished;
    public final RequestScheduler scheduler;
    public final SendableRequestSender sender;
    private boolean logMINOR;
    private boolean finished;

    PersistentChosenRequest(SendableRequest req, short prio, ObjectContainer container, RequestScheduler sched, ClientContext context) throws NoValidBlocksException {
        KeysFetchingLocally keys;
        List<PersistentChosenBlock> candidates;
        SendableRequest sg;
        this.request = req;
        this.prio = prio;
        if (req instanceof SendableGet) {
            sg = (SendableGet)req;
            FetchContext ctx = ((SendableGet)sg).getContext(container);
            if (container != null) {
                container.activate((Object)ctx, 1);
            }
            this.localRequestOnly = ctx.localRequestOnly;
            this.ignoreStore = ctx.ignoreStore;
            this.canWriteClientCache = ctx.canWriteClientCache;
            this.realTimeFlag = sg.realTimeFlag();
            this.forkOnCacheable = false;
        } else if (req instanceof SendableInsert) {
            sg = (SendableInsert)req;
            this.localRequestOnly = ((SendableInsert)sg).localRequestOnly(container);
            this.canWriteClientCache = ((SendableInsert)sg).canWriteClientCache(container);
            this.ignoreStore = false;
            this.forkOnCacheable = ((SendableInsert)sg).forkOnCacheable(container);
            this.realTimeFlag = sg.realTimeFlag();
        } else {
            throw new IllegalStateException("Creating a PersistentChosenRequest for " + req);
        }
        this.scheduler = sched;
        boolean reqActive = container.ext().isActive((Object)req);
        if (!reqActive) {
            container.activate((Object)req, 1);
        }
        if ((candidates = req.makeBlocks(this, sched, keys = sched.fetchingKeys(), container, context)) == null) {
            if (!reqActive) {
                container.deactivate((Object)req, 1);
            }
            throw new NoValidBlocksException();
        }
        this.blocksNotStarted = new ArrayList(candidates.size());
        this.blocksStarted = new HashSet(candidates.size() * 2);
        this.blocksFinished = new HashSet(candidates.size() * 2);
        this.blocksNotStarted.addAll(candidates);
        this.sender = req.getSender(container, context);
        if (!reqActive) {
            container.deactivate((Object)req, 1);
        }
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFinished(PersistentChosenBlock block, ClientContext context) {
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (this.logMINOR) {
            Logger.minor(this, "onFinished() on " + this + " for " + block, (Throwable)new Exception("debug"));
        }
        PersistentChosenRequest persistentChosenRequest = this;
        synchronized (persistentChosenRequest) {
            while (this.blocksNotStarted.remove(block)) {
                Logger.error(this, "Block finished but was in blocksNotStarted: " + block + " for " + this, (Throwable)new Exception("error"));
            }
            this.blocksStarted.remove(block);
            if (this.blocksFinished.contains(block)) {
                Logger.error(this, "Block already in blocksFinished: " + block + " for " + this);
                return;
            }
            this.blocksFinished.add(block);
            if (!this.blocksNotStarted.isEmpty() || !this.blocksStarted.isEmpty()) {
                if (this.logMINOR) {
                    Logger.minor(this, "Not finishing yet: blocks not started: " + this.blocksNotStarted.size() + " started: " + this.blocksStarted.size() + " finished: " + this.blocksFinished.size() + " for " + this);
                }
                return;
            }
        }
        try {
            context.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    PersistentChosenRequest.this.finish(container, context, false, false);
                    return true;
                }
            }, NativeThread.NORM_PRIORITY + 1, false);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(ObjectContainer container, ClientContext context, boolean dumping, boolean alreadyActive) {
        PersistentChosenBlock[] finishedBlocks;
        if (!container.ext().isStored((Object)this.request)) {
            if (this.logMINOR) {
                Logger.minor(this, "Request apparently already deleted: " + this.request + " on " + this);
            }
            this.scheduler.removeRunningRequest(this.request, container);
            return;
        }
        if (!alreadyActive && container.ext().isActive((Object)this.request)) {
            Logger.warning(this, "ALREADY ACTIVATED: " + this.request, (Throwable)new Exception("debug"));
        }
        if (!alreadyActive) {
            container.activate((Object)this.request, 1);
        }
        Logger.normal(this, "Finishing " + this + " for " + this.request);
        PersistentChosenRequest persistentChosenRequest = this;
        synchronized (persistentChosenRequest) {
            int startedSize;
            if (this.finished) {
                if (this.blocksFinished.isEmpty()) {
                    if (!alreadyActive) {
                        container.deactivate((Object)this.request, 1);
                    }
                    return;
                }
                Logger.error(this, "Finished but blocksFinished not empty on " + this, (Throwable)new Exception("debug"));
            }
            if ((startedSize = this.blocksStarted.size()) > 0) {
                Logger.error(this, "Still waiting for callbacks on " + this + " for " + startedSize + " blocks");
                return;
            }
            this.finished = true;
            finishedBlocks = this.blocksFinished.toArray(new PersistentChosenBlock[this.blocksFinished.size()]);
        }
        if (finishedBlocks.length == 0) {
            if (!dumping) {
                Logger.error(this, "No finished blocks in finish() on " + this);
            } else if (this.logMINOR) {
                Logger.minor(this, "No finished blocks in finish() on " + this);
            }
            this.scheduler.removeRunningRequest(this.request, container);
            if (!alreadyActive) {
                container.deactivate((Object)this.request, 1);
            }
            return;
        }
        if (this.request instanceof SendableGet) {
            boolean supportsBulk = this.request instanceof SupportsBulkCallFailure;
            ArrayList<BulkCallFailureItem> bulkFailItems = null;
            for (PersistentChosenBlock block : finishedBlocks) {
                if (block.fetchSucceeded()) continue;
                LowLevelGetException e = block.failedGet();
                if (supportsBulk) {
                    if (bulkFailItems == null) {
                        bulkFailItems = new ArrayList<BulkCallFailureItem>();
                    }
                    bulkFailItems.add(new BulkCallFailureItem(e, block.token));
                    continue;
                }
                ((SendableGet)this.request).onFailure(e, block.token, container, context);
            }
            if (bulkFailItems != null) {
                ((SupportsBulkCallFailure)((Object)this.request)).onFailure(bulkFailItems.toArray(new BulkCallFailureItem[bulkFailItems.size()]), container, context);
            }
        } else {
            container.activate((Object)this.request, 1);
            for (PersistentChosenBlock block : finishedBlocks) {
                ClientKey key = block.getGeneratedKey();
                if (key != null) {
                    ((SendableInsert)this.request).onEncode(block.token, key, container, context);
                }
                if (block.insertSucceeded()) {
                    ((SendableInsert)this.request).onSuccess(block.token, container, context);
                    continue;
                }
                ((SendableInsert)this.request).onFailure(block.failedPut(), block.token, container, context);
            }
        }
        this.scheduler.removeRunningRequest(this.request, container);
        if (this.request instanceof SendableInsert) {
            if (!container.ext().isActive((Object)this.request)) {
                container.activate((Object)this.request, 1);
            }
            if (!((SendableInsert)this.request).isEmpty(container) && !this.request.isCancelled(container)) {
                this.request.getScheduler(container, context).maybeAddToStarterQueue(this.request, container, null);
                this.request.getScheduler(container, context).wakeStarter();
            }
        }
        if (!alreadyActive) {
            container.deactivate((Object)this.request, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ChosenBlock grabNotStarted(Random random, RequestScheduler sched) {
        PersistentChosenBlock ret;
        ArrayList<PersistentChosenBlock> dumped = null;
        try {
            PersistentChosenRequest persistentChosenRequest = this;
            // MONITORENTER : persistentChosenRequest
        }
        catch (Throwable throwable) {
            if (dumped == null) throw throwable;
            Iterator i$ = dumped.iterator();
            while (i$.hasNext()) {
                PersistentChosenBlock block = (PersistentChosenBlock)i$.next();
                block.onDumped();
            }
            throw throwable;
        }
        while (true) {
            if (this.blocksNotStarted.isEmpty()) {
                ChosenBlock chosenBlock = null;
                // MONITOREXIT : persistentChosenRequest
                if (dumped == null) return chosenBlock;
                Iterator i$ = dumped.iterator();
                while (i$.hasNext()) {
                    PersistentChosenBlock block = (PersistentChosenBlock)i$.next();
                    block.onDumped();
                }
                return chosenBlock;
            }
            ret = ListUtils.removeRandomBySwapLastSimple(random, this.blocksNotStarted);
            Key key = ret.key;
            if (key == null || !sched.hasFetchingKey(key, null, false, null)) break;
            if (dumped == null) {
                dumped = new ArrayList<PersistentChosenBlock>();
            }
            dumped.add(ret);
        }
        this.blocksStarted.add(ret);
        PersistentChosenBlock persistentChosenBlock = ret;
        // MONITOREXIT : persistentChosenRequest
        if (dumped == null) return persistentChosenBlock;
        Iterator i$ = dumped.iterator();
        while (i$.hasNext()) {
            PersistentChosenBlock block = (PersistentChosenBlock)i$.next();
            block.onDumped();
        }
        return persistentChosenBlock;
    }

    public synchronized int sizeNotStarted() {
        return this.blocksNotStarted.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDumped(ClientRequestSchedulerCore core, ObjectContainer container, boolean reqAlreadyActive) {
        boolean wasStarted;
        PersistentChosenBlock[] blocks;
        if (this.logMINOR) {
            Logger.minor(this, "Dumping " + this);
        }
        this.scheduler.removeRunningRequest(this.request, container);
        PersistentChosenRequest persistentChosenRequest = this;
        synchronized (persistentChosenRequest) {
            blocks = this.blocksNotStarted.toArray(new PersistentChosenBlock[this.blocksNotStarted.size()]);
            this.blocksNotStarted.clear();
            wasStarted = !this.blocksStarted.isEmpty();
        }
        for (PersistentChosenBlock block : blocks) {
            block.onDumped();
        }
        if (!wasStarted) {
            if (this.logMINOR) {
                Logger.minor(this, "Finishing immediately in onDumped() as nothing pending: " + this);
            }
            this.finish(container, core.sched.clientContext, true, reqAlreadyActive);
        }
    }

    public synchronized void pruneDuplicates(ClientRequestScheduler sched) {
        Iterator<PersistentChosenBlock> iter = this.blocksNotStarted.iterator();
        while (iter.hasNext()) {
            PersistentChosenBlock block = iter.next();
            Key key = block.key;
            if (key == null || !sched.hasFetchingKey(key, null, false, null)) continue;
            iter.remove();
            if (!this.logMINOR) continue;
            Logger.minor(this, "Pruned duplicate " + block + " from " + this);
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanActivate(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }
}

