/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientPutter;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.ManifestElement;
import freenet.client.async.ManifestPutter;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.NativeThread;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class SimpleManifestPutter
extends ManifestPutter
implements PutCompletionCallback {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private HashMap<String, Object> putHandlersByName;
    private HashSet<PutHandler> runningPutHandlers;
    private HashSet<PutHandler> putHandlersWaitingForMetadata;
    private HashSet<PutHandler> waitingForBlockSets;
    private HashSet<PutHandler> putHandlersWaitingForFetchable;
    private FreenetURI finalURI;
    private FreenetURI targetURI;
    private boolean finished;
    private final InsertContext ctx;
    final ClientPutCallback cb;
    private final boolean getCHKOnly;
    private boolean insertedAllFiles;
    private boolean insertedManifest;
    private final HashMap<Metadata, ClientPutState> metadataPuttersByMetadata;
    private final HashMap<Metadata, ClientPutState> metadataPuttersUnfetchable;
    private final String defaultName;
    private int numberOfFiles;
    private long totalSize;
    private boolean metadataBlockSetFinalized;
    private Metadata baseMetadata;
    private boolean hasResolvedBase;
    private static final String[] defaultDefaultNames;
    private int bytesOnZip;
    private ArrayList<PutHandler> elementsToPutInArchive;
    private boolean fetchable;
    private final boolean earlyEncode;
    final byte[] forceCryptoKey;
    final byte cryptoAlgorithm;
    private final DBJob runGotAllMetadata = new DBJob(){

        @Override
        public boolean run(ObjectContainer container, ClientContext context) {
            try {
                context.jobRunner.removeRestartJob(this, NativeThread.NORM_PRIORITY, container);
            }
            catch (DatabaseDisabledException e) {
                return false;
            }
            container.activate((Object)SimpleManifestPutter.this, 1);
            SimpleManifestPutter.this.innerGotAllMetadata(container, context);
            container.deactivate((Object)SimpleManifestPutter.this, 1);
            return true;
        }
    };
    protected int minSuccessFetchBlocks;

    private SimpleManifestPutter() {
        this.metadataPuttersUnfetchable = null;
        this.metadataPuttersByMetadata = null;
        this.getCHKOnly = false;
        this.forceCryptoKey = null;
        this.earlyEncode = false;
        this.defaultName = null;
        this.ctx = null;
        this.cryptoAlgorithm = 0;
        this.cb = null;
    }

    public SimpleManifestPutter(ClientPutCallback cb, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly, RequestClient clientContext, boolean earlyEncode, boolean persistent, ObjectContainer container, ClientContext context) {
        this(cb, manifestElements, prioClass, target, defaultName, ctx, getCHKOnly, clientContext, earlyEncode, persistent, null, container, context);
    }

    private static byte[] getRandomSplitfileKeys(FreenetURI target, InsertContext ctx, boolean persistent, ObjectContainer container, ClientContext context) {
        boolean randomiseSplitfileKeys = ClientPutter.randomiseSplitfileKeys(target, ctx, persistent, container);
        if (randomiseSplitfileKeys) {
            byte[] forceCryptoKey = new byte[32];
            context.random.nextBytes(forceCryptoKey);
            return forceCryptoKey;
        }
        return null;
    }

    public SimpleManifestPutter(ClientPutCallback cb, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly, RequestClient clientContext, boolean earlyEncode, boolean persistent, byte[] forceCryptoKey, ObjectContainer container, ClientContext context) {
        super(prioClass, clientContext);
        InsertContext.CompatibilityMode mode;
        this.defaultName = defaultName;
        if (defaultName != null) {
            if (persistent) {
                container.activate(manifestElements, Integer.MAX_VALUE);
            }
            SimpleManifestPutter.checkDefaultName(manifestElements, defaultName);
        }
        if (this.client.persistent()) {
            container.activate((Object)ctx, 1);
        }
        this.cryptoAlgorithm = (mode = ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && mode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1416.ordinal() ? (byte)2 : (byte)3;
        this.targetURI = persistent ? target.clone() : target;
        this.forceCryptoKey = forceCryptoKey != null ? forceCryptoKey : SimpleManifestPutter.getRandomSplitfileKeys(target, ctx, persistent, container, context);
        this.cb = cb;
        this.ctx = ctx;
        this.getCHKOnly = getCHKOnly;
        this.earlyEncode = earlyEncode;
        this.putHandlersByName = new HashMap();
        this.runningPutHandlers = new HashSet();
        this.putHandlersWaitingForMetadata = new HashSet();
        this.putHandlersWaitingForFetchable = new HashSet();
        this.waitingForBlockSets = new HashSet();
        this.metadataPuttersByMetadata = new HashMap();
        this.metadataPuttersUnfetchable = new HashMap();
        this.elementsToPutInArchive = new ArrayList();
        this.makePutHandlers(manifestElements, this.putHandlersByName, persistent);
        this.checkZips();
    }

    private static void checkDefaultName(HashMap<String, Object> manifestElements, String defaultName) {
        int idx;
        while ((idx = defaultName.indexOf(47)) != -1) {
            String dir = defaultName.substring(0, idx);
            String subname = defaultName.substring(idx + 1);
            Object o = manifestElements.get(defaultName);
            if (o == null) {
                throw new IllegalArgumentException("Default name dir \"" + dir + "\" does not exist");
            }
            if (!(o instanceof HashMap)) {
                throw new IllegalArgumentException("Default name dir \"" + dir + "\" is not a directory in \"" + defaultName + "\"");
            }
            manifestElements = (HashMap)o;
            defaultName = subname;
        }
        Object o = manifestElements.get(defaultName);
        if (o == null) {
            throw new IllegalArgumentException("Default name \"" + defaultName + "\" does not exist");
        }
        if (o instanceof HashMap) {
            throw new IllegalArgumentException("Default filename \"" + defaultName + "\" is a directory?!");
        }
    }

    private void checkZips() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        PutHandler[] running;
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " persistence=" + this.persistent());
        }
        if (this.persistent()) {
            container.activate(this.runningPutHandlers, 2);
        }
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
        }
        try {
            boolean persistent = this.persistent();
            for (int i = 0; i < running.length; ++i) {
                if (logMINOR) {
                    Logger.minor(this, "Starting " + running[i]);
                }
                running[i].start(container, context);
                SimpleManifestPutter simpleManifestPutter2 = this;
                synchronized (simpleManifestPutter2) {
                    if (this.finished) {
                        return;
                    }
                }
                if (persistent && !container.ext().isActive((Object)this)) {
                    container.activate((Object)this, 1);
                }
                if (logMINOR) {
                    Logger.minor(this, "Started " + i + " of " + running.length);
                }
                if (!this.isFinished()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Already finished, killing start() on " + this);
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + running.length + " PutHandler's for " + this);
            }
            if (running.length == 0) {
                this.insertedAllFiles = true;
                if (this.persistent()) {
                    container.store((Object)this);
                }
                this.gotAllMetadata(container, context);
            }
        }
        catch (InsertException e) {
            SimpleManifestPutter simpleManifestPutter3 = this;
            synchronized (simpleManifestPutter3) {
                this.finished = true;
            }
            this.cancelAndFinish(container, context);
            throw e;
        }
    }

    protected void makePutHandlers(HashMap<String, Object> manifestElements, HashMap<String, Object> putHandlersByName, boolean persistent) {
        this.makePutHandlers(manifestElements, putHandlersByName, "", persistent);
    }

    private void makePutHandlers(HashMap<String, Object> manifestElements, HashMap<String, Object> putHandlersByName, String ZipPrefix, boolean persistent) {
        for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
            PutHandler ph;
            String name = entry.getKey();
            Object o = entry.getValue();
            if (o instanceof HashMap) {
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                HashMap<String, Object> elements = Metadata.forceMap(o);
                putHandlersByName.put(name, subMap);
                this.makePutHandlers(elements, subMap, ZipPrefix + name + '/', persistent);
                if (!logDEBUG) continue;
                Logger.debug(this, "Sub map for " + name + " : " + subMap.size() + " elements from " + elements.size());
                continue;
            }
            ManifestElement element = (ManifestElement)o;
            String mimeType = element.mimeOverride;
            if (mimeType == null) {
                mimeType = DefaultMIMETypes.guessMIMEType(name, true);
            }
            ClientMetadata cm = mimeType == null || mimeType.equals("application/octet-stream") ? null : new ClientMetadata(mimeType);
            Bucket data = element.data;
            if (element.targetURI != null) {
                ph = new PutHandler(this, name, element.targetURI, cm, persistent);
            } else {
                int sz = 512 + ((int)data.size() + 511) / 512 * 512;
                if (data.size() <= 65536L && this.bytesOnZip + sz < 2021376) {
                    this.bytesOnZip += sz;
                    if (logMINOR) {
                        Logger.minor(this, "Putting into ZIP: " + name);
                    }
                    ph = new PutHandler(this, name, ZipPrefix + element.fullName, cm, data, persistent);
                    if (logMINOR) {
                        Logger.minor(this, "Putting file into container: " + element.fullName + " : " + ph);
                    }
                    this.elementsToPutInArchive.add(ph);
                    ++this.numberOfFiles;
                    this.totalSize += data.size();
                } else {
                    ph = new PutHandler(this, name, data, cm, this.getCHKOnly, persistent);
                    this.runningPutHandlers.add(ph);
                    this.putHandlersWaitingForMetadata.add(ph);
                    this.putHandlersWaitingForFetchable.add(ph);
                    if (logMINOR) {
                        Logger.minor(this, "Inserting separately as PutHandler: " + name + " : " + ph + " persistent=" + ph.persistent() + ":" + ph.persistent + " " + this.persistent());
                    }
                    ++this.numberOfFiles;
                    this.totalSize += data.size();
                }
            }
            putHandlersByName.put(name, ph);
        }
    }

    @Override
    public FreenetURI getURI() {
        return this.finalURI;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    @Override
    public byte[] getSplitfileCryptoKey() {
        return this.forceCryptoKey;
    }

    private void gotAllMetadata(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.runGotAllMetadata, 1);
            try {
                context.jobRunner.queueRestartJob(this.runGotAllMetadata, NativeThread.NORM_PRIORITY, container, false);
                context.jobRunner.queue(this.runGotAllMetadata, NativeThread.NORM_PRIORITY, false);
            }
            catch (DatabaseDisabledException e) {
                return;
            }
        } else {
            this.innerGotAllMetadata(null, context);
        }
    }

    private void innerGotAllMetadata(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate(this.putHandlersByName, 2);
        }
        if (logMINOR) {
            Logger.minor(this, "Got all metadata");
        }
        HashMap<String, Object> namesToByteArrays = new HashMap<String, Object>();
        this.namesToByteArrays(this.putHandlersByName, namesToByteArrays, container);
        if (this.defaultName != null) {
            Metadata meta = (Metadata)namesToByteArrays.get(this.defaultName);
            if (meta == null) {
                this.fail(new InsertException(1, "Default name " + this.defaultName + " does not exist", null), container, context);
                return;
            }
            namesToByteArrays.put("", meta);
        } else {
            for (String name : defaultDefaultNames) {
                Metadata meta = (Metadata)namesToByteArrays.get(name);
                if (meta == null) continue;
                namesToByteArrays.put("", meta);
                break;
            }
        }
        this.baseMetadata = Metadata.mkRedirectionManifestWithMetadata(namesToByteArrays);
        if (this.persistent()) {
            container.store((Object)this.baseMetadata);
            container.store((Object)this);
        }
        this.resolveAndStartBase(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAndStartBase(ObjectContainer container, ClientContext context) {
        SingleFileInserter metadataInserter;
        InsertBlock block;
        byte[] ckey;
        ArchiveManager.ARCHIVE_TYPE archiveType;
        boolean isMetadata;
        block39: {
            Bucket bucket;
            block38: {
                bucket = null;
                SimpleManifestPutter simpleManifestPutter = this;
                synchronized (simpleManifestPutter) {
                    if (this.hasResolvedBase) {
                        return;
                    }
                }
                try {
                    if (this.persistent()) {
                        container.activate((Object)this.baseMetadata, Integer.MAX_VALUE);
                    }
                    bucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent()), this.baseMetadata.writeToByteArray());
                    if (logMINOR) {
                        Logger.minor(this, "Metadata bucket is " + bucket.size() + " bytes long");
                    }
                }
                catch (IOException e) {
                    this.fail(new InsertException(2, e, null), container, context);
                    return;
                }
                catch (MetadataUnresolvedException e) {
                    try {
                        if (logMINOR) {
                            Logger.minor(this, "Main metadata needs resolving: " + e);
                        }
                        this.resolve(e, container, context);
                        if (this.persistent()) {
                            container.deactivate((Object)this.baseMetadata, 1);
                        }
                        return;
                    }
                    catch (IOException e1) {
                        if (this.persistent()) {
                            container.deactivate((Object)this.baseMetadata, 1);
                        }
                        this.fail(new InsertException(2, e, null), container, context);
                        return;
                    }
                    catch (InsertException e2) {
                        if (this.persistent()) {
                            container.deactivate((Object)this.baseMetadata, 1);
                        }
                        this.fail(e2, container, context);
                        return;
                    }
                }
                if (bucket == null) {
                    return;
                }
                SimpleManifestPutter e = this;
                synchronized (e) {
                    if (this.hasResolvedBase) {
                        return;
                    }
                    this.hasResolvedBase = true;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                    container.activate(this.elementsToPutInArchive, 2);
                }
                isMetadata = true;
                archiveType = null;
                ckey = null;
                if (this.elementsToPutInArchive.isEmpty()) break block38;
                ckey = this.forceCryptoKey;
                BufferedOutputStream os = null;
                try {
                    String mimeType;
                    Bucket outputBucket = context.getBucketFactory(this.persistent()).makeBucket(this.baseMetadata.dataLength());
                    archiveType = ArchiveManager.ARCHIVE_TYPE.getDefault();
                    os = new BufferedOutputStream(outputBucket.getOutputStream());
                    String string = mimeType = archiveType == ArchiveManager.ARCHIVE_TYPE.TAR ? this.createTarBucket(bucket, os, container) : this.createZipBucket(bucket, os, container);
                    if (logMINOR) {
                        Logger.minor(this, "Archive size is " + outputBucket.size());
                    }
                    bucket.free();
                    if (this.persistent()) {
                        bucket.removeFrom(container);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "We are using " + (Object)((Object)archiveType));
                    }
                    if (this.persistent()) {
                        container.activate((Object)this.targetURI, 5);
                    }
                    block = new InsertBlock(outputBucket, new ClientMetadata(mimeType), this.persistent() ? this.targetURI.clone() : this.targetURI);
                    isMetadata = false;
                }
                catch (IOException e2) {
                    block37: {
                        try {
                            this.fail(new InsertException(2, e2, null), container, context);
                            if (!this.persistent()) break block37;
                            container.deactivate((Object)this.baseMetadata, 1);
                        }
                        catch (Throwable throwable) {
                            Closer.close(os);
                            throw throwable;
                        }
                    }
                    Closer.close(os);
                    return;
                }
                Closer.close(os);
                break block39;
            }
            if (this.persistent()) {
                container.activate((Object)this.targetURI, 5);
            }
            block = new InsertBlock(bucket, null, this.persistent() ? this.targetURI.clone() : this.targetURI);
        }
        try {
            metadataInserter = new SingleFileInserter(this, this, block, isMetadata, this.ctx, this.realTimeFlag, archiveType == ArchiveManager.ARCHIVE_TYPE.ZIP, this.getCHKOnly, false, this.baseMetadata, archiveType, true, null, this.earlyEncode, true, this.persistent(), 0L, 0L, null, this.cryptoAlgorithm, ckey, -1L);
            if (logMINOR) {
                Logger.minor(this, "Inserting main metadata: " + metadataInserter + " for " + this.baseMetadata + " for " + this);
            }
            if (this.persistent()) {
                container.activate(this.metadataPuttersByMetadata, 2);
                container.activate(this.metadataPuttersUnfetchable, 2);
            }
            this.metadataPuttersByMetadata.put(this.baseMetadata, metadataInserter);
            this.metadataPuttersUnfetchable.put(this.baseMetadata, metadataInserter);
            if (this.persistent()) {
                container.ext().store(this.metadataPuttersByMetadata, 2);
                container.ext().store(this.metadataPuttersUnfetchable, 2);
                container.deactivate(this.metadataPuttersByMetadata, 1);
                container.deactivate(this.metadataPuttersUnfetchable, 1);
                container.deactivate((Object)this.baseMetadata, 1);
            }
            metadataInserter.start(container, context);
        }
        catch (InsertException e) {
            this.fail(e, container, context);
            return;
        }
        if (this.persistent()) {
            container.deactivate((Object)metadataInserter, 1);
            container.deactivate(this.elementsToPutInArchive, 1);
        }
    }

    private String createTarBucket(Bucket inputBucket, OutputStream os, ObjectContainer container) throws IOException {
        TarArchiveEntry ze;
        if (logMINOR) {
            Logger.minor(this, "Create a TAR Bucket");
        }
        TarArchiveOutputStream tarOS = new TarArchiveOutputStream(os);
        tarOS.setLongFileMode(2);
        for (PutHandler ph : this.elementsToPutInArchive) {
            if (this.persistent()) {
                container.activate((Object)ph, 1);
                container.activate((Object)ph.data, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Putting into tar: " + ph + " data length " + ph.data.size() + " name " + ph.targetInArchive);
            }
            ze = new TarArchiveEntry(ph.targetInArchive);
            ze.setModTime(0L);
            long size = ph.data.size();
            ze.setSize(size);
            tarOS.putArchiveEntry((ArchiveEntry)ze);
            BucketTools.copyTo(ph.data, (OutputStream)tarOS, size);
            tarOS.closeArchiveEntry();
        }
        if (logMINOR) {
            Logger.minor(this, "Putting metadata into tar: length is " + inputBucket.size());
        }
        ze = new TarArchiveEntry(".metadata");
        ze.setModTime(0L);
        long size = inputBucket.size();
        ze.setSize(size);
        tarOS.putArchiveEntry((ArchiveEntry)ze);
        BucketTools.copyTo(inputBucket, (OutputStream)tarOS, size);
        tarOS.closeArchiveEntry();
        tarOS.close();
        return ArchiveManager.ARCHIVE_TYPE.TAR.mimeTypes[0];
    }

    private String createZipBucket(Bucket inputBucket, OutputStream os, ObjectContainer container) throws IOException {
        ZipEntry ze;
        if (logMINOR) {
            Logger.minor(this, "Create a ZIP Bucket");
        }
        ZipOutputStream zos = new ZipOutputStream(os);
        for (PutHandler ph : this.elementsToPutInArchive) {
            if (this.persistent()) {
                container.activate((Object)ph, 1);
                container.activate((Object)ph.data, 1);
            }
            ze = new ZipEntry(ph.targetInArchive);
            ze.setTime(0L);
            zos.putNextEntry(ze);
            BucketTools.copyTo(ph.data, zos, ph.data.size());
            zos.closeEntry();
        }
        ze = new ZipEntry(".metadata");
        ze.setTime(0L);
        zos.putNextEntry(ze);
        BucketTools.copyTo(inputBucket, zos, inputBucket.size());
        zos.closeEntry();
        zos.finish();
        return ArchiveManager.ARCHIVE_TYPE.ZIP.mimeTypes[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(MetadataUnresolvedException e, ObjectContainer container, ClientContext context) throws InsertException, IOException {
        Metadata[] metas = e.mustResolve;
        if (this.persistent()) {
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        for (Metadata m : metas) {
            if (this.persistent()) {
                container.activate((Object)m, Integer.MAX_VALUE);
            }
            if (logMINOR) {
                Logger.minor(this, "Resolving " + m + " for " + this);
            }
            SimpleManifestPutter simpleManifestPutter = this;
            synchronized (simpleManifestPutter) {
                if (this.metadataPuttersByMetadata.containsKey(m)) {
                    if (logMINOR) {
                        Logger.minor(this, "Already started insert for " + m + " in resolve() for " + metas.length + " Metadata's");
                    }
                    continue;
                }
            }
            if (m.isResolved()) {
                Logger.error(this, "Already resolved: " + m + " in resolve() - race condition???");
                if (!this.persistent()) continue;
                container.deactivate((Object)m, 1);
                continue;
            }
            try {
                Bucket b = m.toBucket(context.getBucketFactory(this.persistent()));
                InsertBlock ib = new InsertBlock(b, null, this.persistent() ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI);
                SingleFileInserter metadataInserter = new SingleFileInserter(this, this, ib, true, this.ctx, this.realTimeFlag, false, this.getCHKOnly, false, m, null, true, null, this.earlyEncode, false, this.persistent(), 0L, 0L, null, this.cryptoAlgorithm, null, -1L);
                if (logMINOR) {
                    Logger.minor(this, "Inserting subsidiary metadata: " + metadataInserter + " for " + m);
                }
                SimpleManifestPutter simpleManifestPutter2 = this;
                synchronized (simpleManifestPutter2) {
                    this.metadataPuttersByMetadata.put(m, metadataInserter);
                }
                metadataInserter.start(container, context);
                if (!this.persistent()) continue;
                container.deactivate((Object)metadataInserter, 1);
                container.deactivate((Object)m, 1);
            }
            catch (MetadataUnresolvedException e1) {
                this.resolve(e1, container, context);
                container.deactivate((Object)m, 1);
            }
        }
        if (this.persistent()) {
            container.ext().store(this.metadataPuttersByMetadata, 2);
            container.deactivate(this.metadataPuttersByMetadata, 1);
        }
    }

    private void namesToByteArrays(HashMap<String, Object> putHandlersByName, HashMap<String, Object> namesToByteArrays, ObjectContainer container) {
        for (Map.Entry<String, Object> entry : putHandlersByName.entrySet()) {
            String name = entry.getKey();
            Object o = entry.getValue();
            if (o instanceof PutHandler) {
                PutHandler ph = (PutHandler)o;
                if (this.persistent()) {
                    container.activate((Object)ph, 1);
                }
                Metadata meta = ph.metadata;
                if (ph.metadata == null) {
                    Logger.error(this, "Metadata for " + name + " : " + ph + " is null");
                    continue;
                }
                ph.clearMetadata(container);
                if (this.persistent()) {
                    container.activate((Object)meta, Integer.MAX_VALUE);
                }
                if (logMINOR) {
                    Logger.minor(this, "Putting " + name);
                }
                namesToByteArrays.put(name, meta);
                if (!logMINOR) continue;
                Logger.minor(this, "Putting PutHandler into base metadata: " + ph + " name " + name);
                continue;
            }
            if (o instanceof HashMap) {
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                HashMap<String, Object> elements = Metadata.forceMap(o);
                if (this.persistent()) {
                    container.activate(o, 2);
                }
                namesToByteArrays.put(name, subMap);
                if (logMINOR) {
                    Logger.minor(this, "Putting hashmap into base metadata: " + name + " size " + elements.size() + " active = " + (container == null ? "null" : Boolean.toString(container.ext().isActive(o))));
                    Logger.minor(this, "Putting directory: " + name);
                }
                this.namesToByteArrays(elements, subMap, container);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertedAllFiles(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Inserted all files");
        }
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            this.insertedAllFiles = true;
            if (this.finished || this.cancelled) {
                if (logMINOR) {
                    Logger.minor(this, "Already " + (this.finished ? "finished" : "cancelled"));
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                return;
            }
            if (!this.insertedManifest) {
                if (logMINOR) {
                    Logger.minor(this, "Haven't inserted manifest");
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                return;
            }
            this.finished = true;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.complete(container, context);
    }

    private void complete(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            this.removePutHandlers(container, context);
        }
        boolean deactivateCB = false;
        if (this.persistent()) {
            deactivateCB = !container.ext().isActive((Object)this.cb);
            container.activate((Object)this.cb, 1);
        }
        this.cb.onSuccess(this, container);
        if (deactivateCB) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.cancelAndFinish(container, context);
        if (this.persistent()) {
            this.removePutHandlers(container, context);
        }
        if (this.persistent()) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container);
    }

    private void removePutHandlers(ObjectContainer container, ClientContext context) {
        PutHandler[] handlers;
        container.activate(this.putHandlersByName, 2);
        container.activate(this.runningPutHandlers, 2);
        container.activate(this.putHandlersWaitingForMetadata, 2);
        container.activate(this.waitingForBlockSets, 2);
        container.activate(this.putHandlersWaitingForFetchable, 2);
        container.activate(this.elementsToPutInArchive, 2);
        this.removePutHandlersByName(container, context, this.putHandlersByName);
        this.putHandlersByName = null;
        if (!this.runningPutHandlers.isEmpty()) {
            Logger.error(this, "Running put handlers not part of putHandlersByName: " + this.runningPutHandlers.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still running, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.runningPutHandlers.clear();
        }
        if (!this.putHandlersWaitingForMetadata.isEmpty()) {
            Logger.error(this, "Put handlers waiting for metadata, not part of putHandlersByName: " + this.putHandlersWaitingForMetadata.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.putHandlersWaitingForMetadata.toArray(new PutHandler[this.putHandlersWaitingForMetadata.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for metadata, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.putHandlersWaitingForMetadata.clear();
        }
        if (!this.waitingForBlockSets.isEmpty()) {
            Logger.error(this, "Put handlers waiting for block sets, not part of putHandlersByName: " + this.waitingForBlockSets.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.waitingForBlockSets.toArray(new PutHandler[this.waitingForBlockSets.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for block set, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.waitingForBlockSets.clear();
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            Logger.error(this, "Put handlers waiting for fetchable, not part of putHandlersByName: " + this.putHandlersWaitingForFetchable.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.putHandlersWaitingForFetchable.toArray(new PutHandler[this.putHandlersWaitingForFetchable.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for fetchable, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.putHandlersWaitingForFetchable.clear();
        }
        if (!this.elementsToPutInArchive.isEmpty()) {
            Logger.error(this, "Elements to put in archive, not part of putHandlersByName: " + this.elementsToPutInArchive.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.elementsToPutInArchive.toArray(new PutHandler[this.elementsToPutInArchive.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "To put in archive, but not in putHandlersByName: " + handler);
                handler.removeFrom(container, context);
            }
            this.elementsToPutInArchive.clear();
        }
        container.delete(this.runningPutHandlers);
        container.delete(this.putHandlersWaitingForMetadata);
        container.delete(this.waitingForBlockSets);
        container.delete(this.putHandlersWaitingForFetchable);
        container.delete(this.elementsToPutInArchive);
        this.runningPutHandlers = null;
        this.putHandlersWaitingForMetadata = null;
        this.waitingForBlockSets = null;
        this.putHandlersWaitingForFetchable = null;
        this.elementsToPutInArchive = null;
        container.store((Object)this);
    }

    private void removePutHandlersByName(ObjectContainer container, ClientContext context, HashMap<String, Object> putHandlersByName) {
        if (logMINOR) {
            Logger.minor(this, "removePutHandlersByName on " + this + " : map size = " + putHandlersByName.size());
        }
        for (Map.Entry<String, Object> entry : putHandlersByName.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof PutHandler) {
                PutHandler handler = (PutHandler)value;
                container.activate((Object)handler, 1);
                if (this.runningPutHandlers != null && this.runningPutHandlers.remove(handler)) {
                    container.ext().store(this.runningPutHandlers, 2);
                }
                if (this.putHandlersWaitingForMetadata != null && this.putHandlersWaitingForMetadata.remove(handler)) {
                    container.ext().store(this.putHandlersWaitingForMetadata, 2);
                }
                if (this.waitingForBlockSets != null && this.waitingForBlockSets.remove(handler)) {
                    container.ext().store(this.waitingForBlockSets, 2);
                }
                if (this.putHandlersWaitingForMetadata != null && this.putHandlersWaitingForFetchable.remove(handler)) {
                    container.ext().store(this.putHandlersWaitingForFetchable, 2);
                }
                if (this.elementsToPutInArchive != null && this.elementsToPutInArchive.remove(handler)) {
                    container.ext().store(this.elementsToPutInArchive, 2);
                }
                handler.removeFrom(container, context);
            } else {
                HashMap<String, Object> subMap = Metadata.forceMap(value);
                container.activate(subMap, 2);
                this.removePutHandlersByName(container, context, subMap);
            }
            container.delete((Object)key);
        }
        putHandlersByName.clear();
        container.delete(putHandlersByName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAndFinish(ObjectContainer container, ClientContext context) {
        ClientPutState[] runningMeta;
        PutHandler[] running;
        boolean persistent = this.persistent();
        if (persistent) {
            container.activate(this.runningPutHandlers, 2);
        }
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
        }
        if (logMINOR) {
            Logger.minor(this, "PutHandler's to cancel: " + running.length);
        }
        for (PutHandler putter : running) {
            boolean active = true;
            if (persistent && !(active = container.ext().isActive((Object)putter))) {
                container.activate((Object)putter, 1);
            }
            putter.cancel(container, context);
            if (!active) {
                container.deactivate((Object)putter, 1);
            }
            if (!persistent) continue;
            container.activate((Object)this, 1);
        }
        if (this.persistent()) {
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        SimpleManifestPutter len$ = this;
        synchronized (len$) {
            runningMeta = this.metadataPuttersByMetadata.values().toArray(new ClientPutState[this.metadataPuttersByMetadata.size()]);
        }
        if (logMINOR) {
            Logger.minor(this, "Metadata putters to cancel: " + runningMeta.length);
        }
        for (ClientPutState putter : runningMeta) {
            boolean active = true;
            if (persistent && !(active = container.ext().isActive((Object)putter))) {
                container.activate((Object)putter, 1);
            }
            putter.cancel(container, context);
            if (!active) {
                container.deactivate((Object)putter, 1);
            }
            if (!persistent) continue;
            container.activate((Object)this, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            if (this.finished) {
                return;
            }
            if (super.cancel()) {
                return;
            }
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.fail(new InsertException(10), container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        Metadata token = (Metadata)state.getToken();
        if (this.persistent()) {
            container.activate((Object)token, 1);
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        boolean fin = false;
        ClientPutState oldState = null;
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            oldState = this.metadataPuttersByMetadata.remove(token);
            if (oldState != null) {
                if (this.persistent()) {
                    container.activate(this.metadataPuttersUnfetchable, 2);
                }
                if (this.metadataPuttersUnfetchable.remove(token) != null && this.persistent()) {
                    container.ext().store(this.metadataPuttersUnfetchable, 2);
                }
            } else if (logMINOR) {
                Logger.minor(this, "Did not remove metadata putter " + state + " for " + token + " because not present");
            }
            if (!this.metadataPuttersByMetadata.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Still running metadata putters: " + this.metadataPuttersByMetadata.size());
                    for (Map.Entry<Metadata, ClientPutState> entry : this.metadataPuttersByMetadata.entrySet()) {
                        boolean active = true;
                        boolean metaActive = true;
                        ClientPutState s = entry.getValue();
                        Metadata key = entry.getKey();
                        if (this.persistent()) {
                            active = container.ext().isActive((Object)s);
                            if (!active) {
                                container.activate((Object)s, 1);
                            }
                            metaActive = container.ext().isActive((Object)key);
                            if (!active) {
                                container.activate((Object)metaActive, 1);
                            }
                        }
                        Logger.minor(this, "Still waiting for " + s + " for " + key);
                        if (this.persistent()) {
                            Logger.minor(this, "Key id is " + container.ext().getID((Object)key));
                        }
                        if (key == token) {
                            Logger.error(this, "MATCHED, yet didn't find it earlier?!");
                        }
                        if (key.equals(token)) {
                            Logger.error(this, "MATCHED ON equals(), yet didn't find it earlier and not == ?!");
                        }
                        if (!active) {
                            container.deactivate((Object)s, 1);
                        }
                        if (metaActive) continue;
                        container.deactivate((Object)key, 1);
                    }
                }
            } else {
                Logger.minor(this, "Inserted manifest successfully on " + this + " : " + state);
                this.insertedManifest = true;
                if (this.finished) {
                    if (logMINOR) {
                        Logger.minor(this, "Already finished");
                    }
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                } else if (!this.insertedAllFiles) {
                    if (logMINOR) {
                        Logger.minor(this, "Not inserted all files");
                    }
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                } else {
                    this.finished = true;
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                    fin = true;
                }
            }
        }
        if (this.persistent()) {
            if (token != this.baseMetadata) {
                token.removeFrom(container);
            }
            container.ext().store(this.metadataPuttersByMetadata, 2);
            container.deactivate(this.metadataPuttersByMetadata, 1);
            state.removeFrom(container, context);
            if (oldState != state && oldState != null) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            }
        }
        if (fin) {
            this.complete(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        ClientPutState oldState = null;
        Metadata token = (Metadata)state.getToken();
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            if (this.persistent()) {
                container.activate((Object)token, 1);
            }
            if ((oldState = this.metadataPuttersByMetadata.remove(token)) != null) {
                if (this.persistent()) {
                    container.activate(this.metadataPuttersUnfetchable, 2);
                }
                if (this.metadataPuttersUnfetchable.remove(token) != null && this.persistent()) {
                    container.ext().store(this.metadataPuttersUnfetchable, 2);
                }
            }
        }
        if (token != this.baseMetadata) {
            token.removeFrom(container);
        }
        if (this.persistent()) {
            container.ext().store(this.metadataPuttersByMetadata, 2);
            container.deactivate(this.metadataPuttersByMetadata, 1);
            state.removeFrom(container, context);
            if (oldState != state && oldState != null) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            }
        }
        this.fail(e, container, context);
    }

    @Override
    public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
        if (state.getToken() == this.baseMetadata) {
            this.finalURI = key.getURI();
            if (logMINOR) {
                Logger.minor(this, "Got metadata key: " + this.finalURI);
            }
            if (this.persistent()) {
                container.activate((Object)this.cb, 1);
            }
            this.cb.onGeneratedURI(this.persistent() ? this.finalURI.clone() : this.finalURI, this, container);
            if (this.persistent()) {
                container.deactivate((Object)this.cb, 1);
            }
            if (this.persistent()) {
                container.store((Object)this);
            }
        } else {
            Metadata m = (Metadata)state.getToken();
            if (this.persistent()) {
                container.activate((Object)m, 2);
            }
            m.resolve(key.getURI());
            if (this.persistent()) {
                container.store((Object)m);
            }
            if (logMINOR) {
                Logger.minor(this, "Resolved " + m + " : " + key.getURI());
            }
            this.resolveAndStartBase(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        Metadata m = (Metadata)oldState.getToken();
        if (this.persistent()) {
            container.activate((Object)m, Integer.MAX_VALUE);
            container.activate(this.metadataPuttersUnfetchable, 2);
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            ClientPutState prevState = this.metadataPuttersByMetadata.get(m);
            if (prevState != null) {
                if (prevState != oldState) {
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring transition in " + this + " for metadata putter: " + oldState + " -> " + newState + " because current for " + m + " is " + prevState);
                    }
                    if (this.persistent()) {
                        container.deactivate(this.metadataPuttersUnfetchable, 1);
                        container.deactivate(this.metadataPuttersByMetadata, 1);
                    }
                    return;
                }
                if (this.persistent()) {
                    container.store((Object)newState);
                }
                this.metadataPuttersByMetadata.put(m, newState);
                if (this.persistent()) {
                    container.ext().store(this.metadataPuttersByMetadata, 2);
                }
                if (logMINOR) {
                    Logger.minor(this, "Metadata putter transition: " + oldState + " -> " + newState);
                }
                if (this.metadataPuttersUnfetchable.containsKey(m)) {
                    this.metadataPuttersUnfetchable.put(m, newState);
                    if (this.persistent()) {
                        container.ext().store(this.metadataPuttersUnfetchable, 2);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Unfetchable metadata putter transition: " + oldState + " -> " + newState);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Transition: " + oldState + " -> " + newState);
                }
            } else {
                Logger.error(this, "onTransition() but metadataPuttersByMetadata does not contain metadata tag " + m + " for " + oldState + " should -> " + newState);
            }
        }
        if (this.persistent()) {
            container.deactivate((Object)m, 1);
            container.deactivate(this.metadataPuttersUnfetchable, 2);
            container.deactivate(this.metadataPuttersByMetadata, 2);
        }
    }

    @Override
    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlock(ObjectContainer container) {
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            ++this.minSuccessFetchBlocks;
        }
        super.addBlock(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlocks(int num, ObjectContainer container) {
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            this.minSuccessFetchBlocks += num;
        }
        super.addBlocks(num, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMustSucceedBlocks(int blocks, ObjectContainer container) {
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            this.minSuccessFetchBlocks += blocks;
        }
        super.addMustSucceedBlocks(blocks, container);
    }

    @Override
    public void addRedundantBlocks(int blocks, ObjectContainer container) {
        super.addMustSucceedBlocks(blocks, container);
    }

    @Override
    public void notifyClients(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.minSuccessBlocks, this.minSuccessFetchBlocks, this.blockSetFinalized), container, context);
    }

    @Override
    public int getMinSuccessFetchBlocks() {
        return this.minSuccessFetchBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            this.metadataBlockSetFinalized = true;
            if (this.persistent()) {
                container.activate(this.waitingForBlockSets, 2);
            }
            if (!this.waitingForBlockSets.isEmpty()) {
                if (this.persistent()) {
                    container.store((Object)this);
                    container.deactivate(this.waitingForBlockSets, 1);
                }
                return;
            }
        }
        this.blockSetFinalized(container, context);
        if (this.persistent()) {
            container.store((Object)this);
            container.deactivate(this.waitingForBlockSets, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockSetFinalized(ObjectContainer container, ClientContext context) {
        SimpleManifestPutter simpleManifestPutter = this;
        synchronized (simpleManifestPutter) {
            if (!this.metadataBlockSetFinalized) {
                return;
            }
            if (this.persistent()) {
                container.activate(this.waitingForBlockSets, 2);
            }
            if (this.waitingForBlockSets.isEmpty()) {
                if (this.persistent()) {
                    container.deactivate(this.waitingForBlockSets, 1);
                }
                return;
            }
        }
        if (this.persistent()) {
            container.deactivate(this.waitingForBlockSets, 1);
        }
        super.blockSetFinalized(container, context);
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public static HashMap<String, Object> bucketsByNameToManifestEntries(HashMap<String, Object> bucketsByName) {
        HashMap<String, Object> manifestEntries = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : bucketsByName.entrySet()) {
            String name = entry.getKey();
            Object o = entry.getValue();
            if (o instanceof ManifestElement) {
                manifestEntries.put(name, o);
                continue;
            }
            if (o instanceof Bucket) {
                Bucket data = (Bucket)o;
                manifestEntries.put(name, new ManifestElement(name, data, null, data.size()));
                continue;
            }
            if (o instanceof HashMap) {
                manifestEntries.put(name, SimpleManifestPutter.bucketsByNameToManifestEntries(Metadata.forceMap(o)));
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(o));
        }
        return manifestEntries;
    }

    public static ManifestElement[] flatten(HashMap<String, Object> manifestElements) {
        ArrayList<ManifestElement> v = new ArrayList<ManifestElement>();
        SimpleManifestPutter.flatten(manifestElements, v, "");
        return v.toArray(new ManifestElement[v.size()]);
    }

    public static void flatten(HashMap<String, Object> manifestElements, List<ManifestElement> v, String prefix) {
        for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
            String name = entry.getKey();
            String fullName = prefix.length() == 0 ? name : prefix + '/' + name;
            Object o = entry.getValue();
            if (o instanceof HashMap) {
                SimpleManifestPutter.flatten(Metadata.forceMap(o), v, fullName);
                continue;
            }
            if (o instanceof ManifestElement) {
                ManifestElement me = (ManifestElement)o;
                v.add(new ManifestElement(me, fullName));
                continue;
            }
            throw new IllegalStateException(String.valueOf(o));
        }
    }

    public static <T> HashMap<String, Object> unflatten(List<ManifestElement> v) {
        HashMap<String, Object> manifestElements = new HashMap<String, Object>();
        for (ManifestElement oldElement : v) {
            SimpleManifestPutter.add(oldElement, oldElement.getName(), manifestElements);
        }
        return manifestElements;
    }

    private static void add(ManifestElement e, String namePart, Map<String, Object> target) {
        int idx = namePart.indexOf(47);
        if (idx < 0) {
            target.put(namePart, new ManifestElement(e, namePart));
        } else {
            String before = namePart.substring(0, idx);
            String after = namePart.substring(idx + 1);
            HashMap<String, Object> hm = Metadata.forceMap(target.get(before));
            if (hm == null) {
                hm = new HashMap();
                target.put(before.intern(), hm);
            }
            SimpleManifestPutter.add(e, after, hm);
        }
    }

    @Override
    public int countFiles() {
        return this.numberOfFiles;
    }

    @Override
    public long totalSize() {
        return this.totalSize;
    }

    @Override
    public void onMajorProgress(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent()) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.cb);
            if (deactivate) {
                container.activate((Object)this.cb, 1);
            }
        }
        this.cb.onMajorProgress(container);
        if (deactivate) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    protected void onFetchable(PutHandler handler, ObjectContainer container) {
        if (this.persistent()) {
            container.activate(this.putHandlersWaitingForFetchable, 2);
            container.activate(this.metadataPuttersUnfetchable, 2);
        }
        if (this.checkFetchable(handler)) {
            if (this.persistent()) {
                container.ext().store(this.putHandlersWaitingForMetadata, 2);
                container.store((Object)this);
                container.deactivate(this.putHandlersWaitingForFetchable, 1);
                container.deactivate(this.metadataPuttersUnfetchable, 1);
                container.activate((Object)this.cb, 1);
            }
            this.cb.onFetchable(this, container);
            if (this.persistent()) {
                container.deactivate((Object)this.cb, 1);
            }
        } else if (this.persistent()) {
            container.deactivate(this.putHandlersWaitingForFetchable, 1);
            container.deactivate(this.metadataPuttersUnfetchable, 1);
        }
    }

    private synchronized boolean checkFetchable(PutHandler handler) {
        this.putHandlersWaitingForFetchable.remove(handler);
        if (this.fetchable) {
            return false;
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            return false;
        }
        if (!this.hasResolvedBase) {
            return false;
        }
        if (!this.metadataPuttersUnfetchable.isEmpty()) {
            return false;
        }
        this.fetchable = true;
        return true;
    }

    @Override
    public void onFetchable(ClientPutState state, ObjectContainer container) {
        Metadata m = (Metadata)state.getToken();
        if (this.persistent()) {
            container.activate((Object)m, Integer.MAX_VALUE);
            container.activate(this.metadataPuttersUnfetchable, 2);
            container.activate(this.putHandlersWaitingForFetchable, 2);
        }
        if (this.checkFetchable(m)) {
            if (this.persistent()) {
                container.ext().store(this.metadataPuttersUnfetchable, 2);
                container.store((Object)this);
                container.activate((Object)this.cb, 1);
            }
            this.cb.onFetchable(this, container);
            if (this.persistent()) {
                container.deactivate((Object)this.cb, 1);
            }
        }
        if (this.persistent()) {
            container.deactivate(this.metadataPuttersUnfetchable, 1);
            container.deactivate(this.putHandlersWaitingForFetchable, 1);
        }
    }

    private synchronized boolean checkFetchable(Metadata m) {
        this.metadataPuttersUnfetchable.remove(m);
        if (!this.metadataPuttersUnfetchable.isEmpty()) {
            return false;
        }
        if (this.fetchable) {
            return false;
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            return false;
        }
        this.fetchable = true;
        return true;
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        ClientPutState sfi;
        Metadata meta;
        if (this.putHandlersByName != null) {
            Logger.error(this, "Put handlers list still present in removeFrom() on " + this);
            this.removePutHandlers(container, context);
        }
        if (this.finalURI != null) {
            container.activate((Object)this.finalURI, 5);
            this.finalURI.removeFrom(container);
        }
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.activate(this.metadataPuttersByMetadata, 2);
        container.activate(this.metadataPuttersUnfetchable, 2);
        ArrayList<Metadata> metas = null;
        if (!this.metadataPuttersByMetadata.isEmpty()) {
            Logger.error(this, "Metadata putters by metadata not empty in removeFrom() on " + this);
            for (Map.Entry entry : this.metadataPuttersByMetadata.entrySet()) {
                meta = (Metadata)entry.getKey();
                container.activate((Object)meta, 1);
                sfi = (ClientPutState)entry.getValue();
                container.activate((Object)sfi, 1);
                this.metadataPuttersUnfetchable.remove(meta);
                Logger.error(this, "Metadata putters not empty: " + sfi + " for " + this);
                sfi.cancel(container, context);
                sfi.removeFrom(container, context);
                if (metas == null) {
                    metas = new ArrayList<Metadata>();
                }
                metas.add(meta);
            }
        }
        if (!this.metadataPuttersUnfetchable.isEmpty()) {
            Logger.error(this, "Metadata putters unfetchable by metadata not empty in removeFrom() on " + this);
            for (Map.Entry entry : this.metadataPuttersByMetadata.entrySet()) {
                meta = (Metadata)entry.getKey();
                container.activate((Object)meta, 1);
                sfi = (ClientPutState)entry.getValue();
                container.activate((Object)sfi, 1);
                this.metadataPuttersUnfetchable.remove(meta);
                Logger.error(this, "Metadata putters unfetchable not empty: " + sfi + " for " + this);
                sfi.cancel(container, context);
                sfi.removeFrom(container, context);
            }
        }
        if (metas != null) {
            for (Metadata metadata : metas) {
                if (metadata == this.baseMetadata) continue;
                container.activate((Object)metadata, 1);
                metadata.removeFrom(container);
            }
        }
        this.metadataPuttersByMetadata.clear();
        this.metadataPuttersUnfetchable.clear();
        container.delete(this.metadataPuttersByMetadata);
        container.delete(this.metadataPuttersUnfetchable);
        if (this.baseMetadata != null) {
            container.activate((Object)this.baseMetadata, 1);
            this.baseMetadata.removeFrom(container);
        }
        container.activate((Object)this.runGotAllMetadata, 1);
        container.delete((Object)this.runGotAllMetadata);
        super.removeFrom(container, context);
    }

    public void objectOnUpdate(ObjectContainer container) {
        if (logDEBUG) {
            Logger.debug(this, "Updating " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
        }
    }

    @Override
    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "Storing " + this + " when already finished!", (Throwable)new Exception("error"));
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
        }
        return true;
    }

    protected final ClientMetadata guessMime(String name, ManifestElement me) {
        String mimeType = me.mimeOverride;
        if (mimeType == null) {
            mimeType = DefaultMIMETypes.guessMIMEType(name, true);
        }
        ClientMetadata cm = mimeType == null || mimeType.equals("application/octet-stream") ? null : new ClientMetadata(mimeType);
        return cm;
    }

    protected final void addRedirectNoMime(String name, ManifestElement me, HashMap<String, Object> putHandlersByName2) {
        this.addRedirect(name, me, null, putHandlersByName2);
    }

    protected final void addRedirect(String name, ManifestElement me, HashMap<String, Object> putHandlersByName2) {
        this.addRedirect(name, me, this.guessMime(name, me), putHandlersByName2);
    }

    protected final void addRedirect(String name, ManifestElement me, ClientMetadata cm, HashMap<String, Object> putHandlersByName2) {
        PutHandler ph;
        Bucket data = me.data;
        if (me.targetURI != null) {
            ph = new PutHandler(this, name, me.targetURI, cm, this.persistent());
        } else {
            ph = new PutHandler(this, name, data, cm, this.getCHKOnly, this.persistent());
            this.runningPutHandlers.add(ph);
            this.putHandlersWaitingForMetadata.add(ph);
            this.putHandlersWaitingForFetchable.add(ph);
            if (logMINOR) {
                Logger.minor(this, "Inserting separately as PutHandler: " + name + " : " + ph + " persistent=" + ph.persistent() + ":" + ph.persistent + " " + this.persistent());
            }
            ++this.numberOfFiles;
            this.totalSize += data.size();
        }
        putHandlersByName2.put(name, ph);
    }

    @Override
    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onMetadata(Bucket meta, ClientPutState state, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        defaultDefaultNames = new String[]{"index.html", "index.htm", "default.html", "default.htm"};
    }

    private class PutHandler
    extends BaseClientPutter
    implements PutCompletionCallback {
        private ClientPutState origSFI;
        private ClientPutState currentState;
        private ClientMetadata cm;
        private Metadata metadata;
        private String targetInArchive;
        private final Bucket data;
        private final boolean persistent;
        private final PutHandler containerHandle;
        protected int minSuccessFetchBlocks;

        private PutHandler() {
            this.persistent = false;
            this.data = null;
            this.containerHandle = null;
        }

        protected PutHandler(SimpleManifestPutter smp, String name, Bucket data, ClientMetadata cm, boolean getCHKOnly, boolean persistent) {
            super(smp.priorityClass, smp.client);
            this.persistent = persistent;
            this.cm = cm;
            this.data = data;
            InsertBlock block = new InsertBlock(data, cm, this.persistent() ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI);
            this.origSFI = new SingleFileInserter(this, this, block, false, SimpleManifestPutter.this.ctx, this.realTimeFlag, false, getCHKOnly, true, null, null, false, null, SimpleManifestPutter.this.earlyEncode, false, persistent, 0L, 0L, null, SimpleManifestPutter.this.cryptoAlgorithm, SimpleManifestPutter.this.forceCryptoKey, -1L);
            this.metadata = null;
            this.containerHandle = null;
        }

        protected PutHandler(SimpleManifestPutter smp, String name, FreenetURI target, ClientMetadata cm, boolean persistent) {
            Metadata m;
            super(smp.getPriorityClass(), smp.client);
            this.persistent = persistent;
            this.cm = cm;
            this.data = null;
            this.metadata = m = new Metadata(0, null, null, target, cm);
            if (logMINOR) {
                Logger.minor(this, "Simple redirect metadata: " + m);
            }
            this.origSFI = null;
            this.containerHandle = null;
        }

        protected PutHandler(SimpleManifestPutter smp, String name, String targetInArchive, ClientMetadata cm, Bucket data, boolean persistent) {
            Metadata m;
            super(smp.getPriorityClass(), smp.client);
            this.persistent = persistent;
            this.cm = cm;
            this.data = data;
            this.targetInArchive = targetInArchive;
            this.metadata = m = new Metadata(4, null, null, targetInArchive, cm);
            if (logMINOR) {
                Logger.minor(this, "Internal redirect: " + m);
            }
            this.origSFI = null;
            this.containerHandle = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ObjectContainer container, ClientContext context) throws InsertException {
            ClientPutState sfi;
            if (this.origSFI == null) {
                Logger.error(this, "origSFI is null on start(), should be impossible", (Throwable)new Exception("debug"));
                return;
            }
            if (this.metadata != null) {
                Logger.error(this, "metdata=" + this.metadata + " on start(), should be impossible", (Throwable)new Exception("debug"));
                return;
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.currentState = sfi = this.origSFI;
                this.origSFI = null;
            }
            if (this.persistent) {
                container.activate((Object)sfi, 1);
                container.store((Object)this);
            }
            sfi.schedule(container, context);
            if (this.persistent) {
                container.deactivate((Object)sfi, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
            }
            ClientPutState oldState = null;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.cancelled) {
                    return;
                }
                super.cancel();
                oldState = this.currentState;
            }
            if (this.persistent()) {
                container.store((Object)this);
                if (oldState != null) {
                    container.activate((Object)oldState, 1);
                }
            }
            if (oldState != null) {
                oldState.cancel(container, context);
            }
            this.onFailure(new InsertException(10), null, container, context);
        }

        @Override
        public FreenetURI getURI() {
            return null;
        }

        @Override
        public boolean isFinished() {
            return SimpleManifestPutter.this.finished || this.cancelled || SimpleManifestPutter.this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            if (logMINOR) {
                Logger.minor(this, "Completed " + this);
            }
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
                container.activate((Object)SimpleManifestPutter.this.runningPutHandlers, 2);
            }
            SimpleManifestPutter.this.onFetchable(this, container);
            boolean insertedAllFiles = true;
            BaseClientPutter baseClientPutter = this;
            synchronized (baseClientPutter) {
                oldState = this.currentState;
                this.currentState = null;
            }
            baseClientPutter = SimpleManifestPutter.this;
            synchronized (baseClientPutter) {
                if (this.persistent) {
                    container.store((Object)this);
                }
                SimpleManifestPutter.this.runningPutHandlers.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)SimpleManifestPutter.this.runningPutHandlers, 2);
                    container.activate((Object)SimpleManifestPutter.this.putHandlersWaitingForMetadata, 2);
                }
                if (SimpleManifestPutter.this.putHandlersWaitingForMetadata.remove(this)) {
                    if (this.persistent) {
                        container.ext().store((Object)SimpleManifestPutter.this.putHandlersWaitingForMetadata, 2);
                    }
                    Logger.error(this, "PutHandler was in waitingForMetadata in onSuccess() on " + this + " for " + SimpleManifestPutter.this);
                }
                if (this.persistent) {
                    container.deactivate((Object)SimpleManifestPutter.this.putHandlersWaitingForMetadata, 1);
                    container.activate((Object)SimpleManifestPutter.this.waitingForBlockSets, 2);
                }
                if (SimpleManifestPutter.this.waitingForBlockSets.remove(this)) {
                    if (this.persistent) {
                        container.store((Object)SimpleManifestPutter.this.waitingForBlockSets);
                    }
                    Logger.error(this, "PutHandler was in waitingForBlockSets in onSuccess() on " + this + " for " + SimpleManifestPutter.this);
                }
                if (this.persistent) {
                    container.deactivate((Object)SimpleManifestPutter.this.waitingForBlockSets, 1);
                    container.deactivate((Object)SimpleManifestPutter.this.putHandlersWaitingForFetchable, 1);
                    container.activate((Object)SimpleManifestPutter.this.putHandlersWaitingForFetchable, 2);
                }
                if (SimpleManifestPutter.this.putHandlersWaitingForFetchable.remove(this)) {
                    if (this.persistent) {
                        container.ext().store((Object)SimpleManifestPutter.this.putHandlersWaitingForFetchable, 2);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "PutHandler was in waitingForFetchable in onSuccess() on " + this + " for " + SimpleManifestPutter.this);
                    }
                }
                if (this.persistent) {
                    container.deactivate((Object)SimpleManifestPutter.this.putHandlersWaitingForFetchable, 1);
                }
                if (!SimpleManifestPutter.this.runningPutHandlers.isEmpty()) {
                    if (logMINOR) {
                        Logger.minor(this, "Running put handlers: " + SimpleManifestPutter.this.runningPutHandlers.size());
                        for (PutHandler o : SimpleManifestPutter.this.runningPutHandlers) {
                            boolean activated = true;
                            if (this.persistent && !(activated = container.ext().isActive((Object)o))) {
                                container.activate((Object)o, 1);
                            }
                            Logger.minor(this, "Still running: " + o);
                            if (activated) continue;
                            container.deactivate((Object)o, 1);
                        }
                    }
                    insertedAllFiles = false;
                }
            }
            if (oldState != null && oldState != state && this.persistent) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            } else if (state != null && this.persistent) {
                state.removeFrom(container, context);
            }
            if (insertedAllFiles) {
                SimpleManifestPutter.this.insertedAllFiles(container, context);
            }
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this.runningPutHandlers, 1);
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                oldState = this.currentState;
                this.currentState = null;
            }
            if (oldState != null && oldState != state && this.persistent) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            } else if (state != null && this.persistent) {
                state.removeFrom(container, context);
            }
            if (logMINOR) {
                Logger.minor(this, "Failed: " + this + " - " + e, (Throwable)e);
            }
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.fail(e, container, context);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key + ") for " + this);
            }
            if (this.metadata == null) {
                if (this.persistent) {
                    container.activate((Object)key, 5);
                    container.activate((Object)SimpleManifestPutter.this, 1);
                }
                Metadata m = new Metadata(0, null, null, key.getURI(), this.cm);
                this.onMetadata(m, null, container, context);
                if (this.persistent) {
                    container.deactivate((Object)SimpleManifestPutter.this, 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
            if (newState == null) {
                throw new NullPointerException();
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.currentState == oldState) {
                    this.currentState = newState;
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
                    }
                    return;
                }
                Logger.error(this, "Ignoring onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Assigning metadata: " + m + " for " + this + " from " + state + " persistent=" + this.persistent, (Throwable)new Exception("debug"));
            }
            if (this.metadata != null) {
                Logger.error(this, "Reassigning metadata", (Throwable)new Exception("debug"));
                return;
            }
            this.metadata = m;
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
                container.activate((Object)SimpleManifestPutter.this.putHandlersWaitingForMetadata, 2);
            }
            boolean allMetadatas = false;
            SimpleManifestPutter simpleManifestPutter = SimpleManifestPutter.this;
            synchronized (simpleManifestPutter) {
                SimpleManifestPutter.this.putHandlersWaitingForMetadata.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)SimpleManifestPutter.this.putHandlersWaitingForMetadata, 2);
                    container.store((Object)this);
                }
                if (!(allMetadatas = SimpleManifestPutter.this.putHandlersWaitingForMetadata.isEmpty()) && logMINOR) {
                    Logger.minor(this, "Still waiting for metadata: " + SimpleManifestPutter.this.putHandlersWaitingForMetadata.size());
                }
            }
            if (allMetadatas) {
                SimpleManifestPutter.this.gotAllMetadata(container, context);
            } else {
                try {
                    byte[] buf;
                    if (this.persistent) {
                        container.activate((Object)m, Integer.MAX_VALUE);
                    }
                    if ((buf = m.writeToByteArray()).length > Short.MAX_VALUE) {
                        throw new MetadataUnresolvedException(new Metadata[]{m}, "Too big");
                    }
                }
                catch (MetadataUnresolvedException e) {
                    try {
                        SimpleManifestPutter.this.resolve(e, container, context);
                    }
                    catch (IOException e1) {
                        SimpleManifestPutter.this.fail(new InsertException(2, e1, null), container, context);
                        return;
                    }
                    catch (InsertException e1) {
                        SimpleManifestPutter.this.fail(e1, container, context);
                    }
                }
            }
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this.putHandlersWaitingForMetadata, 1);
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
        }

        @Override
        public void onMetadata(Bucket m, ClientPutState state, ObjectContainer container, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlock(ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.addBlock(container);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                ++this.minSuccessFetchBlocks;
            }
            super.addBlock(container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlocks(int num, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.addBlocks(num, container);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.minSuccessFetchBlocks += num;
            }
            super.addBlock(container);
        }

        @Override
        public void completedBlock(boolean dontNotify, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.completedBlock(dontNotify, container, context);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
            super.completedBlock(dontNotify, container, context);
        }

        @Override
        public void failedBlock(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.failedBlock(container, context);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
            super.failedBlock(container, context);
        }

        @Override
        public void fatallyFailedBlock(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.fatallyFailedBlock(container, context);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
            super.fatallyFailedBlock(container, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addMustSucceedBlocks(int blocks, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.addMustSucceedBlocks(blocks, container);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.minSuccessFetchBlocks += blocks;
            }
            super.addMustSucceedBlocks(blocks, container);
        }

        @Override
        public void addRedundantBlocks(int blocks, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.addRedundantBlocks(blocks, container);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
            super.addMustSucceedBlocks(blocks, container);
        }

        @Override
        public void notifyClients(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.notifyClients(container, context);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
        }

        @Override
        public synchronized int getMinSuccessFetchBlocks() {
            return this.minSuccessFetchBlocks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
                container.activate((Object)SimpleManifestPutter.this.waitingForBlockSets, 2);
            }
            boolean allBlockSets = false;
            SimpleManifestPutter simpleManifestPutter = SimpleManifestPutter.this;
            synchronized (simpleManifestPutter) {
                SimpleManifestPutter.this.waitingForBlockSets.remove(this);
                if (this.persistent) {
                    container.store((Object)SimpleManifestPutter.this.waitingForBlockSets);
                }
                allBlockSets = SimpleManifestPutter.this.waitingForBlockSets.isEmpty();
            }
            if (allBlockSets) {
                SimpleManifestPutter.this.blockSetFinalized(container, context);
            }
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this.waitingForBlockSets, 1);
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
        }

        @Override
        public void onMajorProgress(ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.onMajorProgress(container);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
        }

        @Override
        public void onFetchable(ClientPutState state, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)SimpleManifestPutter.this, 1);
            }
            SimpleManifestPutter.this.onFetchable(this, container);
            if (this.persistent) {
                container.deactivate((Object)SimpleManifestPutter.this, 1);
            }
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        }

        public void clearMetadata(ObjectContainer container) {
            this.metadata = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFrom(ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            ClientPutState oldSFI;
            if (logMINOR) {
                Logger.minor(this, "Removing " + this);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                oldSFI = this.origSFI;
                oldState = this.currentState;
                this.origSFI = null;
                this.currentState = null;
            }
            if (oldSFI != null) {
                Logger.error(this, "origSFI is set in removeFrom() on " + this + " for " + SimpleManifestPutter.this, (Throwable)new Exception("debug"));
                container.activate((Object)oldSFI, 1);
                oldSFI.cancel(container, context);
                oldSFI.removeFrom(container, context);
                if (oldState == oldSFI) {
                    oldState = null;
                }
            }
            if (oldState != null) {
                Logger.error(this, "currentState is set in removeFrom() on " + this + " for " + SimpleManifestPutter.this, (Throwable)new Exception("debug"));
                container.activate((Object)oldState, 1);
                oldState.cancel(container, context);
                oldState.removeFrom(container, context);
            }
            if (this.cm != null) {
                container.activate((Object)this.cm, 5);
                this.cm.removeFrom(container);
            }
            if (this.metadata != null) {
                Logger.normal(this, "Metadata is set in removeFrom() on " + this + " for " + SimpleManifestPutter.this);
                container.activate((Object)this.metadata, 1);
                this.metadata.removeFrom(container);
            }
            super.removeFrom(container, context);
        }

        @Override
        public boolean objectCanNew(ObjectContainer container) {
            if (this.cancelled) {
                Logger.error(this, "Storing " + this + " when already cancelled!", (Throwable)new Exception("error"));
                return false;
            }
            if (logMINOR) {
                Logger.minor(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
            }
            return true;
        }

        @Override
        protected void innerToNetwork(ObjectContainer container, ClientContext context) {
        }
    }
}

