/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientRequester;
import freenet.client.async.Encodeable;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.PutCompletionCallback;
import freenet.crypt.RandomSource;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.KeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.KeyEncodeException;
import freenet.keys.KeyVerifyException;
import freenet.keys.SSKBlock;
import freenet.keys.SSKEncodeException;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.node.SendableRequestSender;
import freenet.store.KeyCollisionException;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SingleBlockInserter
extends SendableInsert
implements ClientPutState,
Encodeable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    Bucket sourceData;
    final short compressionCodec;
    final FreenetURI uri;
    FreenetURI resultingURI;
    final PutCompletionCallback cb;
    final BaseClientPutter parent;
    final InsertContext ctx;
    private int retries;
    private final FailureCodeTracker errors;
    private boolean finished;
    private final boolean dontSendEncoded;
    final int token;
    private final Object tokenObject;
    final boolean isMetadata;
    final boolean getCHKOnly;
    final int sourceLength;
    private int consecutiveRNFs;
    private boolean isSSK;
    private boolean freeData;
    private int completedInserts;
    final int extraInserts;
    final byte[] cryptoKey;
    final byte cryptoAlgorithm;

    private SingleBlockInserter() {
        this.uri = null;
        this.tokenObject = null;
        this.token = 0;
        this.sourceLength = 0;
        this.parent = null;
        this.isMetadata = false;
        this.getCHKOnly = false;
        this.extraInserts = 0;
        this.errors = null;
        this.dontSendEncoded = false;
        this.ctx = null;
        this.cryptoKey = null;
        this.cryptoAlgorithm = 0;
        this.compressionCodec = 0;
        this.cb = null;
    }

    public SingleBlockInserter(BaseClientPutter parent, Bucket data, short compressionCodec, FreenetURI uri, InsertContext ctx, boolean realTimeFlag, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean getCHKOnly, boolean addToParent, boolean dontSendEncoded, Object tokenObject, ObjectContainer container, ClientContext context, boolean persistent, boolean freeData, int extraInserts, byte cryptoAlgorithm, byte[] cryptoKey) {
        super(persistent, realTimeFlag);
        this.consecutiveRNFs = 0;
        this.tokenObject = tokenObject;
        this.token = token;
        this.parent = parent;
        this.dontSendEncoded = dontSendEncoded;
        this.retries = 0;
        this.finished = false;
        this.ctx = ctx;
        this.freeData = freeData;
        this.errors = new FailureCodeTracker(true);
        this.cb = cb;
        this.uri = uri;
        this.compressionCodec = compressionCodec;
        this.sourceData = data;
        if (this.sourceData == null) {
            throw new NullPointerException();
        }
        this.isMetadata = isMetadata;
        this.sourceLength = sourceLength;
        this.getCHKOnly = getCHKOnly;
        this.isSSK = uri.getKeyType().toUpperCase().equals("SSK");
        if (addToParent) {
            parent.addMustSucceedBlocks(1, container);
            parent.notifyClients(container, context);
        }
        this.extraInserts = extraInserts;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.cryptoKey = cryptoKey;
    }

    protected ClientKeyBlock innerEncode(RandomSource random, ObjectContainer container) throws InsertException {
        InsertContext.CompatibilityMode cmode;
        if (this.persistent) {
            container.activate((Object)this.uri, 1);
            container.activate((Object)this.sourceData, 1);
            container.activate((Object)this.ctx, 1);
        }
        boolean pre1254 = (cmode = this.ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && cmode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal();
        try {
            return SingleBlockInserter.innerEncode(random, this.uri, this.sourceData, this.isMetadata, this.compressionCodec, this.sourceLength, this.ctx.compressorDescriptor, pre1254, this.cryptoAlgorithm, this.cryptoKey);
        }
        catch (KeyEncodeException e) {
            Logger.error(SingleBlockInserter.class, "Caught " + e, (Throwable)e);
            throw new InsertException(3, e, null);
        }
        catch (MalformedURLException e) {
            throw new InsertException(1, e, null);
        }
        catch (IOException e) {
            Logger.error(SingleBlockInserter.class, "Caught " + e + " encoding data " + this.sourceData, (Throwable)e);
            throw new InsertException(2, e, null);
        }
        catch (InvalidCompressionCodecException e) {
            throw new InsertException(3, e, null);
        }
    }

    protected static ClientKeyBlock innerEncode(RandomSource random, FreenetURI uri, Bucket sourceData, boolean isMetadata, short compressionCodec, int sourceLength, String compressorDescriptor, boolean pre1254, byte cryptoAlgorithm, byte[] cryptoKey) throws InsertException, CHKEncodeException, IOException, SSKEncodeException, MalformedURLException, InvalidCompressionCodecException {
        String uriType = uri.getKeyType();
        if (uriType.equals("CHK")) {
            return ClientCHKBlock.encode(sourceData, isMetadata, compressionCodec == -1, compressionCodec, sourceLength, compressorDescriptor, pre1254, cryptoKey, cryptoAlgorithm);
        }
        if (uriType.equals("SSK") || uriType.equals("KSK")) {
            InsertableClientSSK ik = InsertableClientSSK.create(uri);
            return ik.encode(sourceData, isMetadata, compressionCodec == -1, compressionCodec, sourceLength, random, compressorDescriptor, pre1254);
        }
        throw new InsertException(1, "Unknown keytype " + uriType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEncode(final ClientKey key, ObjectContainer container, final ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            if (this.resultingURI != null) {
                return;
            }
            this.resultingURI = key.getURI();
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.cb, 1);
        }
        if (!this.persistent) {
            context.mainExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SingleBlockInserter.this.cb.onEncode(key, SingleBlockInserter.this, null, context);
                }
            }, "Got URI");
        } else {
            this.cb.onEncode(key, this, container, context);
        }
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientKeyBlock encode(ObjectContainer container, ClientContext context, boolean calledByCB) throws InsertException {
        boolean shouldSend;
        ClientKeyBlock block;
        if (this.persistent) {
            container.activate((Object)this.sourceData, 1);
            container.activate((Object)this.cb, 1);
        }
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return null;
            }
            if (this.sourceData == null) {
                Logger.error(this, "Source data is null on " + this + " but not finished!");
                return null;
            }
            block = this.innerEncode(context.random, container);
            shouldSend = this.resultingURI == null;
            this.resultingURI = block.getClientKey().getURI();
        }
        if (logMINOR) {
            Logger.minor(this, "Encoded " + this.resultingURI + " for " + this + " shouldSend=" + shouldSend + " dontSendEncoded=" + this.dontSendEncoded);
        }
        if (shouldSend && !this.dontSendEncoded) {
            this.cb.onEncode(block.getClientKey(), this, container, context);
        }
        if (shouldSend && this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent && !calledByCB) {
            container.deactivate((Object)this.cb, 1);
        }
        return block;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getPriorityClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(LowLevelPutException e, Object keyNum, ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.errors, 1);
        }
        if (this.parent.isCancelled()) {
            this.fail(new InsertException(10), container, context);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "onFailure() on " + e + " for " + this);
        }
        switch (e.code) {
            case 5: {
                this.fail(new InsertException(9), container, context);
                return;
            }
            case 1: {
                this.fail(new InsertException(3), container, context);
                return;
            }
            case 3: {
                this.errors.inc(4);
                break;
            }
            case 2: {
                this.errors.inc(5);
                break;
            }
            case 4: {
                this.errors.inc(8);
                break;
            }
            default: {
                Logger.error(this, "Unknown LowLevelPutException code: " + e.code);
                this.errors.inc(3);
            }
        }
        if (this.persistent) {
            this.errors.storeTo(container);
        }
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
        }
        if (e.code == 2 || e.code == 4) {
            ++this.consecutiveRNFs;
            if (logMINOR) {
                Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " / " + this.ctx.consecutiveRNFsCountAsSuccess);
            }
            if (this.consecutiveRNFs >= this.ctx.consecutiveRNFsCountAsSuccess) {
                if (logMINOR) {
                    Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " - counting as success");
                }
                this.onSuccess(keyNum, container, context);
                return;
            }
        } else {
            this.consecutiveRNFs = 0;
        }
        if (logMINOR) {
            Logger.minor(this, "Failed: " + e);
        }
        ++this.retries;
        if (this.retries > this.ctx.maxInsertRetries && this.ctx.maxInsertRetries != -1) {
            this.fail(InsertException.construct(this.persistent ? this.errors.clone() : this.errors), container, context);
            if (this.persistent) {
                container.deactivate((Object)this.ctx, 1);
            }
            return;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.deactivate((Object)this.ctx, 1);
        }
        this.clearCooldown(container, context, true);
    }

    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        this.fail(e, false, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, boolean forceFatal, ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (e.isFatal() || forceFatal) {
            this.parent.fatallyFailedBlock(container, context);
        } else {
            this.parent.failedBlock(container, context);
        }
        this.unregister(container, context, this.getPriorityClass(container));
        if (this.freeData) {
            if (this.persistent) {
                container.activate((Object)this.sourceData, 1);
            }
            this.sourceData.free();
            if (this.persistent) {
                this.sourceData.removeFrom(container);
            }
            this.sourceData = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientKeyBlock getBlock(ObjectContainer container, ClientContext context, boolean calledByCB) {
        try {
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            return this.encode(container, context, calledByCB);
        }
        catch (InsertException e) {
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
            }
            this.cb.onFailure(e, this, container, context);
            if (this.persistent && !calledByCB) {
                container.deactivate((Object)this.cb, 1);
            }
            return null;
        }
        catch (Throwable t) {
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
            }
            Logger.error(this, "Caught " + t, t);
            this.cb.onFailure(new InsertException(3, t, null), this, container, context);
            if (this.persistent && !calledByCB) {
                container.deactivate((Object)this.cb, 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Finished already: " + this);
                }
                return;
            }
        }
        if (this.getCHKOnly) {
            this.tryEncode(container, context);
            this.onSuccess(null, container, context);
        } else {
            this.getScheduler(container, context).registerInsert(this, this.persistent, true, container);
        }
    }

    @Override
    public boolean isSSK() {
        return this.isSSK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreenetURI getURI(ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.resultingURI != null) {
                if (this.persistent) {
                    container.activate((Object)this.resultingURI, 5);
                }
                return this.persistent ? this.resultingURI.clone() : this.resultingURI;
            }
        }
        this.getBlock(container, context, true);
        singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.persistent) {
                container.activate((Object)this.resultingURI, 5);
            }
            return this.persistent ? this.resultingURI.clone() : this.resultingURI;
        }
    }

    public synchronized FreenetURI getURINoEncode() {
        return this.resultingURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Object keyNum, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Succeeded (" + this + "): " + this.token);
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        if (this.parent.isCancelled()) {
            this.fail(new InsertException(10), container, context);
            return;
        }
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.extraInserts > 0 && !this.getCHKOnly && ++this.completedInserts <= this.extraInserts) {
                if (logMINOR) {
                    Logger.minor(this, "Completed inserts " + this.completedInserts + " of extra inserts " + this.extraInserts + " on " + this);
                }
                if (this.persistent) {
                    container.store((Object)this);
                }
                return;
            }
            if (this.finished) {
                Logger.normal(this, "Block already completed: " + this);
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.sourceData, 1);
        }
        if (this.freeData) {
            this.sourceData.free();
            if (this.persistent) {
                this.sourceData.removeFrom(container);
            }
            this.sourceData = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        this.parent.completedBlock(false, container, context);
        this.unregister(container, context, this.getPriorityClass(container));
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Calling onSuccess for " + this.cb);
        }
        this.cb.onSuccess(this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        boolean wasActive = true;
        if (this.persistent) {
            container.store((Object)this);
            wasActive = container.ext().isActive((Object)this.cb);
            if (!wasActive) {
                container.activate((Object)this.cb, 1);
            }
            container.activate((Object)this.sourceData, 1);
        }
        if (this.freeData) {
            this.sourceData.free();
            if (this.persistent) {
                this.sourceData.removeFrom(container);
            }
            this.sourceData = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        super.unregister(container, context, this.getPriorityClass(container));
        this.cb.onFailure(new InsertException(10), this, container, context);
        if (!wasActive) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    @Override
    public synchronized boolean isEmpty(ObjectContainer container) {
        return this.finished;
    }

    @Override
    public synchronized boolean isCancelled(ObjectContainer container) {
        return this.finished;
    }

    @Override
    public SendableRequestSender getSender(ObjectContainer container, ClientContext context) {
        boolean active = true;
        if (this.persistent && !(active = container.ext().isActive((Object)this.ctx))) {
            container.activate((Object)this.ctx, 1);
        }
        String compress = this.ctx.compressorDescriptor;
        if (!active) {
            container.deactivate((Object)this.ctx, 1);
        }
        return new MySendableRequestSender(compress, this);
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public Object getToken() {
        return this.tokenObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryEncode(ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.resultingURI != null) {
                return;
            }
            if (this.finished) {
                return;
            }
        }
        try {
            this.encode(container, context, false);
        }
        catch (InsertException e) {
            this.fail(e, container, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
    }

    @Override
    public synchronized long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public synchronized long countAllKeys(ObjectContainer container, ClientContext context) {
        return this.countSendableKeys(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally ignored, ObjectContainer container, ClientContext context) {
        try {
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
                BlockItemKey key = new BlockItemKey(this, this.hashCode());
                if (!this.persistent && ignored.hasTransientInsert(this, key)) {
                    return null;
                }
                return this.getBlockItem(key, container, context);
            }
        }
        catch (InsertException e) {
            this.fail(e, container, context);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockItem getBlockItem(BlockItemKey key, ObjectContainer container, ClientContext context) throws InsertException {
        try {
            InsertContext.CompatibilityMode cmode;
            boolean pre1254;
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
            }
            if (this.persistent && this.sourceData == null) {
                Logger.error(this, "getBlockItem(): sourceData = null but active = " + container.ext().isActive((Object)this), (Throwable)new Exception("error"));
                this.fail(new InsertException(3), container, context);
                return null;
            }
            boolean deactivateBucket = false;
            if (this.persistent) {
                container.activate((Object)this.uri, 1);
                boolean bl = deactivateBucket = !container.ext().isActive((Object)this.sourceData);
                if (deactivateBucket) {
                    container.activate((Object)this.sourceData, 1);
                }
            }
            Bucket data = this.sourceData.createShadow();
            FreenetURI u = this.uri;
            u = u.getKeyType().equals("CHK") && !this.persistent ? FreenetURI.EMPTY_CHK_URI : u.clone();
            if (data == null) {
                data = context.tempBucketFactory.makeBucket(this.sourceData.size());
                BucketTools.copy(this.sourceData, data);
            }
            boolean ctxActive = true;
            if (this.persistent) {
                if (deactivateBucket) {
                    container.deactivate((Object)this.sourceData, 1);
                }
                container.deactivate((Object)this.uri, 1);
                ctxActive = container.ext().isActive((Object)this.ctx);
                if (!ctxActive) {
                    container.activate((Object)this.ctx, 1);
                }
            }
            boolean bl = pre1254 = (cmode = this.ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && cmode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal();
            if (!ctxActive) {
                container.deactivate((Object)this.ctx, 1);
            }
            return new BlockItem(key, data, this.isMetadata, this.compressionCodec, this.sourceLength, u, this.persistent, pre1254, this.cryptoAlgorithm, this.cryptoKey);
        }
        catch (IOException e) {
            throw new InsertException(2, e, null);
        }
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        BlockItem item;
        try {
            BlockItemKey key = new BlockItemKey(this, this.hashCode());
            item = this.getBlockItem(key, container, context);
        }
        catch (InsertException e) {
            this.fail(e, container, context);
            return null;
        }
        if (item == null) {
            return null;
        }
        PersistentChosenBlock block = new PersistentChosenBlock(true, request, item, null, null, sched);
        return Collections.singletonList(block);
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "removeFrom() on " + this);
        }
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        if (this.resultingURI != null) {
            container.activate((Object)this.resultingURI, 5);
            this.resultingURI.removeFrom(container);
        }
        container.activate((Object)this.errors, 5);
        this.errors.removeFrom(container);
        if (this.freeData && this.sourceData != null && container.ext().isStored((Object)this.sourceData)) {
            Logger.error(this, "Data not removed!");
            container.activate((Object)this.sourceData, 1);
            this.sourceData.removeFrom(container);
        }
        container.delete((Object)this);
    }

    @Override
    public boolean canWriteClientCache(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.ctx);
            if (deactivate) {
                container.activate((Object)this.ctx, 1);
            }
        }
        boolean retval = this.ctx.canWriteClientCache;
        if (deactivate) {
            container.deactivate((Object)this.ctx, 1);
        }
        return retval;
    }

    @Override
    public boolean localRequestOnly(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.ctx);
            if (deactivate) {
                container.activate((Object)this.ctx, 1);
            }
        }
        boolean retval = this.ctx.localRequestOnly;
        if (deactivate) {
            container.deactivate((Object)this.ctx, 1);
        }
        return retval;
    }

    @Override
    public boolean forkOnCacheable(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.ctx);
            if (deactivate) {
                container.activate((Object)this.ctx, 1);
            }
        }
        boolean retval = this.ctx.forkOnCacheable;
        if (deactivate) {
            container.deactivate((Object)this.ctx, 1);
        }
        return retval;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "objectCanNew when already finished on " + this);
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "objectCanNew() on " + this, (Throwable)new Exception("debug"));
        }
        return true;
    }

    @Override
    public boolean isStorageBroken(ObjectContainer container) {
        if (this.parent == null) {
            return true;
        }
        return this.ctx == null;
    }

    @Override
    public void onEncode(SendableRequestItem token, ClientKey key, ObjectContainer container, ClientContext context) {
        this.onEncode(key, container, context);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private static class BlockItem
    implements SendableRequestItem {
        public final boolean pre1254;
        private final Bucket copyBucket;
        final BlockItemKey key;
        private final FreenetURI uri;
        private final boolean persistent;
        private final boolean isMetadata;
        private final short compressionCodec;
        private final int sourceLength;
        public byte cryptoAlgorithm;
        public byte[] cryptoKey;

        BlockItem(BlockItemKey key, Bucket bucket, boolean meta, short codec, int srclen, FreenetURI u, boolean persistent, boolean pre1254, byte cryptoAlgorithm, byte[] cryptoKey) {
            this.key = key;
            this.copyBucket = bucket;
            this.pre1254 = pre1254;
            this.uri = u;
            this.isMetadata = meta;
            this.compressionCodec = codec;
            this.sourceLength = srclen;
            this.persistent = persistent;
            this.cryptoAlgorithm = cryptoAlgorithm;
            this.cryptoKey = cryptoKey;
        }

        @Override
        public void dump() {
            this.copyBucket.free();
        }

        @Override
        public SendableRequestItemKey getKey() {
            return this.key;
        }
    }

    private static class BlockItemKey
    implements SendableRequestItemKey {
        private final int hashCode;
        private final SingleBlockInserter parent;

        BlockItemKey(SingleBlockInserter parent, int hashCode) {
            this.parent = parent;
            this.hashCode = hashCode;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof BlockItemKey && ((BlockItemKey)o).parent == this.parent;
        }
    }

    static class MySendableRequestSender
    implements SendableRequestSender {
        final String compressorDescriptor;
        final SingleBlockInserter orig;

        MySendableRequestSender(String compress, SingleBlockInserter orig) {
            this.compressorDescriptor = compress;
            this.orig = orig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean send(NodeClientCore core, RequestScheduler sched, ClientContext context, ChosenBlock req) {
            block36: {
                ClientKey k = null;
                if (logMINOR) {
                    Logger.minor(this, "Starting request");
                }
                BlockItem block = (BlockItem)req.token;
                try {
                    ClientKey key;
                    KeyBlock b;
                    ClientKeyBlock encodedBlock;
                    try {
                        encodedBlock = SingleBlockInserter.innerEncode(context.random, block.uri, block.copyBucket, block.isMetadata, block.compressionCodec, block.sourceLength, this.compressorDescriptor, block.pre1254, block.cryptoAlgorithm, block.cryptoKey);
                        b = encodedBlock.getBlock();
                    }
                    catch (CHKEncodeException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (SSKEncodeException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (MalformedURLException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (InsertException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (InvalidCompressionCodecException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    if (b == null) {
                        Logger.error(this, "Asked to send empty block", (Throwable)new Exception("error"));
                        boolean e = false;
                        return e;
                    }
                    k = key = encodedBlock.getClientKey();
                    if (block.persistent) {
                        req.setGeneratedKey(key);
                    } else {
                        this.orig.onEncode(key, null, context);
                    }
                    if (req.localRequestOnly) {
                        try {
                            core.node.store(b, false, req.canWriteClientCache, true, false);
                            break block36;
                        }
                        catch (KeyCollisionException e) {
                            LowLevelPutException failed = new LowLevelPutException(5);
                            KeyBlock collided = core.node.fetch(k.getNodeKey(), true, req.canWriteClientCache, false, false, null);
                            if (collided == null) {
                                Logger.error(this, "Collided but no key?!");
                                try {
                                    core.node.store(b, false, req.canWriteClientCache, true, false);
                                }
                                catch (KeyCollisionException e2) {
                                    Logger.error(this, "Collided but no key and still collided!");
                                    throw new LowLevelPutException(1, "Collided, can't find block, but still collides!", e);
                                }
                            }
                            failed.setCollidedBlock(collided);
                            throw failed;
                        }
                    }
                    core.realPut(b, req.canWriteClientCache, req.forkOnCacheable, false, false, req.realTimeFlag);
                }
                catch (LowLevelPutException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Caught " + e, (Throwable)e);
                    }
                    if (e.code == 5) {
                        byte[] inserting;
                        byte[] data;
                        ClientSSKBlock collided;
                        block37: {
                            collided = ClientSSKBlock.construct((SSKBlock)e.getCollidedBlock(), (ClientSSK)k);
                            data = collided.memoryDecode(true);
                            inserting = BucketTools.toByteArray(block.copyBucket);
                            if (collided.isMetadata() != block.isMetadata || collided.getCompressionCodec() != block.compressionCodec || !Arrays.equals(data, inserting)) break block37;
                            if (logMINOR) {
                                Logger.minor(this, "Collided with identical data");
                            }
                            if (!block.persistent) {
                                this.orig.onEncode(k, null, context);
                            }
                            req.onInsertSuccess(context);
                            boolean bl = true;
                            return bl;
                        }
                        try {
                            if (logMINOR) {
                                Logger.minor(this, "Apparently real collision: collided.isMetadata=" + collided.isMetadata() + " block.isMetadata=" + block.isMetadata + " collided.codec=" + collided.getCompressionCodec() + " block.codec=" + block.compressionCodec + " collided.datalength=" + data.length + " block.datalength=" + inserting.length + " H(collided)=" + Fields.hashCode(data) + " H(inserting)=" + Fields.hashCode(inserting));
                            }
                        }
                        catch (KeyVerifyException e1) {
                            Logger.error(this, "Caught " + e1 + " when checking collision!", (Throwable)e1);
                        }
                        catch (KeyDecodeException e1) {
                            Logger.error(this, "Caught " + e1 + " when checking collision!", (Throwable)e1);
                        }
                        catch (IOException e1) {
                            Logger.error(this, "Caught " + e1 + " when checking collision!", (Throwable)e1);
                        }
                    }
                    req.onFailure(e, context);
                    if (logMINOR) {
                        Logger.minor(this, "Request failed for " + e);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    block.copyBucket.free();
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Request succeeded");
            }
            req.onInsertSuccess(context);
            return true;
        }

        @Override
        public boolean sendIsBlocking() {
            return true;
        }
    }
}

