/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ArchiveExtractCallback;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveHandler;
import freenet.client.ArchiveManager;
import freenet.client.ArchiveRestartException;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetWorkerThread;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SimpleSingleFileFetcher;
import freenet.client.async.SingleFileStreamGenerator;
import freenet.client.async.SnoopBucket;
import freenet.client.async.SnoopMetadata;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.StreamGenerator;
import freenet.client.async.USKFetcherTag;
import freenet.client.async.USKFetcherTagCallback;
import freenet.client.async.USKProxyCompletionCallback;
import freenet.crypt.HashResult;
import freenet.crypt.MultiHashInputStream;
import freenet.keys.BaseClientKey;
import freenet.keys.ClientCHK;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import freenet.support.compress.DecompressorThreadManager;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SingleFileFetcher
extends SimpleSingleFileFetcher {
    private static volatile boolean logMINOR;
    final FreenetURI uri;
    private final ArrayList<String> metaStrings;
    private int addedMetaStrings;
    final ClientMetadata clientMetadata;
    private Metadata metadata;
    private Metadata archiveMetadata;
    final ArchiveContext actx;
    private ArchiveHandler ah;
    private int recursionLevel;
    private FreenetURI thisKey;
    private final LinkedList<Compressor.COMPRESSOR_TYPE> decompressors;
    private final boolean dontTellClientGet;
    private final boolean isFinal;
    private final SnoopMetadata metaSnoop;
    private final SnoopBucket bucketSnoop;
    private boolean topDontCompress = false;
    private short topCompatibilityMode = 0;

    public SingleFileFetcher(ClientRequester parent, GetCompletionCallback cb, ClientMetadata metadata, ClientKey key, List<String> metaStrings, FreenetURI origURI, int addedMetaStrings, FetchContext ctx, boolean deleteFetchContext, boolean realTimeFlag, ArchiveContext actx, ArchiveHandler ah, Metadata archiveMetadata, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, boolean isFinal, boolean topDontCompress, short topCompatibilityMode, ObjectContainer container, ClientContext context, boolean hasInitialMetadata) throws FetchException {
        super(key, maxRetries, ctx, parent, cb, isEssential, false, l, container, context, deleteFetchContext, realTimeFlag);
        if (logMINOR) {
            Logger.minor(this, "Creating SingleFileFetcher for " + key + " from " + origURI + " meta=" + metaStrings.toString() + " persistent=" + this.persistent, (Throwable)new Exception("debug"));
        }
        this.isFinal = isFinal;
        this.cancelled = false;
        this.dontTellClientGet = dontTellClientGet;
        if (this.persistent && ah != null) {
            ah = ah.cloneHandler();
        }
        this.ah = ah;
        this.archiveMetadata = archiveMetadata;
        this.metaStrings = metaStrings instanceof ArrayList && !this.persistent ? (ArrayList<Object>)metaStrings : new ArrayList<String>(metaStrings);
        this.addedMetaStrings = addedMetaStrings;
        if (logMINOR) {
            Logger.minor(this, "Metadata: " + metadata);
        }
        this.clientMetadata = metadata != null ? metadata.clone() : new ClientMetadata();
        this.thisKey = hasInitialMetadata ? FreenetURI.EMPTY_CHK_URI.clone() : key.getURI();
        if (origURI == null) {
            throw new NullPointerException();
        }
        this.uri = this.persistent ? origURI.clone() : origURI;
        this.actx = actx;
        this.recursionLevel = recursionLevel + 1;
        if (recursionLevel > ctx.maxRecursionLevel) {
            throw new FetchException(9, "Too much recursion: " + recursionLevel + " > " + ctx.maxRecursionLevel);
        }
        this.decompressors = new LinkedList();
        this.topDontCompress = topDontCompress;
        this.topCompatibilityMode = topCompatibilityMode;
        if (parent instanceof ClientGetter) {
            this.metaSnoop = ((ClientGetter)parent).getMetaSnoop();
            this.bucketSnoop = ((ClientGetter)parent).getBucketSnoop();
        } else {
            this.metaSnoop = null;
            this.bucketSnoop = null;
        }
    }

    public SingleFileFetcher(SingleFileFetcher fetcher, boolean persistent, boolean deleteFetchContext, Metadata newMeta, GetCompletionCallback callback, FetchContext ctx2, ObjectContainer container, ClientContext context) throws FetchException {
        super(persistent ? fetcher.key.cloneKey() : fetcher.key, fetcher.maxRetries, ctx2, fetcher.parent, callback, false, true, fetcher.token, container, context, deleteFetchContext, fetcher.realTimeFlag);
        if (logMINOR) {
            Logger.minor(this, "Creating SingleFileFetcher for " + fetcher.key + " meta=" + fetcher.metaStrings.toString(), (Throwable)new Exception("debug"));
        }
        this.isFinal = false;
        this.dontTellClientGet = fetcher.dontTellClientGet;
        this.actx = fetcher.actx;
        this.ah = fetcher.ah;
        if (persistent && this.ah != null) {
            this.ah = this.ah.cloneHandler();
        }
        this.archiveMetadata = null;
        this.clientMetadata = fetcher.clientMetadata != null ? fetcher.clientMetadata.clone() : new ClientMetadata();
        this.metadata = newMeta;
        this.metaStrings = new ArrayList();
        this.addedMetaStrings = 0;
        this.recursionLevel = fetcher.recursionLevel + 1;
        if (this.recursionLevel > this.ctx.maxRecursionLevel) {
            throw new FetchException(9);
        }
        this.thisKey = persistent ? fetcher.thisKey.clone() : fetcher.thisKey;
        this.decompressors = new LinkedList();
        if (fetcher.uri == null) {
            throw new NullPointerException();
        }
        this.uri = persistent ? fetcher.uri.clone() : fetcher.uri;
        this.metaSnoop = fetcher.metaSnoop;
        this.bucketSnoop = fetcher.bucketSnoop;
        this.topDontCompress = fetcher.topDontCompress;
        this.topCompatibilityMode = fetcher.topCompatibilityMode;
    }

    @Override
    public void onSuccess(ClientKeyBlock block, boolean fromStore, Object token, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.ctx, 1);
        }
        if (this.parent instanceof ClientGetter) {
            ((ClientGetter)this.parent).addKeyToBinaryBlob(block, container, context);
        }
        this.parent.completedBlock(fromStore, container, context);
        if (block == null) {
            Logger.error(this, "block is null! fromStore=" + fromStore + ", token=" + token, (Throwable)new Exception("error"));
            return;
        }
        Bucket data = this.extract(block, container, context);
        if (this.key instanceof ClientSSK) {
            context.uskManager.checkUSK(this.uri, this.persistent, container, data != null && !block.isMetadata());
        }
        if (data == null) {
            if (logMINOR) {
                Logger.minor(this, "No data");
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Block " + (block.isMetadata() ? "is metadata" : "is not metadata") + " on " + this);
        }
        if (this.bucketSnoop != null) {
            if (this.persistent) {
                container.activate((Object)this.bucketSnoop, 1);
            }
            if (this.bucketSnoop.snoopBucket(data, block.isMetadata(), container, context)) {
                this.cancel(container, context);
                if (this.persistent) {
                    container.deactivate((Object)this.bucketSnoop, 1);
                }
                data.free();
                return;
            }
            if (this.persistent) {
                container.deactivate((Object)this.bucketSnoop, 1);
            }
        }
        if (!block.isMetadata()) {
            this.onSuccess(new FetchResult(this.clientMetadata, data), container, context);
        } else {
            this.handleMetadata(data, container, context);
        }
    }

    void startWithMetadata(Bucket data, ObjectContainer container, ClientContext context) {
        this.parent.completedBlock(true, container, context);
        this.handleMetadata(data, container, context);
    }

    private void handleMetadata(Bucket data, ObjectContainer container, ClientContext context) {
        if (!this.ctx.followRedirects) {
            this.onFailure(new FetchException(4, "Told me not to follow redirects (splitfile block??)"), false, container, context);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            return;
        }
        if (this.parent.isCancelled()) {
            this.onFailure(new FetchException(25), false, container, context);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            return;
        }
        if (data.size() > (long)this.ctx.maxMetadataSize) {
            this.onFailure(new FetchException(22), false, container, context);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            return;
        }
        try {
            this.removeMetadata(container);
            this.metadata = Metadata.construct(data);
            if (this.persistent) {
                container.store((Object)this);
            }
            this.innerWrapHandleMetadata(false, container, context);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
        }
        catch (MetadataParseException e) {
            this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            return;
        }
        catch (EOFException e) {
            this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            return;
        }
        catch (IOException e) {
            this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSuccess(final FetchResult result, ObjectContainer container, final ClientContext context) {
        if (this.persistent) {
            container.activate(this.decompressors, 1);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.rcb, 1);
        }
        this.removeMetadata(container);
        this.removeArchiveMetadata(container);
        SingleFileFetcher singleFileFetcher = this;
        synchronized (singleFileFetcher) {
            this.finished = true;
        }
        if (this.parent.isCancelled()) {
            if (logMINOR) {
                Logger.minor(this, "Parent is cancelled");
            }
            result.asBucket().free();
            if (this.persistent) {
                result.asBucket().removeFrom(container);
            }
            this.onFailure(new FetchException(25), false, container, context);
            return;
        }
        if (!this.ctx.ignoreTooManyPathComponents && !this.metaStrings.isEmpty() && this.isFinal) {
            if (this.addedMetaStrings > 0) {
                this.rcb.onFailure(new FetchException(4, "Invalid metadata: too many path components in redirects", this.thisKey), this, container, context);
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Too many path components: for " + this.uri + " meta=" + this.metaStrings.toString());
                }
                FreenetURI tryURI = this.uri;
                tryURI = tryURI.dropLastMetaStrings(this.metaStrings.size());
                this.rcb.onFailure(new FetchException(11, result.size(), this.rcb == this.parent, result.getMimeType(), tryURI), this, container, context);
            }
            result.asBucket().free();
            if (this.persistent) {
                result.asBucket().removeFrom(container);
            }
            return;
        }
        if (result.size() > this.ctx.maxOutputLength) {
            this.rcb.onFailure(new FetchException(21, result.size(), this.rcb == this.parent, result.getMimeType()), this, container, context);
            result.asBucket().free();
            if (this.persistent) {
                result.asBucket().removeFrom(container);
            }
        } else if (this.persistent()) {
            this.rcb.onSuccess(new SingleFileStreamGenerator(result.asBucket(), this.persistent), result.getMetadata(), this.decompressors, this, container, context);
        } else {
            context.mainExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SingleFileFetcher.this.rcb.onSuccess(new SingleFileStreamGenerator(result.asBucket(), SingleFileFetcher.this.persistent), result.getMetadata(), SingleFileFetcher.this.decompressors, SingleFileFetcher.this, null, context);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleMetadata(final ObjectContainer container, final ClientContext context) throws FetchException, MetadataParseException, ArchiveFailureException, ArchiveRestartException {
        block121: {
            long uncompressedLen;
            String mimeType;
            if (this.persistent) {
                container.activate((Object)this, 2);
                container.activate((Object)this.metadata, Integer.MAX_VALUE);
                container.activate(this.metaStrings, Integer.MAX_VALUE);
                container.activate((Object)this.thisKey, 5);
                container.activate((Object)this.ctx, 2);
                if (this.ah != null) {
                    this.ah.activateForExecution(container);
                }
                container.activate((Object)this.parent, 1);
                container.activate((Object)this.actx, 5);
                container.activate((Object)this.clientMetadata, 5);
                container.activate((Object)this.rcb, 1);
            }
            if (this.uri == null) {
                if (container != null) {
                    if (container.ext().isActive((Object)this)) {
                        throw new NullPointerException("SFI " + this + " is active and uri is null!");
                    }
                    throw new NullPointerException("SFI " + this + " is not active!");
                }
                throw new NullPointerException("uri = null on transient SFI?? " + this);
            }
            SingleFileFetcher singleFileFetcher = this;
            synchronized (singleFileFetcher) {
                if (this.cancelled) {
                    return;
                }
                this.finished = true;
            }
            while (true) {
                if (this.metaSnoop != null) {
                    if (this.persistent) {
                        container.activate((Object)this.metaSnoop, 1);
                    }
                    if (this.metaSnoop.snoopMetadata(this.metadata, container, context)) {
                        this.cancel(container, context);
                        if (this.persistent) {
                            container.deactivate((Object)this.metaSnoop, 1);
                        }
                        return;
                    }
                    if (this.persistent) {
                        container.deactivate((Object)this.metaSnoop, 1);
                    }
                }
                if (this.metaStrings.size() == 0) {
                    HashResult[] hashes;
                    if (this.metadata.hasTopData()) {
                        if (this.metadata.topSize > this.ctx.maxOutputLength || this.metadata.topCompressedSize > this.ctx.maxTempLength) {
                            if (this.persistent) {
                                this.removeFrom(container, context);
                            }
                            if (this.metadata.isSimpleRedirect() || this.metadata.isSplitfile()) {
                                this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                            }
                            throw new FetchException(21, this.metadata.topSize, true, this.clientMetadata.getMIMEType());
                        }
                        this.rcb.onExpectedTopSize(this.metadata.topSize, this.metadata.topCompressedSize, this.metadata.topBlocksRequired, this.metadata.topBlocksTotal, container, context);
                        this.topCompatibilityMode = this.metadata.getTopCompatibilityCode();
                        this.topDontCompress = this.metadata.getTopDontCompress();
                    }
                    if ((hashes = this.metadata.getHashes()) != null) {
                        this.rcb.onHashes(hashes, container, context);
                    }
                }
                if (this.metadata.isSimpleManifest()) {
                    String oldName;
                    Metadata newMeta;
                    String name;
                    if (logMINOR) {
                        Logger.minor(this, "Is simple manifest");
                    }
                    if (this.metadata.countDocuments() == 1 && this.metadata.getDocument("") != null && this.metadata.getDocument("").isSimpleManifest()) {
                        Logger.error(this, "Manifest is called \"\" for " + this, (Throwable)new Exception("error"));
                        name = "";
                    } else {
                        if (this.metaStrings.isEmpty()) {
                            FreenetURI u = this.uri;
                            String last = u.lastMetaString();
                            u = last == null || !last.equals("") ? u.addMetaStrings(new String[]{""}) : null;
                            throw new FetchException(24, -1L, false, null, u);
                        }
                        name = this.removeMetaString();
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Next meta-string: " + name + " length " + name.length() + " for " + this);
                    }
                    if (name == null) {
                        if (!this.persistent) {
                            this.metadata = this.metadata.getDefaultDocument();
                        } else {
                            newMeta = this.metadata.grabDefaultDocument();
                            this.metadata.removeFrom(container);
                            this.metadata = newMeta;
                            container.store((Object)this);
                            container.store(this.metaStrings);
                        }
                        if (this.metadata != null) continue;
                        throw new FetchException(24, -1L, false, null, this.uri.addMetaStrings(new String[]{""}));
                    }
                    if (!this.persistent) {
                        Metadata origMd = this.metadata;
                        this.metadata = origMd.getDocument(name);
                        if (this.metadata != null && this.metadata.isSymbolicShortlink()) {
                            oldName = name;
                            if (oldName.equals(name = this.metadata.getSymbolicShortlinkTargetName())) {
                                throw new FetchException(4, "redirect loop: " + name);
                            }
                            this.metadata = origMd.getDocument(name);
                        }
                        this.thisKey = this.thisKey.pushMetaString(name);
                    } else {
                        newMeta = this.metadata.grabDocument(name);
                        if (newMeta != null && newMeta.isSymbolicShortlink()) {
                            oldName = name;
                            if (oldName.equals(name = newMeta.getSymbolicShortlinkTargetName())) {
                                throw new FetchException(4, "redirect loop: " + name);
                            }
                            newMeta = this.metadata.getDocument(name);
                        }
                        this.metadata.removeFrom(container);
                        this.metadata = newMeta;
                        FreenetURI oldThisKey = this.thisKey;
                        this.thisKey = this.thisKey.pushMetaString(name);
                        container.store((Object)this);
                        container.store(this.metaStrings);
                        container.store((Object)this.thisKey);
                        oldThisKey.removeFrom(container);
                    }
                    if (this.metadata != null) continue;
                    throw new FetchException(10, "can't find " + name);
                }
                if (this.metadata.isArchiveManifest()) {
                    if (logMINOR) {
                        Logger.minor(this, "Is archive manifest (type=" + (Object)((Object)this.metadata.getArchiveType()) + " codec=" + this.metadata.getCompressionCodec() + ')');
                    }
                    if (this.metaStrings.isEmpty() && this.ctx.returnZIPManifests) {
                        this.metadata.setSimpleRedirect();
                        if (!this.persistent) continue;
                        container.store((Object)this.metadata);
                        continue;
                    }
                    if (this.ah == null || !this.ah.getKey().equals(this.thisKey)) {
                        this.actx.doLoopDetection(this.thisKey, container);
                        this.ah = context.archiveManager.makeHandler(this.thisKey, this.metadata.getArchiveType(), this.metadata.getCompressionCodec(), this.parent instanceof ClientGetter ? ((ClientGetter)this.parent).collectingBinaryBlob() : false, this.persistent);
                    }
                    this.archiveMetadata = this.metadata;
                    this.metadata = null;
                    Bucket metadataBucket = this.ah.getMetadata(this.actx, context.archiveManager, (ObjectContainer)(this.persistent ? container : null));
                    if (metadataBucket != null) {
                        try {
                            this.metadata = Metadata.construct(metadataBucket);
                            metadataBucket.free();
                        }
                        catch (IOException e) {
                            throw new FetchException(12, (Throwable)e);
                        }
                        if (this.persistent) {
                            container.store((Object)this);
                        }
                    } else {
                        final boolean persistent = this.persistent;
                        this.fetchArchive(false, this.archiveMetadata, ".metadata", new ArchiveExtractCallback(){

                            @Override
                            public void gotBucket(Bucket data, ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "gotBucket on " + SingleFileFetcher.this + " persistent=" + persistent);
                                }
                                try {
                                    SingleFileFetcher.this.metadata = Metadata.construct(data);
                                    data.free();
                                    if (persistent) {
                                        data.removeFrom(container);
                                    }
                                    SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
                                }
                                catch (MetadataParseException e) {
                                    SingleFileFetcher.this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
                                    return;
                                }
                                catch (IOException e) {
                                    SingleFileFetcher.this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
                                    return;
                                }
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            @Override
                            public void notInArchive(ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                SingleFileFetcher.this.onFailure(new FetchException(17, "No metadata in container! Cannot happen as ArchiveManager should synthesise some!"), false, container, context);
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            @Override
                            public void onFailed(ArchiveRestartException e, ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            @Override
                            public void onFailed(ArchiveFailureException e, ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            @Override
                            public void removeFrom(ObjectContainer container) {
                                container.delete((Object)this);
                            }
                        }, container, context);
                        if (persistent) {
                            container.store((Object)this);
                        }
                        return;
                    }
                    metadataBucket.free();
                    continue;
                }
                if (this.metadata.isArchiveMetadataRedirect()) {
                    Bucket dataBucket;
                    if (logMINOR) {
                        Logger.minor(this, "Is archive-metadata");
                    }
                    if (this.ah == null) {
                        throw new FetchException(3, "Archive redirect not in an archive manifest");
                    }
                    String filename = this.metadata.getArchiveInternalName();
                    if (logMINOR) {
                        Logger.minor(this, "Fetching " + filename);
                    }
                    if ((dataBucket = this.ah.get(filename, this.actx, context.archiveManager, (ObjectContainer)(this.persistent ? container : null))) != null) {
                        Metadata newMetadata;
                        if (logMINOR) {
                            Logger.minor(this, "Returning data");
                        }
                        try {
                            newMetadata = Metadata.construct(dataBucket);
                            dataBucket.free();
                        }
                        catch (IOException e) {
                            throw new FetchException(12);
                        }
                        this.removeMetadata(container);
                        SingleFileFetcher e = this;
                        synchronized (e) {
                            this.metadata = newMetadata;
                        }
                        if (!this.persistent) continue;
                        container.store((Object)newMetadata);
                        container.store((Object)this);
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Fetching archive (thisKey=" + this.thisKey + ')');
                    }
                    final boolean persistent = this.persistent;
                    this.fetchArchive(true, this.archiveMetadata, filename, new ArchiveExtractCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void gotBucket(Bucket data, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Returning data");
                            }
                            try {
                                Metadata newMetadata = Metadata.construct(data);
                                SingleFileFetcher.this.removeMetadata(container);
                                SingleFileFetcher singleFileFetcher = SingleFileFetcher.this;
                                synchronized (singleFileFetcher) {
                                    SingleFileFetcher.this.metadata = newMetadata;
                                }
                                if (persistent) {
                                    container.store((Object)newMetadata);
                                    container.store((Object)SingleFileFetcher.this);
                                }
                                SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
                            }
                            catch (IOException e) {
                                SingleFileFetcher.this.onFailure(new FetchException(12), false, container, context);
                            }
                            catch (MetadataParseException e) {
                                SingleFileFetcher.this.onFailure(new FetchException(4), false, container, context);
                            }
                            finally {
                                data.free();
                            }
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void notInArchive(ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(10), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void onFailed(ArchiveRestartException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void onFailed(ArchiveFailureException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void removeFrom(ObjectContainer container) {
                            container.delete((Object)this);
                        }
                    }, container, context);
                    this.removeMetadata(container);
                    return;
                }
                if (this.metadata.isArchiveInternalRedirect()) {
                    Bucket dataBucket;
                    String mime;
                    if (logMINOR) {
                        Logger.minor(this, "Is archive-internal redirect");
                    }
                    this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                    if (this.persistent) {
                        container.store((Object)this.clientMetadata);
                    }
                    if ((mime = this.clientMetadata.getMIMEType()) != null) {
                        this.rcb.onExpectedMIME(this.clientMetadata, container, context);
                    }
                    if (this.metaStrings.isEmpty() && this.isFinal && this.clientMetadata.getMIMETypeNoParams() != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(this.clientMetadata.getMIMETypeNoParams())) {
                        throw new FetchException(29, -1L, false, this.clientMetadata.getMIMEType());
                    }
                    if (this.ah == null) {
                        throw new FetchException(3, "Archive redirect not in an archive manifest");
                    }
                    String filename = this.metadata.getArchiveInternalName();
                    if (logMINOR) {
                        Logger.minor(this, "Fetching " + filename);
                    }
                    if ((dataBucket = this.ah.get(filename, this.actx, context.archiveManager, (ObjectContainer)(this.persistent ? container : null))) != null) {
                        Bucket out;
                        if (logMINOR) {
                            Logger.minor(this, "Returning data");
                        }
                        try {
                            if (this.persistent) {
                                out = context.persistentBucketFactory.makeBucket(dataBucket.size());
                                BucketTools.copy(dataBucket, out);
                                dataBucket.free();
                            } else {
                                out = dataBucket;
                            }
                        }
                        catch (IOException e) {
                            throw new FetchException(12);
                        }
                        this.onSuccess(new FetchResult(this.clientMetadata, out), container, context);
                        return;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Fetching archive (thisKey=" + this.thisKey + ')');
                    }
                    final boolean persistent = this.persistent;
                    this.fetchArchive(true, this.archiveMetadata, filename, new ArchiveExtractCallback(){

                        @Override
                        public void gotBucket(Bucket data, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Returning data");
                            }
                            SingleFileFetcher.this.onSuccess(new FetchResult(SingleFileFetcher.this.clientMetadata, data), container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void notInArchive(ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(10), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void onFailed(ArchiveRestartException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void onFailed(ArchiveFailureException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        @Override
                        public void removeFrom(ObjectContainer container) {
                            container.delete((Object)this);
                        }
                    }, container, context);
                    this.removeMetadata(container);
                    return;
                }
                if (this.metadata.isMultiLevelMetadata()) {
                    if (logMINOR) {
                        Logger.minor(this, "Is multi-level metadata");
                    }
                    this.metadata.setSimpleRedirect();
                    final SingleFileFetcher f = new SingleFileFetcher(this, this.persistent, false, this.metadata, new MultiLevelMetadataCallback(), this.ctx, container, context);
                    this.metadata = null;
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                    if (this.persistent) {
                        container.store((Object)f);
                    }
                    this.parent.onTransition(this, f, container);
                    if (this.persistent) {
                        f.innerWrapHandleMetadata(true, container, context);
                        container.deactivate((Object)f, 1);
                    } else {
                        context.mainExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                f.innerWrapHandleMetadata(true, container, context);
                            }
                        });
                    }
                    return;
                }
                if (this.metadata.isSingleFileRedirect()) {
                    ClientKey redirectedKey;
                    if (logMINOR) {
                        Logger.minor(this, "Is single-file redirect");
                    }
                    this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                    if (this.persistent) {
                        container.store((Object)this.clientMetadata);
                    }
                    if (this.clientMetadata != null && !this.clientMetadata.isTrivial()) {
                        this.rcb.onExpectedMIME(this.clientMetadata, container, context);
                        if (logMINOR) {
                            Logger.minor(this, "MIME type is " + this.clientMetadata);
                        }
                    }
                    if ((mimeType = this.clientMetadata.getMIMETypeNoParams()) != null && ArchiveManager.ARCHIVE_TYPE.isUsableArchiveType(mimeType) && this.metaStrings.size() > 0) {
                        this.metadata.setArchiveManifest();
                        if (this.persistent) {
                            container.store((Object)this.metadata);
                        }
                        this.clientMetadata.clear();
                        if (this.persistent) {
                            container.store((Object)this.clientMetadata);
                        }
                        if (!logMINOR) continue;
                        Logger.minor(this, "Handling implicit container... (redirect)");
                        continue;
                    }
                    if (this.metaStrings.isEmpty() && this.isFinal && mimeType != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(mimeType)) {
                        throw new FetchException(29, -1L, false, this.clientMetadata.getMIMEType());
                    }
                    FreenetURI newURI = this.metadata.getSingleTarget();
                    if (logMINOR) {
                        Logger.minor(this, "Redirecting to " + newURI);
                    }
                    try {
                        BaseClientKey k = BaseClientKey.getBaseKey(newURI);
                        if (!(k instanceof ClientKey)) {
                            throw new FetchException(3, "Redirect to a USK");
                        }
                        redirectedKey = (ClientKey)k;
                    }
                    catch (MalformedURLException e) {
                        throw new FetchException(20, (Throwable)e);
                    }
                    ArrayList<String> newMetaStrings = newURI.listMetaStrings();
                    while (!newMetaStrings.isEmpty()) {
                        String o = newMetaStrings.remove(newMetaStrings.size() - 1);
                        this.metaStrings.add(0, o);
                        ++this.addedMetaStrings;
                    }
                    SingleFileFetcher f = new SingleFileFetcher(this.parent, this.rcb, this.clientMetadata, redirectedKey, this.metaStrings, this.uri, this.addedMetaStrings, this.ctx, this.deleteFetchContext, this.realTimeFlag, this.actx, this.ah, this.archiveMetadata, this.maxRetries, this.recursionLevel, false, this.token, true, this.isFinal, this.topDontCompress, this.topCompatibilityMode, container, context, false);
                    this.deleteFetchContext = false;
                    if (redirectedKey instanceof ClientCHK && !((ClientCHK)redirectedKey).isMetadata()) {
                        this.rcb.onBlockSetFinished(this, container, context);
                        byte[] redirectedCryptoKey = ((ClientCHK)redirectedKey).getCryptoKey();
                        if (this.key instanceof ClientCHK && !Arrays.equals(((ClientCHK)this.key).getCryptoKey(), redirectedCryptoKey)) {
                            redirectedCryptoKey = null;
                        }
                        this.rcb.onSplitfileCompatibilityMode(this.metadata.getMinCompatMode(), this.metadata.getMaxCompatMode(), redirectedCryptoKey, !((ClientCHK)redirectedKey).isCompressed(), true, true, container, context);
                    }
                    if (this.metadata.isCompressed()) {
                        Compressor.COMPRESSOR_TYPE codec = this.metadata.getCompressionCodec();
                        f.addDecompressor(codec);
                    }
                    this.parent.onTransition(this, f, container);
                    if (this.persistent) {
                        container.store(this.metaStrings);
                        container.store((Object)f);
                        container.store((Object)this);
                    }
                    f.schedule(container, context);
                    this.archiveMetadata = null;
                    if (this.persistent) {
                        this.removeFrom(container, context);
                    }
                    return;
                }
                if (!this.metadata.isSplitfile()) break block121;
                if (logMINOR) {
                    Logger.minor(this, "Fetching splitfile");
                }
                this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                if (this.persistent) {
                    container.store((Object)this.clientMetadata);
                }
                if ((mimeType = this.clientMetadata.getMIMETypeNoParams()) == null || !ArchiveManager.ARCHIVE_TYPE.isUsableArchiveType(mimeType) || this.metaStrings.size() <= 0) break;
                this.metadata.setArchiveManifest();
                this.clientMetadata.clear();
                if (this.persistent) {
                    container.store((Object)this.metadata);
                    container.store((Object)this.clientMetadata);
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Handling implicit container... (splitfile)");
            }
            if (this.clientMetadata != null && !this.clientMetadata.isTrivial()) {
                this.rcb.onExpectedMIME(this.clientMetadata, container, context);
            }
            if (this.metaStrings.isEmpty() && this.isFinal && mimeType != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(mimeType)) {
                long len = this.metadata.uncompressedDataLength();
                if (this.persistent) {
                    this.removeFrom(container, context);
                }
                throw new FetchException(29, len, false, this.clientMetadata.getMIMEType());
            }
            if (this.metadata.isCompressed()) {
                Compressor.COMPRESSOR_TYPE codec = this.metadata.getCompressionCodec();
                this.addDecompressor(codec);
                if (this.persistent) {
                    container.store(this.decompressors);
                }
            }
            if (this.isFinal && !this.ctx.ignoreTooManyPathComponents) {
                if (!this.metaStrings.isEmpty()) {
                    if (this.addedMetaStrings > 0) {
                        this.rcb.onFailure(new FetchException(4, "Invalid metadata: too many path components in redirects", this.thisKey), this, container, context);
                    } else {
                        FreenetURI tryURI = this.uri;
                        tryURI = tryURI.dropLastMetaStrings(this.metaStrings.size());
                        this.rcb.onFailure(new FetchException(11, this.metadata.uncompressedDataLength(), this.rcb == this.parent, this.clientMetadata.getMIMEType(), tryURI), this, container, context);
                    }
                    if (this.persistent) {
                        this.removeFrom(container, context);
                    }
                    return;
                }
            } else if (logMINOR) {
                Logger.minor(this, "Not finished: rcb=" + this.rcb + " for " + this);
            }
            long len = this.metadata.dataLength();
            long l = uncompressedLen = this.metadata.isCompressed() ? this.metadata.uncompressedDataLength() : len;
            if (uncompressedLen > this.ctx.maxOutputLength || len > this.ctx.maxTempLength) {
                boolean compressed = this.metadata.isCompressed();
                if (this.persistent) {
                    this.removeFrom(container, context);
                }
                throw new FetchException(21, uncompressedLen, this.isFinal && this.decompressors.size() <= (compressed ? 1 : 0), this.clientMetadata.getMIMEType());
            }
            SplitFileFetcher sf = new SplitFileFetcher(this.metadata, this.rcb, this.parent, this.ctx, this.deleteFetchContext, this.realTimeFlag, this.decompressors, this.clientMetadata, this.actx, this.recursionLevel, this.token, this.topDontCompress, this.topCompatibilityMode, container, context);
            this.deleteFetchContext = false;
            if (this.persistent) {
                container.store((Object)sf);
                if (!container.ext().isActive((Object)this.parent)) {
                    container.activate((Object)this.parent, 1);
                    Logger.error(this, "Not active: " + this.parent);
                }
            }
            this.parent.onTransition(this, sf, container);
            try {
                sf.schedule(container, context);
            }
            catch (KeyListenerConstructionException e) {
                this.onFailure(e.getFetchException(), false, container, context);
                if (this.persistent) {
                    container.deactivate((Object)sf, 1);
                }
                return;
            }
            if (this.persistent) {
                container.deactivate((Object)sf, 1);
            }
            this.rcb.onBlockSetFinished(this, container, context);
            if (this.persistent) {
                this.removeFrom(container, context);
            }
            return;
        }
        Logger.error(this, "Don't know what to do with metadata: " + this.metadata);
        this.removeMetadata(container);
        throw new FetchException(3);
    }

    private String removeMetaString() {
        String name = this.metaStrings.remove(0);
        if (this.addedMetaStrings > 0) {
            --this.addedMetaStrings;
        }
        return name;
    }

    private void addDecompressor(Compressor.COMPRESSOR_TYPE codec) {
        if (logMINOR) {
            Logger.minor(this, "Adding decompressor: " + codec + " on " + this, (Throwable)new Exception("debug"));
        }
        this.decompressors.add(codec);
    }

    private void fetchArchive(boolean forData, Metadata meta, String element, ArchiveExtractCallback callback, final ObjectContainer container, final ClientContext context) throws FetchException, MetadataParseException, ArchiveFailureException, ArchiveRestartException {
        if (logMINOR) {
            Logger.minor(this, "fetchArchive()");
        }
        Metadata newMeta = (Metadata)meta.clone();
        newMeta.setSimpleRedirect();
        final SingleFileFetcher f = new SingleFileFetcher(this, this.persistent, true, newMeta, new ArchiveFetcherCallback(forData, element, callback), new FetchContext(this.ctx, 4, true, null), container, context);
        if (this.persistent) {
            container.store((Object)f);
        }
        if (logMINOR) {
            Logger.minor(this, "fetchArchive(): " + f);
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        this.parent.onTransition(this, f, container);
        if (!this.persistent) {
            context.mainExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    f.innerWrapHandleMetadata(true, container, context);
                }
            });
        } else {
            f.innerWrapHandleMetadata(true, container, context);
            container.deactivate((Object)f, 1);
        }
    }

    protected void innerWrapHandleMetadata(boolean notFinalizedSize, ObjectContainer container, ClientContext context) {
        try {
            this.handleMetadata(container, context);
        }
        catch (MetadataParseException e) {
            this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
        }
        catch (FetchException e) {
            if (notFinalizedSize) {
                e.setNotFinalizedSize();
            }
            this.onFailure(e, false, container, context);
        }
        catch (ArchiveFailureException e) {
            this.onFailure(new FetchException(e), false, container, context);
        }
        catch (ArchiveRestartException e) {
            this.onFailure(new FetchException(e), false, container, context);
        }
    }

    public static ClientGetState create(ClientRequester requester, GetCompletionCallback cb, FreenetURI uri, FetchContext ctx, ArchiveContext actx, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, boolean isFinal, ObjectContainer container, ClientContext context, boolean realTimeFlag, boolean hasInitialMetadata) throws MalformedURLException, FetchException {
        BaseClientKey key = null;
        if (!hasInitialMetadata) {
            key = BaseClientKey.getBaseKey(uri);
        }
        if (!(uri.hasMetaStrings() || ctx.allowSplitfiles || ctx.followRedirects || !(key instanceof ClientKey) || hasInitialMetadata)) {
            return new SimpleSingleFileFetcher((ClientKey)key, maxRetries, ctx, requester, cb, isEssential, false, l, container, context, false, realTimeFlag);
        }
        if (key instanceof ClientKey || hasInitialMetadata) {
            return new SingleFileFetcher(requester, cb, null, (ClientKey)key, new ArrayList<String>(uri.listMetaStrings()), uri, 0, ctx, false, realTimeFlag, actx, null, null, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, isFinal, false, 0, container, context, hasInitialMetadata);
        }
        return SingleFileFetcher.uskCreate(requester, realTimeFlag, cb, (USK)key, new ArrayList<String>(uri.listMetaStrings()), ctx, actx, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, isFinal, container, context);
    }

    private static ClientGetState uskCreate(ClientRequester requester, boolean realTimeFlag, GetCompletionCallback cb, USK usk, ArrayList<String> metaStrings, FetchContext ctx, ArchiveContext actx, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, boolean isFinal, ObjectContainer container, ClientContext context) throws FetchException {
        if (usk.suggestedEdition >= 0L) {
            long edition = context.uskManager.lookupKnownGood(usk);
            if (edition <= usk.suggestedEdition) {
                context.uskManager.startTemporaryBackgroundFetcher(usk, context, ctx, true, realTimeFlag);
                edition = context.uskManager.lookupKnownGood(usk);
                if (edition > usk.suggestedEdition) {
                    if (logMINOR) {
                        Logger.minor(SingleFileFetcher.class, "Redirecting to edition " + edition);
                    }
                    cb.onFailure(new FetchException(27, usk.copy(edition).getURI().addMetaStrings(metaStrings)), null, container, context);
                    return null;
                }
                if (edition == -1L && context.uskManager.lookupLatestSlot(usk) == -1L) {
                    USKFetcherTag tag = context.uskManager.getFetcher(usk.copy(usk.suggestedEdition), ctx, false, requester.persistent(), realTimeFlag, new MyUSKFetcherCallback(requester, cb, usk, metaStrings, ctx, actx, realTimeFlag, maxRetries, recursionLevel, dontTellClientGet, l, requester.persistent(), true), false, container, context, true);
                    if (isEssential) {
                        requester.addMustSucceedBlocks(1, container);
                    }
                    return tag;
                }
                USKProxyCompletionCallback myCB = new USKProxyCompletionCallback(usk, cb, requester.persistent());
                SingleFileFetcher sf = new SingleFileFetcher(requester, myCB, null, usk.getSSK(), metaStrings, usk.getURI().addMetaStrings(metaStrings), 0, ctx, false, realTimeFlag, actx, null, null, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, isFinal, false, 0, container, context, false);
                return sf;
            }
            cb.onFailure(new FetchException(27, usk.copy(edition).getURI().addMetaStrings(metaStrings)), null, container, context);
            return null;
        }
        USKFetcherTag tag = context.uskManager.getFetcher(usk.copy(-usk.suggestedEdition), ctx, false, requester.persistent(), realTimeFlag, new MyUSKFetcherCallback(requester, cb, usk, metaStrings, ctx, actx, realTimeFlag, maxRetries, recursionLevel, dontTellClientGet, l, requester.persistent(), false), false, container, context, false);
        if (isEssential) {
            requester.addMustSucceedBlocks(1, container);
        }
        return tag;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "removeFrom() on " + this);
        }
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        if (this.thisKey != null) {
            container.activate((Object)this.thisKey, 5);
            this.thisKey.removeFrom(container);
        }
        if (this.ah != null) {
            this.ah.activateForExecution(container);
            this.ah.removeFrom(container);
        }
        container.activate(this.metaStrings, 1);
        this.metaStrings.clear();
        container.delete(this.metaStrings);
        container.activate((Object)this.clientMetadata, 1);
        this.clientMetadata.removeFrom(container);
        container.activate(this.decompressors, 1);
        this.decompressors.clear();
        this.removeMetadata(container);
        this.removeArchiveMetadata(container);
        container.delete(this.decompressors);
        super.removeFrom(container, context);
    }

    private void removeMetadata(ObjectContainer container) {
        if (!this.persistent) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "removeMetadata() on " + this);
        }
        if (this.metadata == null) {
            return;
        }
        container.activate((Object)this.metadata, 1);
        this.metadata.removeFrom(container);
        this.metadata = null;
    }

    private void removeArchiveMetadata(ObjectContainer container) {
        if (!this.persistent) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "removeArchiveMetadata() on " + this);
        }
        if (this.archiveMetadata == null) {
            return;
        }
        container.activate((Object)this.archiveMetadata, 1);
        this.archiveMetadata.removeFrom(container);
        this.archiveMetadata = null;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static class MyUSKFetcherCallback
    implements USKFetcherTagCallback {
        final ClientRequester parent;
        final GetCompletionCallback cb;
        final USK usk;
        final ArrayList<String> metaStrings;
        final FetchContext ctx;
        final ArchiveContext actx;
        final int maxRetries;
        final int recursionLevel;
        final boolean dontTellClientGet;
        final long token;
        final boolean persistent;
        final boolean realTimeFlag;
        final boolean datastoreOnly;
        final int hashCode;
        private USKFetcherTag tag;

        @Override
        public void setTag(USKFetcherTag tag, ObjectContainer container, ClientContext context) {
            this.tag = tag;
            if (this.persistent) {
                container.store((Object)this);
            }
        }

        public MyUSKFetcherCallback(ClientRequester requester, GetCompletionCallback cb, USK usk, ArrayList<String> metaStrings, FetchContext ctx, ArchiveContext actx, boolean realTimeFlag, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean persistent, boolean datastoreOnly) {
            this.parent = requester;
            this.cb = cb;
            this.usk = usk;
            this.metaStrings = metaStrings;
            this.ctx = ctx;
            this.actx = actx;
            this.maxRetries = maxRetries;
            this.recursionLevel = recursionLevel;
            this.dontTellClientGet = dontTellClientGet;
            this.token = l;
            this.persistent = persistent;
            this.datastoreOnly = datastoreOnly;
            this.hashCode = super.hashCode();
            this.realTimeFlag = realTimeFlag;
            if (logMINOR) {
                Logger.minor(this, "Created " + this + " for " + usk + " and " + cb + " datastore only = " + datastoreOnly);
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public void onFoundEdition(long l, USK newUSK, ObjectContainer container, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
            block12: {
                if (this.persistent) {
                    container.activate((Object)this, 2);
                }
                if (l < this.usk.suggestedEdition && this.datastoreOnly) {
                    l = this.usk.suggestedEdition;
                }
                ClientSSK key = this.usk.getSSK(l);
                try {
                    if (l == this.usk.suggestedEdition) {
                        SingleFileFetcher sf = new SingleFileFetcher(this.parent, this.cb, null, key, this.metaStrings, key.getURI().addMetaStrings(this.metaStrings), 0, this.ctx, false, this.realTimeFlag, this.actx, null, null, this.maxRetries, this.recursionLevel + 1, this.dontTellClientGet, this.token, false, true, false, 0, container, context, false);
                        if (this.tag != null) {
                            if (this.persistent) {
                                container.activate((Object)this.cb, 1);
                            }
                            this.cb.onTransition(this.tag, sf, container);
                        }
                        sf.schedule(container, context);
                        if (this.persistent) {
                            this.removeFrom(container);
                        }
                    } else {
                        if (this.persistent) {
                            container.activate((Object)this.cb, 1);
                        }
                        this.cb.onFailure(new FetchException(27, newUSK.getURI().addMetaStrings(this.metaStrings)), null, container, context);
                        if (this.persistent) {
                            this.removeFrom(container);
                        }
                    }
                }
                catch (FetchException e) {
                    if (this.persistent) {
                        container.activate((Object)this.cb, 1);
                    }
                    this.cb.onFailure(e, null, container, context);
                    if (!this.persistent) break block12;
                    this.removeFrom(container);
                }
            }
        }

        private void removeFrom(ObjectContainer container) {
            container.delete(this.metaStrings);
            container.delete((Object)this);
            container.activate((Object)this.usk, 5);
            this.usk.removeFrom(container);
        }

        @Override
        public void onFailure(ObjectContainer container, ClientContext context) {
            FetchException e = null;
            if (this.datastoreOnly) {
                if (this.persistent) {
                    container.activate((Object)this.usk, Integer.MAX_VALUE);
                }
                try {
                    this.onFoundEdition(this.usk.suggestedEdition, this.usk, container, context, false, (short)-1, null, false, false);
                    return;
                }
                catch (Throwable t) {
                    e = new FetchException(17, t);
                }
            }
            if (this.persistent) {
                container.activate((Object)this, 2);
            }
            if (e == null) {
                e = new FetchException(13, "No USK found");
            }
            if (logMINOR) {
                Logger.minor(this, "Failing USK with " + e, (Throwable)e);
            }
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
            }
            if (this.cb == null) {
                throw new NullPointerException("Callback is null in " + this + " for usk " + this.usk + " with datastoreOnly=" + this.datastoreOnly);
            }
            this.cb.onFailure(e, null, container, context);
            if (this.persistent) {
                this.removeFrom(container);
            }
        }

        @Override
        public void onCancelled(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)this, 2);
            }
            this.cb.onFailure(new FetchException(25, (String)null), null, container, context);
            if (this.persistent) {
                this.removeFrom(container);
            }
        }

        @Override
        public short getPollingPriorityNormal() {
            return this.parent.getPriorityClass();
        }

        @Override
        public short getPollingPriorityProgress() {
            return this.parent.getPriorityClass();
        }
    }

    class MultiLevelMetadataCallback
    implements GetCompletionCallback {
        private final boolean persistent;
        private final FetchContext ctx;

        MultiLevelMetadataCallback() {
            this.persistent = SingleFileFetcher.this.persistent;
            this.ctx = SingleFileFetcher.this.ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ObjectContainer container, ClientContext context) {
            Bucket finalData;
            PipedOutputStream pipeOut;
            PipedInputStream pipeIn;
            OutputStream output;
            block23: {
                output = null;
                pipeIn = new PipedInputStream();
                pipeOut = new PipedOutputStream();
                finalData = null;
                if (this.persistent) {
                    container.activate(decompressors, 5);
                    container.activate((Object)this.ctx, 2);
                }
                long maxLen = Math.min(this.ctx.maxTempLength, this.ctx.maxOutputLength);
                try {
                    finalData = context.getBucketFactory(this.persistent).makeBucket(maxLen);
                    output = finalData.getOutputStream();
                    if (decompressors != null) {
                        if (logMINOR) {
                            Logger.minor(this, "decompressing...");
                        }
                        pipeIn.connect(pipeOut);
                        DecompressorThreadManager decompressorManager = new DecompressorThreadManager(pipeIn, decompressors, maxLen);
                        pipeIn = decompressorManager.execute();
                        ClientGetWorkerThread worker = new ClientGetWorkerThread(pipeIn, output, null, null, null, false, null, null, null, context.linkFilterExceptionProvider);
                        worker.start();
                        streamGenerator.writeTo(pipeOut, container, context);
                        decompressorManager.waitFinished();
                        worker.waitFinished();
                        break block23;
                    }
                    streamGenerator.writeTo(output, container, context);
                }
                catch (Throwable t) {
                    try {
                        Logger.error(this, "Caught " + t, t);
                        this.onFailure(new FetchException(17, t), state, container, context);
                    }
                    catch (Throwable throwable) {
                        Closer.close(pipeOut);
                        Closer.close(pipeIn);
                        Closer.close(output);
                        throw throwable;
                    }
                    Closer.close(pipeOut);
                    Closer.close(pipeIn);
                    Closer.close(output);
                    return;
                }
            }
            Closer.close(pipeOut);
            Closer.close(pipeIn);
            Closer.close(output);
            boolean wasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                container.activate((Object)SingleFileFetcher.this, 1);
                container.activate((Object)SingleFileFetcher.this.parent, 1);
            }
            try {
                SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, container);
                Metadata meta = Metadata.construct(finalData);
                SingleFileFetcher.this.removeMetadata(container);
                SingleFileFetcher singleFileFetcher = SingleFileFetcher.this;
                synchronized (singleFileFetcher) {
                    SingleFileFetcher.this.metadata = meta;
                }
                if (this.persistent) {
                    container.store((Object)meta);
                    container.store((Object)SingleFileFetcher.this);
                }
                SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
            }
            catch (MetadataParseException e) {
                SingleFileFetcher.this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
                return;
            }
            catch (IOException e) {
                SingleFileFetcher.this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
                return;
            }
            finally {
                finalData.free();
                if (this.persistent) {
                    finalData.removeFrom(container);
                }
            }
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
            }
        }

        @Override
        public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                container.activate((Object)SingleFileFetcher.this, 1);
                container.activate((Object)SingleFileFetcher.this.parent, 1);
            }
            SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, container);
            SingleFileFetcher.this.onFailure(e, true, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
            }
        }

        @Override
        public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        }

        @Override
        public void onExpectedMIME(ClientMetadata mime, ObjectContainer container, ClientContext context) {
        }

        @Override
        public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            boolean cbWasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                container.activate((Object)SingleFileFetcher.this, 1);
                cbWasActive = container.ext().isActive((Object)SingleFileFetcher.this.rcb);
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            SingleFileFetcher.this.rcb.onExpectedSize(size, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (!cbWasActive) {
                container.deactivate((Object)SingleFileFetcher.this.rcb, 1);
            }
        }

        @Override
        public void onFinalizedMetadata(ObjectContainer container) {
        }

        @Override
        public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ObjectContainer container, ClientContext context) {
        }

        @Override
        public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean dontCompress, boolean bottomLayer, boolean definitiveAnyway, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            boolean cbWasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                container.activate((Object)SingleFileFetcher.this, 1);
                cbWasActive = container.ext().isActive((Object)SingleFileFetcher.this.rcb);
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            SingleFileFetcher.this.rcb.onSplitfileCompatibilityMode(min, max, splitfileKey, dontCompress, false, definitiveAnyway, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (!cbWasActive) {
                container.deactivate((Object)SingleFileFetcher.this.rcb, 1);
            }
        }

        @Override
        public void onHashes(HashResult[] hashes, ObjectContainer container, ClientContext context) {
        }
    }

    class ArchiveFetcherCallback
    implements GetCompletionCallback {
        private final boolean wasFetchingFinalData;
        private final String element;
        private final ArchiveExtractCallback callback;
        private final boolean persistent;
        private HashResult[] hashes;
        private final FetchContext ctx;

        ArchiveFetcherCallback(boolean wasFetchingFinalData, String element, ArchiveExtractCallback cb) {
            this.wasFetchingFinalData = wasFetchingFinalData;
            this.element = element;
            this.callback = cb;
            this.persistent = SingleFileFetcher.this.persistent;
            this.ctx = SingleFileFetcher.this.ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ObjectContainer container, ClientContext context) {
            OutputStream output = null;
            PipedInputStream pipeIn = new PipedInputStream();
            PipedOutputStream pipeOut = new PipedOutputStream();
            Bucket data = null;
            if (this.persistent) {
                container.activate(decompressors, 5);
                container.activate((Object)this.ctx, 2);
            }
            long maxLen = Math.min(this.ctx.maxTempLength, this.ctx.maxOutputLength);
            try {
                data = context.getBucketFactory(this.persistent).makeBucket(maxLen);
                output = data.getOutputStream();
                if (decompressors != null) {
                    if (logMINOR) {
                        Logger.minor(this, "decompressing...");
                    }
                    pipeOut.connect(pipeIn);
                    DecompressorThreadManager decompressorManager = new DecompressorThreadManager(pipeIn, decompressors, maxLen);
                    pipeIn = decompressorManager.execute();
                    ClientGetWorkerThread worker = new ClientGetWorkerThread(pipeIn, output, null, null, null, false, null, null, null, context.linkFilterExceptionProvider);
                    worker.start();
                    streamGenerator.writeTo(pipeOut, container, context);
                    decompressorManager.waitFinished();
                    worker.waitFinished();
                } else {
                    streamGenerator.writeTo(output, container, context);
                }
                output.close();
                output = null;
                pipeOut.close();
                pipeOut = null;
                pipeIn.close();
                pipeIn = null;
            }
            catch (Throwable t) {
                try {
                    Logger.error(this, "Caught " + t, t);
                    this.onFailure(new FetchException(17, t), state, container, context);
                }
                catch (Throwable throwable) {
                    Closer.close(pipeOut);
                    Closer.close(pipeIn);
                    Closer.close(output);
                    throw throwable;
                }
                Closer.close(pipeOut);
                Closer.close(pipeIn);
                Closer.close(output);
                return;
            }
            Closer.close(pipeOut);
            Closer.close(pipeIn);
            Closer.close(output);
            if (SingleFileFetcher.this.key instanceof ClientSSK) {
                context.uskManager.checkUSK(SingleFileFetcher.this.uri, this.persistent, container, false);
            }
            if (!this.persistent) {
                SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, container);
                this.innerSuccess(data, container, context);
            } else {
                boolean wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                if (!wasActive) {
                    container.activate((Object)SingleFileFetcher.this, 1);
                }
                container.activate((Object)SingleFileFetcher.this.parent, 1);
                SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, container);
                if (this.persistent) {
                    container.activate((Object)SingleFileFetcher.this.actx, 1);
                }
                SingleFileFetcher.this.ah.activateForExecution(container);
                SingleFileFetcher.this.ah.extractPersistentOffThread(data, true, SingleFileFetcher.this.actx, this.element, this.callback, container, context);
                if (!wasActive) {
                    container.deactivate((Object)SingleFileFetcher.this, 1);
                }
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
                if (this.hashes != null) {
                    for (HashResult res : this.hashes) {
                        container.activate((Object)res, Integer.MAX_VALUE);
                        res.removeFrom(container);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void innerSuccess(Bucket data, ObjectContainer container, ClientContext context) {
            try {
                if (this.hashes != null) {
                    InputStream is;
                    block18: {
                        is = null;
                        try {
                            if (SingleFileFetcher.this.persistent()) {
                                container.activate((Object)this.hashes, Integer.MAX_VALUE);
                            }
                            is = data.getInputStream();
                            MultiHashInputStream hasher = new MultiHashInputStream(is, HashResult.makeBitmask(this.hashes));
                            byte[] buf = new byte[32768];
                            while (hasher.read(buf) > 0) {
                            }
                            hasher.close();
                            is = null;
                            HashResult[] results = hasher.getResults();
                            if (HashResult.strictEquals(results, this.hashes)) break block18;
                            this.onFailure(new FetchException(34), SingleFileFetcher.this, container, context);
                        }
                        catch (IOException e) {
                            try {
                                this.onFailure(new FetchException(12, (Throwable)e), SingleFileFetcher.this, container, context);
                            }
                            catch (Throwable throwable) {
                                Closer.close(is);
                                throw throwable;
                            }
                            Closer.close(is);
                            return;
                        }
                        Closer.close(is);
                        return;
                    }
                    Closer.close(is);
                }
                SingleFileFetcher.this.ah.extractToCache(data, SingleFileFetcher.this.actx, this.element, this.callback, context.archiveManager, container, context);
            }
            catch (ArchiveFailureException e) {
                SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                return;
            }
            catch (ArchiveRestartException e) {
                SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                return;
            }
            finally {
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
            }
            if (this.callback != null) {
                return;
            }
            SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
        }

        @Override
        public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent && !(wasActive = container.ext().isActive((Object)SingleFileFetcher.this))) {
                container.activate((Object)SingleFileFetcher.this, 1);
            }
            SingleFileFetcher.this.onFailure(e, true, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
                this.callback.removeFrom(container);
                if (this.hashes != null) {
                    for (HashResult res : this.hashes) {
                        container.activate((Object)res, Integer.MAX_VALUE);
                        res.removeFrom(container);
                    }
                }
            }
        }

        @Override
        public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent && !(wasActive = container.ext().isActive((Object)SingleFileFetcher.this))) {
                container.activate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            if (this.wasFetchingFinalData) {
                SingleFileFetcher.this.rcb.onBlockSetFinished(SingleFileFetcher.this, container, context);
            }
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        }

        @Override
        public void onExpectedMIME(ClientMetadata metadata, ObjectContainer container, ClientContext context) {
        }

        @Override
        public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent && !(wasActive = container.ext().isActive((Object)SingleFileFetcher.this))) {
                container.activate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            SingleFileFetcher.this.rcb.onExpectedSize(size, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
        }

        @Override
        public void onFinalizedMetadata(ObjectContainer container) {
        }

        @Override
        public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ObjectContainer container, ClientContext context) {
        }

        @Override
        public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean dontCompress, boolean bottomLayer, boolean definitiveAnyway, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            boolean cbWasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                container.activate((Object)SingleFileFetcher.this, 1);
                cbWasActive = container.ext().isActive((Object)SingleFileFetcher.this.rcb);
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            SingleFileFetcher.this.rcb.onSplitfileCompatibilityMode(min, max, splitfileKey, dontCompress, false, false, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (!cbWasActive) {
                container.deactivate((Object)SingleFileFetcher.this.rcb, 1);
            }
        }

        @Override
        public void onHashes(HashResult[] hashes, ObjectContainer container, ClientContext context) {
            this.hashes = hashes;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
    }
}

