/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.CompressionOutput;
import freenet.client.async.InsertCompressor;
import freenet.client.async.MultiPutCompletionCallback;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleBlockInserter;
import freenet.client.async.SplitFileInserter;
import freenet.client.async.USKInserter;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.FinishedCompressionEvent;
import freenet.client.events.StartedCompressionEvent;
import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import freenet.crypt.MultiHashOutputStream;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import freenet.support.io.NotPersistentBucket;
import freenet.support.io.NullOutputStream;
import freenet.support.io.SegmentedBucketChainBucket;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;

class SingleFileInserter
implements ClientPutState {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final BaseClientPutter parent;
    InsertBlock block;
    final InsertContext ctx;
    final boolean metadata;
    final PutCompletionCallback cb;
    final boolean getCHKOnly;
    final ArchiveManager.ARCHIVE_TYPE archiveType;
    private final boolean reportMetadataOnly;
    public final Object token;
    private final boolean freeData;
    private final String targetFilename;
    private final boolean earlyEncode;
    private final boolean persistent;
    private boolean started;
    private boolean cancelled;
    private final boolean forSplitfile;
    private final long origDataLength;
    private final long origCompressedDataLength;
    private HashResult[] origHashes;
    private final byte[] forceCryptoKey;
    private final byte cryptoAlgorithm;
    private final boolean realTimeFlag;
    private final long metadataThreshold;
    private final int hashCode = super.hashCode();

    public int hashCode() {
        return this.hashCode;
    }

    SingleFileInserter(BaseClientPutter parent, PutCompletionCallback cb, InsertBlock block, boolean metadata, InsertContext ctx, boolean realTimeFlag, boolean dontCompress, boolean getCHKOnly, boolean reportMetadataOnly, Object token, ArchiveManager.ARCHIVE_TYPE archiveType, boolean freeData, String targetFilename, boolean earlyEncode, boolean forSplitfile, boolean persistent, long origDataLength, long origCompressedDataLength, HashResult[] origHashes, byte cryptoAlgorithm, byte[] forceCryptoKey, long metadataThreshold) {
        this.earlyEncode = earlyEncode;
        this.reportMetadataOnly = reportMetadataOnly;
        this.token = token;
        this.parent = parent;
        this.block = block;
        this.ctx = ctx;
        this.realTimeFlag = realTimeFlag;
        this.metadata = metadata;
        this.cb = cb;
        this.getCHKOnly = getCHKOnly;
        this.archiveType = archiveType;
        this.freeData = freeData;
        this.targetFilename = targetFilename;
        this.persistent = persistent;
        this.forSplitfile = forSplitfile;
        this.origCompressedDataLength = origCompressedDataLength;
        this.origDataLength = origDataLength;
        this.origHashes = origHashes;
        this.forceCryptoKey = forceCryptoKey;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.metadataThreshold = metadataThreshold;
        if (logMINOR) {
            Logger.minor(this, "Created " + this + " persistent=" + persistent + " freeData=" + freeData);
        }
    }

    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        if (this.persistent) {
            container.activate((Object)this.block, 1);
        }
        this.tryCompress(container, context);
    }

    void onCompressed(CompressionOutput output, ObjectContainer container, ClientContext context) {
        boolean cbActive = true;
        if (this.persistent && !(cbActive = container.ext().isActive((Object)this.cb))) {
            container.activate((Object)this.cb, 1);
        }
        if (this.started) {
            Logger.error(this, "Already started, not starting again", (Throwable)new Exception("error"));
            return;
        }
        if (this.cancelled) {
            Logger.error(this, "Already cancelled, not starting");
            return;
        }
        if (this.persistent) {
            container.activate((Object)this.block, 1);
        }
        try {
            this.onCompressedInner(output, container, context);
        }
        catch (InsertException e) {
            this.cb.onFailure(e, this, container, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught in OffThreadCompressor: " + t, t);
            System.err.println("Caught in OffThreadCompressor: " + t);
            t.printStackTrace();
            this.cb.onFailure(new InsertException(3, t, null), this, container, context);
        }
        if (!cbActive) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCompressedInner(CompressionOutput output, ObjectContainer container, ClientContext context) throws InsertException {
        boolean noMetadata;
        boolean fitsInOneCHK;
        boolean fitsInOneBlockAsIs;
        int oneBlockCompressedSize;
        int blockSize;
        HashResult[] hashes = output.hashes;
        boolean parentWasActive = true;
        if (container != null) {
            container.activate((Object)this.block, 2);
            parentWasActive = container.ext().isActive((Object)this.parent);
            if (!parentWasActive) {
                container.activate((Object)this.parent, 1);
            }
        }
        long origSize = this.block.getData().size();
        byte[] hashThisLayerOnly = null;
        if (hashes != null && this.metadata) {
            hashThisLayerOnly = HashResult.get(hashes, HashType.SHA256);
            hashes = null;
        }
        if (hashes != null) {
            if (logDEBUG) {
                Logger.debug(this, "Computed hashes for " + this + " for " + this.block.desiredURI + " size " + origSize);
                for (HashResult res : hashes) {
                    Logger.debug(this, res.type.name() + " : " + res.hashAsHex());
                }
            }
            if (this.persistent) {
                container.activate((Object)this.ctx, 1);
                container.activate((Object)this.ctx.eventProducer, 1);
            }
            HashResult[] clientHashes = hashes;
            if (this.persistent) {
                clientHashes = HashResult.copy(hashes);
            }
            this.ctx.eventProducer.produceEvent(new ExpectedHashesEvent(clientHashes), container, context);
            this.origHashes = hashes;
            if (this.persistent) {
                container.store((Object)this);
            }
        } else {
            hashes = this.origHashes;
            if (this.persistent) {
                container.activate((Object)hashes, Integer.MAX_VALUE);
            }
        }
        Bucket bestCompressedData = output.data;
        long bestCompressedDataSize = bestCompressedData.size();
        Bucket data = bestCompressedData;
        Compressor.COMPRESSOR_TYPE bestCodec = output.bestCodec;
        boolean shouldFreeData = this.freeData;
        if (bestCodec != null) {
            if (logMINOR) {
                Logger.minor(this, "The best compression algorithm is " + bestCodec + " we have gained" + (100L - bestCompressedDataSize * 100L / origSize) + "% ! (" + origSize + '/' + bestCompressedDataSize + ')');
            }
            shouldFreeData = true;
            if (this.freeData) {
                this.block.getData().free();
                if (this.persistent) {
                    this.block.getData().removeFrom(container);
                }
            }
            this.block.nullData();
            if (this.persistent) {
                container.store((Object)this.block);
            }
        } else {
            data = this.block.getData();
            bestCompressedDataSize = origSize;
        }
        boolean isCHK = false;
        if (this.persistent) {
            container.activate((Object)this.block.desiredURI, 5);
        }
        String type = this.block.desiredURI.getKeyType();
        boolean isUSK = false;
        if (type.equals("SSK") || type.equals("KSK") || (isUSK = type.equals("USK"))) {
            blockSize = 1024;
            oneBlockCompressedSize = 1022;
        } else if (type.equals("CHK")) {
            blockSize = 32768;
            oneBlockCompressedSize = 32764;
            isCHK = true;
        } else {
            throw new InsertException(1, "Unknown key type: " + type, null);
        }
        if (this.parent == this.cb) {
            if (this.persistent) {
                container.activate((Object)this.ctx, 1);
                container.activate((Object)this.ctx.eventProducer, 1);
            }
            int codecID = bestCodec == null ? -1 : (int)bestCodec.metadataID;
            this.ctx.eventProducer.produceEvent(new FinishedCompressionEvent(codecID, origSize, bestCompressedDataSize), container, context);
            if (logMINOR) {
                Logger.minor(this, "Compressed " + origSize + " to " + data.size() + " on " + this + " data = " + data);
            }
        }
        short codecNumber = bestCodec == null ? (short)-1 : (short)bestCodec.metadataID;
        long compressedDataSize = data.size();
        boolean bl = bestCodec == null ? compressedDataSize <= (long)blockSize : (fitsInOneBlockAsIs = compressedDataSize <= (long)oneBlockCompressedSize);
        boolean bl2 = bestCodec == null ? compressedDataSize <= 32768L : (fitsInOneCHK = compressedDataSize <= 32764L);
        if ((fitsInOneBlockAsIs || fitsInOneCHK) && origSize > Integer.MAX_VALUE) {
            throw new InsertException(3, "2GB+ should not encode to one block!", null);
        }
        boolean bl3 = noMetadata = (this.block.clientMetadata == null || this.block.clientMetadata.isTrivial()) && this.targetFilename == null;
        if ((noMetadata || this.metadata) && this.archiveType == null && fitsInOneBlockAsIs) {
            if (this.persistent && data instanceof NotPersistentBucket) {
                data = this.fixNotPersistent(data, context);
            }
            ClientPutState bi = this.createInserter(this.parent, data, codecNumber, this.ctx, this.cb, this.metadata, (int)origSize, -1, this.getCHKOnly, true, container, context, shouldFreeData, this.forSplitfile);
            if (logMINOR) {
                Logger.minor(this, "Inserting without metadata: " + bi + " for " + this);
            }
            this.cb.onTransition(this, bi, container);
            if (this.earlyEncode && bi instanceof SingleBlockInserter && isCHK) {
                ((SingleBlockInserter)bi).getBlock(container, context, true);
            }
            bi.schedule(container, context);
            if (!isUSK) {
                this.cb.onBlockSetFinished(this, container, context);
            }
            this.started = true;
            if (this.persistent) {
                if (!parentWasActive) {
                    container.deactivate((Object)this.parent, 1);
                }
                this.block.nullData();
                this.block.removeFrom(container);
                this.block = null;
                this.removeFrom(container, context);
            }
            return;
        }
        if (fitsInOneCHK) {
            Bucket metadataBucket;
            if (this.persistent && data instanceof NotPersistentBucket) {
                data = this.fixNotPersistent(data, context);
            }
            if (this.reportMetadataOnly) {
                if (this.persistent) {
                    container.activate((Object)this.ctx, 1);
                }
                SingleBlockInserter dataPutter = new SingleBlockInserter(this.parent, data, codecNumber, this.persistent ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI, this.ctx, this.realTimeFlag, this.cb, this.metadata, (int)origSize, -1, this.getCHKOnly, true, true, this.token, container, context, this.persistent, shouldFreeData, this.forSplitfile ? this.ctx.extraInsertsSplitfileHeaderBlock : this.ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
                if (logMINOR) {
                    Logger.minor(this, "Inserting with metadata: " + dataPutter + " for " + this);
                }
                Metadata meta = this.makeMetadata(this.archiveType, dataPutter.getURI(container, context), hashes, container);
                this.cb.onMetadata(meta, (ClientPutState)this, container, context);
                this.cb.onTransition(this, dataPutter, container);
                dataPutter.schedule(container, context);
                if (!isUSK) {
                    this.cb.onBlockSetFinished(this, container, context);
                }
                SingleFileInserter singleFileInserter = this;
                synchronized (singleFileInserter) {
                    this.origHashes = null;
                }
            }
            MultiPutCompletionCallback mcb = new MultiPutCompletionCallback(this.cb, this.parent, this.token, this.persistent, false, this.earlyEncode);
            if (this.persistent) {
                container.activate((Object)this.ctx, 1);
            }
            SingleBlockInserter dataPutter = new SingleBlockInserter(this.parent, data, codecNumber, this.persistent ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI, this.ctx, this.realTimeFlag, mcb, this.metadata, (int)origSize, -1, this.getCHKOnly, true, false, this.token, container, context, this.persistent, shouldFreeData, this.forSplitfile ? this.ctx.extraInsertsSplitfileHeaderBlock : this.ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
            if (logMINOR) {
                Logger.minor(this, "Inserting data: " + dataPutter + " for " + this);
            }
            Metadata meta = this.makeMetadata(this.archiveType, dataPutter.getURI(container, context), hashes, container);
            try {
                metadataBucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent), meta.writeToByteArray());
            }
            catch (IOException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                throw new InsertException(2, e, null);
            }
            catch (MetadataUnresolvedException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                throw new InsertException(3, "Got MetadataUnresolvedException in SingleFileInserter: " + e.toString(), null);
            }
            ClientPutState metaPutter = this.createInserter(this.parent, metadataBucket, (short)-1, this.ctx, mcb, true, (int)origSize, -1, this.getCHKOnly, true, container, context, true, false);
            if (logMINOR) {
                Logger.minor(this, "Inserting metadata: " + metaPutter + " for " + this);
            }
            mcb.addURIGenerator(metaPutter, container);
            mcb.add(dataPutter, container);
            this.cb.onTransition(this, mcb, container);
            Logger.minor(this, "" + mcb + " : data " + dataPutter + " meta " + metaPutter);
            mcb.arm(container, context);
            dataPutter.schedule(container, context);
            if (this.earlyEncode && metaPutter instanceof SingleBlockInserter) {
                ((SingleBlockInserter)metaPutter).getBlock(container, context, true);
            }
            metaPutter.schedule(container, context);
            if (!isUSK) {
                this.cb.onBlockSetFinished(this, container, context);
            }
            this.started = true;
            if (this.persistent) {
                if (!parentWasActive) {
                    container.deactivate((Object)this.parent, 1);
                }
                this.block.nullData();
                this.block.removeFrom(container);
                this.block = null;
                this.removeFrom(container, context);
            }
            return;
        }
        if (this.reportMetadataOnly) {
            SplitFileInserter sfi = new SplitFileInserter(this.parent, this.cb, data, bestCodec, origSize, this.block.clientMetadata, this.ctx, this.getCHKOnly, this.metadata, this.token, this.archiveType, shouldFreeData, this.persistent, this.realTimeFlag, container, context, hashes, hashThisLayerOnly, this.origDataLength, this.origCompressedDataLength, this.cryptoAlgorithm, this.forceCryptoKey);
            if (logMINOR) {
                Logger.minor(this, "Inserting as splitfile: " + sfi + " for " + this);
            }
            this.cb.onTransition(this, sfi, container);
            sfi.start(container, context);
            if (this.earlyEncode) {
                sfi.forceEncode(container, context);
            }
            if (this.persistent) {
                container.store((Object)sfi);
                container.deactivate((Object)sfi, 1);
            }
            this.block.nullData();
            this.block.nullMetadata();
            SingleFileInserter dataPutter = this;
            synchronized (dataPutter) {
                this.origHashes = null;
            }
            if (this.persistent) {
                this.removeFrom(container, context);
            }
        } else {
            InsertContext.CompatibilityMode cmode;
            boolean allowSizes;
            if (this.persistent) {
                container.activate((Object)this.ctx, 1);
            }
            boolean bl4 = allowSizes = (cmode = this.ctx.getCompatibilityMode()) == InsertContext.CompatibilityMode.COMPAT_CURRENT || cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal();
            if (this.metadata) {
                allowSizes = false;
            }
            SplitHandler sh = new SplitHandler(origSize, compressedDataSize, allowSizes);
            SplitFileInserter sfi = new SplitFileInserter(this.parent, sh, data, bestCodec, origSize, this.block.clientMetadata, this.ctx, this.getCHKOnly, this.metadata, this.token, this.archiveType, shouldFreeData, this.persistent, this.realTimeFlag, container, context, HashResult.copy(hashes), hashThisLayerOnly, this.origDataLength, this.origCompressedDataLength, this.cryptoAlgorithm, this.forceCryptoKey);
            sh.sfi = sfi;
            if (logMINOR) {
                Logger.minor(this, "Inserting as splitfile: " + sfi + " for " + sh + " for " + this);
            }
            if (this.persistent) {
                container.store((Object)sh);
            }
            this.cb.onTransition(this, sh, container);
            sfi.start(container, context);
            if (this.earlyEncode) {
                sfi.forceEncode(container, context);
            }
            if (this.persistent) {
                container.store((Object)sfi);
                container.deactivate((Object)sfi, 1);
            }
            this.started = true;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        if (this.persistent && !parentWasActive) {
            container.deactivate((Object)this.parent, 1);
        }
    }

    private Bucket fixNotPersistent(Bucket data, ClientContext context) throws InsertException {
        SegmentedBucketChainBucket seg;
        Bucket[] buckets;
        boolean skip = false;
        if (data instanceof SegmentedBucketChainBucket && (buckets = (seg = (SegmentedBucketChainBucket)data).getBuckets()).length == 1) {
            seg.clear();
            data = buckets[0];
            skip = true;
            if (logMINOR) {
                Logger.minor(this, "Using bucket 0 of SegmentedBucketChainBucket");
            }
        }
        try {
            if (!skip) {
                if (logMINOR) {
                    Logger.minor(this, "Copying data from " + data + " length " + data.size());
                }
                Bucket newData = context.persistentBucketFactory.makeBucket(data.size());
                BucketTools.copy(data, newData);
                data.free();
                data = newData;
            }
        }
        catch (IOException e) {
            Logger.error(this, "Caught " + e + " while copying non-persistent data", (Throwable)e);
            throw new InsertException(2, e, null);
        }
        return data;
    }

    private void tryCompress(ObjectContainer container, ClientContext context) throws InsertException {
        boolean tryCompress;
        boolean atLeast1254;
        int oneBlockCompressedSize;
        int blockSize;
        String type;
        Bucket origData;
        Bucket data = origData = this.block.getData();
        boolean dontCompress = this.ctx.dontCompress;
        if (this.persistent) {
            container.activate((Object)data, 1);
        }
        long origSize = data.size();
        if (this.persistent) {
            container.activate((Object)this.block.desiredURI, 5);
        }
        if ((type = this.block.desiredURI.getKeyType().toUpperCase()).equals("SSK") || type.equals("KSK") || type.equals("USK")) {
            blockSize = 1024;
            oneBlockCompressedSize = 1022;
        } else if (type.equals("CHK")) {
            blockSize = 32768;
            oneBlockCompressedSize = 32764;
        } else {
            throw new InsertException(1, "Unknown key type: " + type, null);
        }
        long wantHashes = 0L;
        InsertContext.CompatibilityMode cmode = this.ctx.getCompatibilityMode();
        boolean bl = atLeast1254 = cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal();
        if (atLeast1254) {
            wantHashes |= (long)HashType.SHA256.bitmask;
            if (data.size() >= 0x100000L && !this.metadata) {
                wantHashes |= (long)HashType.SHA1.bitmask;
                wantHashes |= (long)HashType.MD5.bitmask;
            }
            if (data.size() >= 0x400000L && !this.metadata) {
                wantHashes |= (long)HashType.ED2K.bitmask;
                wantHashes |= (long)HashType.TTH.bitmask;
                wantHashes |= (long)HashType.SHA512.bitmask;
            }
        }
        boolean bl2 = tryCompress = origSize > (long)blockSize && !this.ctx.dontCompress && !dontCompress;
        if (tryCompress) {
            InsertCompressor.start(container, context, this, origData, oneBlockCompressedSize, context.getBucketFactory(this.persistent), this.persistent, wantHashes, !atLeast1254);
        } else {
            if (logMINOR) {
                Logger.minor(this, "Not compressing " + origData + " size = " + origSize + " block size = " + blockSize);
            }
            HashResult[] hashes = null;
            if (wantHashes != 0L) {
                NullOutputStream nos = new NullOutputStream();
                MultiHashOutputStream hasher = new MultiHashOutputStream(nos, wantHashes);
                try {
                    BucketTools.copyTo(data, hasher, data.size());
                }
                catch (IOException e) {
                    throw new InsertException(2, "I/O error generating hashes", e, null);
                }
                hashes = hasher.getResults();
            }
            CompressionOutput output = new CompressionOutput(data, null, hashes);
            this.onCompressed(output, container, context);
        }
    }

    private Metadata makeMetadata(ArchiveManager.ARCHIVE_TYPE archiveType, FreenetURI uri, HashResult[] hashes, ObjectContainer container) {
        Metadata meta = null;
        boolean allowTopBlocks = this.origDataLength != 0L;
        int req = 0;
        int total = 0;
        long data = 0L;
        long compressed = 0L;
        boolean topDontCompress = false;
        short topCompatibilityMode = 0;
        if (allowTopBlocks) {
            boolean wasActive = true;
            boolean ctxWasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)this.parent);
                if (!wasActive) {
                    container.activate((Object)this.parent, 1);
                }
                if (!(ctxWasActive = container.ext().isActive((Object)this.ctx))) {
                    container.activate((Object)this.ctx, 1);
                }
            }
            req = this.parent.getMinSuccessFetchBlocks();
            total = this.parent.totalBlocks;
            if (!wasActive) {
                container.deactivate((Object)this.parent, 1);
            }
            topDontCompress = this.ctx.dontCompress;
            topCompatibilityMode = (short)this.ctx.getCompatibilityCode();
            if (!ctxWasActive) {
                container.deactivate((Object)this.ctx, 1);
            }
            data = this.origDataLength;
            compressed = this.origCompressedDataLength;
        }
        meta = archiveType != null ? new Metadata(3, archiveType, null, uri, this.block.clientMetadata, data, compressed, req, total, topDontCompress, topCompatibilityMode, hashes) : new Metadata(0, archiveType, null, uri, this.block.clientMetadata, data, compressed, req, total, topDontCompress, topCompatibilityMode, hashes);
        if (this.targetFilename != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put(this.targetFilename, meta);
            meta = Metadata.mkRedirectionManifestWithMetadata(hm);
        }
        return meta;
    }

    private ClientPutState createInserter(BaseClientPutter parent, Bucket data, short compressionCodec, InsertContext ctx, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean getCHKOnly, boolean addToParent, ObjectContainer container, ClientContext context, boolean freeData, boolean forSplitfile) throws InsertException {
        FreenetURI uri = this.block.desiredURI;
        uri.checkInsertURI();
        if (this.persistent) {
            container.activate((Object)ctx, 1);
        }
        if (uri.getKeyType().equals("USK")) {
            try {
                return new USKInserter(parent, data, compressionCodec, uri, ctx, cb, isMetadata, sourceLength, token, getCHKOnly, addToParent, this.token, container, context, freeData, this.persistent, this.realTimeFlag, forSplitfile ? ctx.extraInsertsSplitfileHeaderBlock : ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
            }
            catch (MalformedURLException e) {
                throw new InsertException(1, e, null);
            }
        }
        SingleBlockInserter sbi = new SingleBlockInserter(parent, data, compressionCodec, uri, ctx, this.realTimeFlag, cb, isMetadata, sourceLength, token, getCHKOnly, addToParent, false, this.token, container, context, this.persistent, freeData, forSplitfile ? ctx.extraInsertsSplitfileHeaderBlock : ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
        this.block.nullURI();
        if (this.persistent) {
            container.store((Object)this.block);
        }
        return sbi;
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancel " + this);
        }
        SingleFileInserter singleFileInserter = this;
        synchronized (singleFileInserter) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
        }
        if (this.freeData) {
            if (this.persistent) {
                container.activate((Object)this.block, 1);
            }
            this.block.free(container);
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(new InsertException(10), this, container, context);
    }

    @Override
    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        this.start(container, context);
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    public void onStartCompression(Compressor.COMPRESSOR_TYPE ctype, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 2);
        }
        if (this.parent == this.cb) {
            if (this.ctx == null) {
                throw new NullPointerException();
            }
            if (this.ctx.eventProducer == null) {
                throw new NullPointerException();
            }
            this.ctx.eventProducer.produceEvent(new StartedCompressionEvent(ctype), container, context);
        }
    }

    boolean cancelled() {
        return this.cancelled;
    }

    boolean started() {
        return this.started;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "removeFrom() on " + this, (Throwable)new Exception("debug"));
        }
        if (this.block != null) {
            container.activate((Object)this.block, 1);
            this.block.removeFrom(container);
        }
        if (this.origHashes != null) {
            for (HashResult h : this.origHashes) {
                container.activate((Object)h, Integer.MAX_VALUE);
                h.removeFrom(container);
            }
        }
        container.delete((Object)this);
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "objectCanUpdate() on " + this, (Throwable)new Exception("debug"));
        }
        return true;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "objectCanNew() on " + this, (Throwable)new Exception("debug"));
        }
        return true;
    }

    static /* synthetic */ HashResult[] access$902(SingleFileInserter x0, HashResult[] x1) {
        x0.origHashes = x1;
        return x1;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public class SplitHandler
    implements PutCompletionCallback,
    ClientPutState {
        ClientPutState sfi;
        ClientPutState metadataPutter;
        boolean finished;
        boolean splitInsertSuccess;
        boolean metaInsertSuccess;
        boolean splitInsertSetBlocks;
        boolean metaInsertSetBlocks;
        boolean metaInsertStarted;
        boolean metaFetchable;
        final boolean persistent;
        final long origDataLength;
        final long origCompressedDataLength;
        private final int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        private SplitHandler() {
            this.persistent = false;
            this.origDataLength = 0L;
            this.origCompressedDataLength = 0L;
            this.hashCode = 0;
        }

        public SplitHandler(long origDataLength, long origCompressedDataLength, boolean allowSizes) {
            this.persistent = SingleFileInserter.this.persistent;
            this.hashCode = super.hashCode();
            this.origDataLength = allowSizes ? origDataLength : 0L;
            this.origCompressedDataLength = allowSizes ? origCompressedDataLength : 0L;
        }

        @Override
        public synchronized void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
            if (this.persistent && logMINOR) {
                Logger.minor(this, "Transition: " + oldState + " -> " + newState);
            }
            if (oldState == this.sfi) {
                this.sfi = newState;
            }
            if (oldState == this.metadataPutter) {
                this.metadataPutter = newState;
            }
            if (this.persistent) {
                container.store((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this.block, 2);
            }
            if (logMINOR) {
                Logger.minor(this, "onSuccess(" + state + ") for " + this);
            }
            boolean lateStart = false;
            ClientPutState toRemove = null;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                if (state == this.sfi) {
                    if (logMINOR) {
                        Logger.minor(this, "Splitfile insert succeeded for " + this + " : " + state);
                    }
                    this.splitInsertSuccess = true;
                    if (!this.metaInsertSuccess && !this.metaInsertStarted) {
                        lateStart = true;
                    } else {
                        this.sfi = null;
                        if (logMINOR) {
                            Logger.minor(this, "Metadata already started for " + this + " : success=" + this.metaInsertSuccess + " started=" + this.metaInsertStarted);
                        }
                    }
                    toRemove = state;
                } else if (state == this.metadataPutter) {
                    if (logMINOR) {
                        Logger.minor(this, "Metadata insert succeeded for " + this + " : " + state);
                    }
                    this.metaInsertSuccess = true;
                    this.metadataPutter = null;
                    toRemove = state;
                } else {
                    Logger.error(this, "Unknown: " + state + " for " + this, (Throwable)new Exception("debug"));
                }
                if (this.splitInsertSuccess && this.metaInsertSuccess) {
                    if (logMINOR) {
                        Logger.minor(this, "Both succeeded for " + this);
                    }
                    this.finished = true;
                    if (SingleFileInserter.this.freeData) {
                        SingleFileInserter.this.block.free(container);
                    } else {
                        SingleFileInserter.this.block.nullData();
                        if (this.persistent) {
                            container.store((Object)SingleFileInserter.this.block);
                        }
                    }
                }
            }
            if (lateStart) {
                if (!this.startMetadata(container, context)) {
                    toRemove = null;
                } else {
                    splitHandler = this;
                    synchronized (splitHandler) {
                        this.sfi = null;
                    }
                }
            }
            if (toRemove != null && this.persistent) {
                toRemove.removeFrom(container, context);
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            if (this.finished) {
                if (this.persistent) {
                    container.activate((Object)SingleFileInserter.this.cb, 1);
                }
                SingleFileInserter.this.cb.onSuccess(this, container, context);
                if (this.persistent) {
                    container.deactivate((Object)SingleFileInserter.this.cb, 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this.block, 1);
            }
            boolean toFail = true;
            boolean toRemove = false;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (logMINOR) {
                    Logger.minor(this, "onFailure(): " + e + " on " + state + " on " + this + " sfi = " + this.sfi + " metadataPutter = " + this.metadataPutter);
                }
                if (state == this.sfi) {
                    toRemove = true;
                    this.sfi = null;
                    if (this.metadataPutter != null && this.persistent) {
                        container.store((Object)this);
                    }
                } else if (state == this.metadataPutter) {
                    toRemove = true;
                    this.metadataPutter = null;
                    if (this.sfi != null && this.persistent) {
                        container.store((Object)this);
                    }
                } else {
                    Logger.error(this, "onFailure() on unknown state " + state + " on " + this, (Throwable)new Exception("debug"));
                }
                if (this.finished) {
                    toFail = false;
                }
            }
            if (toRemove && this.persistent) {
                state.removeFrom(container, context);
            }
            if (toFail) {
                this.fail(e, container, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Metadata meta, ClientPutState state, ObjectContainer container, ClientContext context) {
            Bucket metadataBucket;
            byte[] metaBytes;
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this.cb, 1);
                container.activate((Object)SingleFileInserter.this.block, 2);
                container.activate((Object)SingleFileInserter.this.ctx, 1);
            }
            InsertException e = null;
            if (logMINOR) {
                Logger.minor(this, "Got metadata for " + this + " from " + state);
            }
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                if (SingleFileInserter.this.reportMetadataOnly) {
                    if (state != this.sfi) {
                        Logger.error(this, "Got metadata from unknown object " + state + " when expecting to report metadata");
                        return;
                    }
                    this.metaInsertSuccess = true;
                } else if (state == this.metadataPutter) {
                    Logger.error(this, "Got metadata for metadata");
                    e = new InsertException(3, "Did not expect to get metadata for metadata inserter", null);
                } else if (state != this.sfi) {
                    Logger.error(this, "Got metadata from unknown state " + state + " sfi=" + this.sfi + " metadataPutter=" + this.metadataPutter + " on " + this + " persistent=" + this.persistent, (Throwable)new Exception("debug"));
                    e = new InsertException(3, "Got metadata from unknown state", null);
                } else {
                    if (this.metadataPutter != null) {
                        return;
                    }
                    if (this.metaInsertSuccess) {
                        return;
                    }
                }
            }
            if (SingleFileInserter.this.reportMetadataOnly) {
                if (this.persistent) {
                    container.store((Object)this);
                }
                SingleFileInserter.this.cb.onMetadata(meta, (ClientPutState)this, container, context);
                return;
            }
            if (e != null) {
                this.onFailure(e, state, container, context);
                return;
            }
            if (this.persistent) {
                container.activate((Object)meta, Integer.MAX_VALUE);
            }
            try {
                metaBytes = meta.writeToByteArray();
            }
            catch (MetadataUnresolvedException e1) {
                Logger.error(this, "Impossible: " + e1, (Throwable)e1);
                this.fail((InsertException)new InsertException(3, "MetadataUnresolvedException in SingleFileInserter.SplitHandler: " + e1, null).initCause(e1), container, context);
                return;
            }
            String metaPutterTargetFilename = SingleFileInserter.this.targetFilename;
            if (SingleFileInserter.this.targetFilename != null && metaBytes.length <= Short.MAX_VALUE) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put(SingleFileInserter.this.targetFilename, meta);
                meta = Metadata.mkRedirectionManifestWithMetadata(hm);
                metaPutterTargetFilename = null;
                try {
                    metaBytes = meta.writeToByteArray();
                }
                catch (MetadataUnresolvedException e1) {
                    Logger.error(this, "Impossible (2): " + e1, (Throwable)e1);
                    this.fail((InsertException)new InsertException(3, "MetadataUnresolvedException in SingleFileInserter.SplitHandler(2): " + e1, null).initCause(e1), container, context);
                    return;
                }
            }
            try {
                metadataBucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent), metaBytes);
            }
            catch (IOException e1) {
                InsertException ex = new InsertException(2, e1, null);
                this.fail(ex, container, context);
                return;
            }
            ClientMetadata m = meta.getClientMetadata();
            InsertContext.CompatibilityMode cmode = SingleFileInserter.this.ctx.getCompatibilityMode();
            if (cmode != InsertContext.CompatibilityMode.COMPAT_CURRENT && cmode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
                m = null;
            }
            if (SingleFileInserter.this.metadataThreshold > 0L && (long)metaBytes.length < SingleFileInserter.this.metadataThreshold) {
                SplitHandler splitHandler2 = this;
                synchronized (splitHandler2) {
                    this.metaInsertSuccess = true;
                }
                SingleFileInserter.this.cb.onMetadata(metadataBucket, state, container, context);
                return;
            }
            InsertBlock newBlock = new InsertBlock(metadataBucket, m, SingleFileInserter.this.block.desiredURI);
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this, 1);
            }
            SplitHandler splitHandler3 = this;
            synchronized (splitHandler3) {
                this.metadataPutter = new SingleFileInserter(SingleFileInserter.this.parent, this, newBlock, true, SingleFileInserter.this.ctx, SingleFileInserter.this.realTimeFlag, false, SingleFileInserter.this.getCHKOnly, false, SingleFileInserter.this.token, SingleFileInserter.this.archiveType, true, metaPutterTargetFilename, SingleFileInserter.this.earlyEncode, true, this.persistent, this.origDataLength, this.origCompressedDataLength, SingleFileInserter.this.origHashes, SingleFileInserter.this.cryptoAlgorithm, SingleFileInserter.this.forceCryptoKey, SingleFileInserter.this.metadataThreshold);
                if (SingleFileInserter.this.origHashes != null) {
                    SingleFileInserter.access$902(SingleFileInserter.this, null);
                    if (this.persistent) {
                        container.store((Object)SingleFileInserter.this);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Created metadata putter for " + this + " : " + this.metadataPutter + " bucket " + metadataBucket + " size " + metadataBucket.size());
                }
                if (this.persistent) {
                    container.store((Object)this);
                }
                if (!SingleFileInserter.this.earlyEncode && !this.splitInsertSuccess) {
                    return;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Putting metadata on " + this.metadataPutter + " from " + this.sfi + " (" + ((SplitFileInserter)this.sfi).getLength() + ')');
            }
            if (!this.startMetadata(container, context)) {
                Logger.error(this, "onMetadata() yet unable to start metadata due to not having all URIs?!?!");
                this.fail(new InsertException(3, "onMetadata() yet unable to start metadata due to not having all URIs", null), container, context);
                return;
            }
            ClientPutState toRemove = null;
            SplitHandler splitHandler4 = this;
            synchronized (splitHandler4) {
                if (this.splitInsertSuccess && this.sfi != null) {
                    toRemove = this.sfi;
                    this.sfi = null;
                }
            }
            if (toRemove != null && this.persistent) {
                toRemove.removeFrom(container, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(InsertException e, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Failing: " + e, (Throwable)e);
            }
            ClientPutState oldSFI = null;
            ClientPutState oldMetadataPutter = null;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                oldSFI = this.sfi;
                oldMetadataPutter = this.metadataPutter;
            }
            if (this.persistent) {
                container.store((Object)this);
                if (oldSFI != null) {
                    container.activate((Object)oldSFI, 1);
                }
                if (oldMetadataPutter != null) {
                    container.activate((Object)oldMetadataPutter, 1);
                }
            }
            if (oldSFI != null) {
                oldSFI.cancel(container, context);
            }
            if (oldMetadataPutter != null) {
                oldMetadataPutter.cancel(container, context);
            }
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this.block, 2);
                container.activate((Object)SingleFileInserter.this.cb, 1);
            }
            splitHandler = this;
            synchronized (splitHandler) {
                if (SingleFileInserter.this.freeData) {
                    SingleFileInserter.this.block.free(container);
                } else {
                    SingleFileInserter.this.block.nullData();
                    if (this.persistent) {
                        container.store((Object)SingleFileInserter.this.block);
                    }
                }
            }
            SingleFileInserter.this.cb.onFailure(e, this, container, context);
        }

        @Override
        public BaseClientPutter getParent() {
            return SingleFileInserter.this.parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (this.persistent && logMINOR) {
                Logger.minor(this, "onEncode() for " + this + " : " + state + " : " + key);
            }
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (state != this.metadataPutter) {
                    if (logMINOR) {
                        Logger.minor(this, "ignored onEncode() for " + this + " : " + state);
                    }
                    return;
                }
            }
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this.cb, 1);
            }
            SingleFileInserter.this.cb.onEncode(key, this, container, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + this);
            }
            ClientPutState oldSFI = null;
            ClientPutState oldMetadataPutter = null;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                oldSFI = this.sfi;
                oldMetadataPutter = this.metadataPutter;
            }
            if (this.persistent) {
                container.store((Object)this);
                if (oldSFI != null) {
                    container.activate((Object)oldSFI, 1);
                }
                if (oldMetadataPutter != null) {
                    container.activate((Object)oldMetadataPutter, 1);
                }
            }
            if (oldSFI != null) {
                oldSFI.cancel(container, context);
            }
            if (oldMetadataPutter != null) {
                oldMetadataPutter.cancel(container, context);
            }
            if (SingleFileInserter.this.freeData) {
                if (this.persistent) {
                    container.activate((Object)SingleFileInserter.this.block, 2);
                }
                SingleFileInserter.this.block.free(container);
            } else {
                SingleFileInserter.this.block.nullData();
                if (this.persistent) {
                    container.store((Object)SingleFileInserter.this.block);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (state == this.sfi) {
                    this.splitInsertSetBlocks = true;
                } else if (state == this.metadataPutter) {
                    this.metaInsertSetBlocks = true;
                } else if (logMINOR) {
                    Logger.minor(this, "Unrecognised: " + state + " in onBlockSetFinished()");
                }
                if (this.persistent) {
                    container.store((Object)this);
                }
                if (!this.splitInsertSetBlocks || !this.metaInsertSetBlocks) {
                    return;
                }
            }
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this.cb, 1);
            }
            SingleFileInserter.this.cb.onBlockSetFinished(this, container, context);
        }

        @Override
        public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
            if (this.persistent) {
                container.activate((Object)this.sfi, 1);
            }
            this.sfi.schedule(container, context);
        }

        @Override
        public Object getToken() {
            return SingleFileInserter.this.token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFetchable(ClientPutState state, ObjectContainer container) {
            boolean meta;
            if (this.persistent && logMINOR) {
                Logger.minor(this, "onFetchable on " + this);
            }
            if (logMINOR) {
                Logger.minor(this, "onFetchable(" + state + ')');
            }
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                boolean bl = meta = state == this.metadataPutter;
                if (meta) {
                    if (!this.metaInsertStarted) {
                        Logger.error(this, "Metadata insert not started yet got onFetchable for it: " + state + " on " + this);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Metadata fetchable" + (this.metaFetchable ? "" : " already"));
                    }
                    if (this.metaFetchable) {
                        return;
                    }
                    this.metaFetchable = true;
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                } else {
                    if (state != this.sfi) {
                        Logger.error(this, "onFetchable for unknown state " + state);
                        return;
                    }
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Data fetchable");
                    }
                    if (this.metaInsertStarted) {
                        return;
                    }
                }
            }
            if (meta) {
                if (this.persistent) {
                    container.activate((Object)SingleFileInserter.this.cb, 1);
                }
                SingleFileInserter.this.cb.onFetchable(this, container);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startMetadata(ObjectContainer container, ClientContext context) {
            if (this.persistent && logMINOR) {
                Logger.minor(this, "startMetadata() on " + this);
            }
            try {
                ClientPutState splitInserter;
                ClientPutState putter;
                SplitHandler splitHandler = this;
                synchronized (splitHandler) {
                    if (this.metaInsertStarted) {
                        return true;
                    }
                    if (this.persistent && this.metadataPutter != null) {
                        container.activate((Object)this.metadataPutter, 1);
                    }
                    if ((putter = this.metadataPutter) == null) {
                        if (logMINOR) {
                            Logger.minor(this, "Cannot start metadata yet: no metadataPutter");
                        }
                    } else {
                        this.metaInsertStarted = true;
                    }
                    splitInserter = this.sfi;
                }
                if (this.persistent) {
                    container.store((Object)this);
                }
                if (putter != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Starting metadata inserter: " + putter + " for " + this);
                    }
                    putter.schedule(container, context);
                    if (logMINOR) {
                        Logger.minor(this, "Started metadata inserter: " + putter + " for " + this);
                    }
                    return true;
                }
                Logger.error(this, "startMetadata() calling forceEncode() on " + splitInserter + " for " + this, (Throwable)new Exception("error"));
                if (this.persistent) {
                    container.activate((Object)splitInserter, 1);
                }
                ((SplitFileInserter)splitInserter).forceEncode(container, context);
                return false;
            }
            catch (InsertException e1) {
                Logger.error(this, "Failing " + this + " : " + e1, (Throwable)e1);
                this.fail(e1, container, context);
                return true;
            }
        }

        public void objectOnActivate(ObjectContainer container) {
            container.activate((Object)SingleFileInserter.this, 1);
        }

        @Override
        public void removeFrom(ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "removeFrom() on " + this);
            }
            container.delete((Object)this);
            SingleFileInserter.this.removeFrom(container, context);
        }

        public boolean objectCanUpdate(ObjectContainer container) {
            if (logDEBUG) {
                Logger.debug(this, "objectCanUpdate() on " + this, (Throwable)new Exception("debug"));
            }
            return true;
        }

        public boolean objectCanNew(ObjectContainer container) {
            if (this.finished) {
                Logger.error(this, "objectCanNew but finished on " + this, (Throwable)new Exception("error"));
            } else if (logDEBUG) {
                Logger.debug(this, "objectCanNew() on " + this, (Throwable)new Exception("debug"));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Bucket meta, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Got metadata bucket for " + this + " from " + state);
            }
            boolean freeIt = false;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                if (state != this.metadataPutter) {
                    if (state == this.sfi) {
                        if (this.metadataPutter != null) {
                            Logger.error(this, "Got metadata from " + this.sfi + " even though already started inserting metadata on the next layer on " + this + " !!");
                            freeIt = true;
                        } else {
                            this.metaInsertSuccess = true;
                        }
                    } else if (SingleFileInserter.this.reportMetadataOnly) {
                        if (state != this.sfi) {
                            Logger.error(this, "Got metadata from unknown object " + state + " when expecting to report metadata");
                            return;
                        }
                        this.metaInsertSuccess = true;
                    } else {
                        Logger.error(this, "Got metadata from unknown object " + state);
                        freeIt = true;
                    }
                }
            }
            if (freeIt) {
                meta.free();
                meta.removeFrom(container);
                return;
            }
            if (this.persistent) {
                container.activate((Object)SingleFileInserter.this.cb, 1);
            }
            SingleFileInserter.this.cb.onMetadata(meta, (ClientPutState)this, container, context);
        }
    }
}

