/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.client.async.SplitFileFetcherSegmentGet;
import freenet.crypt.SHA256;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.node.SendableGet;
import freenet.support.BinaryBloomFilter;
import freenet.support.CountingBloomFilter;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class SplitFileFetcherKeyListener
implements KeyListener {
    private static volatile boolean logMINOR;
    private final SplitFileFetcher fetcher;
    private final boolean persistent;
    private int keyCount;
    private final CountingBloomFilter filter;
    private final BinaryBloomFilter[] segmentFilters;
    private static final long WRITE_DELAY;
    private short prio;
    private final byte[] localSalt;
    private boolean killed;
    final boolean loadedOnStartup;
    final boolean realTime;
    private boolean writingBloomFilter;

    public SplitFileFetcherKeyListener(SplitFileFetcher parent, int keyCount, File bloomFile, File altBloomFile, int mainBloomSizeBytes, int mainBloomK, byte[] localSalt, int segments, int segmentFilterSizeBytes, int segmentBloomK, boolean persistent, boolean newFilter, CountingBloomFilter cachedMainFilter, BinaryBloomFilter[] cachedSegFilters, ObjectContainer container, boolean onStartup, boolean realTime) throws IOException {
        this.fetcher = parent;
        this.loadedOnStartup = onStartup;
        this.persistent = persistent;
        this.keyCount = keyCount;
        this.realTime = realTime;
        assert (localSalt.length == 32);
        this.localSalt = persistent ? Arrays.copyOf(localSalt, 32) : localSalt;
        this.segmentFilters = new BinaryBloomFilter[segments];
        if (cachedSegFilters != null) {
            for (int i = 0; i < cachedSegFilters.length; ++i) {
                this.segmentFilters[i] = cachedSegFilters[i];
                container.activate((Object)cachedSegFilters[i], Integer.MAX_VALUE);
                cachedSegFilters[i].init(container);
                if (!logMINOR) continue;
                Logger.minor(this, "Restored segment " + i + " filter for " + parent + " : k=" + cachedSegFilters[i].getK() + " size = " + cachedSegFilters[i].getSizeBytes() + " bytes = " + cachedSegFilters[i].getLength() + " elements, filled: " + cachedSegFilters[i].getFilledCount());
            }
        } else {
            int i;
            byte[] segmentsFilterBuffer = new byte[segmentFilterSizeBytes * segments];
            ByteBuffer baseBuffer = ByteBuffer.wrap(segmentsFilterBuffer);
            if (!newFilter) {
                FileInputStream fis = new FileInputStream(altBloomFile);
                DataInputStream dis = new DataInputStream(fis);
                dis.readFully(segmentsFilterBuffer);
                dis.close();
            }
            int start = 0;
            int end = segmentFilterSizeBytes;
            for (i = 0; i < segments; ++i) {
                ByteBuffer slice;
                baseBuffer.position(start);
                baseBuffer.limit(end);
                if (persistent) {
                    byte[] buf = Arrays.copyOfRange(segmentsFilterBuffer, start, start + segmentFilterSizeBytes);
                    slice = ByteBuffer.wrap(buf);
                } else {
                    slice = baseBuffer.slice();
                }
                this.segmentFilters[i] = new BinaryBloomFilter(slice, segmentFilterSizeBytes * 8, segmentBloomK);
                start += segmentFilterSizeBytes;
                end += segmentFilterSizeBytes;
            }
            if (persistent) {
                for (i = 0; i < segments; ++i) {
                    if (logMINOR) {
                        Logger.minor(this, "Storing segment " + i + " filter to database for " + parent + " : k=" + this.segmentFilters[i].getK() + " size = " + this.segmentFilters[i].getSizeBytes() + " bytes = " + this.segmentFilters[i].getLength() + " elements, filled: " + this.segmentFilters[i].getFilledCount());
                    }
                    this.segmentFilters[i].storeTo(container);
                }
            }
            parent.setCachedSegFilters(this.segmentFilters);
            if (persistent) {
                container.store((Object)parent);
            }
        }
        byte[] filterBuffer = new byte[mainBloomSizeBytes];
        if (cachedMainFilter != null) {
            this.filter = cachedMainFilter;
            if (persistent) {
                container.activate((Object)this.filter, Integer.MAX_VALUE);
            }
            this.filter.init(container);
            if (logMINOR) {
                Logger.minor(this, "Restored filter for " + parent + " : k=" + this.filter.getK() + " size = " + this.filter.getSizeBytes() + " bytes = " + this.filter.getLength() + " elements, filled: " + this.filter.getFilledCount());
            }
        } else if (newFilter) {
            this.filter = new CountingBloomFilter(mainBloomSizeBytes * 8 / 2, mainBloomK, filterBuffer);
            this.filter.setWarnOnRemoveFromEmpty();
            parent.setCachedMainFilter(this.filter);
            if (persistent) {
                this.filter.storeTo(container);
                container.store((Object)parent);
            }
        } else {
            FileInputStream fis = new FileInputStream(bloomFile);
            DataInputStream dis = new DataInputStream(fis);
            dis.readFully(filterBuffer);
            dis.close();
            this.filter = new CountingBloomFilter(mainBloomSizeBytes * 8 / 2, mainBloomK, filterBuffer);
            this.filter.setWarnOnRemoveFromEmpty();
            parent.setCachedMainFilter(this.filter);
            if (persistent) {
                if (logMINOR) {
                    Logger.minor(this, "Storing filter to database for " + parent + " : k=" + this.filter.getK() + " size = " + this.filter.getSizeBytes() + " bytes = " + this.filter.getLength() + " elements, filled: " + this.filter.getFilledCount());
                }
                this.filter.storeTo(container);
                container.store((Object)parent);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Created " + this + " for " + this.fetcher);
        }
    }

    @Override
    public long countKeys() {
        return this.keyCount;
    }

    void addKey(Key key, int segNo, ClientContext context) {
        byte[] saltedKey = context.getChkFetchScheduler(this.realTime).saltKey(this.persistent, key);
        this.filter.addKey(saltedKey);
        byte[] localSalted = this.localSaltKey(key);
        this.segmentFilters[segNo].addKey(localSalted);
    }

    private byte[] localSaltKey(Key key) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key.getRoutingKey());
        md.update(this.localSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    @Override
    public boolean probablyWantKey(Key key, byte[] saltedKey) {
        if (this.filter == null) {
            Logger.error(this, "Probably want key: filter = null for " + this + " fetcher = " + this.fetcher);
        }
        if (this.filter.checkFilter(saltedKey)) {
            byte[] salted = this.localSaltKey(key);
            for (int i = 0; i < this.segmentFilters.length; ++i) {
                if (!this.segmentFilters[i].checkFilter(salted)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public short definitelyWantKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        byte[] salted = this.localSaltKey(key);
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            boolean found;
            if (!this.segmentFilters[i].checkFilter(salted)) continue;
            if (this.persistent) {
                if (container.ext().isActive((Object)this.fetcher)) {
                    Logger.error(this, "ALREADY ACTIVE in definitelyWantKey(): " + this.fetcher);
                }
                container.activate((Object)this.fetcher, 1);
            }
            SplitFileFetcherSegment segment = this.fetcher.getSegment(i);
            if (this.persistent) {
                container.deactivate((Object)this.fetcher, 1);
            }
            if (this.persistent) {
                if (container.ext().isActive((Object)segment)) {
                    Logger.error(this, "ALREADY ACTIVE in definitelyWantKey(): " + segment);
                }
                container.activate((Object)segment, 1);
            }
            boolean bl = found = segment.getBlockNumber(key, container) >= 0;
            if (!found) {
                Logger.error(this, "Found block in primary and segment bloom filters but segment doesn't want it: " + segment + " on " + this);
            }
            if (this.persistent) {
                container.deactivate((Object)segment, 1);
            }
            if (!found) continue;
            return this.prio;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock block, ObjectContainer container, ClientContext context) {
        boolean found = false;
        byte[] salted = this.localSaltKey(key);
        if (logMINOR) {
            Logger.minor(this, "handleBlock(" + key + ") on " + this + " for " + this.fetcher);
        }
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            boolean match;
            SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
            synchronized (splitFileFetcherKeyListener) {
                match = this.segmentFilters[i].checkFilter(salted);
            }
            if (!match) continue;
            if (this.persistent) {
                if (!container.ext().isStored((Object)this.fetcher)) {
                    Logger.error(this, "Fetcher not in database! for " + this);
                    return false;
                }
                if (container.ext().isActive((Object)this.fetcher)) {
                    Logger.warning(this, "ALREADY ACTIVATED: " + this.fetcher);
                }
                container.activate((Object)this.fetcher, 1);
            }
            SplitFileFetcherSegment segment = this.fetcher.getSegment(i);
            if (this.persistent) {
                if (container.ext().isActive((Object)segment)) {
                    Logger.warning(this, "ALREADY ACTIVATED: " + segment);
                }
                container.activate((Object)segment, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Key " + key + " may be in segment " + segment);
            }
            while (segment.onGotKey(key, block, container, context)) {
                found = true;
            }
            if (this.persistent) {
                container.deactivate((Object)segment, 1);
            }
            if (!this.persistent) continue;
            container.deactivate((Object)this.fetcher, 1);
        }
        return found;
    }

    @Override
    public HasKeyListener getHasKeyListener() {
        return this.fetcher;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        return this.prio;
    }

    @Override
    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        ArrayList<SplitFileFetcherSegmentGet> ret = new ArrayList<SplitFileFetcherSegmentGet>();
        byte[] salted = this.localSaltKey(key);
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            SplitFileFetcherSegmentGet getter;
            int blockNum;
            if (!this.segmentFilters[i].checkFilter(salted)) continue;
            if (this.persistent) {
                if (container.ext().isActive((Object)this.fetcher)) {
                    Logger.warning(this, "ALREADY ACTIVATED in getRequestsForKey: " + this.fetcher);
                }
                container.activate((Object)this.fetcher, 1);
            }
            SplitFileFetcherSegment segment = this.fetcher.getSegment(i);
            if (this.persistent) {
                container.deactivate((Object)this.fetcher, 1);
            }
            if (this.persistent) {
                if (container.ext().isActive((Object)segment)) {
                    Logger.warning(this, "ALREADY ACTIVATED in getRequestsForKey: " + segment);
                }
                container.activate((Object)segment, 1);
            }
            if ((blockNum = segment.getBlockNumber(key, container)) >= 0 && (getter = segment.makeGetter(container, context)) != null) {
                ret.add(getter);
            }
            if (!this.persistent) continue;
            container.deactivate((Object)segment, 1);
        }
        return ret.toArray(new SendableGet[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemove() {
        SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
        synchronized (splitFileFetcherKeyListener) {
            this.killed = true;
        }
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFilters(ObjectContainer container, String reason) throws IOException {
        if (!this.persistent) {
            return;
        }
        SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
        synchronized (splitFileFetcherKeyListener) {
            if (this.killed) {
                return;
            }
        }
        this.filter.storeTo(container);
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            if (logMINOR) {
                Logger.minor(this, "Storing segment " + i + " filter to database (" + reason + ") k=" + this.segmentFilters[i].getK() + " size = " + this.segmentFilters[i].getSizeBytes() + " bytes = " + this.segmentFilters[i].getLength() + " elements, filled: " + this.segmentFilters[i].getFilledCount());
            }
            this.segmentFilters[i].storeTo(container);
        }
    }

    public synchronized int killSegment(SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        int segNo = segment.segNum;
        this.segmentFilters[segNo].unsetAll();
        Key[] removeKeys = segment.listKeys(container);
        if (logMINOR) {
            Logger.minor(this, "Removing segment from bloom filter: " + segment + " keys: " + removeKeys.length);
        }
        for (Key removeKey : removeKeys) {
            byte[] salted;
            if (logMINOR) {
                Logger.minor(this, "Removing key from bloom filter: " + removeKey);
            }
            if (this.filter.checkFilter(salted = context.getChkFetchScheduler(this.realTime).saltKey(this.persistent, removeKey))) {
                this.filter.removeKey(salted);
                continue;
            }
            Logger.error(this, "Removing key " + removeKey + " for " + this + " from " + segment + " : NOT IN BLOOM FILTER!", (Throwable)new Exception("debug"));
        }
        this.scheduleWriteFilters(container, context, "killed segment " + segNo);
        return this.keyCount -= removeKeys.length;
    }

    public synchronized void removeKey(Key key, SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        byte[] salted;
        if (logMINOR) {
            Logger.minor(this, "Removing key " + key + " from bloom filter for " + segment);
        }
        if (logMINOR) {
            Logger.minor(this, "Removing key from bloom filter: " + key);
        }
        if (this.filter.checkFilter(salted = context.getChkFetchScheduler(this.realTime).saltKey(this.persistent, key))) {
            this.filter.removeKey(salted);
            --this.keyCount;
        } else {
            Logger.error(this, "Removing key " + key + " for " + this + " from " + segment + " : NOT IN BLOOM FILTER!", (Throwable)new Exception("debug"));
        }
        boolean deactivateFetcher = false;
        if (this.persistent) {
            boolean bl = deactivateFetcher = !container.ext().isActive((Object)this.fetcher);
            if (deactivateFetcher) {
                container.activate((Object)this.fetcher, 1);
            }
        }
        this.fetcher.setKeyCount(this.keyCount, container);
        if (deactivateFetcher) {
            container.deactivate((Object)this.fetcher, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleWriteFilters(ObjectContainer container, ClientContext context, final String reason) {
        SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
        synchronized (splitFileFetcherKeyListener) {
            if (!this.persistent) {
                return;
            }
            if (this.writingBloomFilter) {
                return;
            }
            this.writingBloomFilter = true;
            try {
                this.filter.storeTo(container);
                context.jobRunner.setCommitThisTransaction();
                context.jobRunner.queue(new DBJob(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        SplitFileFetcherKeyListener splitFileFetcherKeyListener = SplitFileFetcherKeyListener.this;
                        synchronized (splitFileFetcherKeyListener) {
                            try {
                                SplitFileFetcherKeyListener.this.writeFilters(container, reason);
                            }
                            catch (IOException e) {
                                Logger.error(this, "Failed to write bloom filters, we will have more false positives on already-found blocks which aren't in the store: " + e, (Throwable)e);
                            }
                            finally {
                                SplitFileFetcherKeyListener.this.writingBloomFilter = false;
                            }
                        }
                        return false;
                    }
                }, NativeThread.HIGH_PRIORITY, false);
            }
            catch (Throwable t) {
                this.writingBloomFilter = false;
                Logger.error(this, "Caught " + t + " writing bloom filter", t);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.killed;
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    public void objectOnDeactivate(ObjectContainer container) {
        Logger.error(this, "Deactivating a SplitFileFetcherKeyListener: " + this, (Throwable)new Exception("error"));
    }

    @Override
    public boolean isRealTime() {
        return this.realTime;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        WRITE_DELAY = TimeUnit.SECONDS.toMillis(60L);
    }
}

