/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.FECQueue;
import freenet.client.SplitfileBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.MinimalSplitfileBlock;
import freenet.client.async.SplitFileInserter;
import freenet.client.async.SplitFileInserterSegment;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;

public class SplitFileInserterCrossSegment
implements FECCallback {
    private final boolean persistent;
    private final int dataBlocks;
    private final int crossCheckBlocks;
    private final SplitFileInserterSegment[] segments;
    private final int[] blockNumbers;
    private final ClientRequester parent;
    private final SplitFileInserter parentInserter;
    private final int segNum;
    final short splitfileType;
    private transient int counter;
    private transient FECCodec codec;
    private static volatile boolean logMINOR;

    SplitFileInserterCrossSegment(boolean persistent, int dataBlocks, int crossCheckBlocks, ClientRequester parent, short splitfileType, SplitFileInserter parentInserter, int segNum) {
        this.persistent = persistent;
        this.dataBlocks = dataBlocks;
        this.crossCheckBlocks = crossCheckBlocks;
        int totalBlocks = dataBlocks + crossCheckBlocks;
        this.segments = new SplitFileInserterSegment[totalBlocks];
        this.blockNumbers = new int[totalBlocks];
        this.parent = parent;
        this.splitfileType = splitfileType;
        this.parentInserter = parentInserter;
        this.segNum = segNum;
    }

    public void addDataBlock(SplitFileInserterSegment seg, int blockNum) {
        if (logMINOR) {
            Logger.minor(this, "Allocated " + this.counter + " blocks: block " + blockNum + " on segment " + seg.segNo);
        }
        this.segments[this.counter] = seg;
        this.blockNumbers[this.counter] = blockNum;
        ++this.counter;
    }

    public void start(ObjectContainer container, ClientContext context) {
        int i;
        if (logMINOR) {
            Logger.minor(this, "Scheduling encode for cross segment");
        }
        SplitfileBlock[] decodeData = new SplitfileBlock[this.dataBlocks];
        SplitfileBlock[] decodeCheck = new SplitfileBlock[this.segments.length - this.dataBlocks];
        for (i = 0; i < decodeData.length; ++i) {
            MinimalSplitfileBlock wrapper = new MinimalSplitfileBlock(i);
            SplitFileInserterSegment seg = this.segments[i];
            boolean active = true;
            if (this.persistent && !(active = container.ext().isActive((Object)seg))) {
                container.activate((Object)seg, 1);
            }
            Bucket data = seg.getBucket(this.blockNumbers[i]);
            wrapper.assertSetData(data);
            if (this.persistent) {
                container.activate((Object)data, Integer.MAX_VALUE);
            }
            if (!active) {
                container.deactivate((Object)seg, 1);
            }
            decodeData[i] = wrapper;
        }
        for (i = 0; i < decodeCheck.length; ++i) {
            decodeCheck[i] = new MinimalSplitfileBlock(i);
        }
        FECQueue queue = context.fecQueue;
        if (this.codec == null) {
            this.codec = FECCodec.getCodec(this.splitfileType, this.dataBlocks, decodeCheck.length);
        }
        FECJob job = new FECJob(this.codec, queue, decodeData, decodeCheck, 32768, context.getBucketFactory(this.persistent), (FECCallback)this, false, this.getPriorityClass(container), this.persistent);
        this.codec.addToQueue(job, queue, container);
    }

    private short getPriorityClass(ObjectContainer container) {
        boolean parentActive = true;
        if (this.persistent && !(parentActive = container.ext().isActive((Object)this.parent))) {
            container.activate((Object)this.parent, 1);
        }
        short ret = this.parent.getPriorityClass();
        if (!parentActive) {
            container.deactivate((Object)this.parent, 1);
        }
        return ret;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    @Override
    public void onDecodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlocks, SplitfileBlock[] checkBlocks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onEncodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlocks, SplitfileBlock[] checkBlocks) {
        int i;
        for (i = 0; i < this.crossCheckBlocks; ++i) {
            SplitFileInserterSegment seg = this.segments[i + this.dataBlocks];
            int blockNum = this.blockNumbers[i + this.dataBlocks];
            if (this.persistent) {
                container.activate((Object)seg, 1);
            }
            seg.onEncodedCrossCheckBlock(blockNum, checkBlocks[i].getData(), container, context);
            if (this.persistent) {
                container.deactivate((Object)seg, 1);
            }
            checkBlocks[i].clearData();
            if (!this.persistent) continue;
            container.delete((Object)checkBlocks[i]);
        }
        for (i = 0; i < dataBlocks.length; ++i) {
            dataBlocks[i].clearData();
            if (!this.persistent) continue;
            container.delete((Object)dataBlocks[i]);
        }
        if (logMINOR) {
            Logger.minor(this, "Completed encode for cross segment");
        }
        if (this.persistent) {
            container.activate((Object)this.parentInserter, 1);
        }
        this.parentInserter.clearCrossSegment(this.segNum, this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.parentInserter, 1);
        }
        if (this.persistent) {
            this.removeFrom(container);
        }
    }

    private void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    @Override
    public void onFailed(Throwable t, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Encode or decode failed for cross segment: " + this, t);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, SplitFileInserterCrossSegment.class);
            }
        });
    }
}

