/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.keys.ClientCHK;
import freenet.keys.NodeCHK;
import freenet.support.Fields;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;

public class SplitFileSegmentKeys
implements Cloneable {
    public final int dataBlocks;
    public final int checkBlocks;
    public final byte[] commonDecryptKey;
    public final byte[] commonExtraBytes;
    public final byte[] routingKeys;
    public final byte[] decryptKeys;
    public final byte[] extraBytesForKeys;
    static final int EXTRA_BYTES_LENGTH = 5;

    public SplitFileSegmentKeys(int blocksPerSegment, int checkBlocksPerSegment, byte[] splitfileSingleCryptoKey, byte splitfileSingleCryptoAlgorithm) {
        this.dataBlocks = blocksPerSegment;
        this.checkBlocks = checkBlocksPerSegment;
        this.routingKeys = new byte[32 * (this.dataBlocks + this.checkBlocks)];
        if (splitfileSingleCryptoKey != null) {
            this.commonDecryptKey = splitfileSingleCryptoKey;
            this.commonExtraBytes = ClientCHK.getExtra(splitfileSingleCryptoAlgorithm, (short)-1, false);
            this.decryptKeys = null;
            this.extraBytesForKeys = null;
        } else {
            this.commonDecryptKey = null;
            this.commonExtraBytes = null;
            this.decryptKeys = new byte[32 * (this.dataBlocks + this.checkBlocks)];
            this.extraBytesForKeys = new byte[5 * (this.dataBlocks + this.checkBlocks)];
        }
    }

    public int getBlockNumber(ClientCHK key, boolean[] ignoreSlots) {
        byte[] rkey = key.getRoutingKey();
        byte[] ckey = null;
        byte[] extra = null;
        int x = 0;
        for (int i = 0; i < this.dataBlocks + this.checkBlocks; ++i) {
            int oldX = x;
            x += 32;
            if (ignoreSlots != null && ignoreSlots[i] || !Fields.byteArrayEqual(this.routingKeys, rkey, oldX, 0, 32)) continue;
            if (ckey == null) {
                ckey = key.getCryptoKey();
            }
            if (this.commonDecryptKey == null ? !Fields.byteArrayEqual(this.decryptKeys, ckey, oldX, 0, 32) : !Arrays.equals(this.commonDecryptKey, ckey)) continue;
            if (extra == null) {
                extra = key.getExtra();
            }
            if (this.commonExtraBytes != null ? !Arrays.equals(this.commonExtraBytes, extra) : !Fields.byteArrayEqual(this.extraBytesForKeys, extra, i * 5, 0, 5)) continue;
            return i;
        }
        return -1;
    }

    public int getBlockNumber(NodeCHK key, boolean[] ignoreSlots) {
        byte[] rkey = key.getRoutingKey();
        int x = 0;
        for (int i = 0; i < this.dataBlocks + this.checkBlocks; ++i) {
            int oldX = x;
            x += 32;
            if (ignoreSlots != null && ignoreSlots[i] || !Fields.byteArrayEqual(this.routingKeys, rkey, oldX, 0, 32)) continue;
            return i;
        }
        return -1;
    }

    public int[] getBlockNumbers(NodeCHK key, boolean[] ignoreSlots) {
        ArrayList<Integer> results = null;
        byte[] rkey = key.getRoutingKey();
        int x = 0;
        for (int i = 0; i < this.dataBlocks + this.checkBlocks; ++i) {
            int oldX = x;
            x += 32;
            if (ignoreSlots != null && ignoreSlots[i] || !Fields.byteArrayEqual(this.routingKeys, rkey, oldX, 0, 32)) continue;
            if (results == null) {
                results = new ArrayList<Integer>();
            }
            results.add(i);
        }
        if (results == null) {
            return new int[0];
        }
        int[] ret = new int[results.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)results.get(i);
        }
        return ret;
    }

    public NodeCHK getNodeKey(int x, boolean[] ignoreSlots, boolean copy) {
        if (ignoreSlots != null && ignoreSlots[x]) {
            return null;
        }
        return this.getNodeKey(x, copy);
    }

    public ClientCHK getKey(int x, boolean[] ignoreSlots, boolean copy) {
        if (ignoreSlots != null && ignoreSlots[x]) {
            return null;
        }
        return this.getKey(x, copy);
    }

    private ClientCHK getKey(int x, boolean copy) {
        byte[] extra;
        byte[] decryptKey;
        byte[] routingKey = new byte[32];
        System.arraycopy(this.routingKeys, x * 32, routingKey, 0, 32);
        if (this.commonDecryptKey != null) {
            decryptKey = copy ? (byte[])this.commonDecryptKey.clone() : this.commonDecryptKey;
        } else {
            int offset = x * 32;
            decryptKey = Arrays.copyOfRange(this.decryptKeys, offset, offset + 32);
        }
        if (this.commonExtraBytes != null) {
            extra = copy ? (byte[])this.commonExtraBytes.clone() : this.commonExtraBytes;
        } else {
            int offset = x * 5;
            extra = Arrays.copyOfRange(this.extraBytesForKeys, offset, offset + 5);
        }
        try {
            return new ClientCHK(routingKey, decryptKey, extra);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Impossible: " + e);
            throw new IllegalStateException(e);
        }
    }

    private NodeCHK getNodeKey(int x, boolean copy) {
        byte[] extra;
        int xr = x * 32;
        byte[] routingKey = Arrays.copyOfRange(this.routingKeys, xr, xr + 32);
        if (this.commonExtraBytes != null) {
            extra = this.commonExtraBytes;
        } else {
            int xe = x * 5;
            extra = Arrays.copyOfRange(this.extraBytesForKeys, xe, xe + 5);
        }
        byte cryptoAlgorithm = ClientCHK.getCryptoAlgorithmFromExtra(extra);
        return new NodeCHK(routingKey, cryptoAlgorithm);
    }

    public void readKeys(DataInputStream dis, boolean check) throws IOException {
        int offset;
        int count = check ? this.checkBlocks : this.dataBlocks;
        int n = offset = check ? this.dataBlocks : 0;
        if (this.commonDecryptKey != null) {
            int rkOffset = offset * 32;
            for (int i = 0; i < count; ++i) {
                dis.readFully(this.routingKeys, rkOffset, 32);
                rkOffset += 32;
            }
        } else {
            int rkOffset = offset * 32;
            int extraOffset = offset * 5;
            for (int i = 0; i < count; ++i) {
                ClientCHK key = ClientCHK.readRawBinaryKey(dis);
                byte[] r = key.getRoutingKey();
                System.arraycopy(r, 0, this.routingKeys, rkOffset, 32);
                byte[] c = key.getCryptoKey();
                System.arraycopy(c, 0, this.decryptKeys, rkOffset, 32);
                rkOffset += 32;
                byte[] e = key.getExtra();
                System.arraycopy(e, 0, this.extraBytesForKeys, extraOffset, 5);
                extraOffset += 5;
            }
        }
    }

    public void writeKeys(DataOutputStream dos, boolean check) throws IOException {
        int offset;
        int count = check ? this.checkBlocks : this.dataBlocks;
        int n = offset = check ? this.dataBlocks : 0;
        if (this.commonDecryptKey != null) {
            int rkOffset = offset * 32;
            for (int i = 0; i < count; ++i) {
                dos.write(this.routingKeys, rkOffset, 32);
                rkOffset += 32;
            }
        } else {
            int rkOffset = offset * 32;
            int extraOffset = offset * 5;
            for (int i = 0; i < count; ++i) {
                dos.write(this.extraBytesForKeys, extraOffset, 5);
                extraOffset += 5;
                dos.write(this.routingKeys, rkOffset, 32);
                dos.write(this.decryptKeys, rkOffset, 32);
                rkOffset += 32;
            }
        }
    }

    public int getDataBlocks() {
        return this.dataBlocks;
    }

    public int getCheckBlocks() {
        return this.checkBlocks;
    }

    public void setKey(int i, ClientCHK key) {
        byte[] r = key.getRoutingKey();
        System.arraycopy(r, 0, this.routingKeys, i * 32, 32);
        if (this.decryptKeys != null) {
            byte[] c = key.getCryptoKey();
            System.arraycopy(c, 0, this.decryptKeys, i * 32, 32);
        }
        if (this.extraBytesForKeys != null) {
            byte[] e = key.getExtra();
            System.arraycopy(e, 0, this.extraBytesForKeys, i * 5, 5);
        }
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    public NodeCHK[] listNodeKeys(boolean[] foundKeys, boolean copy) {
        ArrayList<NodeCHK> list = new ArrayList<NodeCHK>();
        for (int i = 0; i < this.dataBlocks + this.checkBlocks; ++i) {
            NodeCHK k = this.getNodeKey(i, foundKeys, copy);
            if (k == null) continue;
            list.add(k);
        }
        return list.toArray(new NodeCHK[list.size()]);
    }

    public SplitFileSegmentKeys clone() {
        try {
            return (SplitFileSegmentKeys)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Yes it is!");
        }
    }
}

