/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.client.async.StreamGenerator;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.IOException;
import java.io.OutputStream;

public class SplitFileStreamGenerator
implements StreamGenerator {
    private final SplitFileFetcherSegment[] segments;
    private final long length;
    private final int crossCheckBlocks;
    private static volatile boolean logMINOR;

    SplitFileStreamGenerator(SplitFileFetcherSegment[] segments, long length, int crossCheckBlocks) {
        this.segments = segments;
        this.length = length;
        this.crossCheckBlocks = crossCheckBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream os, ObjectContainer container, ClientContext context) throws IOException {
        try {
            if (logMINOR) {
                Logger.minor(this, "Generating Stream", (Throwable)new Exception("debug"));
            }
            long bytesWritten = 0L;
            for (SplitFileFetcherSegment segment : this.segments) {
                long max = this.length < 0L ? 0L : this.length - bytesWritten;
                bytesWritten += segment.writeDecodedDataTo(os, max, container);
                if (this.crossCheckBlocks != 0) continue;
                segment.fetcherHalfFinished(container);
            }
            if (logMINOR) {
                Logger.minor(this, "Stream completely generated", (Throwable)new Exception("debug"));
            }
            os.close();
        }
        finally {
            Closer.close(os);
        }
    }

    @Override
    public long size() {
        return this.length;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

