/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTagCallback;
import freenet.client.async.USKFetcherWrapper;
import freenet.client.async.USKManager;
import freenet.keys.USK;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;

class USKFetcherTag
implements ClientGetState,
USKFetcherCallback {
    public final long nodeDBHandle;
    public final USKFetcherCallback callback;
    public final USK origUSK;
    protected long edition;
    public final boolean persistent;
    public final FetchContext ctx;
    public final boolean keepLastData;
    private short priority;
    private long token;
    private transient USKFetcher fetcher;
    private short pollingPriorityNormal;
    private short pollingPriorityProgress;
    private boolean finished;
    private final boolean ownFetchContext;
    private final boolean checkStoreOnly;
    private final int hashCode;
    private final boolean realTimeFlag;
    private static volatile boolean logMINOR;

    private USKFetcherTag(USK origUSK, USKFetcherCallback callback, long nodeDBHandle, boolean persistent, boolean realTime, ObjectContainer container, FetchContext ctx, boolean keepLastData, long token, boolean hasOwnFetchContext, boolean checkStoreOnly) {
        this.nodeDBHandle = nodeDBHandle;
        this.callback = callback;
        this.origUSK = origUSK;
        this.edition = origUSK.suggestedEdition;
        this.persistent = persistent;
        this.ctx = ctx;
        this.keepLastData = keepLastData;
        this.token = token;
        this.ownFetchContext = hasOwnFetchContext;
        this.realTimeFlag = realTime;
        this.pollingPriorityNormal = callback.getPollingPriorityNormal();
        this.pollingPriorityProgress = callback.getPollingPriorityProgress();
        this.priority = this.pollingPriorityNormal;
        this.checkStoreOnly = checkStoreOnly;
        this.hashCode = super.hashCode();
        if (logMINOR) {
            Logger.minor(this, "Created tag for " + origUSK + " and " + callback + " : " + this);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static USKFetcherTag create(USK usk, USKFetcherCallback callback, long nodeDBHandle, boolean persistent, boolean realTime, ObjectContainer container, FetchContext ctx, boolean keepLast, int token, boolean hasOwnFetchContext, boolean checkStoreOnly) {
        USKFetcherTag tag = new USKFetcherTag(usk, callback, nodeDBHandle, persistent, realTime, container, ctx, keepLast, token, hasOwnFetchContext, checkStoreOnly);
        if (persistent) {
            container.store((Object)tag);
        }
        return tag;
    }

    synchronized void updatedEdition(long ed, ObjectContainer container) {
        if (this.edition < ed) {
            this.edition = ed;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    public void start(USKManager manager, ClientContext context, ObjectContainer container) {
        USK usk = this.origUSK;
        if (this.persistent) {
            container.activate((Object)this.origUSK, 5);
        }
        if (usk.suggestedEdition < this.edition) {
            usk = usk.copy(this.edition);
        } else if (this.persistent) {
            usk = usk.copy();
        }
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
        }
        this.fetcher = manager.getFetcher(usk, this.ctx, new USKFetcherWrapper(usk, this.priority, this.realTimeFlag ? USKManager.rcRT : USKManager.rcBulk), this.keepLastData, this.checkStoreOnly);
        this.fetcher.addCallback(this);
        this.fetcher.schedule(null, context);
        if (logMINOR) {
            Logger.minor(this, "Starting " + this.fetcher + " for " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        USKFetcher f = this.fetcher;
        if (f != null) {
            this.fetcher.cancel(null, context);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Already cancelled " + this);
                }
                return;
            }
            this.finished = true;
        }
        if (f != null) {
            Logger.error(this, "cancel() for " + this.fetcher + " did not set finished on " + this + " ???");
        }
    }

    @Override
    public long getToken() {
        return this.token;
    }

    @Override
    public void schedule(ObjectContainer container, ClientContext context) {
        this.start(context.uskManager, context, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancelled(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelled on " + this);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            this.finished = true;
        }
        if (this.persistent && container == null) {
            try {
                context.jobRunner.runBlocking(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        container.activate((Object)USKFetcherTag.this.callback, 1);
                        if (USKFetcherTag.this.callback instanceof USKFetcherTagCallback) {
                            ((USKFetcherTagCallback)USKFetcherTag.this.callback).setTag(USKFetcherTag.this, container, context);
                        }
                        USKFetcherTag.this.callback.onCancelled(container, context);
                        USKFetcherTag.this.removeFrom(container, context);
                        container.deactivate((Object)USKFetcherTag.this.callback, 1);
                        return false;
                    }
                }, NativeThread.HIGH_PRIORITY);
            }
            catch (DatabaseDisabledException databaseDisabledException) {}
        } else {
            if (this.callback instanceof USKFetcherTagCallback) {
                ((USKFetcherTagCallback)this.callback).setTag(this, container, context);
            }
            this.callback.onCancelled(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Failed on " + this);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            if (this.finished) {
                Logger.error(this, "onFailure called after finish on " + this, (Throwable)new Exception("error"));
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            if (container != null) {
                container.activate((Object)this.callback, 1);
                if (this.callback instanceof USKFetcherTagCallback) {
                    ((USKFetcherTagCallback)this.callback).setTag(this, container, context);
                }
                this.callback.onFailure(container, context);
                container.deactivate((Object)this.callback, 1);
                this.removeFrom(container, context);
            } else {
                try {
                    context.jobRunner.queue(new DBJob(){

                        @Override
                        public boolean run(ObjectContainer container, ClientContext context) {
                            container.activate((Object)USKFetcherTag.this, 1);
                            container.activate((Object)USKFetcherTag.this.callback, 1);
                            if (USKFetcherTag.this.callback instanceof USKFetcherTagCallback) {
                                ((USKFetcherTagCallback)USKFetcherTag.this.callback).setTag(USKFetcherTag.this, container, context);
                            }
                            USKFetcherTag.this.callback.onFailure(container, context);
                            container.deactivate((Object)USKFetcherTag.this.callback, 1);
                            USKFetcherTag.this.removeFrom(container, context);
                            return true;
                        }
                    }, NativeThread.HIGH_PRIORITY, false);
                }
                catch (DatabaseDisabledException databaseDisabledException) {}
            }
        } else {
            if (this.callback instanceof USKFetcherTagCallback) {
                ((USKFetcherTagCallback)this.callback).setTag(this, container, context);
            }
            this.callback.onFailure(container, context);
        }
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.pollingPriorityNormal;
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.pollingPriorityProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(final long l, final USK key, ObjectContainer container, ClientContext context, final boolean metadata, final short codec, final byte[] data, final boolean newKnownGood, final boolean newSlotToo) {
        if (logMINOR) {
            Logger.minor(this, "Found edition " + l + " on " + this);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            if (this.fetcher == null) {
                Logger.error(this, "onFoundEdition but fetcher is null - isn't onFoundEdition() terminal for USKFetcherCallback's??", (Throwable)new Exception("debug"));
            }
            if (this.finished) {
                Logger.error(this, "onFoundEdition called after finish on " + this, (Throwable)new Exception("error"));
                return;
            }
            this.finished = true;
            this.fetcher = null;
        }
        if (this.persistent) {
            if (container != null) {
                container.activate((Object)this.callback, 1);
                if (this.callback instanceof USKFetcherTagCallback) {
                    ((USKFetcherTagCallback)this.callback).setTag(this, container, context);
                }
                this.callback.onFoundEdition(l, key, container, context, metadata, codec, data, newKnownGood, newSlotToo);
                container.deactivate((Object)this.callback, 1);
                this.removeFrom(container, context);
            } else {
                try {
                    context.jobRunner.queue(new DBJob(){

                        @Override
                        public boolean run(ObjectContainer container, ClientContext context) {
                            container.activate((Object)USKFetcherTag.this.callback, 1);
                            if (USKFetcherTag.this.callback instanceof USKFetcherTagCallback) {
                                ((USKFetcherTagCallback)USKFetcherTag.this.callback).setTag(USKFetcherTag.this, container, context);
                            }
                            USKFetcherTag.this.callback.onFoundEdition(l, key, container, context, metadata, codec, data, newKnownGood, newSlotToo);
                            container.deactivate((Object)USKFetcherTag.this.callback, 1);
                            USKFetcherTag.this.removeFrom(container, context);
                            return false;
                        }
                    }, NativeThread.HIGH_PRIORITY, false);
                }
                catch (DatabaseDisabledException e) {}
            }
        } else {
            if (this.callback instanceof USKFetcherTagCallback) {
                ((USKFetcherTagCallback)this.callback).setTag(this, container, context);
            }
            this.callback.onFoundEdition(l, key, container, context, metadata, codec, data, newKnownGood, newSlotToo);
        }
    }

    public final boolean isFinished() {
        return this.finished;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + this);
        }
        container.activate((Object)this.origUSK, 5);
        this.origUSK.removeFrom(container);
        if (this.ownFetchContext) {
            container.activate((Object)this.ctx, 1);
            this.ctx.removeFrom(container);
        }
        container.delete((Object)this);
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

