/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.StreamGenerator;
import freenet.crypt.HashResult;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.support.compress.Compressor;
import java.util.List;

public class USKProxyCompletionCallback
implements GetCompletionCallback {
    final USK usk;
    final GetCompletionCallback cb;
    final boolean persistent;

    public USKProxyCompletionCallback(USK usk, GetCompletionCallback cb, boolean persistent) {
        this.usk = usk;
        this.cb = cb;
        this.persistent = persistent;
    }

    @Override
    public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ObjectContainer container, ClientContext context) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
            container.activate((Object)this.usk, 5);
        }
        context.uskManager.updateKnownGood(this.usk, this.usk.suggestedEdition, context);
        this.cb.onSuccess(streamGenerator, clientMetadata, decompressors, state, container, context);
        if (this.persistent) {
            this.removeFrom(container);
        }
    }

    private void removeFrom(ObjectContainer container) {
        container.activate((Object)this.usk, 5);
        this.usk.removeFrom(container);
        container.delete((Object)this);
    }

    @Override
    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
        FreenetURI uri;
        switch (e.mode) {
            case 24: 
            case 27: {
                context.uskManager.updateKnownGood(this.usk, this.usk.suggestedEdition, context);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
            container.activate((Object)this.usk, 5);
        }
        if ((uri = e.newURI) != null) {
            uri = this.usk.turnMySSKIntoUSK(uri);
            e = new FetchException(e, uri);
        }
        this.cb.onFailure(e, state, container, context);
        if (this.persistent) {
            this.removeFrom(container);
        }
    }

    @Override
    public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onBlockSetFinished(state, container, context);
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    @Override
    public void onExpectedMIME(ClientMetadata metadata, ObjectContainer container, ClientContext context) throws FetchException {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onExpectedMIME(metadata, container, context);
    }

    @Override
    public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onExpectedSize(size, container, context);
    }

    @Override
    public void onFinalizedMetadata(ObjectContainer container) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFinalizedMetadata(container);
    }

    @Override
    public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ObjectContainer container, ClientContext context) {
        this.cb.onExpectedTopSize(size, compressed, blocksReq, blocksTotal, container, context);
    }

    @Override
    public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean dontCompress, boolean bottomLayer, boolean definitiveAnyway, ObjectContainer container, ClientContext context) {
        this.cb.onSplitfileCompatibilityMode(min, max, splitfileKey, dontCompress, bottomLayer, definitiveAnyway, container, context);
    }

    @Override
    public void onHashes(HashResult[] hashes, ObjectContainer container, ClientContext context) {
        this.cb.onHashes(hashes, container, context);
    }
}

