/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import com.db4o.ObjectContainer;
import freenet.crypt.AEADInputStream;
import freenet.crypt.AEADOutputStream;
import freenet.node.NodeStarter;
import freenet.support.api.Bucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class AEADCryptBucket
implements Bucket {
    private final Bucket underlying;
    private final byte[] key;
    private boolean readOnly;
    static final int OVERHEAD = 32;

    public AEADCryptBucket(Bucket underlying, byte[] key) {
        this.underlying = underlying;
        this.key = Arrays.copyOf(key, key.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        AEADCryptBucket aEADCryptBucket = this;
        synchronized (aEADCryptBucket) {
            if (this.readOnly) {
                throw new IOException("Read only");
            }
        }
        OutputStream os = this.underlying.getOutputStream();
        return AEADOutputStream.createAES(os, this.key, NodeStarter.getGlobalSecureRandom());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.underlying.getInputStream();
        return AEADInputStream.createAES(is, this.key);
    }

    @Override
    public String getName() {
        return "AEADEncrypted:" + this.underlying.getName();
    }

    @Override
    public long size() {
        return this.underlying.size() - 32L;
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public void free() {
        this.underlying.free();
    }

    @Override
    public void storeTo(ObjectContainer container) {
        this.underlying.storeTo(container);
        container.store((Object)this);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        this.underlying.removeFrom(container);
        container.delete((Object)this);
    }

    @Override
    public Bucket createShadow() {
        Bucket undershadow = this.underlying.createShadow();
        AEADCryptBucket ret = new AEADCryptBucket(undershadow, this.key);
        ret.setReadOnly();
        return ret;
    }
}

