/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.crypt.SHA256;
import freenet.keys.CHKVerifyException;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.support.Fields;
import java.security.MessageDigest;
import java.util.Arrays;

public class CHKBlock
implements KeyBlock {
    final byte[] data;
    final byte[] headers;
    final short hashIdentifier;
    final NodeCHK chk;
    final int hashCode;
    public static final int MAX_LENGTH_BEFORE_COMPRESSION = Integer.MAX_VALUE;
    public static final int TOTAL_HEADERS_LENGTH = 36;
    public static final int DATA_LENGTH = 32768;
    public static final int MAX_COMPRESSED_DATA_LENGTH = 32764;

    public String toString() {
        return super.toString() + ": chk=" + this.chk;
    }

    public byte[] getHeaders() {
        return this.headers;
    }

    public byte[] getData() {
        return this.data;
    }

    public static CHKBlock construct(byte[] data, byte[] header, byte cryptoAlgorithm) throws CHKVerifyException {
        return new CHKBlock(data, header, null, true, cryptoAlgorithm);
    }

    public CHKBlock(byte[] data2, byte[] header2, NodeCHK key) throws CHKVerifyException {
        this(data2, header2, key, key.cryptoAlgorithm);
    }

    public CHKBlock(byte[] data2, byte[] header2, NodeCHK key, byte cryptoAlgorithm) throws CHKVerifyException {
        this(data2, header2, key, true, cryptoAlgorithm);
    }

    public CHKBlock(byte[] data2, byte[] header2, NodeCHK key, boolean verify, byte cryptoAlgorithm) throws CHKVerifyException {
        this.data = data2;
        this.headers = header2;
        if (this.headers.length != 36) {
            throw new IllegalArgumentException("Wrong length: " + this.headers.length + " should be " + 36);
        }
        this.hashIdentifier = (short)(((this.headers[0] & 0xFF) << 8) + (this.headers[1] & 0xFF));
        if (key != null && !verify) {
            this.chk = key;
            this.hashCode = key.hashCode() ^ Fields.hashCode(this.data) ^ Fields.hashCode(this.headers) ^ cryptoAlgorithm;
            return;
        }
        if (this.hashIdentifier != 1) {
            throw new CHKVerifyException("Hash not SHA-256");
        }
        MessageDigest md = SHA256.getMessageDigest();
        md.update(this.headers);
        md.update(this.data);
        byte[] hash = md.digest();
        SHA256.returnMessageDigest(md);
        if (key == null) {
            this.chk = new NodeCHK(hash, cryptoAlgorithm);
        } else {
            this.chk = key;
            byte[] check = this.chk.routingKey;
            if (!Arrays.equals(hash, check)) {
                throw new CHKVerifyException("Hash does not verify");
            }
        }
        this.hashCode = this.chk.hashCode() ^ Fields.hashCode(this.data) ^ Fields.hashCode(this.headers) ^ cryptoAlgorithm;
    }

    @Override
    public NodeCHK getKey() {
        return this.chk;
    }

    @Override
    public byte[] getRawHeaders() {
        return this.headers;
    }

    @Override
    public byte[] getRawData() {
        return this.data;
    }

    @Override
    public byte[] getPubkeyBytes() {
        return null;
    }

    @Override
    public byte[] getFullKey() {
        return this.getKey().getFullKey();
    }

    @Override
    public byte[] getRoutingKey() {
        return this.getKey().getRoutingKey();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CHKBlock)) {
            return false;
        }
        CHKBlock block = (CHKBlock)o;
        if (!this.chk.equals(block.chk)) {
            return false;
        }
        if (!Arrays.equals(this.data, block.data)) {
            return false;
        }
        if (!Arrays.equals(this.headers, block.headers)) {
            return false;
        }
        return this.hashIdentifier == block.hashIdentifier;
    }

    public boolean objectCanNew(ObjectContainer container) {
        throw new UnsupportedOperationException("Block set storage in database not supported");
    }
}

