/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.io.IoAdapter;
import freenet.crypt.EncryptingIoAdapter;
import freenet.crypt.HMAC;
import freenet.crypt.RandomSource;
import java.io.UnsupportedEncodingException;
import org.bouncycastle.util.Arrays;

public class DatabaseKey {
    private final byte[] databaseKey;
    private final RandomSource random;
    private static final byte[] PLUGIN;

    DatabaseKey(byte[] key, RandomSource random) {
        this.databaseKey = Arrays.copyOf((byte[])key, (int)key.length);
        this.random = random;
    }

    public EncryptingIoAdapter createEncryptingDb4oAdapter(IoAdapter baseAdapter) {
        return new EncryptingIoAdapter(baseAdapter, this.databaseKey, this.random);
    }

    public static DatabaseKey createRandom(RandomSource random) {
        byte[] databaseKey = new byte[32];
        random.nextBytes(databaseKey);
        return new DatabaseKey(databaseKey, random);
    }

    public byte[] getPluginStoreKey(String storeIdentifier) {
        try {
            byte[] id = storeIdentifier.getBytes("UTF-8");
            byte[] full = new byte[this.databaseKey.length + PLUGIN.length + id.length];
            int x = 0;
            System.arraycopy(this.databaseKey, 0, full, 0, this.databaseKey.length);
            System.arraycopy(PLUGIN, 0, full, x += this.databaseKey.length, PLUGIN.length);
            System.arraycopy(id, 0, full, x += PLUGIN.length, id.length);
            return HMAC.macWithSHA256(this.databaseKey, full, 32);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    static {
        try {
            PLUGIN = "PLUGIN".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }
}

