/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.PCFBMode;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.node.DatabaseKey;
import freenet.node.MasterKeysFileSizeException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.support.Fields;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Arrays;

public class MasterKeys {
    final byte[] clientCacheMasterKey;
    private final byte[] databaseKey;
    final long flags;
    static final long FLAG_ENCRYPT_DATABASE = 2L;
    static final int HASH_LENGTH = 4;

    public MasterKeys(byte[] clientCacheKey, byte[] databaseKey, long flags) {
        this.clientCacheMasterKey = clientCacheKey;
        this.databaseKey = databaseKey;
        this.flags = flags;
    }

    void clearClientCacheKeys() {
        MasterKeys.clear(this.clientCacheMasterKey);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MasterKeys read(File masterKeysFile, RandomSource hardRandom, String password) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        Rijndael cipher;
        block15: {
            System.err.println("Trying to read master keys file...");
            if (masterKeysFile != null) {
                MasterKeys masterKeys;
                FileInputStream fis = null;
                try {
                    Rijndael cipher2;
                    fis = new FileInputStream(masterKeysFile);
                    DataInputStream dis = new DataInputStream(fis);
                    byte[] salt = new byte[32];
                    dis.readFully(salt);
                    byte[] iv = new byte[32];
                    dis.readFully(iv);
                    int length = (int)Math.min(Integer.MAX_VALUE, masterKeysFile.length());
                    if (masterKeysFile.length() > 1024L) {
                        throw new MasterKeysFileSizeException(true);
                    }
                    if (masterKeysFile.length() < 104L) {
                        throw new MasterKeysFileSizeException(false);
                    }
                    byte[] dataAndHash = new byte[length - salt.length - iv.length];
                    dis.readFully(dataAndHash);
                    byte[] pwd = password.getBytes("UTF-8");
                    MessageDigest md = SHA256.getMessageDigest();
                    md.update(pwd);
                    md.update(salt);
                    byte[] outerKey = md.digest();
                    try {
                        cipher2 = new Rijndael(256, 256);
                    }
                    catch (UnsupportedCipherException e) {
                        throw new Error(e);
                    }
                    cipher2.initialize(outerKey);
                    PCFBMode pcfb = PCFBMode.create(cipher2, iv);
                    pcfb.blockDecipher(dataAndHash, 0, dataAndHash.length);
                    byte[] data = Arrays.copyOf(dataAndHash, dataAndHash.length - 4);
                    byte[] hash = Arrays.copyOfRange(dataAndHash, data.length, dataAndHash.length);
                    MasterKeys.clear(dataAndHash);
                    byte[] checkHash = md.digest(data);
                    if (!Fields.byteArrayEqual(checkHash, hash, 0, 0, 4)) {
                        MasterKeys.clear(data);
                        MasterKeys.clear(hash);
                        throw new MasterKeysWrongPasswordException();
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    dis = new DataInputStream(bais);
                    byte[] flagsBytes = new byte[8];
                    dis.readFully(flagsBytes);
                    long flags = Fields.bytesToLong(flagsBytes);
                    byte[] clientCacheKey = new byte[32];
                    dis.readFully(clientCacheKey);
                    byte[] databaseKey = null;
                    databaseKey = new byte[32];
                    dis.readFully(databaseKey);
                    MasterKeys ret = new MasterKeys(clientCacheKey, databaseKey, flags);
                    MasterKeys.clear(data);
                    MasterKeys.clear(hash);
                    SHA256.returnMessageDigest(md);
                    System.err.println("Read old master keys file");
                    masterKeys = ret;
                }
                catch (FileNotFoundException e) {
                    Closer.close(fis);
                    break block15;
                    catch (UnsupportedEncodingException e2) {
                        try {
                            System.err.println("JVM doesn't support UTF-8, this should be impossible!");
                            throw new Error(e2);
                            catch (EOFException e3) {
                                throw new MasterKeysFileSizeException(false);
                            }
                        }
                        catch (Throwable throwable) {
                            Closer.close(fis);
                            throw throwable;
                        }
                    }
                }
                Closer.close(fis);
                return masterKeys;
            }
        }
        System.err.println("Creating new master keys file");
        byte[] clientCacheKey = new byte[32];
        hardRandom.nextBytes(clientCacheKey);
        byte[] databaseKey = new byte[32];
        hardRandom.nextBytes(databaseKey);
        byte[] iv = new byte[32];
        hardRandom.nextBytes(iv);
        byte[] salt = new byte[32];
        hardRandom.nextBytes(salt);
        FileOutputStream fos = new FileOutputStream(masterKeysFile);
        long flags = 0L;
        byte[] flagBytes = Fields.longToBytes(flags);
        byte[] data = new byte[flagBytes.length + clientCacheKey.length + databaseKey.length + 4];
        int offset = 0;
        System.arraycopy(flagBytes, 0, data, offset, flagBytes.length);
        System.arraycopy(clientCacheKey, 0, data, offset += flagBytes.length, clientCacheKey.length);
        System.arraycopy(databaseKey, 0, data, offset += clientCacheKey.length, databaseKey.length);
        MessageDigest md = SHA256.getMessageDigest();
        md.update(data, 0, offset += databaseKey.length);
        byte[] hash = md.digest();
        System.arraycopy(hash, 0, data, offset, 4);
        offset += 4;
        byte[] pwd = password.getBytes("UTF-8");
        md.update(pwd);
        md.update(salt);
        byte[] outerKey = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        cipher.initialize(outerKey);
        PCFBMode pcfb = PCFBMode.create(cipher, iv);
        pcfb.blockEncipher(data, 0, data.length);
        fos.write(salt);
        fos.write(iv);
        fos.write(data);
        fos.close();
        MasterKeys.clear(data);
        MasterKeys.clear(hash);
        return new MasterKeys(clientCacheKey, databaseKey, flags);
    }

    public static void clear(byte[] buf) {
        if (buf == null) {
            return;
        }
        Arrays.fill(buf, (byte)0);
    }

    public void changePassword(File masterKeysFile, String newPassword, RandomSource hardRandom) throws IOException {
        Rijndael cipher;
        byte[] pwd;
        System.err.println("Writing new master.keys file");
        byte[] iv = new byte[32];
        hardRandom.nextBytes(iv);
        byte[] salt = new byte[32];
        hardRandom.nextBytes(salt);
        byte[] flagBytes = Fields.longToBytes(this.flags);
        byte[] data = new byte[iv.length + salt.length + flagBytes.length + this.clientCacheMasterKey.length + this.databaseKey.length + 4];
        int offset = 0;
        System.arraycopy(salt, 0, data, offset, salt.length);
        System.arraycopy(iv, 0, data, offset += salt.length, iv.length);
        int hashedStart = offset += iv.length;
        System.arraycopy(flagBytes, 0, data, offset, flagBytes.length);
        System.arraycopy(this.clientCacheMasterKey, 0, data, offset += flagBytes.length, this.clientCacheMasterKey.length);
        System.arraycopy(this.databaseKey, 0, data, offset += this.clientCacheMasterKey.length, this.databaseKey.length);
        MessageDigest md = SHA256.getMessageDigest();
        md.update(data, hashedStart, (offset += this.databaseKey.length) - hashedStart);
        byte[] hash = md.digest();
        System.arraycopy(hash, 0, data, offset, 4);
        offset += 4;
        try {
            pwd = newPassword.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        md.update(pwd);
        md.update(salt);
        byte[] outerKey = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        cipher.initialize(outerKey);
        PCFBMode pcfb = PCFBMode.create(cipher, iv);
        pcfb.blockEncipher(data, iv.length + salt.length, data.length - iv.length - salt.length);
        RandomAccessFile raf = new RandomAccessFile(masterKeysFile, "rw");
        raf.seek(0L);
        raf.write(data);
        long len = raf.length();
        if (len > (long)data.length) {
            byte[] diff = new byte[(int)(len - (long)data.length)];
            raf.write(diff);
            raf.setLength(data.length);
        }
        raf.getFD().sync();
        raf.close();
    }

    public static void killMasterKeys(File masterKeysFile) throws IOException {
        FileUtil.secureDelete(masterKeysFile);
    }

    public void clearAllNotClientCacheKey() {
        MasterKeys.clear(this.databaseKey);
    }

    public void clearAllNotDatabaseKey() {
        MasterKeys.clear(this.clientCacheMasterKey);
    }

    public void clearAll() {
        MasterKeys.clear(this.clientCacheMasterKey);
        MasterKeys.clear(this.databaseKey);
    }

    public void clearAllNotClientCacheKeyOrDatabaseKey() {
    }

    public DatabaseKey createDatabaseKey(RandomSource random) {
        return new DatabaseKey(this.databaseKey, random);
    }
}

