/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.FreenetFilePersistentConfig;
import freenet.config.InvalidConfigValueException;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.crypt.DiffieHellman;
import freenet.crypt.JceLoader;
import freenet.crypt.RandomSource;
import freenet.crypt.SSL;
import freenet.crypt.Yarrow;
import freenet.node.DNSRequester;
import freenet.node.ExtVersion;
import freenet.node.LoggingConfigHandler;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.SemiOrderedShutdownHook;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class NodeStarter
implements WrapperListener {
    private Node node;
    private static LoggingConfigHandler logConfigHandler;
    public static final int extBuildNumber;
    public static final String extRevisionNumber;
    private FreenetFilePersistentConfig cfg;
    private static NodeStarter nodestarter_osgi;
    private static boolean isTestingVM;
    private static boolean isStarted;
    static SemiOrderedShutdownHook shutdownHook;
    private static SecureRandom globalSecureRandom;

    public static synchronized boolean isTestingVM() {
        if (isStarted) {
            return isTestingVM;
        }
        throw new IllegalStateException();
    }

    private NodeStarter() {
        JceLoader.dumpLoaded();
    }

    public NodeStarter get() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        Class<NodeStarter> clazz = NodeStarter.class;
        synchronized (NodeStarter.class) {
            File configFilename;
            if (isStarted) {
                throw new IllegalStateException();
            }
            isStarted = true;
            isTestingVM = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (args.length > 1) {
                System.out.println("Usage: $ java freenet.node.Node <configFile>");
                return -1;
            }
            String builtWithMessage = "freenet.jar built with freenet-ext.jar Build #29 rv29 running with ext build " + extBuildNumber + " r" + extRevisionNumber;
            Logger.normal(this, builtWithMessage);
            System.out.println(builtWithMessage);
            if (args.length == 0) {
                System.out.println("Using default config filename freenet.ini");
                configFilename = new File("freenet.ini");
            } else {
                configFilename = new File(args[0]);
            }
            Security.setProperty("networkaddress.cache.ttl", "0");
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
            try {
                System.out.println("Creating config from " + configFilename);
                this.cfg = FreenetFilePersistentConfig.constructFreenetFilePersistentConfig(configFilename);
            }
            catch (IOException e) {
                System.out.println("Error : " + e);
                e.printStackTrace();
                return -1;
            }
            SubConfig loggingConfig = new SubConfig("logger", this.cfg);
            PooledExecutor executor = new PooledExecutor();
            try {
                System.out.println("Creating logger...");
                logConfigHandler = new LoggingConfigHandler(loggingConfig, executor);
            }
            catch (InvalidConfigValueException e) {
                System.err.println("Error: could not set up logging: " + e.getMessage());
                e.printStackTrace();
                return -2;
            }
            System.out.println("Starting executor...");
            executor.start();
            WrapperManager.signalStarting((int)500000);
            Runnable useless = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(TimeUnit.MINUTES.toMillis(60L));
                            }
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        catch (Throwable t) {
                            try {
                                Logger.error(this, "Caught " + t, t);
                            }
                            catch (Throwable throwable) {
                            }
                            continue;
                        }
                        break;
                    }
                }
            };
            NativeThread plug = new NativeThread(useless, "Plug", NativeThread.MAX_PRIORITY, false);
            plug.setDaemon(false);
            plug.start();
            SubConfig sslConfig = new SubConfig("ssl", this.cfg);
            SSL.init(sslConfig);
            try {
                this.node = new Node(this.cfg, null, null, logConfigHandler, this, executor);
                this.node.start(false);
                System.out.println("Node initialization completed.");
            }
            catch (NodeInitException e) {
                System.err.println("Failed to load node: " + e.exitCode + " : " + e.getMessage());
                e.printStackTrace();
                System.exit(e.exitCode);
            }
            return null;
        }
    }

    public int stop(int exitCode) {
        System.err.println("Shutting down with exit code " + exitCode);
        this.node.park();
        WrapperManager.signalStopping((int)120000);
        return exitCode;
    }

    public void restart() {
        WrapperManager.restart();
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new NodeStarter(), (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomSource globalTestInit(String testName, boolean enablePlug, Logger.LogLevel logThreshold, String details, boolean noDNS) throws LoggerHook.InvalidThresholdException {
        Class<NodeStarter> clazz = NodeStarter.class;
        synchronized (NodeStarter.class) {
            if (isStarted) {
                throw new IllegalStateException();
            }
            isStarted = true;
            isTestingVM = true;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            File dir = new File(testName);
            if (!(dir.mkdir() || dir.exists() && dir.isDirectory())) {
                System.err.println("Cannot create directory for test");
                System.exit(25);
            }
            Logger.setupStdoutLogging(logThreshold, details);
            Security.setProperty("networkaddress.cache.ttl", "0");
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
            Yarrow random = new Yarrow();
            DiffieHellman.init(random);
            if (enablePlug) {
                Runnable useless = new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(TimeUnit.MINUTES.toMillis(60L));
                                }
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            catch (Throwable t) {
                                try {
                                    Logger.error(this, "Caught " + t, t);
                                }
                                catch (Throwable throwable) {
                                }
                                continue;
                            }
                            break;
                        }
                    }
                };
                Thread plug = new Thread(useless, "Plug");
                plug.setDaemon(false);
                plug.start();
            }
            DNSRequester.DISABLE = noDNS;
            return random;
        }
    }

    public static Node createTestNode(int port, int opennetPort, String testName, boolean disableProbabilisticHTLs, short maxHTL, int dropProb, RandomSource random, Executor executor, int threadLimit, long storeSize, boolean ramStore, boolean enableSwapping, boolean enableARKs, boolean enableULPRs, boolean enablePerNodeFailureTables, boolean enableSwapQueueing, boolean enablePacketCoalescing, int outputBandwidthLimit, boolean enableFOAF, boolean connectToSeednodes, boolean longPingTimes, boolean useSlashdotCache, String ipAddressOverride) throws NodeInitException {
        return NodeStarter.createTestNode(port, opennetPort, testName, disableProbabilisticHTLs, maxHTL, dropProb, random, executor, threadLimit, storeSize, ramStore, enableSwapping, enableARKs, enableULPRs, enablePerNodeFailureTables, enableSwapQueueing, enablePacketCoalescing, outputBandwidthLimit, enableFOAF, connectToSeednodes, longPingTimes, useSlashdotCache, ipAddressOverride, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node createTestNode(int port, int opennetPort, String testName, boolean disableProbabilisticHTLs, short maxHTL, int dropProb, RandomSource random, Executor executor, int threadLimit, long storeSize, boolean ramStore, boolean enableSwapping, boolean enableARKs, boolean enableULPRs, boolean enablePerNodeFailureTables, boolean enableSwapQueueing, boolean enablePacketCoalescing, int outputBandwidthLimit, boolean enableFOAF, boolean connectToSeednodes, boolean longPingTimes, boolean useSlashdotCache, String ipAddressOverride, boolean enableFCP) throws NodeInitException {
        Class<NodeStarter> clazz = NodeStarter.class;
        synchronized (NodeStarter.class) {
            if (!isStarted || !isTestingVM) {
                throw new IllegalStateException("Call globalTestInit() first!");
            }
            // ** MonitorExit[var25_24] (shouldn't be in output)
            File baseDir = new File(testName);
            File portDir = new File(baseDir, Integer.toString(port));
            if (!(portDir.mkdir() || portDir.exists() && portDir.isDirectory())) {
                System.err.println("Cannot create directory for test");
                System.exit(25);
            }
            SimpleFieldSet configFS = new SimpleFieldSet(false);
            if (outputBandwidthLimit > 0) {
                configFS.put("node.outputBandwidthLimit", outputBandwidthLimit);
                configFS.put("node.throttleLocalTraffic", true);
            } else {
                configFS.put("node.outputBandwidthLimit", 0x1000000);
                configFS.put("node.throttleLocalTraffic", false);
            }
            configFS.put("node.useSlashdotCache", useSlashdotCache);
            configFS.put("node.listenPort", port);
            configFS.put("node.disableProbabilisticHTLs", disableProbabilisticHTLs);
            configFS.put("fproxy.enabled", false);
            configFS.put("fcp.enabled", enableFCP);
            configFS.put("fcp.port", 9481);
            configFS.put("fcp.ssl", false);
            configFS.put("console.enabled", false);
            configFS.putSingle("pluginmanager.loadplugin", "");
            configFS.put("node.updater.enabled", false);
            configFS.putSingle("node.install.tempDir", new File(portDir, "temp").toString());
            configFS.putSingle("node.install.storeDir", new File(portDir, "store").toString());
            configFS.put("fcp.persistentDownloadsEnabled", false);
            configFS.putSingle("node.throttleFile", new File(portDir, "throttle.dat").toString());
            configFS.putSingle("node.install.nodeDir", portDir.toString());
            configFS.putSingle("node.install.userDir", portDir.toString());
            configFS.putSingle("node.install.runDir", portDir.toString());
            configFS.putSingle("node.install.cfgDir", portDir.toString());
            configFS.put("node.maxHTL", maxHTL);
            configFS.put("node.testingDropPacketsEvery", dropProb);
            configFS.put("node.alwaysAllowLocalAddresses", true);
            configFS.put("node.includeLocalAddressesInNoderefs", true);
            configFS.put("node.enableARKs", false);
            configFS.put("node.load.threadLimit", threadLimit);
            if (ramStore) {
                configFS.putSingle("node.storeType", "ram");
            }
            configFS.put("node.storeSize", storeSize);
            configFS.put("node.disableHangCheckers", true);
            configFS.put("node.enableSwapping", enableSwapping);
            configFS.put("node.enableSwapQueueing", enableSwapQueueing);
            configFS.put("node.enableARKs", enableARKs);
            configFS.put("node.enableULPRDataPropagation", enableULPRs);
            configFS.put("node.enablePerNodeFailureTables", enablePerNodeFailureTables);
            configFS.put("node.enablePacketCoalescing", enablePacketCoalescing);
            configFS.put("node.publishOurPeersLocation", enableFOAF);
            configFS.put("node.routeAccordingToOurPeersLocation", enableFOAF);
            configFS.put("node.opennet.enabled", opennetPort > 0);
            configFS.put("node.opennet.listenPort", opennetPort);
            configFS.put("node.opennet.alwaysAllowLocalAddresses", true);
            configFS.put("node.opennet.oneConnectionPerIP", false);
            configFS.put("node.opennet.assumeNATed", true);
            configFS.put("node.opennet.connectToSeednodes", connectToSeednodes);
            configFS.put("node.encryptTempBuckets", false);
            configFS.put("node.encryptPersistentTempBuckets", false);
            configFS.put("node.enableRoutedPing", true);
            if (ipAddressOverride != null) {
                configFS.putSingle("node.ipAddressOverride", ipAddressOverride);
            }
            if (longPingTimes) {
                configFS.put("node.maxPingTime", 100000);
                configFS.put("node.subMaxPingTime", 50000);
            }
            configFS.put("node.respondBandwidth", true);
            configFS.put("node.respondBuild", true);
            configFS.put("node.respondIdentifier", true);
            configFS.put("node.respondLinkLengths", true);
            configFS.put("node.respondLocation", true);
            configFS.put("node.respondStoreSize", true);
            configFS.put("node.respondUptime", true);
            PersistentConfig config = new PersistentConfig(configFS);
            Node node = new Node(config, random, random, null, null, executor);
            node.peers.removeAllPeers();
            return node;
        }
    }

    public static void start_osgi(String[] args) {
        nodestarter_osgi = new NodeStarter();
        nodestarter_osgi.start(args);
    }

    public static void stop_osgi(int exitCode) {
        nodestarter_osgi.stop(exitCode);
        nodestarter_osgi = null;
    }

    public static long getMemoryLimitMB() {
        long limit = NodeStarter.getMemoryLimitBytes();
        if (limit <= 0L) {
            return limit;
        }
        if (limit == Long.MAX_VALUE) {
            return -2L;
        }
        if ((limit /= 0x100000L) > Integer.MAX_VALUE) {
            return -1L;
        }
        return limit;
    }

    public static long getMemoryLimitBytes() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            return maxMemory;
        }
        if (maxMemory <= 0L) {
            return -1L;
        }
        if (maxMemory < 0x100000L) {
            return maxMemory * 1024L * 1024L;
        }
        return maxMemory;
    }

    public static synchronized SecureRandom getGlobalSecureRandom() {
        if (globalSecureRandom == null) {
            globalSecureRandom = new SecureRandom();
            globalSecureRandom.nextBytes(new byte[16]);
        }
        return globalSecureRandom;
    }

    static {
        extBuildNumber = ExtVersion.extBuildNumber();
        extRevisionNumber = ExtVersion.extRevisionNumber();
        nodestarter_osgi = null;
    }
}

