/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.CryptFormatException;
import freenet.crypt.DSAPublicKey;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerRestartedException;
import freenet.io.xfer.WaitedTooLongException;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.RequestHandler;
import freenet.node.SSKInsertSender;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.store.KeyCollisionException;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.io.NativeThread;

public class SSKInsertHandler
implements PrioRunnable,
ByteCounter {
    private static boolean logMINOR;
    static final int DATA_INSERT_TIMEOUT = 30000;
    final Node node;
    final long uid;
    final PeerNode source;
    final NodeSSK key;
    final long startTime;
    private SSKBlock block;
    private DSAPublicKey pubKey;
    private short htl;
    private SSKInsertSender sender;
    private byte[] data;
    private byte[] headers;
    private boolean canCommit;
    final InsertTag tag;
    private final boolean canWriteDatastore;
    private final boolean forkOnCacheable;
    private final boolean preferInsert;
    private final boolean ignoreLowBackoff;
    private final boolean realTimeFlag;
    private boolean collided = false;
    private final Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;

    SSKInsertHandler(NodeSSK key, byte[] data, byte[] headers, short htl, PeerNode source, long id, Node node, long startTime, InsertTag tag, boolean canWriteDatastore, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        this.node = node;
        this.uid = id;
        this.source = source;
        this.startTime = startTime;
        this.key = key;
        this.htl = htl;
        this.data = data;
        this.headers = headers;
        this.tag = tag;
        this.canWriteDatastore = canWriteDatastore;
        byte[] pubKeyHash = key.getPubKeyHash();
        this.pubKey = node.getPubKey.getKey(pubKeyHash, false, false, null);
        this.canCommit = false;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.forkOnCacheable = forkOnCacheable;
        this.preferInsert = preferInsert;
        this.ignoreLowBackoff = ignoreLowBackoff;
        this.realTimeFlag = realTimeFlag;
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.realRun();
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
        finally {
            if (logMINOR) {
                Logger.minor(this, "Exiting InsertHandler.run() for " + this.uid);
            }
            this.tag.unlockHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        Message msg;
        int status;
        Message accepted = DMT.createFNPSSKAccepted(this.uid, this.pubKey == null);
        try {
            this.source.sendAsync(accepted, null, this);
        }
        catch (NotConnectedException e1) {
            if (logMINOR) {
                Logger.minor(this, "Lost connection to source");
            }
            return;
        }
        if (this.tag.shouldSlowDown()) {
            try {
                this.source.sendAsync(DMT.createFNPRejectedOverload(this.uid, false, false, this.realTimeFlag), null, this);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
        }
        while (this.headers == null || this.data == null || this.pubKey == null) {
            Message msg2;
            MessageFilter m;
            MessageFilter mfDataInsertRejected;
            MessageFilter mf = mfDataInsertRejected = MessageFilter.create().setType(DMT.FNPDataInsertRejected).setField("uid", this.uid).setSource(this.source).setTimeout(30000L);
            if (this.headers == null) {
                m = MessageFilter.create().setType(DMT.FNPSSKInsertRequestHeaders).setField("uid", this.uid).setSource(this.source).setTimeout(30000L);
                mf = m.or(mf);
            }
            if (this.data == null) {
                m = MessageFilter.create().setType(DMT.FNPSSKInsertRequestData).setField("uid", this.uid).setSource(this.source).setTimeout(30000L);
                mf = m.or(mf);
            }
            if (this.pubKey == null) {
                m = MessageFilter.create().setType(DMT.FNPSSKPubKey).setField("uid", this.uid).setSource(this.source).setTimeout(30000L);
                mf = m.or(mf);
            }
            try {
                msg2 = this.node.usm.waitFor(mf, this);
            }
            catch (DisconnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
            if (msg2 == null) {
                Logger.normal(this, "Failed to receive all parts (data=" + (this.data == null ? "null" : "ok") + " headers=" + (this.headers == null ? "null" : "ok") + " pk=" + this.pubKey + ") for " + this.uid);
                Message failed = DMT.createFNPDataInsertRejected(this.uid, (short)2);
                try {
                    this.source.sendSync(failed, this, this.realTimeFlag);
                }
                catch (NotConnectedException e) {
                }
                catch (SyncSendWaitedTooLongException e) {
                    // empty catch block
                }
                return;
            }
            if (msg2.getSpec() == DMT.FNPSSKInsertRequestHeaders) {
                this.headers = ((ShortBuffer)msg2.getObject("blockHeaders")).getData();
                continue;
            }
            if (msg2.getSpec() == DMT.FNPSSKInsertRequestData) {
                this.data = ((ShortBuffer)msg2.getObject("data")).getData();
                continue;
            }
            if (msg2.getSpec() == DMT.FNPSSKPubKey) {
                byte[] pubkeyAsBytes = ((ShortBuffer)msg2.getObject("pubkeyAsBytes")).getData();
                try {
                    this.pubKey = DSAPublicKey.create(pubkeyAsBytes);
                    if (logMINOR) {
                        Logger.minor(this, "Got pubkey on " + this.uid + " : " + this.pubKey);
                    }
                    Message confirm = DMT.createFNPSSKPubKeyAccepted(this.uid);
                    try {
                        this.source.sendAsync(confirm, null, this);
                        continue;
                    }
                    catch (NotConnectedException e) {
                        if (logMINOR) {
                            Logger.minor(this, "Lost connection to source on " + this.uid);
                        }
                        return;
                    }
                }
                catch (CryptFormatException e) {
                    Logger.error(this, "Invalid pubkey from " + this.source + " on " + this.uid);
                    msg2 = DMT.createFNPDataInsertRejected(this.uid, (short)3);
                    try {
                        this.source.sendSync(msg2, this, this.realTimeFlag);
                    }
                    catch (NotConnectedException ee) {
                    }
                    catch (SyncSendWaitedTooLongException ee) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (msg2.getSpec() == DMT.FNPDataInsertRejected) {
                try {
                    this.source.sendAsync(DMT.createFNPDataInsertRejected(this.uid, msg2.getShort("dataInsertRejectedReason")), null, this);
                }
                catch (NotConnectedException e) {
                    // empty catch block
                }
                return;
            }
            Logger.error(this, "Unexpected message? " + msg2 + " on " + this);
        }
        try {
            this.key.setPubKey(this.pubKey);
            this.block = new SSKBlock(this.data, this.headers, this.key, false);
        }
        catch (SSKVerifyException e1) {
            Logger.error(this, "Invalid SSK from " + this.source, (Throwable)e1);
            Message msg3 = DMT.createFNPDataInsertRejected(this.uid, (short)3);
            try {
                this.source.sendSync(msg3, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
            }
            catch (SyncSendWaitedTooLongException e) {
                // empty catch block
            }
            return;
        }
        SSKBlock storedBlock = this.node.fetch(this.key, false, false, false, this.canWriteDatastore, false, null);
        if (storedBlock != null && !storedBlock.equals(this.block)) {
            try {
                RequestHandler.sendSSK(storedBlock.getRawHeaders(), storedBlock.getRawData(), false, this.pubKey, this.source, this.uid, this, this.realTimeFlag);
            }
            catch (NotConnectedException e1) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
            catch (WaitedTooLongException e1) {
                Logger.error(this, "Took too long to send ssk datareply to " + this.uid + " (because of throttling)");
                return;
            }
            catch (PeerRestartedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Source restarted on " + this.uid);
                }
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send ssk datareply to " + this.uid);
                return;
            }
            this.block = storedBlock;
        }
        if (logMINOR) {
            Logger.minor(this, "Got block for " + this.key + " for " + this.uid);
        }
        if (this.htl > 0) {
            this.sender = this.node.makeInsertSender(this.block, this.htl, this.uid, this.tag, this.source, false, false, this.canWriteDatastore, this.forkOnCacheable, this.preferInsert, this.ignoreLowBackoff, this.realTimeFlag);
        }
        boolean receivedRejectedOverload = false;
        do {
            SSKInsertSender e = this.sender;
            synchronized (e) {
                try {
                    if (this.sender.getStatus() == -1) {
                        this.sender.wait(5000L);
                    }
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            if (!receivedRejectedOverload && this.sender.receivedRejectedOverload()) {
                receivedRejectedOverload = true;
                Message m = DMT.createFNPRejectedOverload(this.uid, false, true, this.realTimeFlag);
                try {
                    this.source.sendAsync(m, null, this);
                }
                catch (NotConnectedException e3) {
                    if (logMINOR) {
                        Logger.minor(this, "Lost connection to source");
                    }
                    return;
                }
            }
            if (!this.sender.hasRecentlyCollided()) continue;
            this.data = this.sender.getData();
            this.headers = this.sender.getHeaders();
            this.collided = true;
            try {
                this.block = new SSKBlock(this.data, this.headers, this.key, true);
            }
            catch (SSKVerifyException e1) {
                throw new Error("Impossible: " + e1, e1);
            }
            try {
                RequestHandler.sendSSK(this.headers, this.data, false, this.pubKey, this.source, this.uid, this, this.realTimeFlag);
            }
            catch (NotConnectedException e1) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
            catch (WaitedTooLongException e1) {
                Logger.error(this, "Took too long to send ssk datareply to " + this.uid + " because of bwlimiting");
                return;
            }
            catch (PeerRestartedException e2) {
                Logger.error(this, "Peer restarted on " + this.uid);
                return;
            }
            catch (SyncSendWaitedTooLongException e3) {
                Logger.error(this, "Took too long to send ssk datareply to " + this.uid);
                return;
            }
        } while ((status = this.sender.getStatus()) == -1);
        if (status == 4 || status == 5 || status == 3) {
            this.tag.unlockHandler();
            msg = DMT.createFNPRejectedOverload(this.uid, true, true, this.realTimeFlag);
            try {
                this.source.sendSync(msg, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send " + msg + " to " + this.source);
                return;
            }
            if (status == 4 || status == 5) {
                this.canCommit = true;
            }
            this.finish(status);
            return;
        }
        if (status == 1 || status == 6) {
            this.tag.unlockHandler();
            msg = DMT.createFNPRouteNotFound(this.uid, this.sender.getHTL());
            try {
                this.source.sendSync(msg, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send " + msg + " to source");
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        if (status == 0) {
            this.tag.unlockHandler();
            msg = DMT.createFNPInsertReply(this.uid);
            try {
                this.source.sendSync(msg, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send " + msg + " to " + this.source);
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        Logger.error(this, "Unknown status code: " + this.sender.getStatusString());
        this.tag.unlockHandler();
        msg = DMT.createFNPRejectedOverload(this.uid, true, true, this.realTimeFlag);
        try {
            this.source.sendSync(msg, this, this.realTimeFlag);
        }
        catch (NotConnectedException e) {
        }
        catch (SyncSendWaitedTooLongException e) {
            Logger.error(this, "Took too long to send " + msg + " to " + this.source);
        }
        this.finish(status);
    }

    private void finish(int code) {
        if (logMINOR) {
            Logger.minor(this, "Finishing");
        }
        if (this.canCommit) {
            this.commit();
        }
        if (code != 4 && code != 5 && code != 3 && code != 6) {
            int totalSent = this.getTotalSentBytes();
            int totalReceived = this.getTotalReceivedBytes();
            if (this.sender != null) {
                totalSent += this.sender.getTotalSentBytes();
                totalReceived += this.sender.getTotalReceivedBytes();
            }
            if (logMINOR) {
                Logger.minor(this, "Remote SSK insert cost " + totalSent + '/' + totalReceived + " bytes (" + code + ')');
            }
            this.node.nodeStats.remoteSskInsertBytesSentAverage.report(totalSent);
            this.node.nodeStats.remoteSskInsertBytesReceivedAverage.report(totalReceived);
            if (code == 0) {
                this.node.nodeStats.successfulSskInsertBytesSentAverage.report(totalSent);
                this.node.nodeStats.successfulSskInsertBytesReceivedAverage.report(totalReceived);
            }
        }
    }

    private void commit() {
        try {
            this.node.store(this.block, this.node.shouldStoreDeep(this.key, this.source, this.sender == null ? new PeerNode[]{} : this.sender.getRoutedTo()), this.collided, false, this.canWriteDatastore, false);
        }
        catch (KeyCollisionException e) {
            Logger.normal(this, "Collision on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.insertSentBytes(true, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.insertReceivedBytes(true, x);
    }

    public int getTotalSentBytes() {
        return this.totalBytesSent;
    }

    public int getTotalReceivedBytes() {
        return this.totalBytesReceived;
    }

    @Override
    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.insertSentBytes(true, -x);
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }
}

