/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.support.SimpleFieldSet;
import java.util.concurrent.TimeUnit;

public class SeedClientPeerNode
extends PeerNode {
    public SeedClientPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, PeerManager peers, boolean fromLocal, boolean noSig, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        super(fs, node2, crypto, peers, fromLocal, noSig, mangler, true);
    }

    @Override
    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new PeerNodeStatus(this, noHeavy);
    }

    @Override
    public boolean isDarknet() {
        return false;
    }

    @Override
    public boolean isOpennet() {
        return false;
    }

    @Override
    public boolean isSeed() {
        return true;
    }

    @Override
    public boolean isRealConnection() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SeedClientPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public void onSuccess(boolean insert, boolean ssk) {
    }

    @Override
    public boolean isRoutingCompatible() {
        return false;
    }

    @Override
    public boolean canAcceptAnnouncements() {
        return true;
    }

    @Override
    public boolean recordStatus() {
        return false;
    }

    @Override
    public boolean handshakeUnknownInitiator() {
        return true;
    }

    @Override
    public int handshakeSetupType() {
        return 1;
    }

    @Override
    public boolean shouldSendHandshake() {
        return false;
    }

    @Override
    public boolean disconnected(boolean dumpMessageQueue, boolean dumpTrackers) {
        boolean ret = super.disconnected(true, true);
        this.node.peers.disconnectAndRemove(this, false, false, false);
        return ret;
    }

    @Override
    protected boolean generateIdentityFromPubkey() {
        return true;
    }

    @Override
    protected boolean ignoreLastGoodVersion() {
        return true;
    }

    @Override
    void startARKFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldDisconnectAndRemoveNow() {
        if (!this.isConnected()) {
            SeedClientPeerNode seedClientPeerNode = this;
            synchronized (seedClientPeerNode) {
                if (this.timeLastConnectionCompleted() > 0L && System.currentTimeMillis() - this.lastReceivedPacketTime() > TimeUnit.SECONDS.toMillis(60L)) {
                    return true;
                }
            }
        } else if (System.currentTimeMillis() - this.timeLastConnectionCompleted() > TimeUnit.HOURS.toMillis(1L)) {
            return true;
        }
        return false;
    }

    @Override
    protected void maybeClearPeerAddedTimeOnConnect() {
    }

    @Override
    protected boolean shouldExportPeerAddedTime() {
        return true;
    }

    @Override
    protected void maybeClearPeerAddedTimeOnRestart(long now) {
    }

    @Override
    public void fatalTimeout() {
        this.forceDisconnect();
    }

    @Override
    public boolean shallWeRouteAccordingToOurPeersLocation() {
        return false;
    }

    @Override
    protected void onConnect() {
        OpennetManager om = this.node.getOpennet();
        if (om != null) {
            om.seedTracker.onConnectSeed(this);
        }
        super.onConnect();
    }

    @Override
    boolean dontKeepFullFieldSet() {
        return true;
    }
}

