/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.DataCarryingMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;

public class AllDataMessage
extends DataCarryingMessage {
    final long dataLength;
    final boolean global;
    final String identifier;
    final long startupTime;
    final long completionTime;
    final String mimeType;

    public AllDataMessage(Bucket bucket, String identifier, boolean global, long startupTime, long completionTime, String mimeType) {
        this.bucket = bucket;
        this.dataLength = bucket.size();
        this.identifier = identifier;
        this.global = global;
        this.startupTime = startupTime;
        this.completionTime = completionTime;
        this.mimeType = mimeType;
    }

    @Override
    long dataLength() {
        return this.dataLength;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("DataLength", this.dataLength);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Global", this.global);
        fs.put("StartupTime", this.startupTime);
        fs.put("CompletionTime", this.completionTime);
        if (this.mimeType != null) {
            fs.putSingle("Metadata.ContentType", this.mimeType);
        }
        return fs;
    }

    @Override
    public String getName() {
        return "AllData";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "AllData goes from server to client not the other way around", this.identifier, this.global);
    }

    @Override
    String getIdentifier() {
        return this.identifier;
    }

    @Override
    boolean isGlobal() {
        return this.global;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

