/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.EnterFiniteCooldownEvent;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileCompatibilityModeEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.FreenetURI;
import freenet.node.fcp.AllDataMessage;
import freenet.node.fcp.ClientGetMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.CompatibilityMode;
import freenet.node.fcp.DataFoundMessage;
import freenet.node.fcp.DownloadRequestStatus;
import freenet.node.fcp.EnterFiniteCooldown;
import freenet.node.fcp.ExpectedDataLength;
import freenet.node.fcp.ExpectedHashes;
import freenet.node.fcp.ExpectedMIME;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.GetFailedMessage;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NotAllowedException;
import freenet.node.fcp.PersistentGet;
import freenet.node.fcp.PersistentRequestRemovedMessage;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.RequestStatusCache;
import freenet.node.fcp.SendingToNetworkMessage;
import freenet.node.fcp.SimpleProgressMessage;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import freenet.support.io.NullBucket;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class ClientGet
extends ClientRequest
implements ClientGetCallback,
ClientEventListener {
    private final FetchContext fctx;
    private final ClientGetter getter;
    private final short returnType;
    private final File targetFile;
    private final File tempFile;
    private Bucket returnBucket;
    private final boolean binaryBlob;
    private static final int VERBOSITY_SPLITFILE_PROGRESS = 1;
    private static final int VERBOSITY_SENT_TO_NETWORK = 2;
    private static final int VERBOSITY_COMPATIBILITY_MODE = 4;
    private static final int VERBOSITY_EXPECTED_HASHES = 8;
    private static final int VERBOSITY_EXPECTED_TYPE = 32;
    private static final int VERBOSITY_EXPECTED_SIZE = 64;
    private static final int VERBOSITY_ENTER_FINITE_COOLDOWN = 128;
    private boolean succeeded;
    private long foundDataLength = -1L;
    private String foundDataMimeType;
    private GetFailedMessage getFailedMessage;
    private ProtocolErrorMessage postFetchProtocolErrorMessage;
    private AllDataMessage allDataPending;
    private SimpleProgressMessage progressPending;
    private boolean sentToNetwork;
    private CompatibilityMode compatMessage;
    private ExpectedHashes expectedHashes;
    private static volatile boolean logMINOR;

    public ClientGet(FCPClient globalClient, FreenetURI uri, boolean dsOnly, boolean ignoreDS, boolean filterData, int maxSplitfileRetries, int maxNonSplitfileRetries, long maxOutputLength, short returnType, boolean persistRebootOnly, String identifier, int verbosity, short prioClass, File returnFilename, File returnTempFilename, String charset, boolean writeToClientCache, boolean realTimeFlag, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, NotAllowedException, IOException {
        super(uri, identifier, verbosity, charset, null, globalClient, prioClass, persistRebootOnly ? (short)1 : 2, realTimeFlag, null, true, container);
        this.fctx = new FetchContext(server.defaultFetchContext, 0, false, null);
        this.fctx.eventProducer.addEventListener(this);
        this.fctx.localRequestOnly = dsOnly;
        this.fctx.ignoreStore = ignoreDS;
        this.fctx.maxNonSplitfileRetries = maxNonSplitfileRetries;
        this.fctx.maxSplitfileBlockRetries = maxSplitfileRetries;
        this.fctx.filterData = filterData;
        this.fctx.maxOutputLength = maxOutputLength;
        this.fctx.maxTempLength = maxOutputLength;
        this.fctx.canWriteClientCache = writeToClientCache;
        Bucket ret = null;
        this.returnType = returnType;
        this.binaryBlob = false;
        String extensionCheck = null;
        if (returnType == 2) {
            String name;
            int idx;
            this.targetFile = returnFilename;
            this.tempFile = returnTempFilename;
            if (!server.core.allowDownloadTo(returnTempFilename) || !server.core.allowDownloadTo(returnFilename)) {
                throw new NotAllowedException();
            }
            ret = new FileBucket(returnTempFilename, false, true, false, false, false);
            if (filterData && (idx = (name = returnFilename.getName()).lastIndexOf(46)) != -1 && ++idx != name.length()) {
                extensionCheck = name.substring(idx);
            }
        } else if (returnType == 1) {
            this.targetFile = null;
            this.tempFile = null;
            ret = new NullBucket();
        } else {
            this.targetFile = null;
            this.tempFile = null;
            ret = this.persistenceType == 2 ? server.core.persistentTempBucketFactory.makeBucket(maxOutputLength) : server.core.tempBucketFactory.makeBucket(maxOutputLength);
        }
        this.returnBucket = ret;
        this.getter = new ClientGetter(this, uri, this.fctx, this.priorityClass, this.lowLevelClient, this.returnBucket, null, false, null, extensionCheck);
    }

    public ClientGet(FCPConnectionHandler handler, ClientGetMessage message, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, MessageInvalidException {
        super(message.uri, message.identifier, message.verbosity, message.charset, handler, message.priorityClass, message.persistenceType, message.realTimeFlag, message.clientToken, message.global, container);
        this.fctx = new FetchContext(server.defaultFetchContext, 0, false, null);
        this.fctx.eventProducer.addEventListener(this);
        this.fctx.localRequestOnly = message.dsOnly;
        this.fctx.ignoreStore = message.ignoreDS;
        this.fctx.maxNonSplitfileRetries = message.maxRetries;
        this.fctx.maxSplitfileBlockRetries = message.maxRetries;
        this.fctx.maxOutputLength = message.maxSize;
        this.fctx.maxTempLength = message.maxTempSize;
        this.fctx.canWriteClientCache = message.writeToClientCache;
        this.fctx.filterData = message.filterData;
        this.fctx.ignoreUSKDatehints = message.ignoreUSKDatehints;
        if (message.allowedMIMETypes != null) {
            this.fctx.allowedMIMETypes = new HashSet<String>();
            for (String mime : message.allowedMIMETypes) {
                this.fctx.allowedMIMETypes.add(mime);
            }
        }
        this.returnType = message.returnType;
        this.binaryBlob = message.binaryBlob;
        Bucket ret = null;
        String extensionCheck = null;
        if (this.returnType == 2) {
            String name;
            int idx;
            this.targetFile = message.diskFile;
            this.tempFile = message.tempFile;
            if (!server.core.allowDownloadTo(this.tempFile) || !server.core.allowDownloadTo(this.targetFile)) {
                throw new MessageInvalidException(24, "Not allowed to download to " + this.tempFile + " or " + this.targetFile, this.identifier, this.global);
            }
            if (!handler.allowDDAFrom(this.tempFile, true) || !handler.allowDDAFrom(this.targetFile, true)) {
                throw new MessageInvalidException(25, "Not allowed to download to " + this.tempFile + " or " + this.targetFile + ". You might need to do a " + "TestDDARequest" + " first.", this.identifier, this.global);
            }
            ret = new FileBucket(message.tempFile, false, true, false, false, false);
            if (this.fctx.filterData && (idx = (name = this.targetFile.getName()).lastIndexOf(46)) != -1 && ++idx != name.length()) {
                extensionCheck = name.substring(idx);
            }
        } else if (this.returnType == 1) {
            this.targetFile = null;
            this.tempFile = null;
            ret = new NullBucket();
        } else {
            this.targetFile = null;
            this.tempFile = null;
            try {
                ret = this.persistenceType == 2 ? server.core.persistentTempBucketFactory.makeBucket(this.fctx.maxOutputLength) : server.core.tempBucketFactory.makeBucket(this.fctx.maxOutputLength);
            }
            catch (IOException e) {
                Logger.error(this, "Cannot create bucket for temp storage: " + e, (Throwable)e);
                this.getter = null;
                this.returnBucket = null;
                throw new MessageInvalidException(17, "Cannot create bucket for temporary storage (out of disk space???): " + e, this.identifier, this.global);
            }
        }
        if (ret == null) {
            Logger.error(this, "Impossible: ret = null in FCP constructor for " + this, (Throwable)new Exception("debug"));
        }
        this.returnBucket = ret;
        this.getter = new ClientGetter(this, this.uri, this.fctx, this.priorityClass, this.lowLevelClient, this.binaryBlob ? new NullBucket() : this.returnBucket, this.binaryBlob ? new BinaryBlobWriter(this.returnBucket) : null, false, message.getInitialMetadata(), extensionCheck);
    }

    @Override
    void register(ObjectContainer container, boolean noTags) throws IdentifierCollisionException {
        if (this.client != null) assert (this.persistenceType == this.client.persistenceType);
        if (this.persistenceType != 0) {
            try {
                this.client.register(this, container);
            }
            catch (IdentifierCollisionException e) {
                this.returnBucket.free();
                if (this.persistenceType == 2) {
                    this.returnBucket.removeFrom(container);
                }
                throw e;
            }
        }
        if (this.persistenceType != 0 && !noTags) {
            FCPMessage msg = this.persistentTagMessage(container);
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ObjectContainer container, ClientContext context) {
        try {
            RequestStatusCache cache;
            Object msg;
            ClientGet clientGet = this;
            synchronized (clientGet) {
                if (this.finished) {
                    return;
                }
            }
            if (this.persistenceType == 2) {
                container.activate((Object)this.getter, 1);
            }
            this.getter.start(container, context);
            if (this.persistenceType != 0 && !this.finished) {
                msg = this.persistentTagMessage(container);
                this.client.queueClientRequestMessage((FCPMessage)msg, 0, container);
            }
            msg = this;
            synchronized (msg) {
                this.started = true;
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStarted(this.identifier, true);
            }
        }
        catch (FetchException e) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.started = true;
            }
            this.onFailure(e, null, container);
        }
        catch (Throwable t) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.started = true;
            }
            this.onFailure(new FetchException(17, t), null, container);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    @Override
    public void onLostConnection(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 0) {
            this.cancel(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        ClientGet clientGet;
        boolean bucketChanged;
        Logger.minor(this, "Succeeded: " + this.identifier);
        Bucket data = result.asBucket();
        if (this.persistenceType == 2) {
            if (data != null) {
                container.activate((Object)data, 5);
            }
            if (this.returnBucket != null) {
                container.activate((Object)this.returnBucket, 5);
            }
            container.activate((Object)this.client, 1);
            if (this.tempFile != null) {
                container.activate((Object)this.tempFile, 5);
            }
            if (this.targetFile != null) {
                container.activate((Object)this.targetFile, 5);
            }
        }
        boolean bl = bucketChanged = this.returnBucket != data && !this.binaryBlob;
        if (bucketChanged) {
            clientGet = this;
            synchronized (clientGet) {
                if (this.finished) {
                    Logger.error(this, "Already finished but onSuccess() for " + this + " data = " + data, (Throwable)new Exception("debug"));
                    data.free();
                    if (this.persistenceType == 2) {
                        data.removeFrom(container);
                    }
                    return;
                }
                if (this.returnType == 0 && this.returnBucket == null) {
                    this.returnBucket = data;
                    bucketChanged = false;
                }
            }
            if (bucketChanged && this.persistenceType == 2 && container.ext().getID((Object)this.returnBucket) == container.ext().getID((Object)data)) {
                Logger.error(this, "DB4O BUG DETECTED WITHOUT ARRAY HANDLING! EVIL HORRIBLE BUG! UID(returnBucket)=" + container.ext().getID((Object)this.returnBucket) + " for " + this.returnBucket + " active=" + container.ext().isActive((Object)this.returnBucket) + " stored = " + container.ext().isStored((Object)this.returnBucket) + " but UID(data)=" + container.ext().getID((Object)data) + " for " + data + " active = " + container.ext().isActive((Object)data) + " stored = " + container.ext().isStored((Object)data));
                this.returnBucket = data;
                bucketChanged = false;
            }
        }
        if (bucketChanged) {
            clientGet = this;
            synchronized (clientGet) {
                if (data instanceof FileBucket && this.returnBucket instanceof FileBucket) {
                    File actualFile = ((FileBucket)data).getFile();
                    File expectedFile = ((FileBucket)this.returnBucket).getFile();
                    if (actualFile.toString().equals(expectedFile.toString())) {
                        Logger.warning(this, "Data was written to the correct file " + actualFile + " but the bucket changed: " + this.returnBucket + " -> " + data);
                        this.returnBucket = data;
                        bucketChanged = false;
                    } else {
                        Logger.error(this, "Data was written to " + actualFile + " but should be written to " + expectedFile);
                        boolean shortCut = false;
                        if (expectedFile.renameTo(actualFile)) {
                            shortCut = true;
                        } else {
                            actualFile.delete();
                            if (expectedFile.renameTo(actualFile)) {
                                shortCut = true;
                            }
                        }
                        if (shortCut) {
                            this.returnBucket.free();
                            if (this.persistenceType == 2) {
                                this.returnBucket.removeFrom(container);
                            }
                            this.returnBucket = data;
                            bucketChanged = false;
                        }
                    }
                } else {
                    Logger.error(this, "Returned bucket " + data + " in onSuccess, expected " + this.returnBucket + (data == this.returnBucket ? " (equal)" : "(not equal)"), (Throwable)new Exception("error"));
                }
            }
        }
        if (bucketChanged) {
            if (this.tempFile != null && this.tempFile.exists()) {
                this.tempFile.delete();
            }
            if (data != this.returnBucket) {
                this.returnBucket.free();
            }
            if (data != this.returnBucket) {
                if (this.persistenceType == 2) {
                    this.returnBucket.removeFrom(container);
                }
                this.returnBucket = this.getBucket(container);
            }
            if (this.persistenceType == 2 && container.ext().isStored((Object)this)) {
                this.returnBucket.storeTo(container);
                container.store((Object)this);
                Logger.error(this, "Data returned to wrong bucket " + data + " expected " + this.returnBucket + " in " + this, (Throwable)new Exception("error"));
                try {
                    BucketTools.copy(data, this.returnBucket);
                }
                catch (IOException e) {
                    Logger.error(this, "Data != returnBucket and then failed to copy to " + this.returnBucket);
                    data.free();
                    this.returnBucket.free();
                    if (this.persistenceType == 2) {
                        data.removeFrom(container);
                    }
                    this.onFailure(new FetchException(17, "Data != returnBucket and then failed to copy", e), null, container);
                    return;
                }
            }
        }
        boolean dontFree = false;
        AllDataMessage adm = null;
        ClientGet clientGet2 = this;
        synchronized (clientGet2) {
            if (this.succeeded) {
                Logger.error(this, "onSuccess called twice for " + this + " (" + this.identifier + ')');
                return;
            }
            this.started = true;
            this.foundDataMimeType = !this.binaryBlob ? result.getMimeType() : "application/x-freenet-binary-blob";
            if (this.returnType == 0) {
                this.completionTime = System.currentTimeMillis();
                adm = new AllDataMessage(this.returnBucket, this.identifier, this.global, this.startupTime, this.completionTime, this.foundDataMimeType);
                if (this.persistenceType == 0) {
                    adm.setFreeOnSent();
                }
                dontFree = true;
            } else if (this.returnType == 2) {
                if (!FileUtil.renameTo(this.tempFile, this.targetFile)) {
                    this.postFetchProtocolErrorMessage = new ProtocolErrorMessage(14, false, null, this.identifier, this.global);
                }
                this.completionTime = System.currentTimeMillis();
                this.returnBucket = new FileBucket(this.targetFile, false, true, false, false, false);
            } else {
                this.completionTime = System.currentTimeMillis();
            }
            if (this.persistenceType == 2 && this.progressPending != null) {
                container.activate((Object)this.progressPending, 1);
                this.progressPending.removeFrom(container);
            }
            this.progressPending = null;
            this.foundDataLength = this.returnBucket.size();
            this.succeeded = true;
            this.finished = true;
        }
        this.trySendDataFoundOrGetFailed(null, container);
        if (adm != null) {
            this.trySendAllDataMessage(adm, null, container);
        }
        if (!dontFree) {
            data.free();
        }
        if (this.persistenceType == 2) {
            this.returnBucket.storeTo(container);
            container.store((Object)this);
        }
        this.finish(container);
        if (this.client != null) {
            this.client.notifySuccess(this, container);
        }
    }

    private void trySendDataFoundOrGetFailed(FCPConnectionOutputHandler handler, ObjectContainer container) {
        FCPMessage msg;
        if (this.succeeded) {
            msg = new DataFoundMessage(this.foundDataLength, this.foundDataMimeType, this.identifier, this.global, this.startupTime, this.completionTime != 0L ? this.completionTime : System.currentTimeMillis());
        } else {
            msg = this.getFailedMessage;
            if (this.persistenceType == 2) {
                container.activate((Object)msg, 5);
            }
        }
        if (handler == null && this.persistenceType == 0) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0, container);
        }
        if (this.postFetchProtocolErrorMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.postFetchProtocolErrorMessage, 5);
            }
            if (handler != null) {
                handler.queue(this.postFetchProtocolErrorMessage);
            } else {
                if (this.persistenceType == 2) {
                    container.activate((Object)this.client, 1);
                }
                this.client.queueClientRequestMessage(this.postFetchProtocolErrorMessage, 0, container);
            }
        }
    }

    private void trySendAllDataMessage(AllDataMessage msg, FCPConnectionOutputHandler handler, ObjectContainer container) {
        if (this.persistenceType != 0) {
            this.allDataPending = msg;
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
            return;
        }
        if (handler == null) {
            handler = this.origHandler.outputHandler;
        }
        handler.queue(msg);
    }

    private void trySendProgress(FCPMessage msg, int verbosityMask, FCPConnectionOutputHandler handler, ObjectContainer container) {
        SimpleProgressMessage oldProgress = null;
        boolean noStore = false;
        if (msg instanceof SimpleProgressMessage) {
            RequestStatusCache cache;
            oldProgress = this.progressPending;
            this.progressPending = (SimpleProgressMessage)msg;
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStatus(this.identifier, this.progressPending.getEvent());
            }
        } else if (msg instanceof SendingToNetworkMessage) {
            this.sentToNetwork = true;
        } else if (msg instanceof CompatibilityMode) {
            RequestStatusCache cache;
            CompatibilityMode compat = (CompatibilityMode)msg;
            if (this.compatMessage != null) {
                if (this.persistenceType == 2) {
                    container.activate((Object)this.compatMessage, 1);
                }
                this.compatMessage.merge(compat.min, compat.max, compat.cryptoKey, compat.dontCompress, compat.definitive);
                if (this.persistenceType == 2) {
                    container.store((Object)this.compatMessage);
                }
            } else {
                this.compatMessage = compat;
                if (this.persistenceType == 2) {
                    container.store((Object)this.compatMessage);
                    container.store((Object)this);
                }
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateDetectedCompatModes(this.identifier, compat.getModes(), compat.cryptoKey, compat.dontCompress);
            }
        } else if (msg instanceof ExpectedHashes) {
            if (this.expectedHashes != null) {
                Logger.error(this, "Got a new ExpectedHashes", (Throwable)new Exception("debug"));
            } else {
                this.expectedHashes = (ExpectedHashes)msg;
                if (this.persistenceType == 2) {
                    container.store((Object)this);
                }
            }
        } else if (msg instanceof ExpectedMIME) {
            RequestStatusCache cache;
            this.foundDataMimeType = ((ExpectedMIME)msg).expectedMIME;
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateExpectedMIME(this.identifier, this.foundDataMimeType);
            }
        } else if (msg instanceof ExpectedDataLength) {
            RequestStatusCache cache;
            this.foundDataLength = ((ExpectedDataLength)msg).dataLength;
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateExpectedDataLength(this.identifier, this.foundDataLength);
            }
        } else if (msg instanceof EnterFiniteCooldown) {
            noStore = true;
        } else assert (false);
        if (this.persistenceType == 2 && !noStore) {
            container.store((Object)this);
            if (oldProgress != null) {
                container.activate((Object)oldProgress, 1);
                ((FCPMessage)oldProgress).removeFrom(container);
            }
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.client, 1);
        }
        if (this.persistenceType == 0 && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, verbosityMask, container);
        }
        if (this.persistenceType == 2 && !this.client.isGlobalQueue) {
            container.deactivate((Object)this.client, 1);
        }
    }

    @Override
    public void sendPendingMessages(FCPConnectionOutputHandler handler, boolean includePersistentRequest, boolean includeData, boolean onlyData, ObjectContainer container) {
        if (!onlyData) {
            if (includePersistentRequest) {
                FCPMessage msg = this.persistentTagMessage(container);
                handler.queue(msg);
            }
            if (this.progressPending != null) {
                if (this.persistenceType == 2) {
                    container.activate((Object)this.progressPending, 5);
                }
                handler.queue(this.progressPending);
            }
            if (this.sentToNetwork) {
                handler.queue(new SendingToNetworkMessage(this.identifier, this.global));
            }
            if (this.finished) {
                this.trySendDataFoundOrGetFailed(handler, container);
            }
        }
        if (onlyData && this.allDataPending == null) {
            Logger.error(this, "No data pending !");
        }
        if (includeData && this.allDataPending != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.allDataPending, 5);
            }
            handler.queue(this.allDataPending);
        }
        if (this.compatMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.compatMessage, 5);
            }
            handler.queue(this.compatMessage);
        }
        if (this.expectedHashes != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.expectedHashes, Integer.MAX_VALUE);
            }
            handler.queue(this.expectedHashes);
        }
        if (this.foundDataMimeType != null) {
            handler.queue(new ExpectedMIME(this.identifier, this.global, this.foundDataMimeType));
        }
        if (this.foundDataLength > 0L) {
            handler.queue(new ExpectedDataLength(this.identifier, this.global, this.foundDataLength));
        }
    }

    @Override
    protected FCPMessage persistentTagMessage(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.uri, 5);
            container.activate((Object)this.fctx, 1);
            container.activate((Object)this.client, 1);
            container.activate((Object)this.targetFile, 5);
            container.activate((Object)this.tempFile, 5);
        }
        return new PersistentGet(this.identifier, this.uri, this.verbosity, this.priorityClass, this.returnType, this.persistenceType, this.targetFile, this.tempFile, this.clientToken, this.client.isGlobalQueue, this.started, this.fctx.maxNonSplitfileRetries, this.binaryBlob, this.fctx.maxOutputLength, this.isRealTime());
    }

    private boolean isRealTime() {
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
            return false;
        }
        return this.lowLevelClient.realTimeFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        if (this.finished) {
            return;
        }
        ClientGet clientGet = this;
        synchronized (clientGet) {
            this.succeeded = false;
            this.getFailedMessage = new GetFailedMessage(e, this.identifier, this.global);
            this.finished = true;
            this.started = true;
            this.completionTime = System.currentTimeMillis();
        }
        if (logMINOR) {
            Logger.minor(this, "Caught " + e, (Throwable)e);
        }
        this.trySendDataFoundOrGetFailed(null, container);
        if (this.persistenceType == 2) {
            container.activate((Object)this.client, 1);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this.getFailedMessage);
        }
        this.finish(container);
        if (this.client != null) {
            this.client.notifyFailure(this, container);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (!this.finished) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.succeeded = false;
                this.finished = true;
                FetchException cancelled = new FetchException(25);
                this.getFailedMessage = new GetFailedMessage(cancelled, this.identifier, this.global);
            }
            this.trySendDataFoundOrGetFailed(null, container);
        }
        PersistentRequestRemovedMessage msg = new PersistentRequestRemovedMessage(this.getIdentifier(), this.global);
        if (this.persistenceType != 0) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.client, 1);
            }
            this.client.queueClientRequestMessage(msg, 0, container);
        }
        this.freeData(container);
        if (this.persistenceType == 2) {
            container.activate((Object)this.fctx, 1);
            if (this.fctx.allowedMIMETypes != null) {
                container.activate(this.fctx.allowedMIMETypes, 5);
                container.delete(this.fctx.allowedMIMETypes);
            }
            this.fctx.removeFrom(container);
            this.getter.removeFrom(container, context);
            if (this.targetFile != null) {
                container.delete((Object)this.targetFile);
            }
            if (this.tempFile != null) {
                container.delete((Object)this.tempFile);
            }
            if (this.getFailedMessage != null) {
                container.activate((Object)this.getFailedMessage, 5);
                this.getFailedMessage.removeFrom(container);
            }
            if (this.postFetchProtocolErrorMessage != null) {
                container.activate((Object)this.postFetchProtocolErrorMessage, 5);
                this.postFetchProtocolErrorMessage.removeFrom(container);
            }
            if (this.allDataPending != null) {
                container.activate((Object)this.allDataPending, 5);
                this.allDataPending.removeFrom(container);
            }
            if (this.progressPending != null) {
                container.activate((Object)this.progressPending, 5);
                this.progressPending.removeFrom(container);
            }
            if (this.compatMessage != null) {
                container.activate((Object)this.compatMessage, 5);
                this.compatMessage.removeFrom(container);
            }
            if (this.expectedHashes != null) {
                container.activate((Object)this.expectedHashes, Integer.MAX_VALUE);
                this.expectedHashes.removeFrom(container);
            }
        }
        super.requestWasRemoved(container, context);
    }

    @Override
    public void receive(ClientEvent ce, ObjectContainer container, ClientContext context) {
        FCPMessage progress;
        int verbosityMask;
        if (this.finished) {
            return;
        }
        if (ce instanceof SplitfileProgressEvent) {
            verbosityMask = 1;
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            this.lastActivity = System.currentTimeMillis();
            progress = new SimpleProgressMessage(this.identifier, this.global, (SplitfileProgressEvent)ce);
        } else if (ce instanceof SendingToNetworkEvent) {
            verbosityMask = 2;
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            progress = new SendingToNetworkMessage(this.identifier, this.global);
        } else if (ce instanceof SplitfileCompatibilityModeEvent) {
            verbosityMask = 4;
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            SplitfileCompatibilityModeEvent event = (SplitfileCompatibilityModeEvent)ce;
            progress = new CompatibilityMode(this.identifier, this.global, event.minCompatibilityMode, event.maxCompatibilityMode, event.splitfileCryptoKey, event.dontCompress, event.bottomLayer);
        } else if (ce instanceof ExpectedHashesEvent) {
            verbosityMask = 8;
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            ExpectedHashesEvent event = (ExpectedHashesEvent)ce;
            progress = new ExpectedHashes(event, this.identifier, this.global);
        } else if (ce instanceof ExpectedMIMEEvent) {
            verbosityMask = 32;
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            ExpectedMIMEEvent event = (ExpectedMIMEEvent)ce;
            progress = new ExpectedMIME(this.identifier, this.global, event.expectedMIMEType);
        } else if (ce instanceof ExpectedFileSizeEvent) {
            verbosityMask = 64;
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            ExpectedFileSizeEvent event = (ExpectedFileSizeEvent)ce;
            progress = new ExpectedDataLength(this.identifier, this.global, event.expectedSize);
        } else if (ce instanceof EnterFiniteCooldownEvent) {
            verbosityMask = 128;
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            EnterFiniteCooldownEvent event = (EnterFiniteCooldownEvent)ce;
            progress = new EnterFiniteCooldown(this.identifier, this.global, event.wakeupTime);
        } else {
            return;
        }
        if (this.persistenceType == 2 && container == null) {
            try {
                context.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        ClientGet.this.trySendProgress(progress, verbosityMask, null, container);
                        return false;
                    }
                }, NativeThread.HIGH_PRIORITY, false);
            }
            catch (DatabaseDisabledException e) {}
        } else {
            this.trySendProgress(progress, verbosityMask, null, container);
        }
    }

    @Override
    protected ClientRequester getClientRequest() {
        return this.getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeData(ObjectContainer container) {
        Bucket data;
        ClientGet clientGet = this;
        synchronized (clientGet) {
            data = this.returnBucket;
            this.returnBucket = null;
        }
        if (data != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)data, 5);
            }
            data.free();
            if (this.persistenceType == 2) {
                data.removeFrom(container);
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
        }
    }

    @Override
    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public boolean isDirect() {
        return this.returnType == 0;
    }

    public boolean isToDisk() {
        return this.returnType == 2;
    }

    public FreenetURI getURI(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.uri, 5);
        }
        return this.uri;
    }

    public long getDataSize(ObjectContainer container) {
        if (this.foundDataLength > 0L) {
            return this.foundDataLength;
        }
        if (this.getter != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.getter, 1);
            }
            return this.getter.expectedSize();
        }
        return -1L;
    }

    public String getMIMEType(ObjectContainer container) {
        if (this.foundDataMimeType != null) {
            return this.foundDataMimeType;
        }
        if (this.getter != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.getter, 1);
            }
            return this.getter.expectedMIME();
        }
        return null;
    }

    public File getDestFilename(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.targetFile, 5);
        }
        return this.targetFile;
    }

    @Override
    public double getSuccessFraction(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFraction();
        }
        return -1.0;
    }

    @Override
    public double getTotalBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getTotalBlocks();
        }
        return 1.0;
    }

    @Override
    public double getMinBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getMinBlocks();
        }
        return 1.0;
    }

    @Override
    public double getFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFailedBlocks();
        }
        return 0.0;
    }

    @Override
    public double getFatalyFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFatalyFailedBlocks();
        }
        return 0.0;
    }

    @Override
    public double getFetchedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFetchedBlocks();
        }
        return 0.0;
    }

    public InsertContext.CompatibilityMode[] getCompatibilityMode(ObjectContainer container) {
        if (this.persistenceType == 2 && this.compatMessage != null) {
            container.activate((Object)this.compatMessage, 2);
        }
        if (this.compatMessage != null) {
            return this.compatMessage.getModes();
        }
        return new InsertContext.CompatibilityMode[]{InsertContext.CompatibilityMode.COMPAT_UNKNOWN, InsertContext.CompatibilityMode.COMPAT_UNKNOWN};
    }

    public boolean getDontCompress(ObjectContainer container) {
        if (this.compatMessage == null) {
            return false;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.compatMessage, 2);
        }
        return this.compatMessage.dontCompress;
    }

    public byte[] getOverriddenSplitfileCryptoKey(ObjectContainer container) {
        if (this.persistenceType == 2 && this.compatMessage != null) {
            container.activate((Object)this.compatMessage, 2);
        }
        if (this.compatMessage != null) {
            return this.compatMessage.cryptoKey;
        }
        return null;
    }

    @Override
    public String getFailureReason(boolean longDescription, ObjectContainer container) {
        if (this.getFailedMessage == null) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.getFailedMessage, 5);
        }
        String s = this.getFailedMessage.shortCodeDescription;
        if (longDescription && this.getFailedMessage.extraDescription != null) {
            s = s + ": " + this.getFailedMessage.extraDescription;
        }
        return s;
    }

    GetFailedMessage getFailureMessage(ObjectContainer container) {
        if (this.getFailedMessage == null) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.getFailedMessage, 5);
        }
        return this.getFailedMessage;
    }

    public int getFailureReasonCode(ObjectContainer container) {
        if (this.getFailedMessage == null) {
            return -1;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.getFailedMessage, 5);
        }
        return this.getFailedMessage.code;
    }

    @Override
    public boolean isTotalFinalized(ObjectContainer container) {
        if (this.finished && this.succeeded) {
            return true;
        }
        if (this.progressPending == null) {
            return false;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.progressPending, 1);
        }
        return this.progressPending.isTotalFinalized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getFinalBucket(ObjectContainer container) {
        ClientGet clientGet = this;
        synchronized (clientGet) {
            if (!this.finished) {
                return null;
            }
            if (!this.succeeded) {
                return null;
            }
            if (this.persistenceType == 2) {
                container.activate((Object)this.returnBucket, 1);
            }
            return this.returnBucket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getBucket(ObjectContainer container) {
        ClientGet clientGet = this;
        synchronized (clientGet) {
            if (this.targetFile != null) {
                if (this.succeeded || this.tempFile == null) {
                    if (this.persistenceType == 2) {
                        container.activate((Object)this.targetFile, 5);
                    }
                    return new FileBucket(this.targetFile, false, true, false, false, false);
                }
                if (this.persistenceType == 2) {
                    container.activate((Object)this.tempFile, 5);
                }
                return new FileBucket(this.tempFile, false, true, false, false, false);
            }
            return this.returnBucket;
        }
    }

    @Override
    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return this.getter.canRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restart(ObjectContainer container, ClientContext context, boolean disableFilterData) {
        Object cache;
        if (!this.canRestart()) {
            return false;
        }
        FreenetURI redirect = null;
        ClientGet clientGet = this;
        synchronized (clientGet) {
            this.finished = false;
            if (this.persistenceType == 2 && this.getFailedMessage != null) {
                container.activate((Object)this.getFailedMessage, 1);
                if (this.getFailedMessage.redirectURI != null) {
                    container.activate((Object)this.getFailedMessage.redirectURI, Integer.MAX_VALUE);
                    redirect = this.getFailedMessage.redirectURI.clone();
                }
                this.getFailedMessage.removeFrom(container);
            } else if (this.getFailedMessage != null) {
                redirect = this.getFailedMessage.redirectURI;
            }
            this.getFailedMessage = null;
            if (this.persistenceType == 2 && this.allDataPending != null) {
                container.activate((Object)this.allDataPending, 1);
                this.allDataPending.removeFrom(container);
            }
            this.allDataPending = null;
            if (this.persistenceType == 2 && this.postFetchProtocolErrorMessage != null) {
                container.activate((Object)this.postFetchProtocolErrorMessage, 1);
                this.postFetchProtocolErrorMessage.removeFrom(container);
            }
            this.postFetchProtocolErrorMessage = null;
            if (this.persistenceType == 2 && this.progressPending != null) {
                container.activate((Object)this.progressPending, 1);
                this.progressPending.removeFrom(container);
            }
            this.progressPending = null;
            if (this.persistenceType == 2 && this.compatMessage != null) {
                container.activate((Object)this.compatMessage, 1);
                this.compatMessage.removeFrom(container);
            }
            this.compatMessage = null;
            if (this.persistenceType == 2 && this.expectedHashes != null) {
                container.activate((Object)this.expectedHashes, 1);
                this.expectedHashes.removeFrom(container);
            }
            this.expectedHashes = null;
            this.started = false;
            if (this.persistenceType == 2) {
                container.activate((Object)this.fctx, 1);
                container.activate((Object)this.fctx.filterData, 1);
            }
            if (disableFilterData) {
                this.fctx.filterData = false;
            }
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            ((RequestStatusCache)cache).updateStarted(this.identifier, redirect);
        }
        try {
            if (this.persistenceType == 2) {
                container.activate((Object)this.getter, 1);
            }
            if (this.getter.restart(redirect, this.fctx.filterData, container, context)) {
                cache = this;
                synchronized (cache) {
                    if (redirect != null) {
                        if (this.persistenceType == 2) {
                            this.uri.removeFrom(container);
                        }
                        this.uri = redirect;
                    }
                    this.started = true;
                }
                if (this.persistenceType == 2) {
                    container.store((Object)this);
                }
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                ((RequestStatusCache)cache).updateStarted(this.identifier, true);
            }
            return true;
        }
        catch (FetchException e) {
            this.onFailure(e, null, container);
            return false;
        }
    }

    public synchronized boolean hasPermRedirect() {
        return this.getFailedMessage != null && this.getFailedMessage.redirectURI != null;
    }

    @Override
    public void onRemoveEventProducer(ObjectContainer container) {
    }

    public boolean filterData(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.fctx, 1);
        }
        return this.fctx.filterData;
    }

    @Override
    RequestStatus getStatus(ObjectContainer container) {
        boolean overriddenDataType;
        Bucket shadow;
        File target;
        boolean totalFinalized = false;
        int total = 0;
        int min = 0;
        int fetched = 0;
        int fatal = 0;
        int failed = 0;
        if (this.progressPending != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.progressPending, Integer.MAX_VALUE);
            }
            totalFinalized = this.progressPending.isTotalFinalized();
            total = (int)this.progressPending.getTotalBlocks();
            min = (int)this.progressPending.getMinBlocks();
            fetched = (int)this.progressPending.getFetchedBlocks();
            fatal = (int)this.progressPending.getFatalyFailedBlocks();
            failed = (int)this.progressPending.getFailedBlocks();
        }
        if (this.finished && this.succeeded) {
            totalFinalized = true;
        }
        if (this.persistenceType == 2) {
            container.deactivate((Object)this.progressPending, 1);
        }
        int failureCode = -1;
        String failureReasonShort = null;
        String failureReasonLong = null;
        if (this.getFailedMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.getFailedMessage, 5);
            }
            failureCode = this.getFailedMessage.code;
            failureReasonShort = this.getFailedMessage.getShortFailedMessage();
            failureReasonShort = this.getFailedMessage.getLongFailedMessage();
            if (this.persistenceType == 2) {
                container.deactivate((Object)this.getFailedMessage, 1);
            }
        }
        String mimeType = this.foundDataMimeType;
        long dataSize = this.foundDataLength;
        if (this.getter != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.getter, 1);
            }
            if (mimeType == null) {
                mimeType = this.getter.expectedMIME();
            }
            if (dataSize <= 0L) {
                dataSize = this.getter.expectedSize();
            }
            if (this.persistenceType == 2) {
                container.deactivate((Object)this.getter, 1);
            }
        }
        if ((target = this.getDestFilename(container)) != null) {
            target = new File(target.getPath());
        }
        if ((shadow = this.getFinalBucket(container)) != null) {
            dataSize = shadow.size();
            shadow = shadow.createShadow();
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.fctx, 1);
        }
        boolean filterData = this.fctx.filterData;
        boolean bl = overriddenDataType = this.fctx.overrideMIME != null || this.fctx.charset != null;
        if (this.persistenceType == 2) {
            container.deactivate((Object)this.fctx, 1);
        }
        return new DownloadRequestStatus(this.identifier, this.persistenceType, this.started, this.finished, this.succeeded, total, min, fetched, fatal, failed, totalFinalized, this.lastActivity, this.priorityClass, failureCode, mimeType, dataSize, target, this.getCompatibilityMode(container), this.getOverriddenSplitfileCryptoKey(container), this.getURI(container).clone(), failureReasonShort, failureReasonLong, overriddenDataType, shadow, filterData, this.getDontCompress(container));
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

