/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutter;
import freenet.client.async.ClientRequester;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.node.fcp.ClientPutBase;
import freenet.node.fcp.ClientPutMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NotAllowedException;
import freenet.node.fcp.PersistentPut;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.RequestStatusCache;
import freenet.node.fcp.SimpleProgressMessage;
import freenet.node.fcp.UploadFileRequestStatus;
import freenet.support.Base64;
import freenet.support.IllegalBase64Exception;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleReadOnlyArrayBucket;
import freenet.support.api.Bucket;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.Arrays;

public class ClientPut
extends ClientPutBase {
    ClientPutter putter;
    private final short uploadFrom;
    private final File origFilename;
    private final FreenetURI targetURI;
    private Bucket data;
    private final ClientMetadata clientMetadata;
    private long finishedSize;
    private final String targetFilename;
    private final boolean binaryBlob;
    private transient boolean compressing;
    private static volatile boolean logMINOR;

    private ClientPut() {
        this.uploadFrom = 0;
        this.targetURI = null;
        this.targetFilename = null;
        this.origFilename = null;
        this.clientMetadata = null;
        this.binaryBlob = false;
    }

    public ClientPut(FCPClient globalClient, FreenetURI uri, String identifier, int verbosity, String charset, short priorityClass, short persistenceType, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, short uploadFromType, File origFilename, String contentType, Bucket data, FreenetURI redirectTarget, String targetFilename, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, boolean realTimeFlag, InsertContext.CompatibilityMode compatMode, byte[] overrideSplitfileKey, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, NotAllowedException, FileNotFoundException, MalformedURLException, MetadataUnresolvedException {
        uri = ClientPut.checkEmptySSK(uri, targetFilename, server.core.clientContext);
        super(uri, identifier, verbosity, charset, null, globalClient, priorityClass, persistenceType, null, true, getCHKOnly, dontCompress, maxRetries, earlyEncode, canWriteClientCache, forkOnCacheable, false, extraInsertsSingleBlock, extraInsertsSplitfileHeaderBlock, realTimeFlag, null, compatMode, false, server, container);
        if (uploadFromType == 1) {
            if (!server.core.allowUploadFrom(origFilename)) {
                throw new NotAllowedException();
            }
            if (!origFilename.exists() || !origFilename.canRead()) {
                throw new FileNotFoundException();
            }
        }
        this.binaryBlob = false;
        this.targetFilename = targetFilename;
        this.uploadFrom = uploadFromType;
        this.origFilename = origFilename;
        String mimeType = contentType;
        this.clientToken = clientToken;
        Bucket tempData = data;
        ClientMetadata cm = new ClientMetadata(mimeType);
        boolean isMetadata = false;
        if (logMINOR) {
            Logger.minor(this, "data = " + tempData + ", uploadFrom = " + ClientPutMessage.uploadFromString(this.uploadFrom));
        }
        if (this.uploadFrom == 2) {
            this.targetURI = redirectTarget;
            Metadata m = new Metadata(0, null, null, this.targetURI, cm);
            byte[] d = m.writeToByteArray();
            tempData = new SimpleReadOnlyArrayBucket(d);
            isMetadata = true;
        } else {
            this.targetURI = null;
        }
        this.data = tempData;
        this.clientMetadata = cm;
        this.putter = new ClientPutter(this, data, this.uri, cm, this.ctx, priorityClass, getCHKOnly, isMetadata, this.lowLevelClient, this.uri.getDocName() == null ? targetFilename : null, this.binaryBlob, server.core.clientContext, overrideSplitfileKey, -1L);
    }

    public ClientPut(FCPConnectionHandler handler, ClientPutMessage message, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, MessageInvalidException, MalformedURLException {
        super(ClientPut.checkEmptySSK(message.uri, message.targetFilename, server.core.clientContext), message.identifier, message.verbosity, null, handler, message.priorityClass, message.persistenceType, message.clientToken, message.global, message.getCHKOnly, message.dontCompress, message.localRequestOnly, message.maxRetries, message.earlyEncode, message.canWriteClientCache, message.forkOnCacheable, message.compressorDescriptor, message.extraInsertsSingleBlock, message.extraInsertsSplitfileHeaderBlock, message.realTimeFlag, message.compatibilityMode, message.ignoreUSKDatehints, server, container);
        String salt = null;
        byte[] saltedHash = null;
        this.binaryBlob = message.binaryBlob;
        if (message.uploadFromType == 1) {
            if (!handler.server.core.allowUploadFrom(message.origFilename)) {
                throw new MessageInvalidException(24, "Not allowed to upload from " + message.origFilename, this.identifier, this.global);
            }
            if (message.fileHash != null) {
                try {
                    salt = handler.connectionIdentifier + '-' + message.identifier + '-';
                    saltedHash = Base64.decodeStandard(message.fileHash);
                }
                catch (IllegalBase64Exception e) {
                    try {
                        saltedHash = Base64.decode(message.fileHash);
                    }
                    catch (IllegalBase64Exception e1) {
                        throw new MessageInvalidException(8, "Can't base64 decode FileHash", this.identifier, this.global);
                    }
                }
            } else if (!handler.allowDDAFrom(message.origFilename, false)) {
                throw new MessageInvalidException(25, "Not allowed to upload from " + message.origFilename + ". Have you done a testDDA previously ?", this.identifier, this.global);
            }
        }
        this.targetFilename = message.targetFilename;
        this.uploadFrom = message.uploadFromType;
        this.origFilename = message.origFilename;
        String mimeType = message.contentType;
        if (this.binaryBlob && mimeType != null && !mimeType.equals("application/x-freenet-binary-blob")) {
            throw new MessageInvalidException(8, "No MIME type allowed when inserting a binary blob", this.identifier, this.global);
        }
        if (mimeType == null && this.origFilename != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.origFilename.getName(), true);
        }
        if (mimeType == null && this.targetFilename != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.targetFilename, true);
        }
        if (mimeType != null && mimeType.equals("")) {
            mimeType = null;
        }
        if (mimeType != null && !DefaultMIMETypes.isPlausibleMIMEType(mimeType)) {
            throw new MessageInvalidException(35, "Bad MIME type in Metadata.ContentType", this.identifier, this.global);
        }
        this.clientToken = message.clientToken;
        Bucket tempData = message.bucket;
        ClientMetadata cm = new ClientMetadata(mimeType);
        boolean isMetadata = false;
        if (logMINOR) {
            Logger.minor(this, "data = " + tempData + ", uploadFrom = " + ClientPutMessage.uploadFromString(this.uploadFrom));
        }
        if (this.uploadFrom == 2) {
            byte[] d;
            this.targetURI = message.redirectTarget;
            Metadata m = new Metadata(0, null, null, this.targetURI, cm);
            try {
                d = m.writeToByteArray();
            }
            catch (MetadataUnresolvedException e) {
                Logger.error(this, "Impossible: " + e, (Throwable)e);
                this.data = null;
                this.clientMetadata = cm;
                this.putter = null;
                throw new MessageInvalidException(17, "Impossible: metadata unresolved: " + e, this.identifier, this.global);
            }
            tempData = new SimpleReadOnlyArrayBucket(d);
            isMetadata = true;
        } else {
            this.targetURI = null;
        }
        this.data = tempData;
        this.clientMetadata = cm;
        if (salt != null) {
            MessageDigest md = SHA256.getMessageDigest();
            try {
                md.update(salt.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            try {
                InputStream is = this.data.getInputStream();
                SHA256.hash(is, md);
                is.close();
            }
            catch (IOException e) {
                SHA256.returnMessageDigest(md);
                Logger.error(this, "Got IOE: " + e.getMessage(), (Throwable)e);
                throw new MessageInvalidException(26, "Unable to access file: " + e, this.identifier, this.global);
            }
            byte[] foundHash = md.digest();
            SHA256.returnMessageDigest(md);
            if (logMINOR) {
                Logger.minor(this, "FileHash result : we found " + Base64.encode(foundHash) + " and were given " + Base64.encode(saltedHash) + '.');
            }
            if (!Arrays.equals(saltedHash, foundHash)) {
                throw new MessageInvalidException(25, "The hash doesn't match! (salt used : \"" + salt + "\")", this.identifier, this.global);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "data = " + this.data + ", uploadFrom = " + ClientPutMessage.uploadFromString(this.uploadFrom));
        }
        this.putter = new ClientPutter(this, this.data, this.uri, cm, this.ctx, this.priorityClass, this.getCHKOnly, isMetadata, this.lowLevelClient, this.uri.getDocName() == null ? this.targetFilename : null, this.binaryBlob, server.core.clientContext, message.overrideSplitfileCryptoKey, message.metadataThreshold);
    }

    @Override
    void register(ObjectContainer container, boolean noTags) throws IdentifierCollisionException {
        if (this.persistenceType != 0) {
            this.client.register(this, container);
        }
        if (this.persistenceType != 0 && !noTags) {
            FCPMessage msg = this.persistentTagMessage(container);
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " : " + this.identifier);
        }
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (this.finished) {
                return;
            }
        }
        try {
            RequestStatusCache cache;
            Object msg;
            if (this.persistenceType == 2) {
                container.activate((Object)this.putter, 1);
            }
            this.putter.start(this.earlyEncode, false, container, context);
            if (this.persistenceType != 0 && !this.finished) {
                msg = this.persistentTagMessage(container);
                this.client.queueClientRequestMessage((FCPMessage)msg, 0, container);
            }
            msg = this;
            synchronized (msg) {
                this.started = true;
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStarted(this.identifier, true);
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
        }
        catch (InsertException e) {
            ClientPut clientPut2 = this;
            synchronized (clientPut2) {
                this.started = true;
            }
            this.onFailure(e, null, container);
        }
        catch (Throwable t) {
            ClientPut clientPut3 = this;
            synchronized (clientPut3) {
                this.started = true;
            }
            this.onFailure(new InsertException(3, t, null), null, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeData(ObjectContainer container) {
        Bucket d;
        ClientPut clientPut = this;
        synchronized (clientPut) {
            d = this.data;
            this.data = null;
            if (d == null) {
                return;
            }
            if (this.persistenceType == 2) {
                container.activate((Object)d, 5);
            }
            this.finishedSize = d.size();
        }
        d.free();
        if (this.persistenceType == 2) {
            d.removeFrom(container);
        }
    }

    @Override
    protected ClientRequester getClientRequest() {
        return this.putter;
    }

    @Override
    protected FCPMessage persistentTagMessage(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.publicURI, 5);
            container.activate((Object)this.uri, 5);
            container.activate((Object)this.clientMetadata, 5);
            container.activate((Object)this.origFilename, 5);
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.lowLevelClient, 1);
            container.activate((Object)this.putter, 1);
        }
        if (this.putter == null) {
            Logger.error(this, "putter == null", (Throwable)new Exception("error"));
        }
        return new PersistentPut(this.identifier, this.publicURI, this.uri, this.verbosity, this.priorityClass, this.uploadFrom, this.targetURI, this.persistenceType, this.origFilename, this.clientMetadata.getMIMEType(), this.client.isGlobalQueue, this.getDataSize(container), this.clientToken, this.started, this.ctx.maxInsertRetries, this.targetFilename, this.binaryBlob, this.ctx.getCompatibilityMode(), this.ctx.dontCompress, this.ctx.compressorDescriptor, this.isRealTime(), this.putter != null ? this.putter.getSplitfileCryptoKey() : null);
    }

    private boolean isRealTime() {
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
            return false;
        }
        return this.lowLevelClient.realTimeFlag();
    }

    @Override
    protected String getTypeName() {
        return "PUT";
    }

    @Override
    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public FreenetURI getFinalURI(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.generatedURI, 5);
        }
        return this.generatedURI;
    }

    public boolean isDirect() {
        return this.uploadFrom == 0;
    }

    public File getOrigFilename(ObjectContainer container) {
        if (this.uploadFrom != 1) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.origFilename, 5);
        }
        return this.origFilename;
    }

    public long getDataSize(ObjectContainer container) {
        if (this.data == null) {
            return this.finishedSize;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.data, 1);
        }
        return this.data.size();
    }

    public String getMIMEType() {
        return this.clientMetadata.getMIMEType();
    }

    @Override
    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return this.putter.canRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restart(ObjectContainer container, ClientContext context, boolean disableFilterData) {
        if (!this.canRestart()) {
            return false;
        }
        this.setVarsRestart(container);
        try {
            Object cache;
            if (this.persistenceType == 2) {
                container.activate((Object)this.putter, 1);
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                ((RequestStatusCache)cache).updateStarted(this.identifier, false);
            }
            if (this.putter.restart(this.earlyEncode, container, context)) {
                cache = this;
                synchronized (cache) {
                    this.generatedURI = null;
                    this.started = true;
                }
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                ((RequestStatusCache)cache).updateStarted(this.identifier, true);
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
            return true;
        }
        catch (InsertException e) {
            this.onFailure(e, null, container);
            return false;
        }
    }

    @Override
    public void setVarsRestart(ObjectContainer container) {
        RequestStatusCache cache;
        super.setVarsRestart(container);
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateCompressionStatus(this.identifier, this.isCompressing(container));
        }
    }

    @Override
    public void onRemoveEventProducer(ObjectContainer container) {
    }

    @Override
    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.putter, 1);
            this.putter.removeFrom(container, context);
            this.putter = null;
            if (this.origFilename != null) {
                container.activate((Object)this.origFilename, 5);
                container.delete((Object)this.origFilename);
            }
            if (this.targetURI != null) {
                container.activate((Object)this.targetURI, 5);
                this.targetURI.removeFrom(container);
            }
        }
        super.requestWasRemoved(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COMPRESS_STATE isCompressing(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.ctx, 1);
        }
        if (this.ctx.dontCompress) {
            return COMPRESS_STATE.WORKING;
        }
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (this.progressMessage == null) {
                return COMPRESS_STATE.WAITING;
            }
            if (this.compressing) {
                return COMPRESS_STATE.COMPRESSING;
            }
            return COMPRESS_STATE.WORKING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStartCompressing() {
        RequestStatusCache cache;
        ClientPut clientPut = this;
        synchronized (clientPut) {
            this.compressing = true;
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateCompressionStatus(this.identifier, COMPRESS_STATE.COMPRESSING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStopCompressing() {
        RequestStatusCache cache;
        ClientPut clientPut = this;
        synchronized (clientPut) {
            this.compressing = false;
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateCompressionStatus(this.identifier, COMPRESS_STATE.WORKING);
        }
    }

    @Override
    RequestStatus getStatus(ObjectContainer container) {
        File fnam;
        FreenetURI finalURI = this.getFinalURI(container);
        if (finalURI != null) {
            finalURI = this.getFinalURI(container).clone();
        }
        int failureCode = -1;
        String failureReasonShort = null;
        String failureReasonLong = null;
        if (this.putFailedMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.putFailedMessage, 5);
            }
            failureCode = this.putFailedMessage.code;
            failureReasonShort = this.putFailedMessage.getShortFailedMessage();
            failureReasonShort = this.putFailedMessage.getLongFailedMessage();
            if (this.persistenceType == 2) {
                container.deactivate((Object)this.putFailedMessage, 5);
            }
        }
        String mimeType = null;
        if (this.persistenceType == 2) {
            container.activate((Object)this.clientMetadata, 1);
            mimeType = this.clientMetadata.getMIMEType();
        }
        if ((fnam = this.getOrigFilename(container)) != null) {
            fnam = new File(fnam.getPath());
        }
        int total = 0;
        int min = 0;
        int fetched = 0;
        int fatal = 0;
        int failed = 0;
        boolean totalFinalized = false;
        if (this.progressMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.progressMessage, 2);
            }
            if (this.progressMessage instanceof SimpleProgressMessage) {
                SimpleProgressMessage msg = (SimpleProgressMessage)this.progressMessage;
                total = (int)msg.getTotalBlocks();
                min = (int)msg.getMinBlocks();
                fetched = (int)msg.getFetchedBlocks();
                fatal = (int)msg.getFatalyFailedBlocks();
                failed = (int)msg.getFailedBlocks();
                totalFinalized = msg.isTotalFinalized();
            }
        }
        FreenetURI origURI = this.uri;
        if (this.persistenceType == 2) {
            container.activate((Object)origURI, Integer.MAX_VALUE);
            origURI = origURI.clone();
        }
        return new UploadFileRequestStatus(this.identifier, this.persistenceType, this.started, this.finished, this.succeeded, total, min, fetched, fatal, failed, totalFinalized, this.lastActivity, this.priorityClass, finalURI, origURI, failureCode, failureReasonShort, failureReasonLong, this.getDataSize(container), mimeType, fnam, this.isCompressing(container));
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static enum COMPRESS_STATE {
        WAITING,
        COMPRESSING,
        WORKING;

    }
}

