/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.config.Config;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class ConfigData
extends FCPMessage {
    static final String name = "ConfigData";
    final Node node;
    final boolean withCurrent;
    final boolean withDefaults;
    final boolean withSortOrder;
    final boolean withExpertFlag;
    final boolean withForceWriteFlag;
    final boolean withShortDescription;
    final boolean withLongDescription;
    final boolean withDataTypes;
    final String identifier;

    public ConfigData(Node node, boolean withCurrent, boolean withDefaults, boolean withSortOrder, boolean withExpertFlag, boolean withForceWriteFlag, boolean withShortDescription, boolean withLongDescription, boolean withDataTypes, String identifier) {
        this.node = node;
        this.withCurrent = withCurrent;
        this.withDefaults = withDefaults;
        this.withSortOrder = withSortOrder;
        this.withExpertFlag = withExpertFlag;
        this.withForceWriteFlag = withForceWriteFlag;
        this.withShortDescription = withShortDescription;
        this.withLongDescription = withLongDescription;
        this.withDataTypes = withDataTypes;
        this.identifier = identifier;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet type;
        SimpleFieldSet longDescription;
        SimpleFieldSet shortDescription;
        SimpleFieldSet forceWriteFlag;
        SimpleFieldSet expertFlag;
        SimpleFieldSet sortOrder;
        SimpleFieldSet defaultSettings;
        SimpleFieldSet current;
        SimpleFieldSet fs = new SimpleFieldSet(true);
        if (this.withCurrent && !(current = this.node.config.exportFieldSet(Config.RequestType.CURRENT_SETTINGS, true)).isEmpty()) {
            fs.put("current", current);
        }
        if (this.withDefaults && !(defaultSettings = this.node.config.exportFieldSet(Config.RequestType.DEFAULT_SETTINGS, false)).isEmpty()) {
            fs.put("default", defaultSettings);
        }
        if (this.withSortOrder && !(sortOrder = this.node.config.exportFieldSet(Config.RequestType.SORT_ORDER, false)).isEmpty()) {
            fs.put("sortOrder", sortOrder);
        }
        if (this.withExpertFlag && !(expertFlag = this.node.config.exportFieldSet(Config.RequestType.EXPERT_FLAG, false)).isEmpty()) {
            fs.put("expertFlag", expertFlag);
        }
        if (this.withForceWriteFlag && !(forceWriteFlag = this.node.config.exportFieldSet(Config.RequestType.FORCE_WRITE_FLAG, false)).isEmpty()) {
            fs.put("forceWriteFlag", forceWriteFlag);
        }
        if (this.withShortDescription && !(shortDescription = this.node.config.exportFieldSet(Config.RequestType.SHORT_DESCRIPTION, false)).isEmpty()) {
            fs.put("shortDescription", shortDescription);
        }
        if (this.withLongDescription && !(longDescription = this.node.config.exportFieldSet(Config.RequestType.LONG_DESCRIPTION, false)).isEmpty()) {
            fs.put("longDescription", longDescription);
        }
        if (this.withDataTypes && !(type = this.node.config.exportFieldSet(Config.RequestType.DATA_TYPE, false)).isEmpty()) {
            fs.put("dataType", type);
        }
        if (this.identifier != null) {
            fs.putSingle("Identifier", this.identifier);
        }
        return fs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "ConfigData goes from server to client not the other way around", null, false);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

