/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import freenet.node.fcp.BaseDataCarryingMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.NullBucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DataCarryingMessage
extends BaseDataCarryingMessage {
    protected Bucket bucket;
    protected boolean freeOnSent;

    Bucket createBucket(BucketFactory bf, long length, FCPServer server) throws IOException {
        return bf.makeBucket(length);
    }

    abstract String getIdentifier();

    abstract boolean isGlobal();

    void setFreeOnSent() {
        this.freeOnSent = true;
    }

    @Override
    public void readFrom(InputStream is, BucketFactory bf, FCPServer server) throws IOException, MessageInvalidException {
        Bucket tempBucket;
        long len = this.dataLength();
        if (len < 0L) {
            return;
        }
        if (len == 0L) {
            this.bucket = new NullBucket();
            return;
        }
        try {
            tempBucket = this.createBucket(bf, len, server);
        }
        catch (IOException e) {
            Logger.error(this, "Bucket error: " + e, (Throwable)e);
            throw new MessageInvalidException(17, e.toString(), this.getIdentifier(), this.isGlobal());
        }
        BucketTools.copyFrom(tempBucket, is, len);
        this.bucket = tempBucket;
    }

    @Override
    protected void writeData(OutputStream os) throws IOException {
        long len = this.dataLength();
        if (len > 0L) {
            BucketTools.copyTo(this.bucket, os, len);
        }
        if (this.freeOnSent) {
            this.bucket.free();
        }
    }

    @Override
    String getEndString() {
        return "Data";
    }
}

