/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.DefaultMIMETypes;
import freenet.node.fcp.DirPutFile;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.FileBucket;
import java.io.File;

public class DiskDirPutFile
extends DirPutFile {
    final File file;

    public static DiskDirPutFile create(String name, String contentTypeOverride, SimpleFieldSet subset, String identifier, boolean global) throws MessageInvalidException {
        String s = subset.get("Filename");
        if (s == null) {
            throw new MessageInvalidException(5, "Missing field: Filename on " + name, identifier, global);
        }
        File file = new File(s);
        String mimeType = contentTypeOverride == null ? DiskDirPutFile.guessMIME(name, file) : contentTypeOverride;
        return new DiskDirPutFile(name, mimeType, file);
    }

    public DiskDirPutFile(String name, String mimeType, File f) {
        super(name, mimeType);
        this.file = f;
    }

    protected static String guessMIME(String name, File file) {
        String mime = DirPutFile.guessMIME(name);
        if (mime == null) {
            mime = DefaultMIMETypes.guessMIMEType(file.getName(), false);
        }
        return mime;
    }

    @Override
    public Bucket getData() {
        return new FileBucket(this.file, true, false, false, false, false);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.file);
        container.delete((Object)this);
    }
}

