/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.DataCarryingMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;

public class FCPPluginReply
extends DataCarryingMessage {
    private static final String NAME = "FCPPluginReply";
    public static final String PARAM_PREFIX = "Param";
    private final long dataLength;
    private final String plugname;
    private final String identifier;
    private final SimpleFieldSet plugparams;

    public FCPPluginReply(String pluginname, String identifier2, SimpleFieldSet fs, Bucket bucket2) {
        this.bucket = bucket2;
        if (this.bucket == null) {
            this.dataLength = -1L;
        } else {
            this.bucket.setReadOnly();
            this.dataLength = this.bucket.size();
        }
        this.plugname = pluginname;
        this.identifier = identifier2;
        this.plugparams = fs;
    }

    @Override
    String getIdentifier() {
        return this.identifier;
    }

    @Override
    boolean isGlobal() {
        return false;
    }

    @Override
    long dataLength() {
        return this.dataLength;
    }

    @Override
    String getEndString() {
        if (this.dataLength() > 0L) {
            return "Data";
        }
        return "EndMessage";
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("PluginName", this.plugname);
        sfs.putSingle("Identifier", this.identifier);
        if (this.dataLength() > 0L) {
            sfs.put("DataLength", this.dataLength());
        }
        sfs.put("Replies", this.plugparams);
        return sfs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "FCPPluginReply goes from server to client not the other way around", null, false);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

