/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.fcp.EndListPeersMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.PeerMessage;
import freenet.support.SimpleFieldSet;

public class ListPeersMessage
extends FCPMessage {
    final boolean withMetadata;
    final boolean withVolatile;
    final String identifier;
    static final String NAME = "ListPeers";

    public ListPeersMessage(SimpleFieldSet fs) {
        this.withMetadata = fs.getBoolean("WithMetadata", false);
        this.withVolatile = fs.getBoolean("WithVolatile", false);
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PeerNode[] nodes;
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ListPeers requires full access", this.identifier, false);
        }
        for (PeerNode pn : nodes = node.getPeerNodes()) {
            handler.outputHandler.queue(new PeerMessage(pn, this.withMetadata, this.withVolatile, this.identifier));
        }
        handler.outputHandler.queue(new EndListPeersMessage(this.identifier));
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

