/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FeedMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public abstract class N2NFeedMessage
extends FeedMessage {
    protected final String sourceNodeName;
    protected final long composed;
    protected final long sent;
    protected final long received;

    public N2NFeedMessage(String header, String shortText, String text, short priorityClass, long updatedTime, String sourceNodeName, long composed, long sent, long received) {
        super(header, shortText, text, priorityClass, updatedTime);
        this.sourceNodeName = sourceNodeName;
        this.composed = composed;
        this.sent = sent;
        this.received = received;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        fs.putSingle("SourceNodeName", this.sourceNodeName);
        if (this.composed != -1L) {
            fs.put("TimeComposed", this.composed);
        }
        if (this.sent != -1L) {
            fs.put("TimeSent", this.sent);
        }
        if (this.received != -1L) {
            fs.put("TimeReceived", this.received);
        }
        return fs;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, this.getName() + " goes from server to client not the other way around", null, false);
    }
}

