/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.ProbeBandwidth;
import freenet.node.fcp.ProbeBuild;
import freenet.node.fcp.ProbeError;
import freenet.node.fcp.ProbeIdentifier;
import freenet.node.fcp.ProbeLinkLengths;
import freenet.node.fcp.ProbeLocation;
import freenet.node.fcp.ProbeOverallBulkOutputCapacityUsage;
import freenet.node.fcp.ProbeRefused;
import freenet.node.fcp.ProbeRejectStats;
import freenet.node.fcp.ProbeStoreSize;
import freenet.node.fcp.ProbeUptime;
import freenet.node.probe.Error;
import freenet.node.probe.Listener;
import freenet.node.probe.Type;
import freenet.support.SimpleFieldSet;

public class ProbeRequest
extends FCPMessage {
    public static final String NAME = "ProbeRequest";
    private final String identifier;
    private final Type type;
    private final byte htl;

    public ProbeRequest(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        try {
            this.type = Type.valueOf(fs.get("Type"));
            this.htl = (byte)(fs.get("HopsToLive") == null ? 70 : (int)fs.getByte("HopsToLive"));
            if (this.htl < 0) {
                throw new MessageInvalidException(7, "hopsToLive cannot be negative.", null, false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(7, "Unrecognized parse probe type \"" + fs.get("Type") + "\": " + e, null, false);
        }
        catch (FSParseException e) {
            throw new MessageInvalidException(7, "Unable to parse hopsToLive \"" + fs.get("HopsToLive") + "\": " + e, null, false);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "Probe requires full access.", this.identifier, false);
        }
        Listener listener = new Listener(){

            @Override
            public void onError(Error error, Byte code, boolean local) {
                handler.outputHandler.queue(new ProbeError(ProbeRequest.this.identifier, error, code, local));
            }

            @Override
            public void onRefused() {
                handler.outputHandler.queue(new ProbeRefused(ProbeRequest.this.identifier));
            }

            @Override
            public void onOutputBandwidth(float outputBandwidth) {
                handler.outputHandler.queue(new ProbeBandwidth(ProbeRequest.this.identifier, outputBandwidth));
            }

            @Override
            public void onBuild(int build) {
                handler.outputHandler.queue(new ProbeBuild(ProbeRequest.this.identifier, build));
            }

            @Override
            public void onIdentifier(long probeIdentifier, byte percentageUptime) {
                handler.outputHandler.queue(new ProbeIdentifier(ProbeRequest.this.identifier, probeIdentifier, percentageUptime));
            }

            @Override
            public void onLinkLengths(float[] linkLengths) {
                handler.outputHandler.queue(new ProbeLinkLengths(ProbeRequest.this.identifier, linkLengths));
            }

            @Override
            public void onLocation(float location) {
                handler.outputHandler.queue(new ProbeLocation(ProbeRequest.this.identifier, location));
            }

            @Override
            public void onStoreSize(float storeSize) {
                handler.outputHandler.queue(new ProbeStoreSize(ProbeRequest.this.identifier, storeSize));
            }

            @Override
            public void onUptime(float uptimePercent) {
                handler.outputHandler.queue(new ProbeUptime(ProbeRequest.this.identifier, uptimePercent));
            }

            @Override
            public void onRejectStats(byte[] stats) {
                handler.outputHandler.queue(new ProbeRejectStats(ProbeRequest.this.identifier, stats));
            }

            @Override
            public void onOverallBulkOutputCapacity(byte bandwidthClassForCapacityUsage, float capacityUsage) {
                handler.outputHandler.queue(new ProbeOverallBulkOutputCapacityUsage(ProbeRequest.this.identifier, bandwidthClassForCapacityUsage, capacityUsage));
            }
        };
        node.startProbe(this.htl, node.random.nextLong(), this.type, listener);
    }
}

